/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-04-03 18:13:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpcx_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wpcx_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_litespeed_img_optming` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `optm_status` tinyint(4) NOT NULL DEFAULT '0',
  `src` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `server_info` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `optm_status` (`optm_status`),
  KEY `src` (`src`(191))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1087 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=700 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `agent` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT '1',
  `module_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `match_url` varchar(2000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `match_data` text COLLATE utf8mb4_unicode_520_ci,
  `regex` int(11) unsigned NOT NULL DEFAULT '0',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  `last_count` int(10) unsigned NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `match_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sent_to` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `agent` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `referrer` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `http_code` int(11) unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `redirect_by` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_dictionary_en_us_pt_br` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT '0',
  `block_type` int(20) DEFAULT '0',
  `original_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_dictionary_en_us_pt_pt` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT '0',
  `block_type` int(20) DEFAULT '0',
  `original_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_dictionary_en_us_ru_ru` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT '0',
  `block_type` int(20) DEFAULT '0',
  `original_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_dictionary_pt_pt_en_us` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT '0',
  `block_type` int(20) DEFAULT '0',
  `original_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_dictionary_ru_ru_en_us` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT '0',
  `block_type` int(20) DEFAULT '0',
  `original_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_en_us` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `domain` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=3344 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_original_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_id` (`meta_id`),
  KEY `gettext_index_original_id` (`original_id`),
  KEY `gettext_meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_original_strings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` text COLLATE utf8mb4_unicode_520_ci,
  `original_plural` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `gettext_index_original` (`original`(100))
) ENGINE=InnoDB AUTO_INCREMENT=3130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_pt_br` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `domain` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_pt_pt` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `domain` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=3038 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_gettext_ru_ru` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translated` longtext COLLATE utf8mb4_unicode_520_ci,
  `domain` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` int(20) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB AUTO_INCREMENT=3017 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_original_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_id` (`meta_id`),
  KEY `index_original_id` (`original_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_trp_original_strings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `index_original` (`original`(100))
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wpcx_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpcx_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=277 DEFAULT CHARSET=utf8;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpcx_comments */
INSERT INTO `wpcx_comments` VALUES("1", "1", "Um comentarista do WordPress", "wapuu@wordpress.example", "https://br.wordpress.org/", "", "2024-02-14 20:19:22", "2024-02-14 23:19:22", "Oi, isto é um comentário.\nPara iniciar a moderar, editar e excluir comentários, visite a tela Comentários no painel.\nOs avatares dos comentaristas vêm do <a href=\"https://br.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wpcx_duplicator_packages */
INSERT INTO `wpcx_duplicator_packages` VALUES("1", "20240403_globalconnectionx", "0051d18c8bab672b8447_20240403150311", "100", "2024-04-03 15:03:34", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 15:03:11\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"0051d18c8bab672b8447_20240403150311\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"36.54 sec.\";s:7:\"ExeSize\";s:7:\"73.48KB\";s:7:\"ZipSize\";s:8:\"133.57MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";s:4:\"Size\";i:140062351;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1207;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9277;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:10483;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:71:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-admin\";i:1;s:74:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-includes\";i:2;s:83:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:1;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:2;s:73:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content\";i:3;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/uploads\";i:4;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/plugins\";i:5;s:84:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/mu-plugins\";i:6;s:80:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:94:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311_installer.php.bak\";s:4:\"Size\";i:75248;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:146:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp/original_files_0051d18-03150311/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:126:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp/original_files_0051d18-03150311\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:76:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3499:\"<?php\ndefine( \'WP_CACHE\', true );\n/**\n * As configurações básicas do WordPress\n *\n * O script de criação wp-config.php usa esse arquivo durante a instalação.\n * Você não precisa usar o site, você pode copiar este arquivo\n * para \"wp-config.php\" e preencher os valores.\n *\n * Este arquivo contém as seguintes configurações:\n *\n * * Configurações do banco de dados\n * * Chaves secretas\n * * Prefixo do banco de dados\n * * ABSPATH\n *\n * @link https://wordpress.org/documentation/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Configurações do banco de dados - Você pode pegar estas informações com o serviço de hospedagem ** //\n/** O nome do banco de dados do WordPress */\ndefine( \'DB_NAME\', \'sql_connectionx_\' );\n\n/** Usuário do banco de dados MySQL */\ndefine( \'DB_USER\', \'sql_ConnectionX_\' );\n\n/** Senha do banco de dados MySQL */\ndefine( \'DB_PASSWORD\', \'nMkjm8H2CKWLdDNz\' );\n\n/** Nome do host do MySQL */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Charset do banco de dados a ser usado na criação das tabelas. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n\n/** O tipo de Collate do banco de dados. Não altere isso se tiver dúvidas. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Chaves únicas de autenticação e salts.\n *\n * Altere cada chave para um frase única!\n * Você pode gerá-las\n * usando o {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org\n * secret-key service}\n * Você pode alterá-las a qualquer momento para invalidar quaisquer\n * cookies existentes. Isto irá forçar todos os\n * usuários a fazerem login novamente.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'.PiQpt=Mm6tEJ>w54RMp=3alF`VEc::$xC%*0aT3Q5W;HVuPtPH{7ugxyDvM^Ot(\' );\ndefine( \'SECURE_AUTH_KEY\',  \'KA^TU;qY_)m9p(*3I,WA?hG/t?n()0AkYb}T5qM<4~=P<pLW,d2FU|${Lt-:Y8+k\' );\ndefine( \'LOGGED_IN_KEY\',    \'?If,]pWfP^IJ?}M9O+fhXpIBO`!8%+,!/xRasid`-#L2^}__3=!A?SmJqK)uczMt\' );\ndefine( \'NONCE_KEY\',        \'  rrg>v@CIG_hqz9v25)0XwN@||33<&ee#whaC$^`bmv;uP&c/}PvXTJ6Wi6#FQ[\' );\ndefine( \'AUTH_SALT\',        \'r6LjRTLtO`8Me`%Q$wO|zDCbgE369]hs3E8QlK!c|OI9 k/>y_ZQNtpZe_nke~Gu\' );\ndefine( \'SECURE_AUTH_SALT\', \'&nRqI9meyUq~6z>w>2?[(I!zd7[[omjlffLa8pD:{E#OUKA^70^r7t:QM.6llRY{\' );\ndefine( \'LOGGED_IN_SALT\',   \'>qwOAc.48i=2BNv#:{d_Mm2V5Jl-D)d>5+$n6x%PZsJ};CvoG~4~6=cHfTXRlb5z\' );\ndefine( \'NONCE_SALT\',       \'y6TG:ieozPiYKn)(CbFY!lD]Tgs?^O$Xwb~5HUCTwupXYQb<_E|qy])=xU.:<mW]\' );\n\n/**#@-*/\n\n/**\n * Prefixo da tabela do banco de dados do WordPress.\n *\n * Você pode ter várias instalações em um único banco de dados se você der\n * um prefixo único para cada um. Somente números, letras e sublinhados!\n */\n$table_prefix = \'wpcx_\';\n\n/**\n * Para desenvolvedores: Modo de debug do WordPress.\n *\n * Altere isto para true para ativar a exibição de avisos\n * durante o desenvolvimento. É altamente recomendável que os\n * desenvolvedores de plugins e temas usem o WP_DEBUG\n * em seus ambientes de desenvolvimento.\n *\n * Para informações sobre outras constantes que podem ser utilizadas\n * para depuração, visite o Codex.\n *\n * @link https://wordpress.org/documentation/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Adicione valores personalizados entre esta linha até \"Isto é tudo\". */\n\n\n\n/* Isto é tudo, pode parar de editar! :) */\n\n/** Caminho absoluto para o diretório WordPress. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Configura as variáveis e arquivos do WordPress. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:40:\"define( \'DB_NAME\', \'sql_connectionx_\' );\";s:5:\"value\";s:18:\"\'sql_connectionx_\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:21:\", \'sql_connectionx_\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:40:\"define( \'DB_USER\', \'sql_ConnectionX_\' );\";s:5:\"value\";s:18:\"\'sql_ConnectionX_\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:21:\", \'sql_ConnectionX_\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:44:\"define( \'DB_PASSWORD\', \'nMkjm8H2CKWLdDNz\' );\";s:5:\"value\";s:18:\"\'nMkjm8H2CKWLdDNz\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:21:\", \'nMkjm8H2CKWLdDNz\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'.PiQpt=Mm6tEJ>w54RMp=3alF`VEc::$xC%*0aT3Q5W;HVuPtPH{7ugxyDvM^Ot(\' );\";s:5:\"value\";s:66:\"\'.PiQpt=Mm6tEJ>w54RMp=3alF`VEc::$xC%*0aT3Q5W;HVuPtPH{7ugxyDvM^Ot(\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'.PiQpt=Mm6tEJ>w54RMp=3alF`VEc::$xC%*0aT3Q5W;HVuPtPH{7ugxyDvM^Ot(\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'KA^TU;qY_)m9p(*3I,WA?hG/t?n()0AkYb}T5qM<4~=P<pLW,d2FU|${Lt-:Y8+k\' );\";s:5:\"value\";s:66:\"\'KA^TU;qY_)m9p(*3I,WA?hG/t?n()0AkYb}T5qM<4~=P<pLW,d2FU|${Lt-:Y8+k\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'KA^TU;qY_)m9p(*3I,WA?hG/t?n()0AkYb}T5qM<4~=P<pLW,d2FU|${Lt-:Y8+k\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'?If,]pWfP^IJ?}M9O+fhXpIBO`!8%+,!/xRasid`-#L2^}__3=!A?SmJqK)uczMt\' );\";s:5:\"value\";s:66:\"\'?If,]pWfP^IJ?}M9O+fhXpIBO`!8%+,!/xRasid`-#L2^}__3=!A?SmJqK)uczMt\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'?If,]pWfP^IJ?}M9O+fhXpIBO`!8%+,!/xRasid`-#L2^}__3=!A?SmJqK)uczMt\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'  rrg>v@CIG_hqz9v25)0XwN@||33<&ee#whaC$^`bmv;uP&c/}PvXTJ6Wi6#FQ[\' );\";s:5:\"value\";s:66:\"\'  rrg>v@CIG_hqz9v25)0XwN@||33<&ee#whaC$^`bmv;uP&c/}PvXTJ6Wi6#FQ[\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'  rrg>v@CIG_hqz9v25)0XwN@||33<&ee#whaC$^`bmv;uP&c/}PvXTJ6Wi6#FQ[\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'r6LjRTLtO`8Me`%Q$wO|zDCbgE369]hs3E8QlK!c|OI9 k/>y_ZQNtpZe_nke~Gu\' );\";s:5:\"value\";s:66:\"\'r6LjRTLtO`8Me`%Q$wO|zDCbgE369]hs3E8QlK!c|OI9 k/>y_ZQNtpZe_nke~Gu\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'r6LjRTLtO`8Me`%Q$wO|zDCbgE369]hs3E8QlK!c|OI9 k/>y_ZQNtpZe_nke~Gu\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'&nRqI9meyUq~6z>w>2?[(I!zd7[[omjlffLa8pD:{E#OUKA^70^r7t:QM.6llRY{\' );\";s:5:\"value\";s:66:\"\'&nRqI9meyUq~6z>w>2?[(I!zd7[[omjlffLa8pD:{E#OUKA^70^r7t:QM.6llRY{\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'&nRqI9meyUq~6z>w>2?[(I!zd7[[omjlffLa8pD:{E#OUKA^70^r7t:QM.6llRY{\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'>qwOAc.48i=2BNv#:{d_Mm2V5Jl-D)d>5+$n6x%PZsJ};CvoG~4~6=cHfTXRlb5z\' );\";s:5:\"value\";s:66:\"\'>qwOAc.48i=2BNv#:{d_Mm2V5Jl-D)d>5+$n6x%PZsJ};CvoG~4~6=cHfTXRlb5z\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'>qwOAc.48i=2BNv#:{d_Mm2V5Jl-D)d>5+$n6x%PZsJ};CvoG~4~6=cHfTXRlb5z\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'y6TG:ieozPiYKn)(CbFY!lD]Tgs?^O$Xwb~5HUCTwupXYQb<_E|qy])=xU.:<mW]\' );\";s:5:\"value\";s:66:\"\'y6TG:ieozPiYKn)(CbFY!lD]Tgs?^O$Xwb~5HUCTwupXYQb<_E|qy])=xU.:<mW]\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'y6TG:ieozPiYKn)(CbFY!lD]Tgs?^O$Xwb~5HUCTwupXYQb<_E|qy])=xU.:<mW]\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:24:\"$table_prefix = \'wpcx_\';\";s:5:\"value\";s:7:\"\'wpcx_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:9:\" \'wpcx_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3416112;s:4:\"File\";s:75:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:4:\"utf8\";}s:13:\"collationList\";a:3:{i:0;s:15:\"utf8_general_ci\";i:1;s:22:\"utf8mb4_unicode_520_ci\";i:2;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:16:\"sql_connectionx_\";s:15:\"tablesBaseCount\";i:39;s:16:\"tablesFinalCount\";i:39;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:13891;s:16:\"tablesSizeOnDisk\";i:9879552;s:10:\"tablesList\";a:39:{s:16:\"wpcx_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:13:\"wpcx_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:24:\"wpcx_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:10:\"wpcx_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:21:\"wpcx_litespeed_avatar\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wpcx_litespeed_img_optming\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:33;s:4:\"size\";i:65536;}s:18:\"wpcx_litespeed_url\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:23:\"wpcx_litespeed_url_file\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:12:\"wpcx_options\";a:3:{s:14:\"inaccurateRows\";i:407;s:12:\"insertedRows\";i:407;s:4:\"size\";i:2179072;}s:13:\"wpcx_postmeta\";a:3:{s:14:\"inaccurateRows\";i:300;s:12:\"insertedRows\";i:300;s:4:\"size\";i:229376;}s:10:\"wpcx_posts\";a:3:{s:14:\"inaccurateRows\";i:97;s:12:\"insertedRows\";i:100;s:4:\"size\";i:2506752;}s:20:\"wpcx_redirection_404\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:65536;}s:23:\"wpcx_redirection_groups\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:22:\"wpcx_redirection_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:114688;}s:21:\"wpcx_redirection_logs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:13:\"wpcx_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:10:\"wpcx_terms\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:23:\"wpcx_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:7;s:4:\"size\";i:32768;}s:18:\"wpcx_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:31:\"wpcx_trp_dictionary_en_us_pt_br\";a:3:{s:14:\"inaccurateRows\";i:51;s:12:\"insertedRows\";i:54;s:4:\"size\";i:65536;}s:31:\"wpcx_trp_dictionary_en_us_pt_pt\";a:3:{s:14:\"inaccurateRows\";i:60;s:12:\"insertedRows\";i:60;s:4:\"size\";i:65536;}s:31:\"wpcx_trp_dictionary_en_us_ru_ru\";a:3:{s:14:\"inaccurateRows\";i:101;s:12:\"insertedRows\";i:104;s:4:\"size\";i:65536;}s:31:\"wpcx_trp_dictionary_pt_pt_en_us\";a:3:{s:14:\"inaccurateRows\";i:110;s:12:\"insertedRows\";i:121;s:4:\"size\";i:65536;}s:31:\"wpcx_trp_dictionary_ru_ru_en_us\";a:3:{s:14:\"inaccurateRows\";i:133;s:12:\"insertedRows\";i:134;s:4:\"size\";i:65536;}s:22:\"wpcx_trp_gettext_en_us\";a:3:{s:14:\"inaccurateRows\";i:2959;s:12:\"insertedRows\";i:3343;s:4:\"size\";i:737280;}s:30:\"wpcx_trp_gettext_original_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:33:\"wpcx_trp_gettext_original_strings\";a:3:{s:14:\"inaccurateRows\";i:3067;s:12:\"insertedRows\";i:3125;s:4:\"size\";i:507904;}s:22:\"wpcx_trp_gettext_pt_br\";a:3:{s:14:\"inaccurateRows\";i:563;s:12:\"insertedRows\";i:563;s:4:\"size\";i:229376;}s:22:\"wpcx_trp_gettext_pt_pt\";a:3:{s:14:\"inaccurateRows\";i:2863;s:12:\"insertedRows\";i:3033;s:4:\"size\";i:704512;}s:22:\"wpcx_trp_gettext_ru_ru\";a:3:{s:14:\"inaccurateRows\";i:2765;s:12:\"insertedRows\";i:3016;s:4:\"size\";i:884736;}s:22:\"wpcx_trp_original_meta\";a:3:{s:14:\"inaccurateRows\";i:55;s:12:\"insertedRows\";i:59;s:4:\"size\";i:65536;}s:25:\"wpcx_trp_original_strings\";a:3:{s:14:\"inaccurateRows\";i:219;s:12:\"insertedRows\";i:240;s:4:\"size\";i:65536;}s:13:\"wpcx_usermeta\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:10:\"wpcx_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:20:\"wpcx_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:114688;}s:30:\"wpcx_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:65536;}s:21:\"wpcx_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:23:\"wpcx_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:20:\"wpcx_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:49152;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"5.7.40\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:170:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp/20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 15:03:11\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"0051d18c8bab672b8447_20240403150311\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_0051d18c8bab672b8447_20240403150311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:435;}}}");
INSERT INTO `wpcx_duplicator_packages` VALUES("2", "20240403_globalconnectionx", "9ca0dcead521a2565963_20240403181324", "21", "2024-04-03 18:13:39", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 18:13:24\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"9ca0dcead521a2565963_20240403181324\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.6\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1072;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:8542;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 18:13:24\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"9ca0dcead521a2565963_20240403181324\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:76:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:75:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:170:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp/20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:71:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-admin\";i:1;s:74:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-includes\";i:2;s:83:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:1;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:2;s:73:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content\";i:3;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/uploads\";i:4;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/plugins\";i:5;s:84:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/mu-plugins\";i:6;s:80:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:94:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpcx_litespeed_img_optming */
INSERT INTO `wpcx_litespeed_img_optming` VALUES("1", "130", "1", "2024/02/global-connection-x-robo.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("2", "130", "1", "2024/02/global-connection-x-robo-222x300.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("3", "130", "1", "2024/02/global-connection-x-robo-757x1024.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("4", "130", "1", "2024/02/global-connection-x-robo-150x150.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("5", "130", "1", "2024/02/global-connection-x-robo-768x1039.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("6", "130", "1", "2024/02/global-connection-x-robo-9x12.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("7", "130", "1", "2024/02/global-connection-x-robo-400x250.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("8", "130", "1", "2024/02/global-connection-x-robo-798x675.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("9", "130", "1", "2024/02/global-connection-x-robo-400x284.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("10", "130", "1", "2024/02/global-connection-x-robo-510x382.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("11", "130", "1", "2024/02/global-connection-x-robo-400x516.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("12", "130", "1", "2024/02/global-connection-x-robo-480x650.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("13", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("14", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-225x300.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("15", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-150x150.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("16", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-9x12.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("17", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x250.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("18", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x284.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("19", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-450x382.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("20", "132", "1", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x516.jpg", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("21", "142", "1", "2024/02/global-connection-x-robo-2.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("22", "142", "1", "2024/02/global-connection-x-robo-2-240x300.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("23", "142", "1", "2024/02/global-connection-x-robo-2-819x1024.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("24", "142", "1", "2024/02/global-connection-x-robo-2-150x150.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("25", "142", "1", "2024/02/global-connection-x-robo-2-768x960.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("26", "142", "1", "2024/02/global-connection-x-robo-2-10x12.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("27", "142", "1", "2024/02/global-connection-x-robo-2-400x250.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("28", "142", "1", "2024/02/global-connection-x-robo-2-1080x675.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("29", "142", "1", "2024/02/global-connection-x-robo-2-400x284.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("30", "142", "1", "2024/02/global-connection-x-robo-2-510x382.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("31", "142", "1", "2024/02/global-connection-x-robo-2-400x516.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("32", "142", "1", "2024/02/global-connection-x-robo-2-980x1225.png", "");
INSERT INTO `wpcx_litespeed_img_optming` VALUES("33", "142", "1", "2024/02/global-connection-x-robo-2-480x600.png", "");

/* INSERT TABLE DATA: wpcx_options */
INSERT INTO `wpcx_options` VALUES("1", "siteurl", "https://connectionx.sousalimaconsultoria.com.br", "yes");
INSERT INTO `wpcx_options` VALUES("2", "home", "https://connectionx.sousalimaconsultoria.com.br", "yes");
INSERT INTO `wpcx_options` VALUES("3", "blogname", "Global ConnectionX", "yes");
INSERT INTO `wpcx_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wpcx_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpcx_options` VALUES("6", "admin_email", "eolimabr@gmail.com", "yes");
INSERT INTO `wpcx_options` VALUES("7", "start_of_week", "0", "yes");
INSERT INTO `wpcx_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpcx_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpcx_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpcx_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpcx_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpcx_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpcx_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpcx_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpcx_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpcx_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpcx_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpcx_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wpcx_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wpcx_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wpcx_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpcx_options` VALUES("23", "date_format", "j \\d\\e F \\d\\e Y", "yes");
INSERT INTO `wpcx_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wpcx_options` VALUES("25", "links_updated_date_format", "j \\d\\e F \\d\\e Y, H:i", "yes");
INSERT INTO `wpcx_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wpcx_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpcx_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wpcx_options` VALUES("29", "rewrite_rules", "a:340:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=layout_category&term=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=layout_category&term=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:51:\"index.php?taxonomy=layout_category&term=$matches[1]\";s:51:\"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:46:\"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:27:\"layout_tag/([^/]+)/embed/?$\";s:57:\"index.php?taxonomy=layout_tag&term=$matches[1]&embed=true\";s:39:\"layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?taxonomy=layout_tag&term=$matches[1]&paged=$matches[2]\";s:21:\"layout_tag/([^/]+)/?$\";s:46:\"index.php?taxonomy=layout_tag&term=$matches[1]\";s:52:\"layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_pack/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_pack&term=$matches[1]&embed=true\";s:40:\"layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_pack&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_pack/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_pack&term=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_type/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_type&term=$matches[1]&embed=true\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_type&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_type&term=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:29:\"module_width/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=module_width&term=$matches[1]&embed=true\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=module_width&term=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:48:\"index.php?taxonomy=module_width&term=$matches[1]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:22:\"scope/([^/]+)/embed/?$\";s:52:\"index.php?taxonomy=scope&term=$matches[1]&embed=true\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?taxonomy=scope&term=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:41:\"index.php?taxonomy=scope&term=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:37:\"et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:51:\"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:32:\"et_tb_item_type/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&embed=true\";s:44:\"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&paged=$matches[2]\";s:26:\"et_tb_item_type/([^/]+)/?$\";s:51:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]\";s:38:\"et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:31:\"et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:39:\"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:46:\"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:35:\"et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:27:\"et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:45:\"language_switcher/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"language_switcher/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"language_switcher/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"language_switcher/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"language_switcher/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"language_switcher/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"language_switcher/([^/]+)/embed/?$\";s:50:\"index.php?language_switcher=$matches[1]&embed=true\";s:38:\"language_switcher/([^/]+)/trackback/?$\";s:44:\"index.php?language_switcher=$matches[1]&tb=1\";s:46:\"language_switcher/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?language_switcher=$matches[1]&paged=$matches[2]\";s:53:\"language_switcher/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?language_switcher=$matches[1]&cpage=$matches[2]\";s:42:\"language_switcher/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?language_switcher=$matches[1]&page=$matches[2]\";s:34:\"language_switcher/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"language_switcher/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"language_switcher/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"language_switcher/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"language_switcher/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"language_switcher/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_options/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_options/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_options/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_options/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_options&name=$matches[1]&embed=true\";s:37:\"et_theme_options/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_options&name=$matches[1]&tb=1\";s:45:\"et_theme_options/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_options/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_options/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_options&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_options/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_options/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_options/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:56:\"et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:37:\"et_code_snippet_type/([^/]+)/embed/?$\";s:53:\"index.php?et_code_snippet_type=$matches[1]&embed=true\";s:49:\"et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]\";s:31:\"et_code_snippet_type/([^/]+)/?$\";s:42:\"index.php?et_code_snippet_type=$matches[1]\";s:43:\"et_code_snippet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"et_code_snippet/([^/]+)/embed/?$\";s:63:\"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true\";s:36:\"et_code_snippet/([^/]+)/trackback/?$\";s:57:\"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1\";s:44:\"et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]\";s:51:\"et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]\";s:40:\"et_code_snippet/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]\";s:32:\"et_code_snippet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"et_code_snippet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"et_code_snippet/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=64&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wpcx_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpcx_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpcx_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpcx_options` VALUES("33", "active_plugins", "a:7:{i:1;s:31:\"creame-whatsapp-me/joinchat.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:49:\"gtmetrix-for-wordpress/gtmetrix-for-wordpress.php\";i:5;s:27:\"redirection/redirection.php\";i:7;s:21:\"safe-svg/safe-svg.php\";i:8;s:37:\"translatepress-multilingual/index.php\";i:9;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wpcx_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpcx_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wpcx_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpcx_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpcx_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpcx_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wpcx_options` VALUES("40", "template", "Divi", "yes");
INSERT INTO `wpcx_options` VALUES("41", "stylesheet", "Divi", "yes");
INSERT INTO `wpcx_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wpcx_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wpcx_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wpcx_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wpcx_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wpcx_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpcx_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wpcx_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wpcx_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wpcx_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wpcx_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wpcx_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wpcx_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wpcx_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wpcx_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpcx_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpcx_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wpcx_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wpcx_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wpcx_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wpcx_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wpcx_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wpcx_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wpcx_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wpcx_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wpcx_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wpcx_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wpcx_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wpcx_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wpcx_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wpcx_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wpcx_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wpcx_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wpcx_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpcx_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("79", "uninstall_plugins", "a:3:{s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "no");
INSERT INTO `wpcx_options` VALUES("80", "timezone_string", "America/Sao_Paulo", "yes");
INSERT INTO `wpcx_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wpcx_options` VALUES("82", "page_on_front", "64", "yes");
INSERT INTO `wpcx_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wpcx_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wpcx_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpcx_options` VALUES("86", "site_icon", "122", "yes");
INSERT INTO `wpcx_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wpcx_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wpcx_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wpcx_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wpcx_options` VALUES("91", "admin_email_lifespan", "1723504761", "yes");
INSERT INTO `wpcx_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wpcx_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wpcx_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wpcx_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wpcx_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wpcx_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wpcx_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wpcx_options` VALUES("99", "wp_attachment_pages_enabled", "0", "yes");
INSERT INTO `wpcx_options` VALUES("100", "initial_db_version", "56657", "yes");
INSERT INTO `wpcx_options` VALUES("101", "wpcx_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:70:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:10:\"loco_admin\";b:1;s:20:\"wpseo_manage_options\";b:1;s:15:\"access_gtmetrix\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wpcx_options` VALUES("102", "fresh_site", "0", "yes");
INSERT INTO `wpcx_options` VALUES("103", "WPLANG", "pt_BR", "yes");
INSERT INTO `wpcx_options` VALUES("104", "user_count", "1", "no");
INSERT INTO `wpcx_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:156:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Posts recentes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:224:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentários</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Arquivos</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorias</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("106", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wpcx_options` VALUES("107", "cron", "a:14:{i:1712168362;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1712170800;a:1:{s:16:\"gfw_hourly_event\";a:1:{s:32:\"26b69dc9b9c77e4c1647111635ada6f2\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:1:{i:0;s:6:\"hourly\";}s:8:\"interval\";i:3600;}}}i:1712186362;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1712186381;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1712187775;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712189575;a:1:{s:21:\"trp_plugin_optin_sync\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712193427;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1712194152;a:1:{s:22:\"redirection_log_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1712196000;a:1:{s:15:\"gfw_daily_event\";a:1:{s:32:\"b681bdb4ffa2e3ee000b79d7717b3cad\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:5:\"daily\";}s:8:\"interval\";i:86400;}}}i:1712272762;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712282400;a:1:{s:16:\"gfw_weekly_event\";a:1:{s:32:\"3da684f71cbffda6ffbf128968c0ca47\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:1:{i:0;s:6:\"weekly\";}s:8:\"interval\";i:604800;}}}i:1713180056;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1713319200;a:1:{s:17:\"gfw_monthly_event\";a:1:{s:32:\"21daff591fc782d9882e919049132e18\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:1:{i:0;s:7:\"monthly\";}s:8:\"interval\";i:2635200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpcx_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.4.3\";s:5:\"files\";a:500:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:20:\"block/editor-rtl.css\";i:29;s:24:\"block/editor-rtl.min.css\";i:30;s:16:\"block/editor.css\";i:31;s:20:\"block/editor.min.css\";i:32;s:21:\"button/editor-rtl.css\";i:33;s:25:\"button/editor-rtl.min.css\";i:34;s:17:\"button/editor.css\";i:35;s:21:\"button/editor.min.css\";i:36;s:20:\"button/style-rtl.css\";i:37;s:24:\"button/style-rtl.min.css\";i:38;s:16:\"button/style.css\";i:39;s:20:\"button/style.min.css\";i:40;s:22:\"buttons/editor-rtl.css\";i:41;s:26:\"buttons/editor-rtl.min.css\";i:42;s:18:\"buttons/editor.css\";i:43;s:22:\"buttons/editor.min.css\";i:44;s:21:\"buttons/style-rtl.css\";i:45;s:25:\"buttons/style-rtl.min.css\";i:46;s:17:\"buttons/style.css\";i:47;s:21:\"buttons/style.min.css\";i:48;s:22:\"calendar/style-rtl.css\";i:49;s:26:\"calendar/style-rtl.min.css\";i:50;s:18:\"calendar/style.css\";i:51;s:22:\"calendar/style.min.css\";i:52;s:25:\"categories/editor-rtl.css\";i:53;s:29:\"categories/editor-rtl.min.css\";i:54;s:21:\"categories/editor.css\";i:55;s:25:\"categories/editor.min.css\";i:56;s:24:\"categories/style-rtl.css\";i:57;s:28:\"categories/style-rtl.min.css\";i:58;s:20:\"categories/style.css\";i:59;s:24:\"categories/style.min.css\";i:60;s:19:\"code/editor-rtl.css\";i:61;s:23:\"code/editor-rtl.min.css\";i:62;s:15:\"code/editor.css\";i:63;s:19:\"code/editor.min.css\";i:64;s:18:\"code/style-rtl.css\";i:65;s:22:\"code/style-rtl.min.css\";i:66;s:14:\"code/style.css\";i:67;s:18:\"code/style.min.css\";i:68;s:18:\"code/theme-rtl.css\";i:69;s:22:\"code/theme-rtl.min.css\";i:70;s:14:\"code/theme.css\";i:71;s:18:\"code/theme.min.css\";i:72;s:22:\"columns/editor-rtl.css\";i:73;s:26:\"columns/editor-rtl.min.css\";i:74;s:18:\"columns/editor.css\";i:75;s:22:\"columns/editor.min.css\";i:76;s:21:\"columns/style-rtl.css\";i:77;s:25:\"columns/style-rtl.min.css\";i:78;s:17:\"columns/style.css\";i:79;s:21:\"columns/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:30:\"comment-template/style-rtl.css\";i:85;s:34:\"comment-template/style-rtl.min.css\";i:86;s:26:\"comment-template/style.css\";i:87;s:30:\"comment-template/style.min.css\";i:88;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:89;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:90;s:38:\"comments-pagination-numbers/editor.css\";i:91;s:42:\"comments-pagination-numbers/editor.min.css\";i:92;s:34:\"comments-pagination/editor-rtl.css\";i:93;s:38:\"comments-pagination/editor-rtl.min.css\";i:94;s:30:\"comments-pagination/editor.css\";i:95;s:34:\"comments-pagination/editor.min.css\";i:96;s:33:\"comments-pagination/style-rtl.css\";i:97;s:37:\"comments-pagination/style-rtl.min.css\";i:98;s:29:\"comments-pagination/style.css\";i:99;s:33:\"comments-pagination/style.min.css\";i:100;s:29:\"comments-title/editor-rtl.css\";i:101;s:33:\"comments-title/editor-rtl.min.css\";i:102;s:25:\"comments-title/editor.css\";i:103;s:29:\"comments-title/editor.min.css\";i:104;s:23:\"comments/editor-rtl.css\";i:105;s:27:\"comments/editor-rtl.min.css\";i:106;s:19:\"comments/editor.css\";i:107;s:23:\"comments/editor.min.css\";i:108;s:22:\"comments/style-rtl.css\";i:109;s:26:\"comments/style-rtl.min.css\";i:110;s:18:\"comments/style.css\";i:111;s:22:\"comments/style.min.css\";i:112;s:20:\"cover/editor-rtl.css\";i:113;s:24:\"cover/editor-rtl.min.css\";i:114;s:16:\"cover/editor.css\";i:115;s:20:\"cover/editor.min.css\";i:116;s:19:\"cover/style-rtl.css\";i:117;s:23:\"cover/style-rtl.min.css\";i:118;s:15:\"cover/style.css\";i:119;s:19:\"cover/style.min.css\";i:120;s:22:\"details/editor-rtl.css\";i:121;s:26:\"details/editor-rtl.min.css\";i:122;s:18:\"details/editor.css\";i:123;s:22:\"details/editor.min.css\";i:124;s:21:\"details/style-rtl.css\";i:125;s:25:\"details/style-rtl.min.css\";i:126;s:17:\"details/style.css\";i:127;s:21:\"details/style.min.css\";i:128;s:20:\"embed/editor-rtl.css\";i:129;s:24:\"embed/editor-rtl.min.css\";i:130;s:16:\"embed/editor.css\";i:131;s:20:\"embed/editor.min.css\";i:132;s:19:\"embed/style-rtl.css\";i:133;s:23:\"embed/style-rtl.min.css\";i:134;s:15:\"embed/style.css\";i:135;s:19:\"embed/style.min.css\";i:136;s:19:\"embed/theme-rtl.css\";i:137;s:23:\"embed/theme-rtl.min.css\";i:138;s:15:\"embed/theme.css\";i:139;s:19:\"embed/theme.min.css\";i:140;s:19:\"file/editor-rtl.css\";i:141;s:23:\"file/editor-rtl.min.css\";i:142;s:15:\"file/editor.css\";i:143;s:19:\"file/editor.min.css\";i:144;s:18:\"file/style-rtl.css\";i:145;s:22:\"file/style-rtl.min.css\";i:146;s:14:\"file/style.css\";i:147;s:18:\"file/style.min.css\";i:148;s:23:\"footnotes/style-rtl.css\";i:149;s:27:\"footnotes/style-rtl.min.css\";i:150;s:19:\"footnotes/style.css\";i:151;s:23:\"footnotes/style.min.css\";i:152;s:23:\"freeform/editor-rtl.css\";i:153;s:27:\"freeform/editor-rtl.min.css\";i:154;s:19:\"freeform/editor.css\";i:155;s:23:\"freeform/editor.min.css\";i:156;s:22:\"gallery/editor-rtl.css\";i:157;s:26:\"gallery/editor-rtl.min.css\";i:158;s:18:\"gallery/editor.css\";i:159;s:22:\"gallery/editor.min.css\";i:160;s:21:\"gallery/style-rtl.css\";i:161;s:25:\"gallery/style-rtl.min.css\";i:162;s:17:\"gallery/style.css\";i:163;s:21:\"gallery/style.min.css\";i:164;s:21:\"gallery/theme-rtl.css\";i:165;s:25:\"gallery/theme-rtl.min.css\";i:166;s:17:\"gallery/theme.css\";i:167;s:21:\"gallery/theme.min.css\";i:168;s:20:\"group/editor-rtl.css\";i:169;s:24:\"group/editor-rtl.min.css\";i:170;s:16:\"group/editor.css\";i:171;s:20:\"group/editor.min.css\";i:172;s:19:\"group/style-rtl.css\";i:173;s:23:\"group/style-rtl.min.css\";i:174;s:15:\"group/style.css\";i:175;s:19:\"group/style.min.css\";i:176;s:19:\"group/theme-rtl.css\";i:177;s:23:\"group/theme-rtl.min.css\";i:178;s:15:\"group/theme.css\";i:179;s:19:\"group/theme.min.css\";i:180;s:21:\"heading/style-rtl.css\";i:181;s:25:\"heading/style-rtl.min.css\";i:182;s:17:\"heading/style.css\";i:183;s:21:\"heading/style.min.css\";i:184;s:19:\"html/editor-rtl.css\";i:185;s:23:\"html/editor-rtl.min.css\";i:186;s:15:\"html/editor.css\";i:187;s:19:\"html/editor.min.css\";i:188;s:20:\"image/editor-rtl.css\";i:189;s:24:\"image/editor-rtl.min.css\";i:190;s:16:\"image/editor.css\";i:191;s:20:\"image/editor.min.css\";i:192;s:19:\"image/style-rtl.css\";i:193;s:23:\"image/style-rtl.min.css\";i:194;s:15:\"image/style.css\";i:195;s:19:\"image/style.min.css\";i:196;s:19:\"image/theme-rtl.css\";i:197;s:23:\"image/theme-rtl.min.css\";i:198;s:15:\"image/theme.css\";i:199;s:19:\"image/theme.min.css\";i:200;s:29:\"latest-comments/style-rtl.css\";i:201;s:33:\"latest-comments/style-rtl.min.css\";i:202;s:25:\"latest-comments/style.css\";i:203;s:29:\"latest-comments/style.min.css\";i:204;s:27:\"latest-posts/editor-rtl.css\";i:205;s:31:\"latest-posts/editor-rtl.min.css\";i:206;s:23:\"latest-posts/editor.css\";i:207;s:27:\"latest-posts/editor.min.css\";i:208;s:26:\"latest-posts/style-rtl.css\";i:209;s:30:\"latest-posts/style-rtl.min.css\";i:210;s:22:\"latest-posts/style.css\";i:211;s:26:\"latest-posts/style.min.css\";i:212;s:18:\"list/style-rtl.css\";i:213;s:22:\"list/style-rtl.min.css\";i:214;s:14:\"list/style.css\";i:215;s:18:\"list/style.min.css\";i:216;s:25:\"media-text/editor-rtl.css\";i:217;s:29:\"media-text/editor-rtl.min.css\";i:218;s:21:\"media-text/editor.css\";i:219;s:25:\"media-text/editor.min.css\";i:220;s:24:\"media-text/style-rtl.css\";i:221;s:28:\"media-text/style-rtl.min.css\";i:222;s:20:\"media-text/style.css\";i:223;s:24:\"media-text/style.min.css\";i:224;s:19:\"more/editor-rtl.css\";i:225;s:23:\"more/editor-rtl.min.css\";i:226;s:15:\"more/editor.css\";i:227;s:19:\"more/editor.min.css\";i:228;s:30:\"navigation-link/editor-rtl.css\";i:229;s:34:\"navigation-link/editor-rtl.min.css\";i:230;s:26:\"navigation-link/editor.css\";i:231;s:30:\"navigation-link/editor.min.css\";i:232;s:29:\"navigation-link/style-rtl.css\";i:233;s:33:\"navigation-link/style-rtl.min.css\";i:234;s:25:\"navigation-link/style.css\";i:235;s:29:\"navigation-link/style.min.css\";i:236;s:33:\"navigation-submenu/editor-rtl.css\";i:237;s:37:\"navigation-submenu/editor-rtl.min.css\";i:238;s:29:\"navigation-submenu/editor.css\";i:239;s:33:\"navigation-submenu/editor.min.css\";i:240;s:25:\"navigation/editor-rtl.css\";i:241;s:29:\"navigation/editor-rtl.min.css\";i:242;s:21:\"navigation/editor.css\";i:243;s:25:\"navigation/editor.min.css\";i:244;s:24:\"navigation/style-rtl.css\";i:245;s:28:\"navigation/style-rtl.min.css\";i:246;s:20:\"navigation/style.css\";i:247;s:24:\"navigation/style.min.css\";i:248;s:23:\"nextpage/editor-rtl.css\";i:249;s:27:\"nextpage/editor-rtl.min.css\";i:250;s:19:\"nextpage/editor.css\";i:251;s:23:\"nextpage/editor.min.css\";i:252;s:24:\"page-list/editor-rtl.css\";i:253;s:28:\"page-list/editor-rtl.min.css\";i:254;s:20:\"page-list/editor.css\";i:255;s:24:\"page-list/editor.min.css\";i:256;s:23:\"page-list/style-rtl.css\";i:257;s:27:\"page-list/style-rtl.min.css\";i:258;s:19:\"page-list/style.css\";i:259;s:23:\"page-list/style.min.css\";i:260;s:24:\"paragraph/editor-rtl.css\";i:261;s:28:\"paragraph/editor-rtl.min.css\";i:262;s:20:\"paragraph/editor.css\";i:263;s:24:\"paragraph/editor.min.css\";i:264;s:23:\"paragraph/style-rtl.css\";i:265;s:27:\"paragraph/style-rtl.min.css\";i:266;s:19:\"paragraph/style.css\";i:267;s:23:\"paragraph/style.min.css\";i:268;s:25:\"post-author/style-rtl.css\";i:269;s:29:\"post-author/style-rtl.min.css\";i:270;s:21:\"post-author/style.css\";i:271;s:25:\"post-author/style.min.css\";i:272;s:33:\"post-comments-form/editor-rtl.css\";i:273;s:37:\"post-comments-form/editor-rtl.min.css\";i:274;s:29:\"post-comments-form/editor.css\";i:275;s:33:\"post-comments-form/editor.min.css\";i:276;s:32:\"post-comments-form/style-rtl.css\";i:277;s:36:\"post-comments-form/style-rtl.min.css\";i:278;s:28:\"post-comments-form/style.css\";i:279;s:32:\"post-comments-form/style.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"query/style-rtl.css\";i:357;s:23:\"query/style-rtl.min.css\";i:358;s:15:\"query/style.css\";i:359;s:19:\"query/style.min.css\";i:360;s:19:\"quote/style-rtl.css\";i:361;s:23:\"quote/style-rtl.min.css\";i:362;s:15:\"quote/style.css\";i:363;s:19:\"quote/style.min.css\";i:364;s:19:\"quote/theme-rtl.css\";i:365;s:23:\"quote/theme-rtl.min.css\";i:366;s:15:\"quote/theme.css\";i:367;s:19:\"quote/theme.min.css\";i:368;s:23:\"read-more/style-rtl.css\";i:369;s:27:\"read-more/style-rtl.min.css\";i:370;s:19:\"read-more/style.css\";i:371;s:23:\"read-more/style.min.css\";i:372;s:18:\"rss/editor-rtl.css\";i:373;s:22:\"rss/editor-rtl.min.css\";i:374;s:14:\"rss/editor.css\";i:375;s:18:\"rss/editor.min.css\";i:376;s:17:\"rss/style-rtl.css\";i:377;s:21:\"rss/style-rtl.min.css\";i:378;s:13:\"rss/style.css\";i:379;s:17:\"rss/style.min.css\";i:380;s:21:\"search/editor-rtl.css\";i:381;s:25:\"search/editor-rtl.min.css\";i:382;s:17:\"search/editor.css\";i:383;s:21:\"search/editor.min.css\";i:384;s:20:\"search/style-rtl.css\";i:385;s:24:\"search/style-rtl.min.css\";i:386;s:16:\"search/style.css\";i:387;s:20:\"search/style.min.css\";i:388;s:20:\"search/theme-rtl.css\";i:389;s:24:\"search/theme-rtl.min.css\";i:390;s:16:\"search/theme.css\";i:391;s:20:\"search/theme.min.css\";i:392;s:24:\"separator/editor-rtl.css\";i:393;s:28:\"separator/editor-rtl.min.css\";i:394;s:20:\"separator/editor.css\";i:395;s:24:\"separator/editor.min.css\";i:396;s:23:\"separator/style-rtl.css\";i:397;s:27:\"separator/style-rtl.min.css\";i:398;s:19:\"separator/style.css\";i:399;s:23:\"separator/style.min.css\";i:400;s:23:\"separator/theme-rtl.css\";i:401;s:27:\"separator/theme-rtl.min.css\";i:402;s:19:\"separator/theme.css\";i:403;s:23:\"separator/theme.min.css\";i:404;s:24:\"shortcode/editor-rtl.css\";i:405;s:28:\"shortcode/editor-rtl.min.css\";i:406;s:20:\"shortcode/editor.css\";i:407;s:24:\"shortcode/editor.min.css\";i:408;s:24:\"site-logo/editor-rtl.css\";i:409;s:28:\"site-logo/editor-rtl.min.css\";i:410;s:20:\"site-logo/editor.css\";i:411;s:24:\"site-logo/editor.min.css\";i:412;s:23:\"site-logo/style-rtl.css\";i:413;s:27:\"site-logo/style-rtl.min.css\";i:414;s:19:\"site-logo/style.css\";i:415;s:23:\"site-logo/style.min.css\";i:416;s:27:\"site-tagline/editor-rtl.css\";i:417;s:31:\"site-tagline/editor-rtl.min.css\";i:418;s:23:\"site-tagline/editor.css\";i:419;s:27:\"site-tagline/editor.min.css\";i:420;s:25:\"site-title/editor-rtl.css\";i:421;s:29:\"site-title/editor-rtl.min.css\";i:422;s:21:\"site-title/editor.css\";i:423;s:25:\"site-title/editor.min.css\";i:424;s:24:\"site-title/style-rtl.css\";i:425;s:28:\"site-title/style-rtl.min.css\";i:426;s:20:\"site-title/style.css\";i:427;s:24:\"site-title/style.min.css\";i:428;s:26:\"social-link/editor-rtl.css\";i:429;s:30:\"social-link/editor-rtl.min.css\";i:430;s:22:\"social-link/editor.css\";i:431;s:26:\"social-link/editor.min.css\";i:432;s:27:\"social-links/editor-rtl.css\";i:433;s:31:\"social-links/editor-rtl.min.css\";i:434;s:23:\"social-links/editor.css\";i:435;s:27:\"social-links/editor.min.css\";i:436;s:26:\"social-links/style-rtl.css\";i:437;s:30:\"social-links/style-rtl.min.css\";i:438;s:22:\"social-links/style.css\";i:439;s:26:\"social-links/style.min.css\";i:440;s:21:\"spacer/editor-rtl.css\";i:441;s:25:\"spacer/editor-rtl.min.css\";i:442;s:17:\"spacer/editor.css\";i:443;s:21:\"spacer/editor.min.css\";i:444;s:20:\"spacer/style-rtl.css\";i:445;s:24:\"spacer/style-rtl.min.css\";i:446;s:16:\"spacer/style.css\";i:447;s:20:\"spacer/style.min.css\";i:448;s:20:\"table/editor-rtl.css\";i:449;s:24:\"table/editor-rtl.min.css\";i:450;s:16:\"table/editor.css\";i:451;s:20:\"table/editor.min.css\";i:452;s:19:\"table/style-rtl.css\";i:453;s:23:\"table/style-rtl.min.css\";i:454;s:15:\"table/style.css\";i:455;s:19:\"table/style.min.css\";i:456;s:19:\"table/theme-rtl.css\";i:457;s:23:\"table/theme-rtl.min.css\";i:458;s:15:\"table/theme.css\";i:459;s:19:\"table/theme.min.css\";i:460;s:23:\"tag-cloud/style-rtl.css\";i:461;s:27:\"tag-cloud/style-rtl.min.css\";i:462;s:19:\"tag-cloud/style.css\";i:463;s:23:\"tag-cloud/style.min.css\";i:464;s:28:\"template-part/editor-rtl.css\";i:465;s:32:\"template-part/editor-rtl.min.css\";i:466;s:24:\"template-part/editor.css\";i:467;s:28:\"template-part/editor.min.css\";i:468;s:27:\"template-part/theme-rtl.css\";i:469;s:31:\"template-part/theme-rtl.min.css\";i:470;s:23:\"template-part/theme.css\";i:471;s:27:\"template-part/theme.min.css\";i:472;s:30:\"term-description/style-rtl.css\";i:473;s:34:\"term-description/style-rtl.min.css\";i:474;s:26:\"term-description/style.css\";i:475;s:30:\"term-description/style.min.css\";i:476;s:27:\"text-columns/editor-rtl.css\";i:477;s:31:\"text-columns/editor-rtl.min.css\";i:478;s:23:\"text-columns/editor.css\";i:479;s:27:\"text-columns/editor.min.css\";i:480;s:26:\"text-columns/style-rtl.css\";i:481;s:30:\"text-columns/style-rtl.min.css\";i:482;s:22:\"text-columns/style.css\";i:483;s:26:\"text-columns/style.min.css\";i:484;s:19:\"verse/style-rtl.css\";i:485;s:23:\"verse/style-rtl.min.css\";i:486;s:15:\"verse/style.css\";i:487;s:19:\"verse/style.min.css\";i:488;s:20:\"video/editor-rtl.css\";i:489;s:24:\"video/editor-rtl.min.css\";i:490;s:16:\"video/editor.css\";i:491;s:20:\"video/editor.min.css\";i:492;s:19:\"video/style-rtl.css\";i:493;s:23:\"video/style-rtl.min.css\";i:494;s:15:\"video/style.css\";i:495;s:19:\"video/style.min.css\";i:496;s:19:\"video/theme-rtl.css\";i:497;s:23:\"video/theme-rtl.min.css\";i:498;s:15:\"video/theme.css\";i:499;s:19:\"video/theme.min.css\";}}", "yes");
INSERT INTO `wpcx_options` VALUES("124", "theme_mods_twentytwentyfour", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1707952855;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wpcx_options` VALUES("125", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wpcx_options` VALUES("154", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wpcx_options` VALUES("155", "current_theme", "Divi", "yes");
INSERT INTO `wpcx_options` VALUES("156", "theme_mods_Divi", "a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:6;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}", "yes");
INSERT INTO `wpcx_options` VALUES("157", "theme_switched", "", "yes");
INSERT INTO `wpcx_options` VALUES("158", "et_pb_cache_notice", "a:1:{s:6:\"4.22.1\";s:6:\"ignore\";}", "yes");
INSERT INTO `wpcx_options` VALUES("163", "et_core_version", "4.24.3", "yes");
INSERT INTO `wpcx_options` VALUES("165", "et_divi", "a:180:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:29:\"presets_storage_migrated_flag\";b:1;s:39:\"builder_global_presets_history_migrated\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:6:\"4.24.3\";s:31:\"divi_previous_installed_version\";s:6:\"4.24.2\";s:29:\"divi_latest_installed_version\";s:6:\"4.24.3\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:29:\"custom_defaults_migrated_flag\";b:1;s:9:\"divi_logo\";s:89:\"https://connectionx.sousalimaconsultoria.com.br/wp-content/uploads/2024/02/Ativo-2@4x.png\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:23:\"divi_show_facebook_icon\";s:5:\"false\";s:22:\"divi_show_twitter_icon\";s:5:\"false\";s:24:\"divi_show_instagram_icon\";s:5:\"false\";s:18:\"divi_show_rss_icon\";s:5:\"false\";s:17:\"divi_facebook_url\";s:1:\"#\";s:16:\"divi_twitter_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:16:\"divi_back_to_top\";s:2:\"on\";s:18:\"divi_smooth_scroll\";s:2:\"on\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:15:\"divi_custom_css\";s:256:\"@media (max-width: 980px) {\r\n .container.et_menu_container { \r\n width: calc( 100% - 60px);\r\n }\r\n}\r\n\r\n.et_mobile_menu {\r\n margin-left: -30px;\r\n padding: 5%;\r\n width: calc( 100% + 60px);\r\n}\r\n\r\n.mobile_nav.opened .mobile_menu_bar:before {\r\n content: \"4d\";\r\n} \";s:29:\"divi_dynamic_module_framework\";s:2:\"on\";s:16:\"divi_dynamic_css\";s:2:\"on\";s:18:\"divi_dynamic_icons\";s:2:\"on\";s:22:\"divi_inline_stylesheet\";s:2:\"on\";s:17:\"divi_critical_css\";s:2:\"on\";s:30:\"divi_critical_threshold_height\";s:5:\"Baixo\";s:25:\"divi_dynamic_js_libraries\";s:2:\"on\";s:19:\"divi_disable_emojis\";s:2:\"on\";s:20:\"divi_defer_block_css\";s:2:\"on\";s:24:\"divi_google_fonts_inline\";s:5:\"false\";s:51:\"divi_limit_google_fonts_support_for_legacy_browsers\";s:2:\"on\";s:23:\"divi_enable_jquery_body\";s:2:\"on\";s:32:\"divi_enable_jquery_compatibility\";s:2:\"on\";s:29:\"divi_enable_jquery_body_super\";s:5:\"false\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:3:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";}s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:3:\"off\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:19:\"product_tour_status\";a:1:{i:1;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:46:\"et_fb_pref_builder_enable_visual_theme_builder\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:4:\"left\";s:21:\"et_fb_pref_modal_snap\";s:4:\"true\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:400;s:33:\"et_fb_pref_modal_dimension_height\";i:400;s:27:\"et_fb_pref_modal_position_x\";i:30;s:27:\"et_fb_pref_modal_position_y\";i:400;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:444;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:300;s:30:\"et_fb_pref_lv_modal_position_x\";i:459;s:30:\"et_fb_pref_lv_modal_position_y\";i:400;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:12:\"heading_font\";s:6:\"Ubuntu\";s:9:\"body_font\";s:6:\"Ubuntu\";s:16:\"body_header_size\";i:36;s:10:\"link_color\";s:7:\"#49aa3c\";s:11:\"menu_height\";i:66;s:11:\"logo_height\";i:93;s:29:\"disable_custom_footer_credits\";b:1;s:16:\"show_search_icon\";b:0;s:16:\"et_global_colors\";a:4:{s:41:\"gcid-1bcf785a-50e1-437b-b09f-65567babc1de\";a:2:{s:5:\"color\";s:7:\"#0f0122\";s:6:\"active\";s:3:\"yes\";}s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";a:2:{s:5:\"color\";s:7:\"#32c8d9\";s:6:\"active\";s:3:\"yes\";}s:41:\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\";a:2:{s:5:\"color\";s:7:\"#793aff\";s:6:\"active\";s:3:\"yes\";}s:41:\"gcid-f1f9244b-c8ab-43e1-95c3-c0bdf69ac7b5\";a:2:{s:5:\"color\";s:7:\"#0f0122\";s:6:\"active\";s:3:\"yes\";}}s:12:\"header_style\";s:4:\"left\";s:12:\"vertical_nav\";b:0;s:13:\"nav_fullwidth\";b:1;s:14:\"primary_nav_bg\";s:7:\"#0f0122\";s:9:\"menu_link\";s:22:\"rgba(255,255,255,0.81)\";s:16:\"menu_link_active\";s:7:\"#ffffff\";s:23:\"primary_nav_dropdown_bg\";s:7:\"#0d0021\";s:31:\"primary_nav_dropdown_link_color\";s:22:\"rgba(255,255,255,0.81)\";s:25:\"secondary_nav_dropdown_bg\";s:7:\"#000000\";s:12:\"divi_favicon\";s:0:\"\";}", "yes");
INSERT INTO `wpcx_options` VALUES("166", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("167", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("168", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("169", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("170", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("171", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("172", "et_safe_mode_plugins_allowlist", "a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `wpcx_options` VALUES("173", "et_support_center_installed", "true", "yes");
INSERT INTO `wpcx_options` VALUES("174", "et_images_temp_folder", "/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/uploads/et_temp", "yes");
INSERT INTO `wpcx_options` VALUES("175", "et_schedule_clean_images_last_time", "1711633049", "yes");
INSERT INTO `wpcx_options` VALUES("176", "et_bfb_settings", "a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}", "yes");
INSERT INTO `wpcx_options` VALUES("177", "_transient_et_builder_show_bfb_welcome_modal", "1", "yes");
INSERT INTO `wpcx_options` VALUES("178", "et_support_center_setup_done", "processed", "yes");
INSERT INTO `wpcx_options` VALUES("179", "et_pb_builder_options", "a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("180", "et_divi_builder_global_presets_ng", "O:8:\"stdClass\":8:{s:10:\"et_pb_text\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":11:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"Текст Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"c465de18-8f22-47eb-b105-9d4b2640d1f2\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"H4 Subheading\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:18:\"header_4_font_size\";s:4:\"14px\";s:20:\"header_4_line_height\";s:5:\"1.5em\";s:13:\"custom_margin\";s:18:\"||0px||false|false\";s:13:\"header_4_font\";s:18:\"Inter|700||on|||||\";s:23:\"header_4_letter_spacing\";s:3:\"1px\";s:19:\"header_4_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:18:\"global_colors_info\";s:69:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"header_4_text_color\"]}\";}}s:36:\"09a353db-159e-4e83-864c-9195d86cbf58\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H1\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:16:\"header_font_size\";s:4:\"75px\";s:22:\"header_font_size_phone\";s:4:\"24px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.2em\";s:23:\"header_font_size_tablet\";s:4:\"40px\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";}}s:36:\"bf4cbcbe-72ce-49de-a121-5ff106b9fd3b\";O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Body\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.4\";s:8:\"settings\";O:8:\"stdClass\":8:{s:28:\"header_font_size_last_edited\";s:11:\"off|desktop\";s:23:\"header_font_size_tablet\";s:4:\"55px\";s:14:\"text_font_size\";s:4:\"16px\";s:21:\"text_font_size_tablet\";s:4:\"15px\";s:20:\"text_font_size_phone\";s:4:\"14px\";s:26:\"text_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"text_line_height\";s:5:\"1.8em\";s:15:\"text_text_color\";s:22:\"rgba(255,255,255,0.75)\";}}s:36:\"8c513909-9003-4a53-bec5-0e5b54331033\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H2\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:13:\"header_2_font\";s:16:\"Inter|700|||||||\";s:18:\"header_2_font_size\";s:4:\"48px\";s:25:\"header_2_font_size_tablet\";s:4:\"32px\";s:24:\"header_2_font_size_phone\";s:4:\"20px\";s:30:\"header_2_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_2_line_height\";s:5:\"1.2em\";s:19:\"header_2_text_color\";s:7:\"#FFFFFF\";}}s:36:\"e8b52690-756d-4e5b-ac68-9003472e9075\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H5\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":6:{s:19:\"header_5_text_color\";s:7:\"#FFFFFF\";s:13:\"header_5_font\";s:16:\"Inter|700|||||||\";s:20:\"header_5_line_height\";s:5:\"1.4em\";s:25:\"header_5_font_size_tablet\";s:4:\"15px\";s:24:\"header_5_font_size_phone\";s:4:\"14px\";s:30:\"header_5_font_size_last_edited\";s:10:\"on|desktop\";}}s:36:\"15df52d1-5084-4a08-9e8f-0deee2d0dcc8\";O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Body Small\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.7\";s:8:\"settings\";O:8:\"stdClass\":4:{s:28:\"header_font_size_last_edited\";s:11:\"off|desktop\";s:23:\"header_font_size_tablet\";s:4:\"55px\";s:16:\"text_line_height\";s:5:\"1.6em\";s:15:\"text_text_color\";s:22:\"rgba(255,255,255,0.75)\";}}s:36:\"07ebcc14-f9e1-4ebd-9e16-ffa3798c9e53\";O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"H2 as H1\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":7:{s:13:\"header_2_font\";s:16:\"Inter|700|||||||\";s:19:\"header_2_text_color\";s:7:\"#FFFFFF\";s:18:\"header_2_font_size\";s:4:\"75px\";s:25:\"header_2_font_size_tablet\";s:4:\"40px\";s:24:\"header_2_font_size_phone\";s:4:\"24px\";s:30:\"header_2_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_2_line_height\";s:5:\"1.2em\";}}s:36:\"b6440af9-c330-418d-96d9-3897edeb344a\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H4\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:11:\"header_font\";s:8:\"||||||||\";s:13:\"header_4_font\";s:16:\"Inter|700|||||||\";s:20:\"header_4_line_height\";s:5:\"1.4em\";s:25:\"header_4_font_size_tablet\";s:4:\"16px\";s:24:\"header_4_font_size_phone\";s:4:\"15px\";s:30:\"header_4_font_size_last_edited\";s:10:\"on|desktop\";s:19:\"header_4_text_color\";s:7:\"#FFFFFF\";s:18:\"header_4_font_size\";s:4:\"19px\";}}s:36:\"1a5b8d73-d5e4-42ef-9296-2608b2bfc702\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H3\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:11:\"header_font\";s:8:\"||||||||\";s:13:\"header_3_font\";s:16:\"Inter|700|||||||\";s:18:\"header_3_font_size\";s:4:\"25px\";s:25:\"header_3_font_size_tablet\";s:4:\"20px\";s:24:\"header_3_font_size_phone\";s:4:\"16px\";s:30:\"header_3_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_3_line_height\";s:5:\"1.4em\";s:19:\"header_3_text_color\";s:7:\"#FFFFFF\";}}s:36:\"a00ad49a-6a5a-4a3a-8220-090b2ebc3461\";O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"H1 Big\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":6:{s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:16:\"header_font_size\";s:5:\"120px\";s:23:\"header_font_size_tablet\";s:4:\"40px\";s:22:\"header_font_size_phone\";s:4:\"24px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";}}}}s:18:\"et_pb_contact_form\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:60:\"Контактная форма Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"2df51b23-0535-4e13-a25b-43d003495833\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.13.1\";s:8:\"settings\";O:8:\"stdClass\":17:{s:13:\"custom_button\";s:2:\"on\";s:10:\"_unique_id\";s:36:\"d85b3ac5-5288-4ff0-8d76-365416e10a89\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:27:\"form_field_background_color\";s:19:\"RGBA(255,255,255,0)\";s:21:\"form_field_text_color\";s:7:\"#FFFFFF\";s:15:\"form_field_font\";s:18:\"Inter|700||on|||||\";s:16:\"border_width_all\";s:3:\"1px\";s:16:\"border_color_all\";s:7:\"#FFFFFF\";s:12:\"border_radii\";s:22:\"on|10px|10px|10px|10px\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\":[\"button_bg_color\"]}\";}}}}s:15:\"et_pb_accordion\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:62:\"Элемент-аккордион Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"3c1473fb-7bd2-44ff-a3d5-7e4bf5718698\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":20:{s:11:\"toggle_font\";s:16:\"Inter|700|||||||\";s:17:\"toggle_text_color\";s:7:\"#FFFFFF\";s:18:\"toggle_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:23:\"background_enable_color\";s:3:\"off\";s:28:\"open_toggle_background_color\";s:41:\"gcid-f1f9244b-c8ab-43e1-95c3-c0bdf69ac7b5\";s:30:\"closed_toggle_background_color\";s:19:\"RGBA(255,255,255,0)\";s:16:\"border_width_all\";s:3:\"0px\";s:12:\"border_radii\";s:18:\"on|0px|0px|0px|0px\";s:10:\"icon_color\";s:7:\"#FFFFFF\";s:18:\"global_colors_info\";s:78:\"{\"gcid-f1f9244b-c8ab-43e1-95c3-c0bdf69ac7b5\":[\"open_toggle_background_color\"]}\";s:16:\"border_width_top\";s:3:\"2px\";s:16:\"border_color_all\";s:22:\"rgba(255,255,255,0.16)\";s:18:\"use_icon_font_size\";s:3:\"off\";s:11:\"toggle_icon\";s:17:\"&#x4c;||divi||400\";}}}}s:12:\"et_pb_button\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":6:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:41:\"Кнопка Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"429afed6-7753-4ada-9795-4f99d56cd3e1\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":9:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";}}s:36:\"c3b6dc80-0bc2-4c8f-8794-c9f2d8782f2a\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\":[\"button_bg_color\"]}\";}}s:36:\"b72721c5-f7dc-4e52-8c0f-533e2e524ffb\";O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Secondary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"button_bg_color\"]}\";}}s:36:\"073a2a7f-9490-4241-8bd1-aaddec630008\";O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Secondary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":8:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:19:\"RGBA(255,255,255,0)\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:14:\"custom_padding\";s:25:\"0px|0px|0px|0px|true|true\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:3:\"0px\";}}s:36:\"47ddf118-3e5b-435c-a5e8-f9ec0a3e4f65\";O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Primary Light Outline\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"1px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:15:\"button_bg_color\";s:19:\"RGBA(255,255,255,0)\";s:19:\"button_border_color\";s:7:\"#FFFFFF\";s:22:\"button_bg_enable_color\";s:2:\"on\";}}}}s:17:\"et_pb_post_slider\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:54:\"Слайдер поста Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"116c0272-93ea-495c-973c-21d68c1dff5e\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":31:{s:16:\"bg_overlay_color\";s:21:\"rgba(121,58,255,0.81)\";s:12:\"border_radii\";s:22:\"on|20px|20px|20px|20px\";s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:22:\"16px||16px||true|false\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:16:\"header_font_size\";s:4:\"25px\";s:23:\"header_font_size_tablet\";s:4:\"20px\";s:22:\"header_font_size_phone\";s:4:\"16px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:14:\"meta_font_size\";s:4:\"14px\";s:16:\"meta_line_height\";s:5:\"1.6em\";s:15:\"meta_text_color\";s:7:\"#FFFFFF\";s:19:\"arrows_custom_color\";s:7:\"#FFFFFF\";s:20:\"dot_nav_custom_color\";s:7:\"#FFFFFF\";s:9:\"show_meta\";s:3:\"off\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:2:\"{}\";}}}}s:10:\"et_pb_blog\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:37:\"Блог Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"79402496-f842-4fc2-86c5-8e8458d06734\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":30:{s:9:\"fullwidth\";s:3:\"off\";s:9:\"show_more\";s:2:\"on\";s:29:\"masonry_tile_background_color\";s:19:\"RGBA(255,255,255,0)\";s:16:\"border_width_all\";s:3:\"0px\";s:18:\"border_radii_image\";s:22:\"on|20px|20px|20px|20px\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:16:\"header_font_size\";s:4:\"19px\";s:23:\"header_font_size_tablet\";s:4:\"16px\";s:22:\"header_font_size_phone\";s:4:\"15px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:11:\"show_author\";s:3:\"off\";s:15:\"meta_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:20:\"read_more_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:14:\"meta_font_size\";s:4:\"14px\";s:19:\"read_more_font_size\";s:4:\"14px\";s:15:\"pagination_font\";s:16:\"Inter|700|||||||\";s:21:\"pagination_text_color\";s:7:\"#FFFFFF\";s:20:\"pagination_font_size\";s:4:\"16px\";s:27:\"pagination_font_size_tablet\";s:4:\"15px\";s:26:\"pagination_font_size_phone\";s:4:\"14px\";s:32:\"pagination_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"global_colors_info\";s:88:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"meta_text_color\",\"read_more_text_color\"]}\";}}}}s:12:\"et_pb_signup\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:56:\"Напишите Оптин Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"6a9d9cc9-d31d-4670-a652-290419fa1b0b\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.4\";s:8:\"settings\";O:8:\"stdClass\":19:{s:6:\"layout\";s:10:\"top_bottom\";s:13:\"custom_button\";s:2:\"on\";s:23:\"background_enable_color\";s:3:\"off\";s:20:\"use_background_color\";s:3:\"off\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:27:\"form_field_background_color\";s:19:\"RGBA(255,255,255,0)\";s:21:\"form_field_text_color\";s:7:\"#FFFFFF\";s:15:\"form_field_font\";s:18:\"Inter|700||on|||||\";s:19:\"border_radii_fields\";s:22:\"on|10px|10px|10px|10px\";s:23:\"border_color_all_fields\";s:7:\"#FFFFFF\";s:23:\"border_width_all_fields\";s:3:\"1px\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"button_bg_color\"]}\";}}}}s:20:\"et_pb_number_counter\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:61:\"Счетчик с числами Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"6800abd9-d007-4433-9917-222da7c58c36\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":11:{s:10:\"title_font\";s:18:\"Inter|700||on|||||\";s:16:\"title_text_color\";s:7:\"#FFFFFF\";s:15:\"title_font_size\";s:4:\"14px\";s:20:\"title_letter_spacing\";s:3:\"1px\";s:11:\"number_font\";s:16:\"Inter|700|||||||\";s:17:\"number_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:16:\"number_font_size\";s:4:\"75px\";s:22:\"number_font_size_phone\";s:4:\"60px\";s:28:\"number_font_size_last_edited\";s:8:\"on|phone\";s:17:\"title_line_height\";s:5:\"1.4em\";s:18:\"global_colors_info\";s:67:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"number_text_color\"]}\";}}}}}", "no");
INSERT INTO `wpcx_options` VALUES("181", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:16:\"use_google_fonts\";s:2:\"on\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";}", "yes");
INSERT INTO `wpcx_options` VALUES("182", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:10:\"marcolagoa\";s:7:\"api_key\";s:40:\"c84f1cb139beb2f5a4a9f8f39621ebcf327b263c\";}", "no");
INSERT INTO `wpcx_options` VALUES("184", "et_account_status", "active", "no");
INSERT INTO `wpcx_options` VALUES("188", "et_support_site_id", "ZybijOTa=7JGnN+t4SQx", "yes");
INSERT INTO `wpcx_options` VALUES("213", "recently_activated", "a:3:{s:27:\"redis-cache/redis-cache.php\";i:1712167859;s:35:\"litespeed-cache/litespeed-cache.php\";i:1712167838;s:25:\"cloudflare/cloudflare.php\";i:1712167836;}", "yes");
INSERT INTO `wpcx_options` VALUES("214", "_transient_et_updated_plugins_data", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1708047850;}", "yes");
INSERT INTO `wpcx_options` VALUES("430", "trp_settings", "a:15:{s:16:\"default-language\";s:5:\"pt_PT\";s:17:\"publish-languages\";a:2:{i:0;s:5:\"pt_PT\";i:1;s:5:\"en_US\";}s:21:\"translation-languages\";a:2:{i:0;s:5:\"pt_PT\";i:1;s:5:\"en_US\";}s:9:\"url-slugs\";a:2:{s:5:\"pt_PT\";s:2:\"pt\";s:5:\"en_US\";s:2:\"en\";}s:22:\"native_or_english_name\";s:12:\"english_name\";s:36:\"add-subdirectory-to-default-language\";s:2:\"no\";s:30:\"force-language-to-custom-links\";s:3:\"yes\";s:17:\"shortcode-options\";s:16:\"flags-full-names\";s:12:\"menu-options\";s:16:\"flags-full-names\";s:15:\"floater-options\";s:16:\"flags-full-names\";s:13:\"floater-color\";s:4:\"dark\";s:16:\"floater-position\";s:12:\"bottom-right\";s:14:\"trp-ls-floater\";s:2:\"no\";s:21:\"trp-ls-show-poweredby\";s:2:\"no\";s:41:\"translation-languages-formality-parameter\";a:2:{s:5:\"pt_PT\";s:7:\"default\";s:5:\"en_US\";s:7:\"default\";}}", "yes");
INSERT INTO `wpcx_options` VALUES("431", "trp_db_stored_data", "a:2:{s:17:\"install_timestamp\";i:1707955975;s:27:\"gettext_plural_forms_header\";a:4:{s:5:\"pt_BR\";s:25:\"nplurals=2; plural=n > 1;\";s:5:\"ru_RU\";s:129:\"nplurals=3; plural=(n % 10 == 1 && n % 100 != 11) ? 0 : ((n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 12 || n % 100 > 14)) ? 1 : 2);\";s:5:\"en_US\";s:26:\"nplurals=2; plural=n != 1;\";s:5:\"pt_PT\";s:26:\"nplurals=2; plural=n != 1;\";}}", "yes");
INSERT INTO `wpcx_options` VALUES("432", "trp_plugin_version", "2.7.4", "yes");
INSERT INTO `wpcx_options` VALUES("440", "trp_plugin_optin", "yes", "yes");
INSERT INTO `wpcx_options` VALUES("441", "trp_plugin_optin_email", "eolimabr@gmail.com", "yes");
INSERT INTO `wpcx_options` VALUES("442", "trp_advanced_settings", "a:24:{s:39:\"show_dynamic_content_before_translation\";s:2:\"no\";s:27:\"disable_dynamic_translation\";s:2:\"no\";s:26:\"strip_gettext_post_content\";s:2:\"no\";s:23:\"strip_gettext_post_meta\";s:2:\"no\";s:23:\"exclude_gettext_strings\";a:2:{s:6:\"string\";a:0:{}s:6:\"domain\";a:0:{}}s:33:\"exclude_words_from_auto_translate\";a:1:{s:5:\"words\";a:0:{}}s:22:\"skip_dynamic_selectors\";a:1:{s:8:\"selector\";a:0:{}}s:27:\"exclude_translate_selectors\";a:1:{s:8:\"selector\";a:0:{}}s:44:\"exclude_selectors_from_automatic_translation\";a:1:{s:8:\"selector\";a:0:{}}s:42:\"disable_post_container_tags_for_post_title\";s:2:\"no\";s:44:\"disable_post_container_tags_for_post_content\";s:2:\"no\";s:39:\"disable_translation_for_gettext_strings\";s:2:\"no\";s:38:\"show_regular_tab_in_string_translation\";s:2:\"no\";s:22:\"hreflang_remove_locale\";s:9:\"show_both\";s:23:\"html_lang_remove_locale\";s:7:\"default\";s:25:\"serve_similar_translation\";s:2:\"no\";s:27:\"force_slash_at_end_of_links\";s:2:\"no\";s:27:\"enable_numerals_translation\";s:2:\"no\";s:25:\"disable_languages_sitemap\";s:2:\"no\";s:24:\"enable_hreflang_xdefault\";s:8:\"disabled\";s:46:\"show_opposite_flag_language_switcher_shortcode\";s:2:\"no\";s:41:\"open_language_switcher_shortcode_on_click\";s:2:\"no\";s:20:\"plugin_optin_setting\";s:3:\"yes\";s:15:\"custom_language\";a:6:{s:11:\"cuslangcode\";a:0:{}s:11:\"cuslangname\";a:0:{}s:13:\"cuslangnative\";a:0:{}s:10:\"cuslangiso\";a:0:{}s:11:\"cuslangflag\";a:0:{}s:12:\"cuslangisrtl\";a:0:{}}}", "yes");
INSERT INTO `wpcx_options` VALUES("453", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wpcx_options` VALUES("463", "trp_machine_translation_settings", "a:10:{s:19:\"machine-translation\";s:2:\"no\";s:18:\"translation-engine\";s:19:\"google_translate_v2\";s:14:\"block-crawlers\";s:3:\"yes\";s:28:\"automatically-translate-slug\";s:3:\"yes\";s:32:\"machine_translation_counter_date\";s:10:\"2024-04-03\";s:25:\"machine_translation_limit\";s:7:\"1000000\";s:27:\"machine_translation_counter\";i:0;s:20:\"google-translate-key\";s:0:\"\";s:23:\"machine_translation_log\";s:2:\"no\";s:46:\"machine_translation_trigger_quota_notification\";b:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("529", "et_divi_builder_global_presets_history_ng", "O:8:\"stdClass\":2:{s:7:\"history\";a:1:{i:0;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":8:{s:10:\"et_pb_text\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":11:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"Текст Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"c465de18-8f22-47eb-b105-9d4b2640d1f2\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"H4 Subheading\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:18:\"header_4_font_size\";s:4:\"14px\";s:20:\"header_4_line_height\";s:5:\"1.5em\";s:13:\"custom_margin\";s:18:\"||0px||false|false\";s:13:\"header_4_font\";s:18:\"Inter|700||on|||||\";s:23:\"header_4_letter_spacing\";s:3:\"1px\";s:19:\"header_4_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:18:\"global_colors_info\";s:69:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"header_4_text_color\"]}\";}}s:36:\"09a353db-159e-4e83-864c-9195d86cbf58\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H1\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:16:\"header_font_size\";s:4:\"75px\";s:22:\"header_font_size_phone\";s:4:\"24px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.2em\";s:23:\"header_font_size_tablet\";s:4:\"40px\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";}}s:36:\"bf4cbcbe-72ce-49de-a121-5ff106b9fd3b\";O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Body\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.4\";s:8:\"settings\";O:8:\"stdClass\":8:{s:28:\"header_font_size_last_edited\";s:11:\"off|desktop\";s:23:\"header_font_size_tablet\";s:4:\"55px\";s:14:\"text_font_size\";s:4:\"16px\";s:21:\"text_font_size_tablet\";s:4:\"15px\";s:20:\"text_font_size_phone\";s:4:\"14px\";s:26:\"text_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"text_line_height\";s:5:\"1.8em\";s:15:\"text_text_color\";s:22:\"rgba(255,255,255,0.75)\";}}s:36:\"8c513909-9003-4a53-bec5-0e5b54331033\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H2\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":7:{s:13:\"header_2_font\";s:16:\"Inter|700|||||||\";s:18:\"header_2_font_size\";s:4:\"48px\";s:25:\"header_2_font_size_tablet\";s:4:\"32px\";s:24:\"header_2_font_size_phone\";s:4:\"20px\";s:30:\"header_2_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_2_line_height\";s:5:\"1.2em\";s:19:\"header_2_text_color\";s:7:\"#FFFFFF\";}}s:36:\"e8b52690-756d-4e5b-ac68-9003472e9075\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H5\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":6:{s:19:\"header_5_text_color\";s:7:\"#FFFFFF\";s:13:\"header_5_font\";s:16:\"Inter|700|||||||\";s:20:\"header_5_line_height\";s:5:\"1.4em\";s:25:\"header_5_font_size_tablet\";s:4:\"15px\";s:24:\"header_5_font_size_phone\";s:4:\"14px\";s:30:\"header_5_font_size_last_edited\";s:10:\"on|desktop\";}}s:36:\"15df52d1-5084-4a08-9e8f-0deee2d0dcc8\";O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Body Small\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.7\";s:8:\"settings\";O:8:\"stdClass\":4:{s:28:\"header_font_size_last_edited\";s:11:\"off|desktop\";s:23:\"header_font_size_tablet\";s:4:\"55px\";s:16:\"text_line_height\";s:5:\"1.6em\";s:15:\"text_text_color\";s:22:\"rgba(255,255,255,0.75)\";}}s:36:\"07ebcc14-f9e1-4ebd-9e16-ffa3798c9e53\";O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"H2 as H1\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":7:{s:13:\"header_2_font\";s:16:\"Inter|700|||||||\";s:19:\"header_2_text_color\";s:7:\"#FFFFFF\";s:18:\"header_2_font_size\";s:4:\"75px\";s:25:\"header_2_font_size_tablet\";s:4:\"40px\";s:24:\"header_2_font_size_phone\";s:4:\"24px\";s:30:\"header_2_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_2_line_height\";s:5:\"1.2em\";}}s:36:\"b6440af9-c330-418d-96d9-3897edeb344a\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H4\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:11:\"header_font\";s:8:\"||||||||\";s:13:\"header_4_font\";s:16:\"Inter|700|||||||\";s:20:\"header_4_line_height\";s:5:\"1.4em\";s:25:\"header_4_font_size_tablet\";s:4:\"16px\";s:24:\"header_4_font_size_phone\";s:4:\"15px\";s:30:\"header_4_font_size_last_edited\";s:10:\"on|desktop\";s:19:\"header_4_text_color\";s:7:\"#FFFFFF\";s:18:\"header_4_font_size\";s:4:\"19px\";}}s:36:\"1a5b8d73-d5e4-42ef-9296-2608b2bfc702\";O:8:\"stdClass\":5:{s:4:\"name\";s:2:\"H3\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":8:{s:11:\"header_font\";s:8:\"||||||||\";s:13:\"header_3_font\";s:16:\"Inter|700|||||||\";s:18:\"header_3_font_size\";s:4:\"25px\";s:25:\"header_3_font_size_tablet\";s:4:\"20px\";s:24:\"header_3_font_size_phone\";s:4:\"16px\";s:30:\"header_3_font_size_last_edited\";s:10:\"on|desktop\";s:20:\"header_3_line_height\";s:5:\"1.4em\";s:19:\"header_3_text_color\";s:7:\"#FFFFFF\";}}s:36:\"a00ad49a-6a5a-4a3a-8220-090b2ebc3461\";O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"H1 Big\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":6:{s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:16:\"header_font_size\";s:5:\"120px\";s:23:\"header_font_size_tablet\";s:4:\"40px\";s:22:\"header_font_size_phone\";s:4:\"24px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";}}}}s:18:\"et_pb_contact_form\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:60:\"Контактная форма Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"2df51b23-0535-4e13-a25b-43d003495833\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.13.1\";s:8:\"settings\";O:8:\"stdClass\":17:{s:13:\"custom_button\";s:2:\"on\";s:10:\"_unique_id\";s:36:\"d85b3ac5-5288-4ff0-8d76-365416e10a89\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:27:\"form_field_background_color\";s:19:\"RGBA(255,255,255,0)\";s:21:\"form_field_text_color\";s:7:\"#FFFFFF\";s:15:\"form_field_font\";s:18:\"Inter|700||on|||||\";s:16:\"border_width_all\";s:3:\"1px\";s:16:\"border_color_all\";s:7:\"#FFFFFF\";s:12:\"border_radii\";s:22:\"on|10px|10px|10px|10px\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\":[\"button_bg_color\"]}\";}}}}s:15:\"et_pb_accordion\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:62:\"Элемент-аккордион Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"3c1473fb-7bd2-44ff-a3d5-7e4bf5718698\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":20:{s:11:\"toggle_font\";s:16:\"Inter|700|||||||\";s:17:\"toggle_text_color\";s:7:\"#FFFFFF\";s:18:\"toggle_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:23:\"background_enable_color\";s:3:\"off\";s:28:\"open_toggle_background_color\";s:41:\"gcid-f1f9244b-c8ab-43e1-95c3-c0bdf69ac7b5\";s:30:\"closed_toggle_background_color\";s:19:\"RGBA(255,255,255,0)\";s:16:\"border_width_all\";s:3:\"0px\";s:12:\"border_radii\";s:18:\"on|0px|0px|0px|0px\";s:10:\"icon_color\";s:7:\"#FFFFFF\";s:18:\"global_colors_info\";s:78:\"{\"gcid-f1f9244b-c8ab-43e1-95c3-c0bdf69ac7b5\":[\"open_toggle_background_color\"]}\";s:16:\"border_width_top\";s:3:\"2px\";s:16:\"border_color_all\";s:22:\"rgba(255,255,255,0.16)\";s:18:\"use_icon_font_size\";s:3:\"off\";s:11:\"toggle_icon\";s:17:\"&#x4c;||divi||400\";}}}}s:12:\"et_pb_button\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":6:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:41:\"Кнопка Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"429afed6-7753-4ada-9795-4f99d56cd3e1\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":9:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";}}s:36:\"c3b6dc80-0bc2-4c8f-8794-c9f2d8782f2a\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-714b9843-c3e2-4fdc-916a-785e28b7a70d\":[\"button_bg_color\"]}\";}}s:36:\"b72721c5-f7dc-4e52-8c0f-533e2e524ffb\";O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Secondary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.8.1\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:19:\"button_border_width\";s:3:\"0px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"button_bg_color\"]}\";}}s:36:\"073a2a7f-9490-4241-8bd1-aaddec630008\";O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Secondary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":8:{s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:19:\"RGBA(255,255,255,0)\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:14:\"custom_padding\";s:25:\"0px|0px|0px|0px|true|true\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:3:\"0px\";}}s:36:\"47ddf118-3e5b-435c-a5e8-f9ec0a3e4f65\";O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Primary Light Outline\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":10:{s:13:\"custom_button\";s:2:\"on\";s:14:\"custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:20:\"button_border_radius\";s:5:\"100px\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"1px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:15:\"button_bg_color\";s:19:\"RGBA(255,255,255,0)\";s:19:\"button_border_color\";s:7:\"#FFFFFF\";s:22:\"button_bg_enable_color\";s:2:\"on\";}}}}s:17:\"et_pb_post_slider\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:54:\"Слайдер поста Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"116c0272-93ea-495c-973c-21d68c1dff5e\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":31:{s:16:\"bg_overlay_color\";s:21:\"rgba(121,58,255,0.81)\";s:12:\"border_radii\";s:22:\"on|20px|20px|20px|20px\";s:13:\"custom_button\";s:2:\"on\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#000000\";s:15:\"button_bg_color\";s:7:\"#FFFFFF\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:22:\"16px||16px||true|false\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:16:\"header_font_size\";s:4:\"25px\";s:23:\"header_font_size_tablet\";s:4:\"20px\";s:22:\"header_font_size_phone\";s:4:\"16px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:14:\"meta_font_size\";s:4:\"14px\";s:16:\"meta_line_height\";s:5:\"1.6em\";s:15:\"meta_text_color\";s:7:\"#FFFFFF\";s:19:\"arrows_custom_color\";s:7:\"#FFFFFF\";s:20:\"dot_nav_custom_color\";s:7:\"#FFFFFF\";s:9:\"show_meta\";s:3:\"off\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:2:\"{}\";}}}}s:10:\"et_pb_blog\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:37:\"Блог Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"79402496-f842-4fc2-86c5-8e8458d06734\";O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Primary\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":30:{s:9:\"fullwidth\";s:3:\"off\";s:9:\"show_more\";s:2:\"on\";s:29:\"masonry_tile_background_color\";s:19:\"RGBA(255,255,255,0)\";s:16:\"border_width_all\";s:3:\"0px\";s:18:\"border_radii_image\";s:22:\"on|20px|20px|20px|20px\";s:11:\"header_font\";s:16:\"Inter|700|||||||\";s:17:\"header_text_color\";s:7:\"#FFFFFF\";s:16:\"header_font_size\";s:4:\"19px\";s:23:\"header_font_size_tablet\";s:4:\"16px\";s:22:\"header_font_size_phone\";s:4:\"15px\";s:28:\"header_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"header_line_height\";s:5:\"1.4em\";s:15:\"body_text_color\";s:22:\"rgba(255,255,255,0.75)\";s:14:\"body_font_size\";s:4:\"16px\";s:21:\"body_font_size_tablet\";s:4:\"15px\";s:20:\"body_font_size_phone\";s:4:\"14px\";s:26:\"body_font_size_last_edited\";s:10:\"on|desktop\";s:16:\"body_line_height\";s:5:\"1.8em\";s:11:\"show_author\";s:3:\"off\";s:15:\"meta_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:20:\"read_more_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:14:\"meta_font_size\";s:4:\"14px\";s:19:\"read_more_font_size\";s:4:\"14px\";s:15:\"pagination_font\";s:16:\"Inter|700|||||||\";s:21:\"pagination_text_color\";s:7:\"#FFFFFF\";s:20:\"pagination_font_size\";s:4:\"16px\";s:27:\"pagination_font_size_tablet\";s:4:\"15px\";s:26:\"pagination_font_size_phone\";s:4:\"14px\";s:32:\"pagination_font_size_last_edited\";s:10:\"on|desktop\";s:18:\"global_colors_info\";s:88:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"meta_text_color\",\"read_more_text_color\"]}\";}}}}s:12:\"et_pb_signup\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:56:\"Напишите Оптин Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"6a9d9cc9-d31d-4670-a652-290419fa1b0b\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:5:\"4.9.4\";s:8:\"settings\";O:8:\"stdClass\":19:{s:6:\"layout\";s:10:\"top_bottom\";s:13:\"custom_button\";s:2:\"on\";s:23:\"background_enable_color\";s:3:\"off\";s:20:\"use_background_color\";s:3:\"off\";s:16:\"button_text_size\";s:4:\"14px\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:15:\"button_bg_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:19:\"button_border_width\";s:3:\"0px\";s:20:\"button_border_radius\";s:5:\"100px\";s:11:\"button_font\";s:18:\"Inter|700||on|||||\";s:21:\"button_custom_padding\";s:29:\"16px|24px|16px|24px|true|true\";s:27:\"form_field_background_color\";s:19:\"RGBA(255,255,255,0)\";s:21:\"form_field_text_color\";s:7:\"#FFFFFF\";s:15:\"form_field_font\";s:18:\"Inter|700||on|||||\";s:19:\"border_radii_fields\";s:22:\"on|10px|10px|10px|10px\";s:23:\"border_color_all_fields\";s:7:\"#FFFFFF\";s:23:\"border_width_all_fields\";s:3:\"1px\";s:22:\"button_bg_enable_color\";s:2:\"on\";s:18:\"global_colors_info\";s:65:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"button_bg_color\"]}\";}}}}s:20:\"et_pb_number_counter\";O:8:\"stdClass\":2:{s:7:\"default\";s:8:\"_initial\";s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":5:{s:4:\"name\";s:61:\"Счетчик с числами Предустановка 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.24.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}s:36:\"6800abd9-d007-4433-9917-222da7c58c36\";O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Primary Light\";s:7:\"created\";i:1708033160649;s:7:\"updated\";i:1708033160649;s:7:\"version\";s:6:\"4.19.2\";s:8:\"settings\";O:8:\"stdClass\":11:{s:10:\"title_font\";s:18:\"Inter|700||on|||||\";s:16:\"title_text_color\";s:7:\"#FFFFFF\";s:15:\"title_font_size\";s:4:\"14px\";s:20:\"title_letter_spacing\";s:3:\"1px\";s:11:\"number_font\";s:16:\"Inter|700|||||||\";s:17:\"number_text_color\";s:41:\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\";s:16:\"number_font_size\";s:4:\"75px\";s:22:\"number_font_size_phone\";s:4:\"60px\";s:28:\"number_font_size_last_edited\";s:8:\"on|phone\";s:17:\"title_line_height\";s:5:\"1.4em\";s:18:\"global_colors_info\";s:67:\"{\"gcid-39bb5ebd-8d97-4670-a45a-b1ffd711f3fc\":[\"number_text_color\"]}\";}}}}}s:4:\"time\";i:1708033160672;s:5:\"label\";s:44:\"Импортировано из макета\";}}s:5:\"index\";s:1:\"0\";}", "no");
INSERT INTO `wpcx_options` VALUES("549", "_transient_health-check-site-status-result", "{\"good\":\"25\",\"recommended\":\"3\",\"critical\":\"1\"}", "yes");
INSERT INTO `wpcx_options` VALUES("601", "redirection_options", "a:33:{s:7:\"support\";b:0;s:5:\"token\";s:32:\"0e158168b483005d9aa5f1db24cabd35\";s:12:\"monitor_post\";i:1;s:13:\"monitor_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"associated_redirect\";s:0:\"\";s:11:\"auto_target\";s:0:\"\";s:15:\"expire_redirect\";i:7;s:10:\"expire_404\";i:7;s:12:\"log_external\";b:0;s:10:\"log_header\";b:0;s:10:\"track_hits\";b:1;s:7:\"modules\";a:0:{}s:10:\"newsletter\";b:0;s:14:\"redirect_cache\";i:1;s:10:\"ip_logging\";i:1;s:10:\"ip_headers\";a:0:{}s:8:\"ip_proxy\";a:0:{}s:13:\"last_group_id\";i:1;s:8:\"rest_api\";i:0;s:5:\"https\";b:0;s:7:\"headers\";a:0:{}s:8:\"database\";s:3:\"4.2\";s:8:\"relocate\";s:48:\"https://connectionx.sousalimaconsultoria.com.br/\";s:16:\"preferred_domain\";s:0:\"\";s:7:\"aliases\";a:0:{}s:10:\"permalinks\";a:0:{}s:9:\"cache_key\";i:0;s:13:\"plugin_update\";s:6:\"prompt\";s:13:\"update_notice\";i:0;s:10:\"flag_query\";s:5:\"exact\";s:9:\"flag_case\";b:1;s:13:\"flag_trailing\";b:1;s:10:\"flag_regex\";b:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("606", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"22.4\";}", "yes");
INSERT INTO `wpcx_options` VALUES("607", "wpseo", "a:110:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:20:\"taxonomy_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"22.4\";s:16:\"previous_version\";s:4:\"22.2\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1708046228;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:47:\"https://connectionx.sousalimaconsultoria.com.br\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:10:{s:15:\"layout_category\";s:15:\"layout_category\";s:10:\"layout_tag\";s:10:\"layout_tag\";s:11:\"layout_pack\";s:11:\"layout_pack\";s:11:\"layout_type\";s:11:\"layout_type\";s:12:\"module_width\";s:12:\"module_width\";s:5:\"scope\";s:5:\"scope\";s:15:\"et_tb_item_type\";s:15:\"et_tb_item_type\";s:16:\"project_category\";s:16:\"project_category\";s:11:\"project_tag\";s:11:\"project_tag\";s:20:\"et_code_snippet_type\";s:20:\"et_code_snippet_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:3:{i:0;s:18:\"siteRepresentation\";i:1;s:14:\"socialProfiles\";i:2;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1708046229;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"project\";}s:28:\"last_known_public_taxonomies\";a:9:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:15:\"layout_category\";i:4;s:10:\"layout_tag\";i:5;s:15:\"et_tb_item_type\";i:6;s:16:\"project_category\";i:7;s:11:\"project_tag\";i:8;s:20:\"et_code_snippet_type\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1712167861;s:31:\"wpseo_unindexed_post_link_count\";i:1712167861;s:31:\"wpseo_unindexed_term_link_count\";i:1712167861;s:35:\"wpseo_total_unindexed_general_items\";i:1712167861;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("608", "wpseo_titles", "a:238:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:40:\"%%name%%, Autor em %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:66:\"Você pesquisou por %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:44:\"Página não encontrada %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:54:\"O post %%POSTLINK%% apareceu primeiro em %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:33:\"Erro 404: Página não encontrada\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Arquivos para\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Início\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:19:\"Você pesquisou por\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:18:\"Global ConnectionX\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:89:\"https://connectionx.sousalimaconsultoria.com.br/wp-content/uploads/2024/02/Ativo-2@4x.png\";s:12:\"company_name\";s:18:\"Global ConnectionX\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:0:\"\";s:15:\"noindex-project\";b:0;s:26:\"display-metabox-pt-project\";b:1;s:26:\"post_types-project-maintax\";i:0;s:24:\"schema-page-type-project\";s:7:\"WebPage\";s:27:\"schema-article-type-project\";s:4:\"None\";s:20:\"social-title-project\";s:9:\"%%title%%\";s:26:\"social-description-project\";s:0:\"\";s:24:\"social-image-url-project\";s:0:\"\";s:23:\"social-image-id-project\";i:0;s:23:\"title-ptarchive-project\";s:51:\"Arquivo %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:30:\"social-title-ptarchive-project\";s:21:\"Arquivo %%pt_plural%%\";s:36:\"social-description-ptarchive-project\";s:0:\"\";s:34:\"social-image-url-ptarchive-project\";s:0:\"\";s:33:\"social-image-id-ptarchive-project\";i:0;s:18:\"title-tax-category\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:25:\"Arquivo de %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:25:\"Arquivo de %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:25:\"Arquivo de %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:25:\"title-tax-layout_category\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-layout_category\";s:0:\"\";s:35:\"display-metabox-tax-layout_category\";b:1;s:27:\"noindex-tax-layout_category\";b:0;s:32:\"social-title-tax-layout_category\";s:25:\"Arquivo de %%term_title%%\";s:38:\"social-description-tax-layout_category\";s:0:\"\";s:36:\"social-image-url-tax-layout_category\";s:0:\"\";s:35:\"social-image-id-tax-layout_category\";i:0;s:33:\"taxonomy-layout_category-ptparent\";i:0;s:20:\"title-tax-layout_tag\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-layout_tag\";s:0:\"\";s:30:\"display-metabox-tax-layout_tag\";b:1;s:22:\"noindex-tax-layout_tag\";b:0;s:27:\"social-title-tax-layout_tag\";s:25:\"Arquivo de %%term_title%%\";s:33:\"social-description-tax-layout_tag\";s:0:\"\";s:31:\"social-image-url-tax-layout_tag\";s:0:\"\";s:30:\"social-image-id-tax-layout_tag\";i:0;s:28:\"taxonomy-layout_tag-ptparent\";i:0;s:25:\"title-tax-et_tb_item_type\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-et_tb_item_type\";s:0:\"\";s:35:\"display-metabox-tax-et_tb_item_type\";b:1;s:27:\"noindex-tax-et_tb_item_type\";b:0;s:32:\"social-title-tax-et_tb_item_type\";s:25:\"Arquivo de %%term_title%%\";s:38:\"social-description-tax-et_tb_item_type\";s:0:\"\";s:36:\"social-image-url-tax-et_tb_item_type\";s:0:\"\";s:35:\"social-image-id-tax-et_tb_item_type\";i:0;s:33:\"taxonomy-et_tb_item_type-ptparent\";i:0;s:21:\"title-tax-layout_pack\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_pack\";s:0:\"\";s:31:\"display-metabox-tax-layout_pack\";b:1;s:23:\"noindex-tax-layout_pack\";b:0;s:28:\"social-title-tax-layout_pack\";s:25:\"Arquivo de %%term_title%%\";s:34:\"social-description-tax-layout_pack\";s:0:\"\";s:32:\"social-image-url-tax-layout_pack\";s:0:\"\";s:31:\"social-image-id-tax-layout_pack\";i:0;s:29:\"taxonomy-layout_pack-ptparent\";i:0;s:21:\"title-tax-layout_type\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_type\";s:0:\"\";s:31:\"display-metabox-tax-layout_type\";b:1;s:23:\"noindex-tax-layout_type\";b:0;s:28:\"social-title-tax-layout_type\";s:25:\"Arquivo de %%term_title%%\";s:34:\"social-description-tax-layout_type\";s:0:\"\";s:32:\"social-image-url-tax-layout_type\";s:0:\"\";s:31:\"social-image-id-tax-layout_type\";i:0;s:29:\"taxonomy-layout_type-ptparent\";i:0;s:22:\"title-tax-module_width\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-module_width\";s:0:\"\";s:32:\"display-metabox-tax-module_width\";b:1;s:24:\"noindex-tax-module_width\";b:0;s:29:\"social-title-tax-module_width\";s:25:\"Arquivo de %%term_title%%\";s:35:\"social-description-tax-module_width\";s:0:\"\";s:33:\"social-image-url-tax-module_width\";s:0:\"\";s:32:\"social-image-id-tax-module_width\";i:0;s:30:\"taxonomy-module_width-ptparent\";i:0;s:15:\"title-tax-scope\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-scope\";s:0:\"\";s:25:\"display-metabox-tax-scope\";b:1;s:17:\"noindex-tax-scope\";b:0;s:22:\"social-title-tax-scope\";s:25:\"Arquivo de %%term_title%%\";s:28:\"social-description-tax-scope\";s:0:\"\";s:26:\"social-image-url-tax-scope\";s:0:\"\";s:25:\"social-image-id-tax-scope\";i:0;s:23:\"taxonomy-scope-ptparent\";i:0;s:26:\"title-tax-project_category\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:1;s:28:\"noindex-tax-project_category\";b:0;s:33:\"social-title-tax-project_category\";s:25:\"Arquivo de %%term_title%%\";s:39:\"social-description-tax-project_category\";s:0:\"\";s:37:\"social-image-url-tax-project_category\";s:0:\"\";s:36:\"social-image-id-tax-project_category\";i:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:21:\"title-tax-project_tag\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-project_tag\";s:0:\"\";s:31:\"display-metabox-tax-project_tag\";b:1;s:23:\"noindex-tax-project_tag\";b:0;s:28:\"social-title-tax-project_tag\";s:25:\"Arquivo de %%term_title%%\";s:34:\"social-description-tax-project_tag\";s:0:\"\";s:32:\"social-image-url-tax-project_tag\";s:0:\"\";s:31:\"social-image-id-tax-project_tag\";i:0;s:29:\"taxonomy-project_tag-ptparent\";i:0;s:30:\"title-tax-et_code_snippet_type\";s:55:\"Arquivo de %%term_title%% %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-tax-et_code_snippet_type\";s:0:\"\";s:40:\"display-metabox-tax-et_code_snippet_type\";b:1;s:32:\"noindex-tax-et_code_snippet_type\";b:0;s:37:\"social-title-tax-et_code_snippet_type\";s:25:\"Arquivo de %%term_title%%\";s:43:\"social-description-tax-et_code_snippet_type\";s:0:\"\";s:41:\"social-image-url-tax-et_code_snippet_type\";s:0:\"\";s:40:\"social-image-id-tax-et_code_snippet_type\";i:0;s:38:\"taxonomy-et_code_snippet_type-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:82;s:17:\"company_logo_meta\";a:10:{s:5:\"width\";i:7458;s:6:\"height\";i:2222;s:8:\"filesize\";i:257961;s:3:\"url\";s:89:\"https://connectionx.sousalimaconsultoria.com.br/wp-content/uploads/2024/02/Ativo-2@4x.png\";s:4:\"path\";s:104:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/uploads/2024/02/Ativo-2@4x.png\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:82;s:3:\"alt\";s:0:\"\";s:6:\"pixels\";i:16571676;s:4:\"type\";s:9:\"image/png\";}s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("609", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "yes");
INSERT INTO `wpcx_options` VALUES("629", "wpseo_sitemap_cache_validator_global", "5JpDS", "no");
INSERT INTO `wpcx_options` VALUES("634", "wpseo_sitemap_1_cache_validator", "nsSZ", "no");
INSERT INTO `wpcx_options` VALUES("635", "wpseo_sitemap_page_cache_validator", "nsT4", "no");
INSERT INTO `wpcx_options` VALUES("675", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/pt_BR/wordpress-6.5.zip\";s:6:\"locale\";s:5:\"pt_BR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/pt_BR/wordpress-6.5.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.5\";s:7:\"version\";s:3:\"6.5\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1712167861;s:15:\"version_checked\";s:3:\"6.5\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpcx_options` VALUES("677", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1712167861;s:7:\"checked\";a:2:{s:4:\"Divi\";s:6:\"4.24.3\";s:16:\"twentytwentyfour\";s:3:\"1.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:2:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.1.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:4:\"Divi\";a:6:{s:5:\"theme\";s:4:\"Divi\";s:11:\"new_version\";s:6:\"4.24.1\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:144:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=c84f1cb139beb2f5a4a9f8f39621ebcf327b263c&username=marcolagoa\";s:8:\"requires\";s:0:\"\";s:12:\"requires_php\";s:0:\"\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpcx_options` VALUES("678", "_site_transient_et_update_themes", "O:8:\"stdClass\":4:{s:7:\"checked\";a:2:{s:4:\"Divi\";s:6:\"4.24.1\";s:16:\"twentytwentyfour\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:4:\"Divi\";a:6:{s:5:\"theme\";s:4:\"Divi\";s:11:\"new_version\";s:6:\"4.24.1\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:144:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=c84f1cb139beb2f5a4a9f8f39621ebcf327b263c&username=marcolagoa\";s:8:\"requires\";s:0:\"\";s:12:\"requires_php\";s:0:\"\";}}s:12:\"last_checked\";i:1708047844;}", "no");
INSERT INTO `wpcx_options` VALUES("691", "litespeed.conf.__activation", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("692", "litespeed.purge.queue", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("693", "litespeed.purge.queue2", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("694", "litespeed.optimize.timestamp_purge_css", "1712167838", "yes");
INSERT INTO `wpcx_options` VALUES("695", "litespeed.admin_display.messages", "[\"<div class=\\\"litespeed_icon notice notice-success is-dismissible\\\"><p>Todos os caches foram limpos com sucesso.<\\/p><\\/div>\"]", "yes");
INSERT INTO `wpcx_options` VALUES("696", "litespeed.cloud._summary", "{\"curr_request.ver\":0,\"last_request.ver\":1712167874,\"news.utime\":1712167819,\"curr_request.news\":0,\"last_request.news\":1712167819}", "yes");
INSERT INTO `wpcx_options` VALUES("697", "litespeed.conf._version", "6.1", "yes");
INSERT INTO `wpcx_options` VALUES("698", "litespeed.conf.hash", "XqLZpI1359fAzSRNvjlnbwjXg436IZmp", "yes");
INSERT INTO `wpcx_options` VALUES("699", "litespeed.conf.auto_upgrade", "", "yes");
INSERT INTO `wpcx_options` VALUES("700", "litespeed.conf.api_key", "", "yes");
INSERT INTO `wpcx_options` VALUES("701", "litespeed.conf.server_ip", "", "yes");
INSERT INTO `wpcx_options` VALUES("702", "litespeed.conf.guest", "", "yes");
INSERT INTO `wpcx_options` VALUES("703", "litespeed.conf.guest_optm", "", "yes");
INSERT INTO `wpcx_options` VALUES("704", "litespeed.conf.news", "1", "yes");
INSERT INTO `wpcx_options` VALUES("705", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"spider\",\"PTST\",\"HeadlessChrome\"]", "yes");
INSERT INTO `wpcx_options` VALUES("706", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "yes");
INSERT INTO `wpcx_options` VALUES("707", "litespeed.conf.cache", "1", "yes");
INSERT INTO `wpcx_options` VALUES("708", "litespeed.conf.cache-priv", "1", "yes");
INSERT INTO `wpcx_options` VALUES("709", "litespeed.conf.cache-commenter", "1", "yes");
INSERT INTO `wpcx_options` VALUES("710", "litespeed.conf.cache-rest", "1", "yes");
INSERT INTO `wpcx_options` VALUES("711", "litespeed.conf.cache-page_login", "1", "yes");
INSERT INTO `wpcx_options` VALUES("712", "litespeed.conf.cache-favicon", "1", "yes");
INSERT INTO `wpcx_options` VALUES("713", "litespeed.conf.cache-resources", "1", "yes");
INSERT INTO `wpcx_options` VALUES("714", "litespeed.conf.cache-mobile", "1", "yes");
INSERT INTO `wpcx_options` VALUES("715", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "yes");
INSERT INTO `wpcx_options` VALUES("716", "litespeed.conf.cache-browser", "1", "yes");
INSERT INTO `wpcx_options` VALUES("717", "litespeed.conf.cache-exc_useragents", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("718", "litespeed.conf.cache-exc_cookies", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("719", "litespeed.conf.cache-exc_qs", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("720", "litespeed.conf.cache-exc_cat", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("721", "litespeed.conf.cache-exc_tag", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("722", "litespeed.conf.cache-force_uri", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("723", "litespeed.conf.cache-force_pub_uri", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("724", "litespeed.conf.cache-priv_uri", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("725", "litespeed.conf.cache-exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("726", "litespeed.conf.cache-exc_roles", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("727", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "yes");
INSERT INTO `wpcx_options` VALUES("728", "litespeed.conf.cache-ttl_pub", "604800", "yes");
INSERT INTO `wpcx_options` VALUES("729", "litespeed.conf.cache-ttl_priv", "1800", "yes");
INSERT INTO `wpcx_options` VALUES("730", "litespeed.conf.cache-ttl_frontpage", "604800", "yes");
INSERT INTO `wpcx_options` VALUES("731", "litespeed.conf.cache-ttl_feed", "604800", "yes");
INSERT INTO `wpcx_options` VALUES("732", "litespeed.conf.cache-ttl_rest", "604800", "yes");
INSERT INTO `wpcx_options` VALUES("733", "litespeed.conf.cache-ttl_browser", "31557600", "yes");
INSERT INTO `wpcx_options` VALUES("734", "litespeed.conf.cache-ttl_status", "[\"404 3600\",\"500 600\"]", "yes");
INSERT INTO `wpcx_options` VALUES("735", "litespeed.conf.cache-login_cookie", "", "yes");
INSERT INTO `wpcx_options` VALUES("736", "litespeed.conf.cache-vary_cookies", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("737", "litespeed.conf.cache-vary_group", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("738", "litespeed.conf.purge-upgrade", "1", "yes");
INSERT INTO `wpcx_options` VALUES("739", "litespeed.conf.purge-stale", "", "yes");
INSERT INTO `wpcx_options` VALUES("740", "litespeed.conf.purge-post_all", "", "yes");
INSERT INTO `wpcx_options` VALUES("741", "litespeed.conf.purge-post_f", "1", "yes");
INSERT INTO `wpcx_options` VALUES("742", "litespeed.conf.purge-post_h", "1", "yes");
INSERT INTO `wpcx_options` VALUES("743", "litespeed.conf.purge-post_p", "1", "yes");
INSERT INTO `wpcx_options` VALUES("744", "litespeed.conf.purge-post_pwrp", "1", "yes");
INSERT INTO `wpcx_options` VALUES("745", "litespeed.conf.purge-post_a", "1", "yes");
INSERT INTO `wpcx_options` VALUES("746", "litespeed.conf.purge-post_y", "", "yes");
INSERT INTO `wpcx_options` VALUES("747", "litespeed.conf.purge-post_m", "1", "yes");
INSERT INTO `wpcx_options` VALUES("748", "litespeed.conf.purge-post_d", "", "yes");
INSERT INTO `wpcx_options` VALUES("749", "litespeed.conf.purge-post_t", "1", "yes");
INSERT INTO `wpcx_options` VALUES("750", "litespeed.conf.purge-post_pt", "1", "yes");
INSERT INTO `wpcx_options` VALUES("751", "litespeed.conf.purge-timed_urls", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("752", "litespeed.conf.purge-timed_urls_time", "", "yes");
INSERT INTO `wpcx_options` VALUES("753", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "yes");
INSERT INTO `wpcx_options` VALUES("754", "litespeed.conf.esi", "", "yes");
INSERT INTO `wpcx_options` VALUES("755", "litespeed.conf.esi-cache_admbar", "1", "yes");
INSERT INTO `wpcx_options` VALUES("756", "litespeed.conf.esi-cache_commform", "1", "yes");
INSERT INTO `wpcx_options` VALUES("757", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "yes");
INSERT INTO `wpcx_options` VALUES("758", "litespeed.conf.util-instant_click", "", "yes");
INSERT INTO `wpcx_options` VALUES("759", "litespeed.conf.util-no_https_vary", "", "yes");
INSERT INTO `wpcx_options` VALUES("760", "litespeed.conf.debug-disable_all", "", "yes");
INSERT INTO `wpcx_options` VALUES("761", "litespeed.conf.debug", "", "yes");
INSERT INTO `wpcx_options` VALUES("762", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "yes");
INSERT INTO `wpcx_options` VALUES("763", "litespeed.conf.debug-level", "", "yes");
INSERT INTO `wpcx_options` VALUES("764", "litespeed.conf.debug-filesize", "3", "yes");
INSERT INTO `wpcx_options` VALUES("765", "litespeed.conf.debug-cookie", "", "yes");
INSERT INTO `wpcx_options` VALUES("766", "litespeed.conf.debug-collaps_qs", "", "yes");
INSERT INTO `wpcx_options` VALUES("767", "litespeed.conf.debug-inc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("768", "litespeed.conf.debug-exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("769", "litespeed.conf.debug-exc_strings", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("770", "litespeed.conf.db_optm-revisions_max", "0", "yes");
INSERT INTO `wpcx_options` VALUES("771", "litespeed.conf.db_optm-revisions_age", "0", "yes");
INSERT INTO `wpcx_options` VALUES("772", "litespeed.conf.optm-css_min", "", "yes");
INSERT INTO `wpcx_options` VALUES("773", "litespeed.conf.optm-css_comb", "", "yes");
INSERT INTO `wpcx_options` VALUES("774", "litespeed.conf.optm-css_comb_ext_inl", "1", "yes");
INSERT INTO `wpcx_options` VALUES("775", "litespeed.conf.optm-ucss", "", "yes");
INSERT INTO `wpcx_options` VALUES("776", "litespeed.conf.optm-ucss_inline", "", "yes");
INSERT INTO `wpcx_options` VALUES("777", "litespeed.conf.optm-ucss_whitelist", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("778", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("779", "litespeed.conf.optm-ucss_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("780", "litespeed.conf.optm-css_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("781", "litespeed.conf.optm-js_min", "", "yes");
INSERT INTO `wpcx_options` VALUES("782", "litespeed.conf.optm-js_comb", "", "yes");
INSERT INTO `wpcx_options` VALUES("783", "litespeed.conf.optm-js_comb_ext_inl", "1", "yes");
INSERT INTO `wpcx_options` VALUES("784", "litespeed.conf.optm-js_delay_inc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("785", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "yes");
INSERT INTO `wpcx_options` VALUES("786", "litespeed.conf.optm-html_min", "", "yes");
INSERT INTO `wpcx_options` VALUES("787", "litespeed.conf.optm-html_lazy", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("788", "litespeed.conf.optm-qs_rm", "", "yes");
INSERT INTO `wpcx_options` VALUES("789", "litespeed.conf.optm-ggfonts_rm", "", "yes");
INSERT INTO `wpcx_options` VALUES("790", "litespeed.conf.optm-css_async", "", "yes");
INSERT INTO `wpcx_options` VALUES("791", "litespeed.conf.optm-ccss_per_url", "", "yes");
INSERT INTO `wpcx_options` VALUES("792", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "yes");
INSERT INTO `wpcx_options` VALUES("793", "litespeed.conf.optm-ccss_sep_uri", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("794", "litespeed.conf.optm-css_async_inline", "1", "yes");
INSERT INTO `wpcx_options` VALUES("795", "litespeed.conf.optm-css_font_display", "", "yes");
INSERT INTO `wpcx_options` VALUES("796", "litespeed.conf.optm-js_defer", "0", "yes");
INSERT INTO `wpcx_options` VALUES("797", "litespeed.conf.optm-emoji_rm", "", "yes");
INSERT INTO `wpcx_options` VALUES("798", "litespeed.conf.optm-noscript_rm", "", "yes");
INSERT INTO `wpcx_options` VALUES("799", "litespeed.conf.optm-ggfonts_async", "", "yes");
INSERT INTO `wpcx_options` VALUES("800", "litespeed.conf.optm-exc_roles", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("801", "litespeed.conf.optm-ccss_con", "", "yes");
INSERT INTO `wpcx_options` VALUES("802", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "yes");
INSERT INTO `wpcx_options` VALUES("803", "litespeed.conf.optm-gm_js_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("804", "litespeed.conf.optm-dns_prefetch", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("805", "litespeed.conf.optm-dns_prefetch_ctrl", "", "yes");
INSERT INTO `wpcx_options` VALUES("806", "litespeed.conf.optm-dns_preconnect", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("807", "litespeed.conf.optm-exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("808", "litespeed.conf.optm-guest_only", "1", "yes");
INSERT INTO `wpcx_options` VALUES("809", "litespeed.conf.object", "", "yes");
INSERT INTO `wpcx_options` VALUES("810", "litespeed.conf.object-kind", "", "yes");
INSERT INTO `wpcx_options` VALUES("811", "litespeed.conf.object-host", "localhost", "yes");
INSERT INTO `wpcx_options` VALUES("812", "litespeed.conf.object-port", "11211", "yes");
INSERT INTO `wpcx_options` VALUES("813", "litespeed.conf.object-life", "360", "yes");
INSERT INTO `wpcx_options` VALUES("814", "litespeed.conf.object-persistent", "1", "yes");
INSERT INTO `wpcx_options` VALUES("815", "litespeed.conf.object-admin", "1", "yes");
INSERT INTO `wpcx_options` VALUES("816", "litespeed.conf.object-transients", "1", "yes");
INSERT INTO `wpcx_options` VALUES("817", "litespeed.conf.object-db_id", "0", "yes");
INSERT INTO `wpcx_options` VALUES("818", "litespeed.conf.object-user", "", "yes");
INSERT INTO `wpcx_options` VALUES("819", "litespeed.conf.object-pswd", "", "yes");
INSERT INTO `wpcx_options` VALUES("820", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "yes");
INSERT INTO `wpcx_options` VALUES("821", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "yes");
INSERT INTO `wpcx_options` VALUES("822", "litespeed.conf.discuss-avatar_cache", "", "yes");
INSERT INTO `wpcx_options` VALUES("823", "litespeed.conf.discuss-avatar_cron", "", "yes");
INSERT INTO `wpcx_options` VALUES("824", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "yes");
INSERT INTO `wpcx_options` VALUES("825", "litespeed.conf.optm-localize", "", "yes");
INSERT INTO `wpcx_options` VALUES("826", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "yes");
INSERT INTO `wpcx_options` VALUES("827", "litespeed.conf.media-preload_featured", "", "yes");
INSERT INTO `wpcx_options` VALUES("828", "litespeed.conf.media-lazy", "", "yes");
INSERT INTO `wpcx_options` VALUES("829", "litespeed.conf.media-lazy_placeholder", "", "yes");
INSERT INTO `wpcx_options` VALUES("830", "litespeed.conf.media-placeholder_resp", "", "yes");
INSERT INTO `wpcx_options` VALUES("831", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "yes");
INSERT INTO `wpcx_options` VALUES("832", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "yes");
INSERT INTO `wpcx_options` VALUES("833", "litespeed.conf.media-lqip", "", "yes");
INSERT INTO `wpcx_options` VALUES("834", "litespeed.conf.media-lqip_qual", "4", "yes");
INSERT INTO `wpcx_options` VALUES("835", "litespeed.conf.media-lqip_min_w", "150", "yes");
INSERT INTO `wpcx_options` VALUES("836", "litespeed.conf.media-lqip_min_h", "150", "yes");
INSERT INTO `wpcx_options` VALUES("837", "litespeed.conf.media-placeholder_resp_async", "1", "yes");
INSERT INTO `wpcx_options` VALUES("838", "litespeed.conf.media-iframe_lazy", "", "yes");
INSERT INTO `wpcx_options` VALUES("839", "litespeed.conf.media-add_missing_sizes", "", "yes");
INSERT INTO `wpcx_options` VALUES("840", "litespeed.conf.media-lazy_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("841", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "yes");
INSERT INTO `wpcx_options` VALUES("842", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("843", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("844", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("845", "litespeed.conf.media-lazy_uri_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("846", "litespeed.conf.media-lqip_exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("847", "litespeed.conf.media-vpi", "", "yes");
INSERT INTO `wpcx_options` VALUES("848", "litespeed.conf.media-vpi_cron", "", "yes");
INSERT INTO `wpcx_options` VALUES("849", "litespeed.conf.img_optm-auto", "1", "yes");
INSERT INTO `wpcx_options` VALUES("850", "litespeed.conf.img_optm-cron", "1", "yes");
INSERT INTO `wpcx_options` VALUES("851", "litespeed.conf.img_optm-ori", "1", "yes");
INSERT INTO `wpcx_options` VALUES("852", "litespeed.conf.img_optm-rm_bkup", "", "yes");
INSERT INTO `wpcx_options` VALUES("853", "litespeed.conf.img_optm-webp", "1", "yes");
INSERT INTO `wpcx_options` VALUES("854", "litespeed.conf.img_optm-lossless", "", "yes");
INSERT INTO `wpcx_options` VALUES("855", "litespeed.conf.img_optm-exif", "", "yes");
INSERT INTO `wpcx_options` VALUES("856", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]", "yes");
INSERT INTO `wpcx_options` VALUES("857", "litespeed.conf.img_optm-webp_replace_srcset", "1", "yes");
INSERT INTO `wpcx_options` VALUES("858", "litespeed.conf.img_optm-jpg_quality", "82", "yes");
INSERT INTO `wpcx_options` VALUES("859", "litespeed.conf.crawler", "", "yes");
INSERT INTO `wpcx_options` VALUES("860", "litespeed.conf.crawler-usleep", "500", "yes");
INSERT INTO `wpcx_options` VALUES("861", "litespeed.conf.crawler-run_duration", "400", "yes");
INSERT INTO `wpcx_options` VALUES("862", "litespeed.conf.crawler-run_interval", "600", "yes");
INSERT INTO `wpcx_options` VALUES("863", "litespeed.conf.crawler-crawl_interval", "302400", "yes");
INSERT INTO `wpcx_options` VALUES("864", "litespeed.conf.crawler-threads", "3", "yes");
INSERT INTO `wpcx_options` VALUES("865", "litespeed.conf.crawler-timeout", "30", "yes");
INSERT INTO `wpcx_options` VALUES("866", "litespeed.conf.crawler-load_limit", "1", "yes");
INSERT INTO `wpcx_options` VALUES("867", "litespeed.conf.crawler-sitemap", "", "yes");
INSERT INTO `wpcx_options` VALUES("868", "litespeed.conf.crawler-drop_domain", "1", "yes");
INSERT INTO `wpcx_options` VALUES("869", "litespeed.conf.crawler-map_timeout", "120", "yes");
INSERT INTO `wpcx_options` VALUES("870", "litespeed.conf.crawler-roles", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("871", "litespeed.conf.crawler-cookies", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("872", "litespeed.conf.misc-heartbeat_front", "", "yes");
INSERT INTO `wpcx_options` VALUES("873", "litespeed.conf.misc-heartbeat_front_ttl", "60", "yes");
INSERT INTO `wpcx_options` VALUES("874", "litespeed.conf.misc-heartbeat_back", "", "yes");
INSERT INTO `wpcx_options` VALUES("875", "litespeed.conf.misc-heartbeat_back_ttl", "60", "yes");
INSERT INTO `wpcx_options` VALUES("876", "litespeed.conf.misc-heartbeat_editor", "", "yes");
INSERT INTO `wpcx_options` VALUES("877", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "yes");
INSERT INTO `wpcx_options` VALUES("878", "litespeed.conf.cdn", "", "yes");
INSERT INTO `wpcx_options` VALUES("879", "litespeed.conf.cdn-ori", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("880", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "yes");
INSERT INTO `wpcx_options` VALUES("881", "litespeed.conf.cdn-exc", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("882", "litespeed.conf.cdn-quic", "", "yes");
INSERT INTO `wpcx_options` VALUES("883", "litespeed.conf.cdn-cloudflare", "", "yes");
INSERT INTO `wpcx_options` VALUES("884", "litespeed.conf.cdn-cloudflare_email", "", "yes");
INSERT INTO `wpcx_options` VALUES("885", "litespeed.conf.cdn-cloudflare_key", "", "yes");
INSERT INTO `wpcx_options` VALUES("886", "litespeed.conf.cdn-cloudflare_name", "", "yes");
INSERT INTO `wpcx_options` VALUES("887", "litespeed.conf.cdn-cloudflare_zone", "", "yes");
INSERT INTO `wpcx_options` VALUES("888", "litespeed.conf.cdn-mapping", "[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]", "yes");
INSERT INTO `wpcx_options` VALUES("889", "litespeed.conf.cdn-attr", "[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]", "yes");
INSERT INTO `wpcx_options` VALUES("890", "litespeed.conf.qc-token", "", "yes");
INSERT INTO `wpcx_options` VALUES("891", "litespeed.conf.qc-nameservers", "", "yes");
INSERT INTO `wpcx_options` VALUES("892", "litespeed.gui.lscwp_whm_install", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("893", "litespeed.gui.dismiss", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("894", "litespeed.gui._summary", "{\"new_version\":1708652422,\"score\":1709257222}", "yes");
INSERT INTO `wpcx_options` VALUES("895", "litespeed.data.upgrading", "-1", "yes");
INSERT INTO `wpcx_options` VALUES("897", "litespeed.img_optm._summary", "{\"next_post_id\":0,\"is_running\":0}", "yes");
INSERT INTO `wpcx_options` VALUES("899", "litespeed.crawler.bypass_list", "[]", "yes");
INSERT INTO `wpcx_options` VALUES("900", "litespeed.preset._summary", "{\"preset\":\"basic\",\"preset_timestamp\":1708047774}", "yes");
INSERT INTO `wpcx_options` VALUES("909", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1712167861;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:10:{s:25:\"cloudflare/cloudflare.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/cloudflare\";s:4:\"slug\";s:10:\"cloudflare\";s:6:\"plugin\";s:25:\"cloudflare/cloudflare.php\";s:11:\"new_version\";s:6:\"4.12.7\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/cloudflare/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/cloudflare.4.12.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/cloudflare/assets/icon-256x256.png?rev=2471183\";s:2:\"1x\";s:63:\"https://ps.w.org/cloudflare/assets/icon-128x128.png?rev=2471183\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/cloudflare/assets/banner-1544x500.png?rev=2471183\";s:2:\"1x\";s:65:\"https://ps.w.org/cloudflare/assets/banner-772x250.png?rev=2471183\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:7:\"1.5.8.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.8.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:49:\"gtmetrix-for-wordpress/gtmetrix-for-wordpress.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/gtmetrix-for-wordpress\";s:4:\"slug\";s:22:\"gtmetrix-for-wordpress\";s:6:\"plugin\";s:49:\"gtmetrix-for-wordpress/gtmetrix-for-wordpress.php\";s:11:\"new_version\";s:5:\"0.4.8\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/gtmetrix-for-wordpress/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/gtmetrix-for-wordpress.0.4.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/gtmetrix-for-wordpress/assets/icon-256x256.png?rev=1982953\";s:2:\"1x\";s:75:\"https://ps.w.org/gtmetrix-for-wordpress/assets/icon-256x256.png?rev=1982953\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/gtmetrix-for-wordpress/assets/banner-772x250.png?rev=1982951\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.3.1\";}s:31:\"creame-whatsapp-me/joinchat.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/creame-whatsapp-me\";s:4:\"slug\";s:18:\"creame-whatsapp-me\";s:6:\"plugin\";s:31:\"creame-whatsapp-me/joinchat.php\";s:11:\"new_version\";s:5:\"5.1.1\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/creame-whatsapp-me/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/creame-whatsapp-me.5.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/creame-whatsapp-me/assets/icon-256x256.gif?rev=2699533\";s:2:\"1x\";s:71:\"https://ps.w.org/creame-whatsapp-me/assets/icon-128x128.gif?rev=2699533\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/creame-whatsapp-me/assets/banner-1544x500.png?rev=2936349\";s:2:\"1x\";s:73:\"https://ps.w.org/creame-whatsapp-me/assets/banner-772x250.png?rev=2936349\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.9.6\";}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:3:\"6.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/litespeed-cache.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:27:\"redirection/redirection.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/redirection\";s:4:\"slug\";s:11:\"redirection\";s:6:\"plugin\";s:27:\"redirection/redirection.php\";s:11:\"new_version\";s:5:\"5.4.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/redirection/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/redirection.5.4.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/redirection/assets/icon-256x256.jpg?rev=983639\";s:2:\"1x\";s:63:\"https://ps.w.org/redirection/assets/icon-128x128.jpg?rev=983640\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/redirection/assets/banner-1544x500.jpg?rev=983641\";s:2:\"1x\";s:65:\"https://ps.w.org/redirection/assets/banner-772x250.jpg?rev=983642\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}s:27:\"redis-cache/redis-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/redis-cache\";s:4:\"slug\";s:11:\"redis-cache\";s:6:\"plugin\";s:27:\"redis-cache/redis-cache.php\";s:11:\"new_version\";s:5:\"2.5.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/redis-cache/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/redis-cache.2.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/redis-cache/assets/icon-256x256.gif?rev=2568513\";s:2:\"1x\";s:64:\"https://ps.w.org/redis-cache/assets/icon-128x128.gif?rev=2568513\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/redis-cache/assets/banner-1544x500.png?rev=2315420\";s:2:\"1x\";s:66:\"https://ps.w.org/redis-cache/assets/banner-772x250.png?rev=2315420\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:21:\"safe-svg/safe-svg.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/safe-svg\";s:4:\"slug\";s:8:\"safe-svg\";s:6:\"plugin\";s:21:\"safe-svg/safe-svg.php\";s:11:\"new_version\";s:5:\"2.2.4\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/safe-svg/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/safe-svg.2.2.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:53:\"https://ps.w.org/safe-svg/assets/icon.svg?rev=2779013\";s:3:\"svg\";s:53:\"https://ps.w.org/safe-svg/assets/icon.svg?rev=2779013\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/safe-svg/assets/banner-1544x500.png?rev=2683939\";s:2:\"1x\";s:63:\"https://ps.w.org/safe-svg/assets/banner-772x250.png?rev=2683939\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";}s:37:\"translatepress-multilingual/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/translatepress-multilingual\";s:4:\"slug\";s:27:\"translatepress-multilingual\";s:6:\"plugin\";s:37:\"translatepress-multilingual/index.php\";s:11:\"new_version\";s:5:\"2.7.4\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/translatepress-multilingual/\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/plugin/translatepress-multilingual.2.7.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/translatepress-multilingual/assets/icon-256x256.png?rev=1722670\";s:2:\"1x\";s:80:\"https://ps.w.org/translatepress-multilingual/assets/icon-128x128.png?rev=1722670\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/translatepress-multilingual/assets/banner-1544x500.png?rev=2312348\";s:2:\"1x\";s:82:\"https://ps.w.org/translatepress-multilingual/assets/banner-772x250.png?rev=2312348\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.1.0\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"22.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"6.3\";}}s:7:\"checked\";a:10:{s:25:\"cloudflare/cloudflare.php\";s:6:\"4.12.7\";s:25:\"duplicator/duplicator.php\";s:7:\"1.5.8.1\";s:49:\"gtmetrix-for-wordpress/gtmetrix-for-wordpress.php\";s:5:\"0.4.8\";s:31:\"creame-whatsapp-me/joinchat.php\";s:5:\"5.1.1\";s:35:\"litespeed-cache/litespeed-cache.php\";s:3:\"6.1\";s:27:\"redirection/redirection.php\";s:5:\"5.4.2\";s:27:\"redis-cache/redis-cache.php\";s:5:\"2.5.1\";s:21:\"safe-svg/safe-svg.php\";s:5:\"2.2.4\";s:37:\"translatepress-multilingual/index.php\";s:5:\"2.7.4\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"22.4\";}}", "no");
INSERT INTO `wpcx_options` VALUES("910", "_site_transient_et_update_all_plugins", "O:8:\"stdClass\":3:{s:7:\"checked\";a:8:{s:25:\"cloudflare/cloudflare.php\";s:6:\"4.12.4\";s:49:\"gtmetrix-for-wordpress/gtmetrix-for-wordpress.php\";s:5:\"0.4.8\";s:35:\"litespeed-cache/litespeed-cache.php\";s:3:\"6.1\";s:27:\"redirection/redirection.php\";s:5:\"5.4.2\";s:27:\"redis-cache/redis-cache.php\";s:5:\"2.5.0\";s:21:\"safe-svg/safe-svg.php\";s:5:\"2.2.2\";s:37:\"translatepress-multilingual/index.php\";s:5:\"2.7.1\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"22.0\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1708047850;}", "no");
INSERT INTO `wpcx_options` VALUES("911", "gfw_options", "a:15:{s:10:\"authorized\";i:1;s:12:\"api_username\";s:21:\"social@everton.etc.br\";s:7:\"api_key\";s:32:\"441549df6ed35daa901dd24e7acd3e58\";s:9:\"locations\";a:7:{i:1;a:4:{s:4:\"name\";s:17:\"Vancouver, Canada\";s:7:\"default\";b:1;s:2:\"id\";s:1:\"1\";s:8:\"browsers\";a:3:{i:0;i:2;i:1;i:1;i:2;i:3;}}i:2;a:4:{s:4:\"name\";s:10:\"London, UK\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"2\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}i:3;a:4:{s:4:\"name\";s:17:\"Sydney, Australia\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"3\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}i:4;a:4:{s:4:\"name\";s:20:\"San Antonio, TX, USA\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"4\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}i:5;a:4:{s:4:\"name\";s:13:\"Mumbai, India\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"5\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}i:6;a:4:{s:4:\"name\";s:18:\"São Paulo, Brazil\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"6\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}i:7;a:4:{s:4:\"name\";s:16:\"Hong Kong, China\";s:7:\"default\";b:0;s:2:\"id\";s:1:\"7\";s:8:\"browsers\";a:2:{i:0;i:1;i:1;i:3;}}}s:16:\"default_location\";s:1:\"6\";s:15:\"default_adblock\";s:1:\"0\";s:16:\"dashboard_widget\";s:1:\"1\";s:12:\"toolbar_link\";s:1:\"1\";s:19:\"notifications_email\";s:12:\"api_username\";s:16:\"widget_pagespeed\";s:1:\"1\";s:12:\"widget_yslow\";s:1:\"1\";s:13:\"widget_scores\";s:1:\"1\";s:11:\"widget_link\";s:1:\"1\";s:10:\"widget_css\";s:1:\"1\";s:9:\"front_url\";s:2:\"wp\";}", "yes");
INSERT INTO `wpcx_options` VALUES("924", "widget_gfw-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpcx_options` VALUES("931", "category_children", "a:0:{}", "yes");
INSERT INTO `wpcx_options` VALUES("942", "wpseo_sitemap_post_cache_validator", "75tZm", "no");
INSERT INTO `wpcx_options` VALUES("958", "wpseo_sitemap_108_cache_validator", "4cuZT", "no");
INSERT INTO `wpcx_options` VALUES("971", "trp_machine_translation_counter", "0", "yes");
INSERT INTO `wpcx_options` VALUES("975", "joinchat", "a:23:{s:9:\"telephone\";s:13:\"+351967382547\";s:12:\"message_send\";s:64:\"Olá *{SITE}*! Preciso de mais informações sobre {TITLE} {URL}\";s:12:\"button_image\";i:0;s:10:\"button_tip\";s:0:\"\";s:8:\"position\";s:5:\"right\";s:12:\"button_delay\";i:3;s:12:\"message_text\";s:28:\"Olá 👋\nPodemos ajudá-lo?\";s:13:\"message_start\";s:15:\"Abrir bate-papo\";s:5:\"color\";s:7:\"#25d366\";s:9:\"dark_mode\";s:2:\"no\";s:6:\"header\";s:6:\"__wa__\";s:10:\"optin_text\";s:0:\"\";s:13:\"message_delay\";i:10;s:13:\"message_views\";i:2;s:4:\"gads\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:11:\"mobile_only\";s:2:\"no\";s:12:\"whatsapp_web\";s:2:\"no\";s:2:\"qr\";s:2:\"no\";s:13:\"message_badge\";s:2:\"no\";s:11:\"optin_check\";s:2:\"no\";s:5:\"clear\";s:2:\"no\";s:10:\"visibility\";a:1:{s:3:\"all\";s:3:\"yes\";}}", "yes");
INSERT INTO `wpcx_options` VALUES("1026", "db_upgraded", "", "yes");
INSERT INTO `wpcx_options` VALUES("1027", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:18:\"eolimabr@gmail.com\";s:7:\"version\";s:3:\"6.5\";s:9:\"timestamp\";i:1712086170;}", "no");
INSERT INTO `wpcx_options` VALUES("1030", "can_compress_scripts", "1", "yes");
INSERT INTO `wpcx_options` VALUES("1031", "duplicator_version_plugin", "1.5.8.1", "yes");
INSERT INTO `wpcx_options` VALUES("1033", "duplicator_install_info", "a:3:{s:7:\"version\";s:7:\"1.5.8.1\";s:4:\"time\";i:1712156523;s:10:\"updateTime\";i:1712156523;}", "no");
INSERT INTO `wpcx_options` VALUES("1034", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wpcx_options` VALUES("1035", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wpcx_options` VALUES("1036", "duplicator_settings", "a:20:{s:7:\"version\";s:7:\"1.5.8.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "yes");
INSERT INTO `wpcx_options` VALUES("1037", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"ZQrMsXtBK9tBNLWLGvw67KfB7dT&86Ci8lfVB,NTRG+M\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1712156650,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 248.97,\n    \"siteNumFiles\": 9614,\n    \"siteDbSizeMB\": 8.27,\n    \"siteDbNumTables\": 36\n}", "yes");
INSERT INTO `wpcx_options` VALUES("1038", "duplicator_notifications", "a:4:{s:6:\"update\";i:1712156525;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wpcx_options` VALUES("1039", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 18:13:24\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"9ca0dcead521a2565963_20240403181324\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1072;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:8542;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-04-03 18:13:24\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:3:\"6.5\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:5:\"8.3.0\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20240403_globalconnectionx\";s:4:\"Hash\";s:35:\"9ca0dcead521a2565963_20240403181324\";s:8:\"NameHash\";s:62:\"20240403_globalconnectionx_9ca0dcead521a2565963_20240403181324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:76:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:71:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-admin\";i:1;s:74:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-includes\";i:2;s:83:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:1;s:62:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress\";i:2;s:73:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content\";i:3;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/uploads\";i:4;s:81:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/plugins\";i:5;s:84:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/mu-plugins\";i:6;s:80:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:94:\"/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wpcx_options` VALUES("1040", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[1],\"failedPackageIds\":[]}", "yes");
INSERT INTO `wpcx_options` VALUES("1042", "_site_transient_timeout_available_translations", "1712178660", "no");
INSERT INTO `wpcx_options` VALUES("1043", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.7/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-01 08:21:52\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.3/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.25/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 08:32:45\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-20 07:52:10\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-24 20:54:09\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 17:01:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 19:45:46\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-11 13:58:40\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-26 13:44:37\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.5/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-26 13:47:17\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 00:26:05\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-24 17:55:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 00:25:51\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.5/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 07:19:19\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 06:27:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-24 17:26:23\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 06:28:23\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-23 14:39:57\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 06:41:50\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-29 21:55:55\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-23 18:03:40\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-01 01:17:17\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 09:42:02\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.15/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.20/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-24 23:42:22\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 13:51:37\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-05 10:16:58\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-12 17:31:37\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-11 13:09:06\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 20:55:14\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 13:45:51\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 08:55:46\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 19:37:31\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-26 11:43:31\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-03-01 06:52:39\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.32\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.32/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2024-03-07 03:26:04\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 18:23:28\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 09:45:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 09:36:14\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-28 18:29:32\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-27 04:26:54\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 05:43:49\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.25/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.20/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.5\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.5/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 15:06:12\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 11:51:19\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.5/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-01-30 17:48:58\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.5/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-09 18:37:05\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 16:18:08\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.7/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-23 19:36:11\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-28 08:03:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-28 12:13:47\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.14\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.14/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 09:31:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-19 15:23:25\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-05 08:03:59\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.5/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-23 18:33:06\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 13:55:56\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-24 17:37:51\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.33\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.33/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-27 16:05:52\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-28 22:45:59\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.5/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-08-21 12:17:05\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-28 22:46:41\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 10:02:51\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-23 15:40:27\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.15/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 06:35:54\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-12 10:29:16\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-02-14 12:47:33\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-25 15:04:50\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 15:29:12\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 00:35:33\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-02-16 11:09:57\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.5/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.9/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.24/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-02 11:24:23\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-31 21:59:11\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.15/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-03-30 20:40:28\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.5\";s:7:\"updated\";s:19:\"2024-04-03 15:44:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.5/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `wpcx_options` VALUES("1044", "_transient_timeout_et_core_path", "1712254260", "no");
INSERT INTO `wpcx_options` VALUES("1045", "_transient_et_core_path", "/www/wwwroot/ConnectionX.sousalimaconsultoria.com.br/wordpress/wp-content/themes/Divi/core", "no");
INSERT INTO `wpcx_options` VALUES("1046", "_transient_timeout_et_core_version", "1712254260", "no");
INSERT INTO `wpcx_options` VALUES("1047", "_transient_et_core_version", "4.24.3", "no");
INSERT INTO `wpcx_options` VALUES("1048", "_site_transient_timeout_theme_roots", "1712169661", "no");
INSERT INTO `wpcx_options` VALUES("1049", "_site_transient_theme_roots", "a:2:{s:4:\"Divi\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";}", "no");
INSERT INTO `wpcx_options` VALUES("1050", "_transient_timeout_trp_checked_if_site_meets_conditions_for_review", "1712254261", "no");
INSERT INTO `wpcx_options` VALUES("1051", "_transient_trp_checked_if_site_meets_conditions_for_review", "yes", "no");
INSERT INTO `wpcx_options` VALUES("1052", "_transient_timeout_wpseo_total_unindexed_posts_limited", "1712168761", "no");
INSERT INTO `wpcx_options` VALUES("1053", "_transient_wpseo_total_unindexed_posts_limited", "0", "no");
INSERT INTO `wpcx_options` VALUES("1054", "_transient_timeout_wpseo_total_unindexed_terms_limited", "1712168761", "no");
INSERT INTO `wpcx_options` VALUES("1055", "_transient_wpseo_total_unindexed_terms_limited", "0", "no");
INSERT INTO `wpcx_options` VALUES("1056", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1712254261", "no");
INSERT INTO `wpcx_options` VALUES("1057", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `wpcx_options` VALUES("1058", "_transient_timeout_wpseo_total_unindexed_general_items", "1712254261", "no");
INSERT INTO `wpcx_options` VALUES("1059", "_transient_wpseo_total_unindexed_general_items", "0", "no");
INSERT INTO `wpcx_options` VALUES("1060", "_transient_timeout_wpseo_unindexed_post_link_count", "1712254261", "no");
INSERT INTO `wpcx_options` VALUES("1061", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `wpcx_options` VALUES("1062", "_transient_timeout_wpseo_unindexed_term_link_count", "1712254261", "no");
INSERT INTO `wpcx_options` VALUES("1063", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `wpcx_options` VALUES("1064", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "no");
INSERT INTO `wpcx_options` VALUES("1065", "_transient_timeout_et_check_mod_pagespeed", "1712254356", "no");
INSERT INTO `wpcx_options` VALUES("1066", "_transient_et_check_mod_pagespeed", "", "no");
INSERT INTO `wpcx_options` VALUES("1067", "_transient_timeout__et_builder_gf_feature_cache", "1712254358", "no");
INSERT INTO `wpcx_options` VALUES("1068", "_transient__et_builder_gf_feature_cache", "1", "no");
INSERT INTO `wpcx_options` VALUES("1069", "_site_transient_timeout_browser_ab86a5fd083db056ffac3e298af00f67", "1712772786", "no");
INSERT INTO `wpcx_options` VALUES("1070", "_site_transient_browser_ab86a5fd083db056ffac3e298af00f67", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"123.0.0.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wpcx_options` VALUES("1071", "_site_transient_timeout_php_check_3920ce57dc4ba24f77e58541e4f04e12", "1712772786", "no");
INSERT INTO `wpcx_options` VALUES("1072", "_site_transient_php_check_3920ce57dc4ba24f77e58541e4f04e12", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wpcx_options` VALUES("1073", "_transient_timeout_wpseo-statistics-totals", "1712254388", "no");
INSERT INTO `wpcx_options` VALUES("1074", "_transient_wpseo-statistics-totals", "a:1:{i:1;a:2:{s:6:\"scores\";a:1:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"label\";s:50:\"Posts <strong>sem</strong> uma frase-chave em foco\";s:5:\"count\";i:1;s:4:\"link\";s:124:\"https://connectionx.sousalimaconsultoria.com.br/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";i:0;s:4:\"good\";i:0;s:2:\"na\";i:1;s:7:\"noindex\";i:0;}}}", "no");
INSERT INTO `wpcx_options` VALUES("1075", "_site_transient_timeout_community-events-d2678360d6e6d6e520a002ade3e87108", "1712211188", "no");
INSERT INTO `wpcx_options` VALUES("1076", "_site_transient_community-events-d2678360d6e6d6e520a002ade3e87108", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:20:\"2804:7f0:90c0:3c4e::\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wpcx_options` VALUES("1077", "_transient_timeout_feed_b85365aa61afaf3d4189819a6f57c4c4", "1712211188", "no");
INSERT INTO `wpcx_options` VALUES("1078", "_transient_feed_b85365aa61afaf3d4189819a6f57c4c4", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Blog | WordPress.org Brasil\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://br.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 19:59:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"pt-BR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.6-alpha-57919\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Blog | WordPress.org Brasil\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://br.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 19:59:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Diga olá ao WordPress 6.5 “Regina”, inspirado na versatilidade dinâmica da renomada violinista de jazz Regina Carter. Uma artista premiada e célebre educadora de jazz conhecida por transcender o gênero, as bases técnicas de Regina na música clássica e a profunda compreensão do jazz lhe renderam a reputação de ir além do que é possível [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:67288:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"WordPress 6.5 &quot;Regina&quot;\" class=\"wp-image-17178\" /></figure>\n\n\n\n<p>Diga olá ao WordPress 6.5 “Regina”, inspirado na versatilidade dinâmica da renomada violinista de jazz <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. Uma artista premiada e célebre educadora de jazz conhecida por transcender o gênero, as bases técnicas de Regina na música clássica e a profunda compreensão do jazz lhe renderam a reputação de ir além do que é possível com o violino.</p>\n\n\n\n<p>Deixe as reviravoltas impressionantes e as curvas sutis do <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">som de Regina</a> surpreendê-lo enquanto você explora tudo o que a versão 6.5 oferece.</p>\n\n\n\n<p>Esta última versão do WordPress coloca mais poder nos detalhes. Ele oferece maneiras novas e aprimoradas de ajustar e melhorar sua experiência de criação de sites, permitindo que você crie de maneiras que o tornam mais seu. Você encontrará novas maneiras de gerenciar a tipografia do seu site, revisões mais abrangentes disponíveis em mais lugares e uma coleção de atualizações do editor de sites combinadas com ganhos de desempenho impressionantes para ajudá-lo a fazer coisas mais suaves e rápidas.</p>\n\n\n\n<p>“Regina” também marca a introdução de algumas ferramentas inovadoras para desenvolvedores que começarão a transformar a forma como você usa e estende os blocos para criar experiências envolventes. A API de Interatividade abre um mundo de possibilidades criativas, enquanto a API de vinculação de blocos torna as conexões dinâmicas entre blocos e dados perfeitas. Estes, entre outras melhorias e atualizações focadas no desenvolvedor, estão prontos para ajudá-lo a evoluir como você cria com o WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Baixe o WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Adicione e gerencie fontes em todo o seu site</h3>\n\n\n\n<p>A nova biblioteca de fontes coloca você no controle de uma parte essencial do design do seu site, a digitografia, sem codificação ou etapas extras. Instale, remova e ative facilmente fontes locais e do Google Fonts em seu site para qualquer tema de bloco. A capacidade de incluir coleções de tipografia personalizadas dá aos criadores e editores de sites mais opções quando se trata de conteúdo de estilo.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Font-Manager-2-1024x656.png\" alt=\"\" class=\"wp-image-17167\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenha mais de suas revisões, incluindo as partes de modelos</h3>\n\n\n\n<p>Trabalhe através de projetos criativos com uma imagem mais abrangente do que foi feito. Obtenha detalhes como impressões de data e hora, resumos rápidos e uma lista de páginas de todas as revisões e exibir revisões do livro de estilos para ver como as alterações afetam cada bloco. As revisões também estão disponíveis para modelos e partes de modelo.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Revisions-1-1024x656.png\" alt=\"\" class=\"wp-image-17168\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Trabalhe com ferramentas de fundo e sombra aprimoradas</h3>\n\n\n\n<ul>\n<li>Controle as opções de tamanho, repetição e ponto focal para imagens de fundo em blocos de grupo para que você possa explorar maneiras sutis de adicionar interesse visual aos layouts.</li>\n\n\n\n<li>Defina proporções para imagens de bloco de capa e adicione facilmente sobreposições de cores que obtêm automaticamente a cor da imagem escolhida.</li>\n\n\n\n<li>Adicione suporte de sombra a mais tipos de blocos e crie layouts com profundidade visual ou jogue um pouco de personalidade em seu design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/design-tools-1-1024x656.png\" alt=\"\" class=\"wp-image-17169\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Descubra novas visualizações de dados</h3>\n\n\n\n<p>Cada parte do seu site vem com uma biblioteca de informações e dados, e agora você pode encontrar o que precisa rapidamente e organizá-lo da maneira que quiser. As visualizações de dados para páginas, modelos, padrões e partes de modelos permitem que você veja os dados em uma exibição de tabela ou grade, com a opção de alternar campos e fazer alterações em massa.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Data-Views-1-1024x656.png\" alt=\"\" class=\"wp-image-17165\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Arrastar e soltar mais suaves</h3>\n\n\n\n<p>Sinta a diferença quando você move as coisas, com pistas visuais úteis, como itens deslocados na visualização de lista ou arrastando sem atrito para qualquer lugar em seu espaço de trabalho, do início ao fim.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/drag-and-drop-1-1024x656.png\" alt=\"\" class=\"wp-image-17170\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Controles de links melhorados</h3>\n\n\n\n<p>Crie e gerencie facilmente links com uma experiência de construção de links mais intuitiva, como uma interface simplificada e um atalho para copiar links.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/link-controls-1-1024x656.png\" alt=\"\" class=\"wp-image-17171\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">O que há de novo para desenvolvedores</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Interações de blocos com a API de Interatividade</h3>\n\n\n\n<p>A <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">API de interatividade</a> oferece aos desenvolvedores um método padronizado para a construção de experiências interativas com blocos. Ele simplifica o processo, com menos dependências de ferramentas externas, mantendo o desempenho ideal. Use-o para criar experiências de usuário memoráveis, como buscar resultados de pesquisa instantaneamente ou permitir que os visitantes interajam com o conteúdo em tempo real.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conexão de blocos a campos personalizados ou outros conteúdos dinâmicos</h3>\n\n\n\n<p>Vincule atributos de blocos a campos personalizados e use o valor de campos personalizados sem criar novos blocos. Alimentados pela <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">API de vinculação de blocos</a>, os desenvolvedores podem estender esse recurso ainda mais para conectar blocos a qualquer conteúdo dinâmico, mesmo além dos campos personalizados. Se houver dados armazenados em outro lugar, facilmente apontar blocos para essa nova fonte com apenas algumas linhas de código.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Adição de ferramentas de aparência a temas clássicos</h3>\n\n\n\n<p>Dê aos designers e criadores usando temas clássicos acesso a uma experiência de design atualizada. Opte pelo suporte para espaçamento, borda, tipografia e opções de cores, mesmo sem usar o theme.json. Uma vez que o suporte é habilitado, mais ferramentas serão adicionadas automaticamente à medida que estiverem disponíveis.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore melhorias na experiência de plugin</h3>\n\n\n\n<p>Agora há uma <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">maneira mais fácil de gerenciar dependências de plugins</a>. Os autores dos plugins podem fornecer um novo cabeçalho chamado <code>Requires Plugins</code>, com uma lista separada por vírgula de plugins necessárias, apresentando aos usuários links para instalar e ativar esses plugins primeiro.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ainda mais rápido: atualizações de desempenho</h3>\n\n\n\n<p>Esta versão inclui mais de 110 atualizações de desempenho, resultando em um aumento impressionante na velocidade e eficiência em todo o editor de posts e ao editor de sites. O carregamento é duas vezes mais rápido do que na versão 6.4, com velocidade de processamento de entrada até cinco vezes mais rápido do que a versão anterior.</p>\n\n\n\n<p>Os sites traduzidos veem até 25% de melhoria no tempo de carregamento para este lançamento, cortesia da <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Destaques de desempenho adicionais incluem <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">suporte de imagem AVIF</a> e melhorias para <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registrar variações de bloco com retornos de chamada</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Uma tradição de inclusão</h3>\n\n\n\n<p>Esta versão inclui mais de 65 melhorias de acessibilidade em toda a plataforma, tornando-a mais acessível do que nunca. Ele contém uma correção importante que desbloqueia o acesso ao submenus de administrador para usuários de leitores de tela e outros que navegam pelo teclado. Esta versão também adiciona correções ao contraste de cores em estados de foco de administrador, posicionamento de elementos e foco de cursor, entre muitos outros, que ajudam a melhorar a experiência do WordPress para todos.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Saiba mais sobre o WordPress 6.5</h2>\n\n\n\n<p>Confira a nova <a href=\"https://wordpress.org/download/releases/6-5/\">página do WordPress 6.5</a> para saber mais sobre as inúmeras melhorias e recursos desta versão, incluindo demonstrações curtas de alguns dos recursos destacados.</p>\n\n\n\n<p>Explore o <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> para vídeos rápidos, <a href=\"https://learn.wordpress.org/social-learning/\">workshops on-line</a> e outros recursos gratuitos para aumentar seus conhecimentos e habilidades do WordPress.</p>\n\n\n\n<p>Confira o <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">Guia de Campo do WordPress 6.5</a> para obter informações técnicas detalhadas e as <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">notas de desenvolvedor</a> para ajudá-lo a construir com o WordPress e tirar o máximo proveito desta versão. Não se esqueça de assinar o <a href=\"https://developer.wordpress.org/news/\">blog do desenvolvedor</a> para atualizações de desenvolvedores, tutoriais de recursos e outros conteúdos úteis do WordPress do ponto de vista do desenvolvedor.</p>\n\n\n\n<p>Para obter mais informações sobre instalação, alterações de arquivo, correções e outras atualizações, leia as <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">notas da versão 6.5</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O esquadrão da versão 6.5</h2>\n\n\n\n<p>Cada lançamento tem muitas partes móveis com seus próprios triunfos e desafios. É preciso uma equipe dedicada de colaboradores entusiasmados para ajudar a manter as coisas no caminho certo e se mover sem problemas. 6.5 é possível graças a um grupo multifuncional de colaboradores, sempre pronto para defender ideias, remover bloqueadores e resolver problemas.</p>\n\n\n\n<ul>\n<li>Líder da versão: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordenadores do lançamento: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Time líder do núcleo: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Líderes editores técnicos: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Líderes de triagem do núcleo: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Líderes de triagem de editores: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Líderes de design: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Líderes de marketing e comunicação: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Líderes de documentação: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Líderes de performance: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Líderes de testes: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Líderes do tema padrão: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Agradecimento aos colaboradores</h2>\n\n\n\n<p>O WordPress acredita na democratização da publicação e nas <a href=\"https://opensource.org/osd-annotated\">liberdades que vêm com código aberto</a>. Apoiar essa ideia é uma comunidade global e diversificada de pessoas que colaboram para fortalecer o software.</p>\n\n\n\n<p>O WordPress 6.5 reflete os inúmeros esforços e a paixão de cerca de 700 colaboradores em pelo menos 57 países. Este lançamento também recebeu mais de 150 colaboradores pela primeira vez!</p>\n\n\n\n<p>Suas colaborações proporcionaram mais de 2.500 aprimoramentos e correções, garantindo uma versão estável para todos. Um testemunho do poder e capacidade da comunidade de código aberto do WordPress.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/chesio/\"></a></p>\n\n\n\n<p>Mais de <a href=\"https://translate.wordpress.org/stats/\">70 localidades traduziram 90%</a> ou mais do WordPress 6.5 em seu idioma. Os tradutores comunitários estão trabalhando duro para garantir que mais traduções estejam a caminho. Agradecemos a todos que ajudam a disponibilizar o WordPress em 200 idiomas.</p>\n\n\n\n<p>Por último, mas não menos importante, agradecemos aos voluntários que contribuem nos <a href=\"https://wordpress.org/support/\">fóruns de suporte</a>, respondendo a perguntas de usuários do WordPress em todo o mundo.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se e contribua</h3>\n\n\n\n<p>A participação no WordPress não se limita à codificação. Se você gosta de contribuir com o WordPress, aprender mais e se envolver é fácil. Descubra as equipes que se reúnem para <a href=\"https://make.wordpress.org/\">criar o WordPress</a> e explore o roteiro do produto no <a href=\"https://make.wordpress.org/core/\">blog de desenvolvimento do núcleo</a>. Você também pode usar esta <a href=\"https://make.wordpress.org/contribute/\">ferramenta interativa</a> para ajudá-lo a decidir qual equipe é a certa para você.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/03/28/wordpress-6-5-release-candidate-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 16:40:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3019\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"O último release candidate (RC4) para WordPress 6.5 já está disponível! Este release candidate é uma adição ao ciclo de lançamento existente do WordPress 6.5. Ele permite mais tempo para testes para garantir que cada recurso e melhoria esteja na melhor forma possível. A meta atual para o lançamento do WordPress 6.5 é 02 de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6516:\"\n<p>O último release candidate (RC4) para WordPress 6.5 já está disponível!</p>\n\n\n\n<p>Este release candidate é uma adição ao ciclo de lançamento existente do WordPress 6.5. Ele permite mais tempo para testes para garantir que cada recurso e melhoria esteja na melhor forma possível.</p>\n\n\n\n<p>A meta atual para o lançamento do WordPress 6.5 é <strong>02 de abril de 2024</strong>. Obtenha uma visão geral do ciclo de <a href=\"https://make.wordpress.org/core/6-5/\">lançamento da versão 6.5</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionadas a versão 6.5</a>. Se você está procurando notas técnicas mais detalhadas sobre novos recursos e melhorias, o <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">Guia de Campo WordPress 6.5</a> é para você.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.5 RC4?</h2>\n\n\n\n<p>Agradecemos os muitos feedbacks úteis sobre um dos principais recursos deste lançamento: A biblioteca de fontes. Isso resultou em algumas <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">melhorias adicionais necessárias</a> para garantir que o maior número de sites possíveis possa se beneficiar desse novo recurso adequadamente.</p>\n\n\n\n<p>Esta versão também inclui seis correções de erros para o editor e mais de 10 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tiquetes para o núcleo do WordPress</a>. Para obter mais informações técnicas relacionadas a questões resolvidas desde a versão RC3, você pode navegar nos seguintes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-20&amp;until=2024-03-28\">Tíquetes do GitHub para a versão 6.5</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F20%2F2024..03%2F28%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados </a><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">do Trac</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como testar</h2>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica</strong>. Em vez disso, é recomendável avaliar o RC4 em um servidor e site de teste.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.5 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 RC4 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar dretamente</th><td>Faça o download da <a href=\"https://wordpress.org/wordpress-6.5-RC4.zip\">versão RC4 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-RC</code>4</td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">instância 6.5 RC4 do WordPress Playground</a> (disponível dentro de 35 minutos após o lançamento estar pronto) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post:</em> <em><a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/03/19/wordpress-6-5-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Mar 2024 19:12:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3015\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"O terceiro release candidate (RC3) para WordPress 6.5 está disponível!  Esta versão do WordPress está em desenvolvimento. Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica. Em vez disso, é recomendável avaliar o RC3 em um servidor e site de teste. Alcançar esta fase do ciclo de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9384:\"\n<p>O terceiro release candidate (RC3) para WordPress 6.5 está disponível! </p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica</strong>. Em vez disso, é recomendável avaliar o RC3 em um servidor e site de teste.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.5 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 RC3 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-RC3.zip\">versão RC3 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Command Line</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-RC</code>3</td></tr><tr><th>WordPress Playground</th><td>Use uma <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">instância 6.5 RC3 no WordPress Playground</a> (disponível dentro de 35 minutos após a liberação estar pronta) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento do WordPress 6.5 é <strong>26 de março de 2024</strong>. Obtenha uma visão geral do ciclo de <a href=\"https://make.wordpress.org/core/6-5/\">lançamento da versão 6.5</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionadas a versão 6.5</a>.</p>\n\n\n\n<p>Se você está procurando notas técnicas mais detalhadas sobre novos recursos e melhorias, o <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">guia de campo do WordPress 6.5</a> é para você.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.5 RC3?</h2>\n\n\n\n<p>Agradecemos aos muitos contribuidores que testaram até este ponto. Esta versão inclui 10 correções de erros para o editor e cerca de 15 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tíquetes para núcleo do WordPress</a>. Para mais informações técnicas relacionadas a problemas resolvidos desde a versão RC2, você pode navegar nos seguintes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-13&amp;until=2024-03-19\">Tíquetes do GitHub para a versão 6.5</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir para esta versão</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado por uma comunidade apaixonada de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem várias maneiras pelas quais você pode ajudar a plataforma web de código aberto mais popular do mundo, independentemente de sua experiência técnica.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Envolva-se nos testes</h2>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.5. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Procurar por vulnerabilidades</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.5, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não divulgadas</a> é duplicada. Siga as práticas de divulgação responsáveis conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.5. Com o RC3, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme do seu plugin</a> para 6.5.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a>&nbsp;O lançamento dessa versão também significa que&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a>&nbsp;da versão 6.5 serão evitadas.</p>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post:</em> <em><a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em>, <em><a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/03/12/wordpress-6-5-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Mar 2024 18:17:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3011\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"O segundo release candidate (RC2) para WordPress 6.5 está disponível! Esta versão do WordPress está em desenvolvimento. Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica. Em vez disso, é recomendável avaliar o RC2 em um servidor e site de teste. Alcançar esta fase do ciclo de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9832:\"\n<p>O segundo release candidate (RC2) para WordPress 6.5 está disponível!</p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica</strong>. Em vez disso, é recomendável avaliar o RC2 em um servidor e site de teste.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.5 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 RC2 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-RC2.zip\">versão RC2 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-RC2</code></td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">instância 6.5 RC2 do WordPress Playground</a> (disponível dentro de 35 minutos após a liberação estar pronta) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento do WordPress 6.5 é <strong>26 de março de 2024</strong>. Obtenha uma visão geral do ciclo de <a href=\"https://make.wordpress.org/core/6-5/\">lançamento da versão 6.5</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionadas a versão 6.5</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.5 RC2?</h2>\n\n\n\n<p>Graças aos muitos contribuidores que testaram até este ponto, esta versão inclui aproximadamente 20 correções de erros para o editor e mais de <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F05%2F2024..03%2F12%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">30 tickets para o núcleo do WordPress</a>. Para obter mais informações técnicas relacionadas a questões abordadas desde a versão RC1, você pode navegar pelos seguintes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-05&amp;until=2024-03-12\">Tíquetes do GitHub para a vrsão 6.5</a> desde 5 de março.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F05%2F2024..03%2F12%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 5 de março.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Atualização sobre substituições de conteúdo para padrões sincronizados</h3>\n\n\n\n<p>Conforme os padrões sincronizados melhoram, cada aprimoramento deve continuar a fornecer a melhor experiência possível. Com isso em mente, o WordPress 6.5 <a href=\"https://make.wordpress.org/core/2024/03/07/unblocking-wp6-5-font-library-and-synced-pattern-overrides/\">não incluirá a capacidade de substituir o conteúdo em padrões sincronizados</a>. Isso permite mais tempo para feedback e testes para garantir que o recurso possa realmente brilhar. Espere que este recurso estreie no próximo grande lançamento!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir?</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado pela comunidade de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem uma variedade de maneiras pelas quais você pode ajudar, independentemente de sua experiência técnica.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se nos testes</h3>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.5. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta/RC</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.5, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.5. Com o RC2, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme</a> do seu <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin</a> para a versão 6.5.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a>&nbsp;O lançamento dessa versão também significa que&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a>&nbsp;da versão 6.5 serão evitadas.</p>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post:</em> <em><a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/03/06/wordpress-6-5-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Mar 2024 09:20:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3007\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"O primeiro release candidate (RC1) para o WordPress 6.5 já está disponível! Esta versão do WordPress está em desenvolvimento. Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica. Em vez disso, é recomendável avaliar o RC1 em um servidor e site de teste. Alcançar esta fase do [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11160:\"\n<p>O primeiro release candidate (RC1) para o WordPress 6.5 já está disponível!</p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica</strong>. Em vez disso, é recomendável avaliar o RC1 em um servidor e site de teste.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.5 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 RC1 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-RC1.zip\">versão RC1 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-RC1</code></td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">instância 6.5 RC1 do WordPress Playground</a> (disponível dentro de 35 minutos após a liberação estar pronta) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento do WordPress 6.5 é <strong>26 de março de 2024</strong>. Obtenha uma visão geral do ciclo de <a href=\"https://make.wordpress.org/core/6-5/\">lançamento da versão 6.5</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionadas a versão 6.5</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.5 RC1?</h2>\n\n\n\n<p>Graças aos muitos colaboradores que testaram até este ponto, esta versão inclui mais de 20 correções de erros para o editor e mais de 40 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F27%2F2024..03%2F05%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tíquetes para o núcleo do WordPress</a>.</p>\n\n\n\n<p>Obtenha uma retrospectiva dos recursos destacados do WordPress 6.5 no <a href=\"https://br.wordpress.org/2024/02/15/wordpress-6-5-beta-1/\">anúncio da versão Beta 1.</a> Para obter mais informações técnicas relacionadas a problemas resolvidos desde a versão Beta 3, você pode navegar pelos seguintes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-02-27&amp;until=2024-03-05\">Tíquetes do GitHub para a versão 6.5</a> desde 27 de fevereiro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F27%2F2024..03%2F05%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 27 de fevereiro.</li>\n</ul>\n\n\n\n<p>Quer olhar mais profundamente para os detalhes e notas técnicas para esta versão? Esses posts recentes cobrem algumas das atualizações mais recentes:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">Apresentando a dependências de plugins no WordPress 6.5</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unificação do editor de sites e editor de posts na versão 6.5</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\">Atualizações para a API de HTML na versão 6.5</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">API de interatividade na versão 6.5</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Melhorias de I18N na versão 6.5 (performance de traduções)</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">WordPress 6.5 adiciona suporte ao AVIF</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/10/core-editor-improvement-power-in-the-details/\">Melhoria de núcleo no editor: Poder nos detalhes</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/01/22/core-editor-improvement-robust-revisions-in-the-site-editor/\">Melhoria de núcleo no editor: Revisões robustas no editor de sites</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">Todas as notas de desenvolvedor relacionadas a versão 6.5</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir?</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado pela comunidade de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem uma variedade de maneiras pelas quais você pode ajudar, independentemente de sua experiência técnica.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se nos testes</h3>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.5. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta/RC</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.5, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.5. Com o RC1, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme</a> do seu <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin</a> para a versão 6.5.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a> O lançamento dessa versão também significa que <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a> da versão 6.5 serão evitadas.</p>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post: <a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a>,</em> <em><a href=\"https://profiles.wordpress.org/courane01/\">@courane01</a>, <a href=\"https://profiles.wordpress.org/hellosatya/\">@hellosatya</a> e <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">@huzaifaalmesbah</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/02/28/wordpress-6-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Feb 2024 10:18:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=2998\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:343:\"O WordPress 6.5 Beta 3 já está disponível para testes! Esta versão do WordPress está em desenvolvimento. Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial. Você [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9651:\"\n<p>O WordPress 6.5 Beta 3 já está disponível para testes!</p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento. </strong>Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 Beta 3 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-beta3.zip\">versão Beta 3 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-beta</code>3</td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">instância</a> <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">6.5 Beta 3 do WordPress Playground</a> para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento da versão final do WordPress 6.5 é <strong>26 de março de 2024</strong>, que está a apenas quatro semanas de distância! Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-5/\">ciclo de lançamento da versão 6.5</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionados a versão 6.5</a> nas próximas semanas para obter mais informações.</p>\n\n\n\n<p><strong>Acompanhe o que há de novo no WordPress 6.5</strong> : <a href=\"https://br.wordpress.org/2024/02/15/wordpress-6-5-beta-1/\">Leia o anúncio Beta 1</a> para mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como testar</h2>\n\n\n\n<p>Sua ajuda para testar a versão do WordPress 6.5 Beta 3 é a chave para garantir que tudo no lançamento seja o melhor que pode ser. Embora o teste do processo de atualização seja essencial, experimentar novos recursos é igualmente importante. <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.5.</p>\n\n\n\n<p>Se você acha que encontrou um erro, informe-o na área <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alfa / Beta</a> nos fóruns de suporte. Se você se sentir confortável em escrever um relatório de erros reproduzível, <a href=\"https://core.trac.wordpress.org/newticket\">registre um no WordPress Trac</a>. É aqui também que você pode encontrar uma <a href=\"https://core.trac.wordpress.org/tickets/major\">lista de erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os lançamentos de testes em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de testes em Make Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal de teste central</a> no <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta e RC</h2>\n\n\n\n<p>Entre a versão Beta 1 e o Release Candidate final (RC) para cada nova versão do WordPress, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Atualizações e destaques</h2>\n\n\n\n<p>O WordPress 6.5 Beta 3 contém mais de 45 atualizações do editor desde a versão Beta 2, incluindo mais de 35 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F21%2F2024..02%2F27%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tíquetes para o núcleo do WordPress</a>.</p>\n\n\n\n<p>Cada ciclo Beta se concentra em correções de erros, e mais estão a caminho com sua ajuda através dos testes. Você pode procurar os detalhes técnicos de todos os erros abordados desde a versão Beta 1 usando estes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-02-21&amp;until=2024-02-27\">Tíquetes do GitHub para a versão 6.5</a> desde 21 de fevereiro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F21%2F2024..02%2F27%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 21 de fevereiro.</li>\n</ul>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post: <a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em>, <em><a href=\"https://profiles.wordpress.org/swissspidy/\">@swissspidy</a>, <a href=\"https://profiles.wordpress.org/adarshposimyth/\">@adarshposimyth</a></em> e <em><a href=\"https://profiles.wordpress.org/davidbaumwald/\">@davidbaumwald</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/02/20/wordpress-6-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Feb 2024 20:18:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=2994\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:343:\"O WordPress 6.5 Beta 2 já está disponível para testes. Esta versão do WordPress está em desenvolvimento. Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial. Você [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9580:\"\n<p>O WordPress 6.5 Beta 2 já está disponível para testes.</p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento. </strong>Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 Beta 2 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-beta2.zip\">versão Beta 2 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-beta</code>2</td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\" data-type=\"link\" data-id=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">instância 6.5 Beta 2 do WordPress Playground</a> para testar o software diretamente no seu navegador, sem a necessidade de um site ou configuração separada.</td></tr></tbody></table><figcaption class=\"wp-element-caption\"><br><br>A meta atual para o lançamento da versão final do WordPress 6.5 é <strong>26 de março de 2024</strong>. Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-5/\">ciclo de lançamento da versão 6.5</a> e acompanhe o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionados a versão 6.5</a> nas próximas semanas para mais detalhes.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Como testar esta versão</h2>\n\n\n\n<p>Sua ajuda para testar esta versão do WordPress 6.5 Beta 2 é a chave para garantir que tudo no lançamento seja o melhor que pode ser. Embora o teste do processo de atualização seja essencial, experimentar novos recursos é igualmente importante. <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.5.</p>\n\n\n\n<p>Se você acha que encontrou um erro, informe-o na área <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alfa / Beta</a> nos fóruns de suporte. Se você se sentir confortável em escrever um relatório de erros reproduzível, <a href=\"https://core.trac.wordpress.org/newticket\">registre um no WordPress Trac</a>. É aqui também que você pode encontrar uma <a href=\"https://core.trac.wordpress.org/tickets/major\">lista de erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os lançamentos de testes em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de testes em Make Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal de teste central</a> no <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta e RC</h2>\n\n\n\n<p>Entre a versão Beta 1 e o Release Candidate final (RC) para cada nova versão do WordPress, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Atualizações e destaques da versão Beta 2</h2>\n\n\n\n<p>O WordPress 6.5 Beta 2 contém mais de 50 atualizações para o editor desde a versão Beta 1, incluindo mais de 40 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F14%2F2024..02%2F19%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tickets para o núcleo do WordPress</a>.</p>\n\n\n\n<p>Cada ciclo Beta se concentra em correções de erros, e mais estão a caminho com sua ajuda através dos testes. Você pode procurar os detalhes técnicos de todos os erros abordados desde a versão Beta 1 usando estes links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-02-14&amp;until=2024-02-20\">Tíquetes do GitHub para a versão 6.5</a> desde 14 de fevereiro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F14%2F2024..02%2F20%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 14 de fevereiro.</li>\n</ul>\n\n\n\n<p><em>Agradecemos aos seguintes colaboradores por colaborarem neste post:</em> <em><a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em>, <em><a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">@huzaifaalmesbah</a></em>, <em><a href=\"https://profiles.wordpress.org/rajinsharwar/\">@rajinsharwar</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">@swissspidy</a> e <a href=\"https://profiles.wordpress.org/courane01/\">@courane01</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.5 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/02/15/wordpress-6-5-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Feb 2024 12:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=2984\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:343:\"O WordPress 6.5 Beta 1 já está disponível para testes. Esta versão do WordPress está em desenvolvimento. Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial. Você [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:25838:\"\n<p>O WordPress 6.5 Beta 1 já está disponível para testes.</p>\n\n\n\n<p><strong>Esta versão do WordPress está em desenvolvimento. </strong>Não é recomendável executar esta versão em um site de produção. Ao invés disso, é recomendável que você a use em um site de teste. Isso permitirá que você teste a nova versão antes do lançamento oficial.</p>\n\n\n\n<p>Você pode testar o WordPress 6.5 Beta 1 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.5-beta1.zip\">versão Beta 1 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.5-beta1</code></td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">instância</a> <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">6.5 Beta 1 do WordPress Playground</a> para testar o software diretamente no seu navegador, sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento da versão final do WordPress 6.5 é <strong>26 de março de 2024</strong>. Sua ajuda nos testes da versão é vital para garantir que tudo nesta versão seja o melhor possível.</p>\n\n\n\n<p>Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-5/\">ciclo de lançamento da versão 6.5</a> e acompanhe o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-5/\">posts relacionados a versão 6.5</a> nas próximas semanas para mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como ajudar a testar esta versão</h2>\n\n\n\n<p>Testar problemas é uma parte crítica do desenvolvimento de qualquer software, e é uma maneira significativa para qualquer pessoa contribuir – quer você tenha experiência ou não.</p>\n\n\n\n<p>Se você acha que encontrou um erro, informe-o na área <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alfa / Beta</a> nos fóruns de suporte. Se você se sentir confortável em escrever um relatório de erros reproduzível, <a href=\"https://core.trac.wordpress.org/newticket\">registre um no WordPress Trac</a>. É aqui também que você pode encontrar uma <a href=\"https://core.trac.wordpress.org/tickets/major\">lista de erros conhecidos</a>.</p>\n\n\n\n<p>O WordPress 6.5 incluirá muitos novos recursos anteriormente disponíveis apenas através do plugin Gutenberg. Saiba mais sobre as atualizações do Gutenberg desde o WordPress 6.4, conferindo os artigos das  <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">Novidades do Gutenberg</a> para as versões <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">16.8</a>, <a href=\"https://make.wordpress.org/core/2023/10/25/whats-new-in-gutenberg-16-9-25-october-2/\">16.9</a>, <a href=\"https://make.wordpress.org/core/2023/11/10/whats-new-in-gutenberg-17-0-9-november/\">17.0</a>, <a href=\"https://make.wordpress.org/core/2023/11/22/whats-new-in-gutenberg-17-1-22-november/\">17.1</a>, <a href=\"https://make.wordpress.org/core/2023/12/06/whats-new-in-gutenberg-17-2-6-december/\">17.</a>2, <a href=\"https://make.wordpress.org/core/2023/12/20/whats-new-in-gutenberg-17-3-20-december/\">17.3</a>, <a href=\"https://make.wordpress.org/core/2024/01/04/whats-new-in-gutenberg-17-4-03-january/\">17.4</a>, <a href=\"https://make.wordpress.org/core/2024/01/17/whats-new-in-gutenberg-17-5-17-january-2024/\">17.5</a>, <a href=\"https://make.wordpress.org/core/2024/01/31/whats-new-in-gutenberg-17-6-31-january/\">17.6</a> e <a href=\"https://make.wordpress.org/core/2024/02/14/whats-new-in-gutenberg-17-7-14th-february/\">17.7</a>.</p>\n\n\n\n<p>O WordPress 6.5 Beta 1 contém aproximadamente 681 melhorias e 488 correções de erros para o editor, incluindo cerca de <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">229 tíquetes para o núcleo do WordPress 6.5</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta e RC</h2>\n\n\n\n<p>Entre a versão Beta 1 e o Release Candidate final (RC) para cada nova versão do WordPress, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Descubra o que está a caminho no WordPress 6.5</h2>\n\n\n\n<p>O primeiro grande lançamento deste ano adicionará finesse e ajustes para como você controla sua experiência de criação de sites, com muito a explorar especificamente para desenvolvedores. Você encontrará mais maneiras de gerenciar suas fontes e estilos, atualizações notáveis para padrões sincronizados, uma coleção de atualizações do editor de site e atualizações de desempenho para ajudar a fazer as coisas juntamente com novas maneiras de aproveitar as ferramentas de design em temas clássicos.</p>\n\n\n\n<p>O WordPress 6.5 incluirá APIs fundamentais inovadoras que começarão a transformar a forma como você usa blocos para criar experiências memoráveis. Esta versão convida você a navegar pelas bibliotecas em estágio inicial, descobrir como você gostaria de vê-los evoluir e ter um impacto em suas futuras melhorias e capacidades.</p>\n\n\n\n<p>Ainda com curiosidade? Continue lendo para alguns destaques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conheça a biblioteca de fontes</h3>\n\n\n\n<p>Inicialmente previsto para lançamento no WordPress 6.4, a <a href=\"https://core.trac.wordpress.org/ticket/59166\">biblioteca de fontes</a> é uma daquelas grandes coisas que vale a pena esperar. Ela oferece novos recursos para gerenciar eficientemente uma peça vital do design do seu site, a tipografia, sem etapas adicionais ou de codificação.</p>\n\n\n\n<p>Com a biblioteca de fontes, você pode lidar com fontes em todo o site, independentemente do seu tema ativo, como a forma como gerencia ativos na biblioteca de mídia. Você pode instalar fontes locais ou do Google Fonts, e é facilmente extensível, com a capacidade de adicionar suas próprias coleções de tipografia personalizadas.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Padrões sincronizados recebem uma atualização</h3>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/reusable-blocks/\">Padrões sincronizados</a> trazem eficiência para o processo de design, permitindo que você faça alterações globais em layouts específicos com o mínimo de esforço. No entanto, muitas vezes é necessário fazer alterações contextuais quando se trata de conteúdo.</p>\n\n\n\n<p>O WordPress 6.5 introduz novos aprimoramentos em padrões sincronizados que permitem substituir o conteúdo em cada instância específica. Você pode escolher qual conteúdo pode ser atualizado em um padrão sincronizado, mantendo o design e o layout que você já criou. Use-o para peças modeladas como receitas, depoimentos ou estudos de caso que usam elementos recorrentes para enquadrar conteúdo exclusivo.</p>\n\n\n\n<p>Este grande lançamento apresentará substituições para os blocos de parágrafo, imagem, cabeçalho e botão, com suporte para mais blocos por vir à medida que o trabalho em padrões sincronizados continua.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conectando blocos e campos personalizados ou outro conteúdo dinâmico</h3>\n\n\n\n<p>O WordPress 6.5 finalmente <a href=\"https://github.com/WordPress/gutenberg/issues/53300#issuecomment-1938463648\">possibilitará conectar os principais atributos de bloco a campos personalizados</a>. Esse recurso permite que você use o valor de um campo personalizado sem criar blocos personalizados. Por exemplo, uma publicação digital pode usar campos personalizados com blocos de parágrafo e imagem. Ele poderia extrair informações de seus perfis de editores e colaboradores individuais para exibir dinamicamente em sua página de equipe, como cargos e nomes.</p>\n\n\n\n<p>A <a href=\"https://github.com/WordPress/gutenberg/issues/54536\">API de vinculação de blocos</a> alimenta essa funcionalidade e foi projetada para ser extensível o suficiente para que os desenvolvedores conectem blocos a qualquer conteúdo dinâmico, não apenas campos personalizados. Se seus dados são armazenados em outro lugar, você pode facilmente apontar blocos para essa nova fonte com apenas algumas linhas de código.</p>\n\n\n\n<p>Este é o primeiro passo de um projeto maior para simplificar a forma como os campos personalizados e outros conteúdos dinâmicos são gerenciados.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A API de Interatividade foi adicionada no núcleo</h3>\n\n\n\n<p>O que começou como apenas uma ideia no WordPress 6.4 com o <a href=\"https://github.com/WordPress/gutenberg/issues/51132\">recurso de lightbox para imagens</a>, está oficialmente entrando no núcleo. A <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks\">API de Interatividade</a> é uma nova estrutura que oferece aos desenvolvedores um método padronizado para trazer experiências interativas para os blocos. Ele visa simplificar o processo, com menos dependências de ferramentas externas, mantendo o desempenho ideal.</p>\n\n\n\n<p>As interações criam experiências envolventes, seja mostrando novos comentários ou buscando resultados de pesquisa sem recarregar uma página, permitindo que os visitantes interajam com o conteúdo em tempo real ou incorporando efeitos como contagens regressistas e animações de transição que surpreendem e encantam. Confira <a href=\"https://wpmovies.dev/\">este site de demonstração para ter um gostinho do que esse recurso pode fazer</a>.</p>\n\n\n\n<p>A versão 6.5 é apenas o começo, trazendo essa experiência de criação para o núcleo. Descubra como você pode <a href=\"https://github.com/WordPress/gutenberg/issues/56803\">acompanhar o trabalho ou dar uma mão</a> testando mais recursos.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenha mais de suas revisões</h3>\n\n\n\n<p>As revisões são os marcadores do progresso. Para projetos criativos, eles também são um retorno bem-vindo quando você está trabalhando através de um novo design ou conceito. Esta versão traz mais detalhes para o seu histórico de revisão de estilo no editor de sites.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/01/22/core-editor-improvement-robust-revisions-in-the-site-editor/\">As revisões de estilo na versão 6.5</a> apresentam uma imagem mais detalhada do seu trabalho, com atualizações de design, como marcadores de data e prazos, resumos rápidos que descrevem mudanças e a capacidade de ver uma lista completa de revisões feitas, não apenas as 100 anteriores. Exibe também as revisões do livro de estilos, para ver as alterações que não são refletidas no modelo em que você está trabalhando. As revisões de estilo também estão recentemente disponíveis para modelos e partes de modelo, oferecendo uma visão mais ampla das alterações do seu site.</p>\n\n\n\n<p>Espere ver mais <a href=\"https://make.wordpress.org/core/2023/07/05/revisions/\">trabalho acontecendo para expandir e melhorar as revisões em toda a experiência do WordPress</a>. É uma parte fundamental da edição colaborativa e do foco de fluxo de trabalho da <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">fase 3 do projeto Gutenberg</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Temas clássicos podem optar por ferramentas de aparência</h3>\n\n\n\n<p>Como a experiência de design em temas de blocos evolui e melhora, muitas dessas atualizações também estão disponíveis para temas clássicos. Os autores do tema podem optar por <a href=\"https://core.trac.wordpress.org/ticket/60118\">adicionar suporte para ferramentas de aparência a qualquer tema clássico</a>, mesmo sem o uso do theme.json. Designers e criadores de sites que usam temas clássicos terão acesso a um conjunto variado de opções de design, desde <a href=\"https://github.com/WordPress/wordpress-develop/blob/trunk/src/wp-includes/class-wp-theme-json.php#L576\">espaçamento e controles de espaçamento até tipografia e opções de cores</a>.</p>\n\n\n\n<p>Mudar de tema pode parecer um grande esforço, e para as pessoas que não estão prontas para entrar na flexibilidade dos temas do bloco, esses caminhos podem ajudar a aliviar essa tensão. Uma vez que um tema clássico recebe suporte inicial para ferramentas de aparência, mais opções de design serão adicionadas automaticamente à medida que estiverem disponíveis.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Mais ferramentas de design estão a caminho</h3>\n\n\n\n<p>Cada versão do WordPress traz mais reflexão e atenção à maneira como você pode criar com o editor de sites. As últimas melhorias na experiência de design ajudam a dar vida à sua visão criativa:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/57005\">Imagens de plano de fundo para blocos de grupo recebem suporte a tamanho e repetição</a>, permitindo que você jogue com maneiras sutis ou marcantes para adicionar mais interesse visual aos seus layouts.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/56897\">O suporte à proporção de aspecto para o bloco de cobertura</a> oferece mais controle sobre a forma e o tamanho das imagens do bloco de cobertura.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/57103\">Suporte de sombra adicionado a mais blocos</a> para ajudar a criar layouts com profundidade visual ou adicionar um pouco de personalidade ao seu design.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Atualizações do Site Editor para agilizar seu fluxo de trabalho</h3>\n\n\n\n<p>Traga facilidade e simplicidade para o processo de construção do seu site com os mais recentes avanços para os recursos do editor de sites, desde melhorias importantes na interface até as ferramentas atualizadas.</p>\n\n\n\n<p>Indo além dos blocos de grupo, agora você pode <a href=\"https://github.com/WordPress/gutenberg/pull/54426\">renomear todos os blocos no modo de exibição de lista</a>. Você também pode <a href=\"https://github.com/WordPress/gutenberg/pull/55188\">renomear</a> ou <a href=\"https://github.com/WordPress/gutenberg/pull/55292\">duplicar</a> padrões individuais para ajudar a mantê-los organizados. Outras melhorias notáveis da interface do usuário adicionam acesso às configurações de bloco com um <a href=\"https://github.com/WordPress/gutenberg/pull/50273\">rápido clique com o botão direito do mouse na exibição de lista</a>, ajuste de preferências com <a href=\"https://github.com/WordPress/gutenberg/issues/56510\">as configurações consolidadas no painel de preferências do editor</a> e a capacidade de usar a <a href=\"https://github.com/WordPress/gutenberg/pull/56295\">barra de ferramentas de bloco no modo de download quando você estiver no modo sem distrações</a>.</p>\n\n\n\n<p>Você também notará uma experiência de construção de links mais limpa e unificada que <a href=\"https://github.com/WordPress/gutenberg/issues/50891\">melhora os controles de links</a>, facilitando a criação e o gerenciamento de links em vários blocos.</p>\n\n\n\n<p>Esta versão apresenta <a href=\"https://github.com/WordPress/gutenberg/issues/33683\">melhorias no arrastar e soltar</a> para tornar sua experiência de edição mais intuitiva. Você notará ajustes visuais úteis, como <a href=\"https://github.com/WordPress/gutenberg/pull/56625\">itens deslocados no visualização de lista</a> quando você os arrastar para reorganizar. Você também descobrirá que pode <a href=\"https://github.com/WordPress/gutenberg/pull/56070\">arrastar e soltar para qualquer lugar que você gostaria</a> no editor, desde o início até o fim do espaço de trabalho.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Novas visualizações de dados no editor de sites</h3>\n\n\n\n<p>Cada parte do seu site vem com uma biblioteca de informações e dados. Organizá-lo, encontrar o que você precisa e fazer alterações deve ser tão fácil quanto a experiência de edição do site.</p>\n\n\n\n<p>O WordPress 6.5 inclui <a href=\"https://github.com/WordPress/gutenberg/issues/55083\">visualizações de dados</a> para páginas, modelos, padrões e em partes de modelos. Você pode visualizar dados em uma tabela ou exibição de grade, com uma nova interface do usuário para alternar campos e fazer alterações em massa. É uma experiência refrescante e rica em recursos que lidera o caminho para o próximo <a href=\"https://make.wordpress.org/core/2023/07/12/admin-design/\">projeto de redesenho da administração</a> no roteiro do WordPress.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Melhorias de experiência na dependência de plugins</h3>\n\n\n\n<p>O WordPress 6.5 melhora <a href=\"https://core.trac.wordpress.org/changeset/57545\">a forma como os usuários gerenciam plugins que exigem outros plugins</a>. Os autores dos plugins podem fornecer um novo cabeçalho chamado <code>Requires Plugins</code> com uma lista separada por vírgulas de plugins necessários do repositório WordPress.org, que apresentará aos usuários os links para instalar e ativar esses plugins primeiro.</p>\n\n\n\n<p>Os plugins necessários devem permanecer ativos e instalados enquanto os plugins que os exigem estiverem ativos e instalados. Se quaisquer plugins necessários se tornarem inativo ou desinstalado, os plugins que os exigem serão desativados automaticamente.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Grandes ganhos de desempenho em toda a experiência de edição e muito mais</h3>\n\n\n\n<p>O WordPress 6.5 contém mais de 110 atualizações relacionadas ao desempenho, incluindo um <a href=\"https://github.com/WordPress/gutenberg/issues/57935\">aumento impressionante na velocidade e na eficiência</a> em todo o editor de posts e no editor de sites. O carregamento é mais de duas vezes mais rápido do que em a versão 6.4, com a velocidade de processamento de entrada aumentando para quase quatro vezes mais rápido do que a versão anterior. Você também vai encontrar-se navegando através do editor de site seis vezes mais rápido do que antes.</p>\n\n\n\n<p>O tempo de carregamento para sites traduzidos recebe um impulso devido à <a href=\"https://make.wordpress.org/core/2023/11/08/merging-performant-translations-into-core/\">fusão da performance de traduções para o núcleo</a>. Isso melhora muito o tempo de carregamento dos sites traduzidos em toda a linha, carregando vários idiomas simultaneamente, tornando a alteração entre eles uma experiência mais rápida e agradável.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Destaques de acessibilidade</h3>\n\n\n\n<p>Garantir que o WordPress permaneça altamente acessível é crucial para o seu sucesso e cumprir a missão de democratizar a publicação. Com isso em mente, a versão 6.5 enviará mais de 65 atualizações para melhorar a acessibilidade em toda a plataforma. Essas atualizações incluem correções para configurações de contraste, foco de cursor, submenus, posicionamento de elementos e muito mais. Para mais informações sobre tíquetes específicos e melhorias, visite o <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.5&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">Trac do WordPress</a> e o GitHub do Gutenberg.</p>\n\n\n\n<p><strong><em>Note que os recursos destacados neste post estão sujeitos a alterações antes do lançamento final.</em></strong></p>\n\n\n\n<p><em>Agradecemos <em>aos seguintes colaboradores por colaborarem neste post:</em> <a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a>, <em><a href=\"https://profiles.wordpress.org/rajinsharwar/\">@rajinsharwar</a>,</em> <a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a>, <a href=\"https://profiles.wordpress.org/courane01/\">@courane01</a>, <a href=\"https://profiles.wordpress.org/hellosatya/\">@hellosatya</a>, <a href=\"https://profiles.wordpress.org/bph/\">@bph</a>, <a href=\"https://profiles.wordpress.org/greenshady/\">@greenshady</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">@richtabor</a>, <a href=\"https://profiles.wordpress.org/priethor/\">@priethor</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">@annezazu</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a>, <a href=\"https://profiles.wordpress.org/santosguillamot/\">@santosguillamot</a>, <a href=\"https://profiles.wordpress.org/cwhitmore/\">@cwhitmore</a>, <a href=\"https://profiles.wordpress.org/costdev/\">@costdev</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">@ehtis</a>, <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">@huzaifaalmesbah</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">@get_dave</a> e <a href=\"https://profiles.wordpress.org/ellatrix/\">@ellatrix</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WordPress 6.4.3 – Atualização de manutenção e segurança\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://br.wordpress.org/2024/01/31/wordpress-6-4-3-atualizacao-de-manutencao-e-seguranca/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Jan 2024 15:05:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=2980\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"Esta versão de manutenção e segurança apresenta 5 correções de erros no núcleo, 16 correções de erros para o editor de blocos e 2 correções de segurança. Como esta é uma versão de segurança, é recomendável que você atualize seus sites imediatamente. Também estão disponíveis correções para as versões 4.1 e posteriores do WordPress. Você [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7334:\"\n<p>Esta versão de manutenção e segurança apresenta <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;component=!Bundled+Theme&amp;id=!59828&amp;milestone=6.4.3&amp;group=status&amp;col=id&amp;col=summary&amp;col=component&amp;col=owner&amp;col=type&amp;col=priority&amp;col=version&amp;col=keywords&amp;order=priority\">5 correções de erros no núcleo</a>, <a href=\"https://github.com/WordPress/wordpress-develop/pull/5698#issuecomment-1909302298\">16 correções de erros para o editor de blocos</a> e 2 correções de segurança.</p>\n\n\n\n<p><strong>Como esta é uma versão de segurança, é recomendável que você atualize seus sites imediatamente.</strong> Também estão disponíveis correções para as versões 4.1 e posteriores do WordPress.</p>\n\n\n\n<p>Você pode <a href=\"https://wordpress.org/wordpress-6.4.3.zip\">baixar o WordPress 6.4.3 do WordPress.org</a> ou visitar seu painel do WordPress, clicar em “Atualizações” e clicar em “Atualizar agora”. Se você tiver sites que suportam atualizações automáticas em segundo plano, o processo de atualização será iniciado automaticamente.</p>\n\n\n\n<p>O WordPress 6.4.3 é uma versão de ciclo curto. O próximo grande lançamento será a <a href=\"https://make.wordpress.org/core/6-5/\">versão 6.5</a> prevista para 26 de março de 2024. Você pode revisar um resumo das atualizações de manutenção nesta versão lendo o <a href=\"https://make.wordpress.org/core/2024/01/25/wordpress-6-4-3-rc1-is-now-available/\">anúncio do release candidate</a>. Para mais informações sobre esta versão, visite <a href=\"https://wordpress.org/support/wordpress-version/version-6-4-3\">o site HelpHub</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Atualizações de segurança incluídas nesta versão</h2>\n\n\n\n<p>A equipe de segurança gostaria de agradecer às seguintes pessoas por relatar vulnerabilidades de forma responsável e permitir que elas sejam corrigidas nesta versão:</p>\n\n\n\n<ul>\n<li><a href=\"https://hackerone.com/m4tutocs\">m4tuto</a> por encontrar uma maneira de desviar o envio de arquivos PHP pelo instalador de plugins (exigindo privilégios de administrador).</li>\n\n\n\n<li><a href=\"https://twitter.com/_s_n_t\">@_s_n_t</a> da <a href=\"https://twitter.com/pentestltd\">@pentestltd</a> trabalhando com a Trend Micro Zero Day Initiative por encontrar uma vulnerabilidade RCE POP Chains.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Agradecimento aos colaboradores do WordPress</h2>\n\n\n\n<p>Este lançamento foi liderado por <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> e <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>O WordPress 6.4.3 não teria sido possível sem as contribuições das seguintes pessoas. Seus esforços para fornecer manutenção e correções de segurança em uma versão estável é uma prova do poder e da capacidade da comunidade WordPress.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/ajlende\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexstine\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andraganescu\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/aristath\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/artemiosans\">Artemio Morales</a>, <a href=\"https://profiles.wordpress.org/benharri\">ben</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/cbravobernal\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/chesio\">Česlav Przywara</a>, <a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/mapumba\">Daniel Käfer</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>, <a href=\"https://profiles.wordpress.org/kebbet\">Erik</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/joen\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joppuyo\">joppuyo</a>, <a href=\"https://profiles.wordpress.org/lakshmananphp\">Lax Mariappan</a>, <a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a>, <a href=\"https://profiles.wordpress.org/flootr\">Markus</a>, <a href=\"https://profiles.wordpress.org/czapla\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/ntsekouras\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/dhrupo\">Niluthpal Purkayastha</a>, <a href=\"https://profiles.wordpress.org/noahtallen\">Noah Allen</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/tykoted\">Teddy Patriarca</a> e <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir</h2>\n\n\n\n<p>Para se envolver no desenvolvimento do núcleo do WordPress, dirija-se ao Trac, <a href=\"https://core.trac.wordpress.org/report/6\">escolha um ticket</a> e participe da conversa nos <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C065MBW03EH\">#6-5-release-leads channels</a>. Precisa de ajuda? Confira o <a href=\"https://make.wordpress.org/core/handbook/\">manual do colaborador do núcleo</a>.</p>\n\n\n\n<p>Como um lembrete final, a equipe de segurança do WordPress nunca enviará um e-mail para você solicitar que você instale um plug-in ou tema em seu site e nunca pedirá um nome de usuário e senha do administrador. <a href=\"https://wordpress.org/news/2023/12/alert-wordpress-security-team-impersonation-scams/\">Por favor, mantenha-se vigilante contra ataques de phishing</a>.</p>\n\n\n\n<p><em>Agradecemos a <a href=\"https://profiles.wordpress.org/angelasjin/\">Angela Jin</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham S.</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> e <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> para revisão.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Pessoas do WordPress: Daniel Kossmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://br.wordpress.org/2024/01/24/pessoas-do-wordpress-daniel-kossmann/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://br.wordpress.org/2024/01/24/pessoas-do-wordpress-daniel-kossmann/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Jan 2024 20:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:5:\"Geral\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"comunidade\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"meetups\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:20:\"Pessoas do WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=2962\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"A mais recente história das Pessoas do WordPress destaca Daniel Kossmann, do Brasil, em sua jornada de fã de videogames a construtor de comunidade.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Daniel Kossmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16462:\"\n<p><strong>Neste mês, destacamos Daniel Kossmann, um engenheiro de software da América do Sul que compartilha seu entusiasmo pelo WordPress em todas as oportunidades.</strong></p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>A série <em>Pessoas do WordPress</em> (em inglês: People of WordPress) apresenta histórias inspiradoras de como a vida das pessoas pode mudar para melhor através do WordPress e sua comunidade global de colaboradores.</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://br.wordpress.org/files/2024/01/image.jpeg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1014\" height=\"627\" src=\"https://br.wordpress.org/files/2024/01/image.jpeg\" alt=\"\" class=\"wp-image-2967\" srcset=\"https://br.wordpress.org/files/2024/01/image.jpeg 1014w, https://br.wordpress.org/files/2024/01/image-300x186.jpeg 300w, https://br.wordpress.org/files/2024/01/image-768x475.jpeg 768w\" sizes=\"(max-width: 1014px) 100vw, 1014px\" /></a></figure>\n\n\n\n<p>A aventura de Daniel com o WordPress começou em 2009, quando procurava uma maneira de publicar e compartilhar artigos sobre filmes. Desse pequeno começo, ele agora desfruta de uma carreira interessante e variada no Brasil e ainda vai além, ampliando constantemente suas conexões com a comunidade.</p>\n\n\n\n<p>Acompanhar o WordPress e suas novas funcionalidades fascina Daniel, e ele está sempre buscando maneiras de compartilhar o que o WP tem a oferecer. Seu foco inicial no WordPress para publicação de conteúdo logo se tornou uma apreciação mais ampla da capacidade da plataforma de construir comunidades e carreiras.</p>\n\n\n\n<p>Daniel atuou como organizador da comunidade por sete anos em Curitiba, Brasil, e co-organizou quatro eventos anuais do <a href=\"https://wptranslationday.org/\">WordPress Translation Day</a> (Dia da Tradução do WordPress) na cidade. Iniciativas de construção de comunidades, como essas, atraem novos voluntários e ajudam a impulsionar grupos locais de usuários.</p>\n\n\n\n<p>Agora trabalhando como gerente de engenharia de software, Daniel mantém seu interesse em apoiar a comunidade WordPress através de uma newsletter em português.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Encontrar o WordPress para publicar conteúdo pode ser transformador</h2>\n\n\n\n<p>As habilidades de desenvolvimento web de Daniel foram inicialmente autodidatas, impulsionadas pelo seu interesse em tecnologia e videogames. Ele desenvolveu sistemas em ASP e PHP, e criou materiais online para ensinar outros a criar sites.</p>\n\n\n\n<p>Quando chegou a hora de escolher o curso de nível superior, não teve dúvidas de que seria algo relacionado a computadores e escolheu Ciência da Computação na Universidade Federal do Paraná.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Para poder me concentrar mais no conteúdo do que na programação, acabei conhecendo o WordPress. Foi amor à primeira vista!&#8221;</p>\n</blockquote>\n\n\n\n<p>Em 2009, lançou um blog público sobre filmes que se tornou um centro para conteúdo cultural relacionado a cinema, literatura e quadrinhos. O blog tinha colaboradores de várias cidades do país. Ele achou o WordPress uma ferramenta fácil para publicar artigos. Isso permitiu que passasse mais tempo escrevendo conteúdo em vez de ter que usar suas habilidades de engenharia de software para escrever código.</p>\n\n\n\n<p>No entanto, uma vez que descobriu a amplitude e versatilidade do software, quis construir temas e funcionalidades para personalizar sites.</p>\n\n\n\n<p>Enquanto procurava tutoriais, se deparou com um evento do WordPress acontecendo em sua própria cidade. Esse evento, o <a href=\"https://curitiba.wordcamp.org/2010/\">WordCamp Curitiba 2010</a>, teve um profundo impacto no Daniel.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><em>&#8220;Outros eventos de tecnologia que participei cobravam mais que o dobro deste WordCamp, mas não ofereciam metade das coisas dele.&#8221;</em></p>\n</blockquote>\n\n\n\n<p>Daniel foi inspirado não apenas pelas palestras, mas também pela gentileza mostrada por outros no evento. Sua timidez inerente significava que tinha que sair de sua zona de conforto para socializar. No entanto, o acolhimento dos participantes e a recepção que recebeu tornaram isso menos assustador. Ele foi fisgado pela comunidade que conheceu e prometeu ser voluntário no próximo WordCamp e até se candidatar como palestrante.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://br.wordpress.org/files/2024/01/image-1.jpeg\"><img decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://br.wordpress.org/files/2024/01/image-1-1024x683.jpeg\" alt=\"\" class=\"wp-image-2969\" srcset=\"https://br.wordpress.org/files/2024/01/image-1-1024x683.jpeg 1024w, https://br.wordpress.org/files/2024/01/image-1-300x200.jpeg 300w, https://br.wordpress.org/files/2024/01/image-1-768x512.jpeg 768w, https://br.wordpress.org/files/2024/01/image-1.jpeg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\"><em>Daniel dando uma palestra no WordCamp São Paulo 2018 sobre Gutenberg</em></figcaption></figure>\n\n\n\n<p>Menos de dois anos depois, Daniel ajudou a organizar o <a href=\"https://curitiba.wordcamp.org/2012/\">WordCamp em Curitiba 2012</a>, e lá deu sua primeira palestra pública. Foi um momento importante na sua jornada. Ele está determinado em continuar melhorando suas habilidades de oratória a cada vez que se apresenta e a ajudar outros a fazerem o mesmo.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Do usuário do WordPress a empreendedor</h2>\n\n\n\n<p>Daniel sonhava em começar sua própria empresa desde criança. Após sua formatura na universidade em 2011, decidiu realizar esse sonho. Ele abriu uma empresa de desenvolvimento web, imaginando-a como um laboratório de projetos criativos.</p>\n\n\n\n<p>Inicialmente, trabalhou com uma variedade de sistemas e linguagens de programação. Logo depois, percebeu que manter múltiplas soluções exigia tempo e esforço consideráveis. Então, optou por usar uma única plataforma, o WordPress. Ela oferecia facilidade de uso para seus clientes e a possibilidade de oferecer vários tipos de sites.</p>\n\n\n\n<p><em>&#8220;Essa decisão me permitiu mergulhar ainda mais na plataforma, fazendo soluções melhores e mais rápidas de entregar para meus clientes&#8221;</em>, disse Daniel.</p>\n\n\n\n<p>À medida que a empresa crescia, expandiu os serviços oferecidos para incluir suporte, manutenção, cursos, consultoria e hospedagem otimizada para WordPress. Isso deu a Daniel acesso a uma gama mais ampla de clientes e maior especialização na plataforma WordPress.</p>\n\n\n\n<p>Mesmo sendo uma empresa pequena, Daniel queria retribuir à comunidade do WordPress. Ao usar este software de código aberto, o negócio não enfrentou os custos de usar plataformas comerciais. Ele então sentiu que deveria investir de volta no software e em sua comunidade tanto quanto pudesse, desde patrocínio de eventos até colaborando nas Equipes de Colaboradores.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://br.wordpress.org/files/2024/01/image-2.jpeg\"><img decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://br.wordpress.org/files/2024/01/image-2-1024x768.jpeg\" alt=\"\" class=\"wp-image-2970\" srcset=\"https://br.wordpress.org/files/2024/01/image-2-1024x768.jpeg 1024w, https://br.wordpress.org/files/2024/01/image-2-300x225.jpeg 300w, https://br.wordpress.org/files/2024/01/image-2-768x576.jpeg 768w, https://br.wordpress.org/files/2024/01/image-2-440x330.jpeg 440w, https://br.wordpress.org/files/2024/01/image-2.jpeg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Suas contribuições na comunidade incluem palestras em <em>meetups</em> e WordCamps para compartilhar o que ele aprendeu no dia a dia do trabalho. <em>“Sempre foi e ainda é um grande prazer poder fazer essas contribuições”</em>, afirmou.</p>\n\n\n\n<p>Em 2019, após oito anos da sua fundação, decidiu fechar sua empresa e começar um novo capítulo como Coordenador de Desenvolvimento. Seu foco continua sendo o WordPress, tanto profissionalmente quanto na comunidade.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Apoiando localmente: reenergizando a comunidade WordPress de Curitiba</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://br.wordpress.org/files/2024/01/image-3.jpeg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://br.wordpress.org/files/2024/01/image-3-1024x768.jpeg\" alt=\"\" class=\"wp-image-2971\" srcset=\"https://br.wordpress.org/files/2024/01/image-3-1024x768.jpeg 1024w, https://br.wordpress.org/files/2024/01/image-3-300x225.jpeg 300w, https://br.wordpress.org/files/2024/01/image-3-768x576.jpeg 768w, https://br.wordpress.org/files/2024/01/image-3-440x330.jpeg 440w, https://br.wordpress.org/files/2024/01/image-3.jpeg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\"><em>Daniel palestrando no meetup de Curitiba em 2016</em></figcaption></figure>\n\n\n\n<p>Após o WordCamp em Curitiba em 2012, a comunidade da cidade fez uma pausa na organização de eventos. Três anos depois, Daniel estava ansioso para ajudar a reiniciar os meetups em Curitiba. Ele se conectou com outros na comunidade brasileira para encontrar uma maneira de apoiar tanto os usuários finais do WordPress quanto as empresas que usam a plataforma. Por meio da ferramenta de mensagens instantâneas Slack, o evento foi reiniciado em agosto de 2015. Todo o planejamento foi feito virtualmente e os organizadores só se conheceram pessoalmente no dia do evento.</p>\n\n\n\n<p>Embora não tivessem muita experiência em planejamento de eventos, os organizadores do meetup estavam determinados a garantir que os participantes se divertissem e desfrutassem de uma atmosfera descontraída. Eles queriam que as pessoas se sentissem à vontade para socializar e conversar antes e depois das palestras. Um dos elementos mais bem-sucedidos desses meetups focados no usuário foram as dicas que os participantes compartilhavam.</p>\n\n\n\n<p>Para Daniel, ficar de frente com as pessoas para apresentar o evento ainda não era fácil. No entanto, sabia que a única maneira de superar sua timidez era continuar a praticar e melhorar sua autoconfiança. Essa determinação e senso de realização o inspirou a incentivar outros a apresentarem palestras e compartilhar as dicas que utiliza.</p>\n\n\n\n<p>O <a href=\"https://www.meetup.com/wpcuritiba/\">meetup de Curitiba</a> continua a prosperar. Embora Daniel tenha mudado a forma que apoia a comunidade, tem um carinho duradouro por ela. Isso o tornou um defensor de grupos locais como o coração da comunidade WordPress. Ele acredita que o interesse e o entusiasmo pelo aprendizado compartilhados nos meetups ajudam a aumentar o interesse dos participantes tanto no software quanto em sua comunidade, e sua disposição para participar.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Compartilhando os benefícios do WordPress em todo o Brasil</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://br.wordpress.org/files/2024/01/image-4.jpeg\"><img loading=\"lazy\" decoding=\"async\" width=\"991\" height=\"600\" src=\"https://br.wordpress.org/files/2024/01/image-4.jpeg\" alt=\"\" class=\"wp-image-2972\" srcset=\"https://br.wordpress.org/files/2024/01/image-4.jpeg 991w, https://br.wordpress.org/files/2024/01/image-4-300x182.jpeg 300w, https://br.wordpress.org/files/2024/01/image-4-768x465.jpeg 768w\" sizes=\"(max-width: 991px) 100vw, 991px\" /></a><figcaption class=\"wp-element-caption\">Daniel apresentando em um meetup de Curitiba em 2019</figcaption></figure>\n\n\n\n<p>Em junho de 2019, Daniel criou uma <em>newsletter</em>, <a href=\"https://www.painelwp.com.br/\">PainelWP</a>, para divulgar conteúdo sobre o WordPress em português e inspirar outros a criarem conteúdo nesse idioma. </p>\n\n\n\n<p>Daniel acredita que traduzir é uma maneira poderosa de tornar o WordPress mais acessível para pessoas que não falam inglês, o que é o caso de muitas pessoas no Brasil. </p>\n\n\n\n<p>Em 2021, Daniel começou a escrever regularmente sobre o WordPress em seu blog também. Ele continua publicando notícias semanais, tutoriais, dicas e compartilhando eventos.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Conselhos para futuros colaboradores do WordPress</h2>\n\n\n\n<p>Daniel acredita que a comunidade do WordPress é um dos pontos fortes da plataforma. Ela atrai pessoas com uma variedade de habilidades técnicas e experiências, e se esforça para ter um espaço diverso e aberto para trocas.</p>\n\n\n\n<p>Há inúmeras maneiras de contribuir para o WordPress que não envolvem código. Ele disse: <em>“Sou um grande evangelizador do aprendizado em público. Uma ótima maneira de colaborar é criar seu blog com WordPress e compartilhar sua jornada de uso, escrevendo sobre dicas e recursos úteis. Isso eventualmente te levará à documentação oficial do WordPress e, quanto mais você usar, mais oportunidades de melhorias você verá. Então você pode começar a contribuir para aprimorá-lo. Além disso, você pode escolher um plugin ou tema que usa e ajudar com sua tradução.”</em></p>\n\n\n\n<p>Ele acrescentou: <em>“Meu maior conselho para quem está começando a contribuir para o WordPress é começar com um pequeno passo, talvez resolvendo um bug fácil ou corrigindo um erro de digitação, e criar uma rotina para trabalhar consistentemente nisso como, por exemplo, uma hora todo fim de semana.”</em></p>\n\n\n\n<p>Daniel fez várias amizades duradouras, recebeu indicações profissionais por conta da sua participação em eventos da comunidade e desfruta de uma carreira que continua a ter variedade e coisas novas para aprender.</p>\n\n\n\n<p>Sua mensagem final é para que participem dos <a href=\"https://www.meetup.com/topics/wordpress/\">encontros locais</a> do WordPress ou online em outras cidades, e se inspire como ele tem se inspirado por 14 anos e ainda continua.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Compartilhe as histórias</h2>\n\n\n\n<p>Ajude a compartilhar essas histórias de colaboradores de código aberto e continue a crescer a comunidade. Conheça mais <em>WordPressers</em> na série <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">Pessoas do WordPress</a>.</p>\n\n\n\n<p>Para ajudá-lo a descobrir mais sobre como usar o software WordPress, confira os recursos e artigos gratuito da comunidade em <a href=\"https://learn.wordpress.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Learn.WordPress.org</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Colaboradores</h2>\n\n\n\n<p>Obrigado ao <a href=\"https://profiles.wordpress.org/kossmann/\">@kossmann</a> por compartilhar suas aventuras no WordPress.</p>\n\n\n\n<p>Obrigado a Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\" target=\"_blank\" rel=\"noreferrer noopener\">@webcommsat</a>), Larissa Murillo (<a href=\"https://profiles.wordpress.org/lmurillom/\" target=\"_blank\" rel=\"noreferrer noopener\">@lmurillom</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\" target=\"_blank\" rel=\"noreferrer noopener\">@meher</a>), Chloe Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\" target=\"_blank\" rel=\"noreferrer noopener\">@cbringmann</a>) pela pesquisa, entrevistas e escrita deste artigo de destaque.</p>\n\n\n\n<p>A série <em>Pessoas do WordPress</em> agradece a Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\" target=\"_blank\" rel=\"noreferrer noopener\">@chanthaboune</a>) e Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\" target=\"_blank\" rel=\"noreferrer noopener\">@topher1kenobe</a>) pelo apoio.</p>\n\n\n\n<p><em>Artigo originalmente publicado em inglês no <a href=\"https://wordpress.org/news/2023/01/people-of-wordpress-daniel-kossmann/\" target=\"_blank\" rel=\"noreferrer noopener\">blog da Comunidade do WordPress</a> em 31 de janeiro de 2023. Traduzido por <a href=\"https://profiles.wordpress.org/kossmann/\" target=\"_blank\" rel=\"noreferrer noopener\">Daniel Kossmann</a>, com ajuda do ChatGPT, e revisado por <a href=\"https://profiles.wordpress.org/gugaalves/\" target=\"_blank\" rel=\"noreferrer noopener\">Guga Alves</a>, <a href=\"https://profiles.wordpress.org/pamprn/\" target=\"_blank\" rel=\"noreferrer noopener\">Pamela Ribeiro</a> e <a href=\"https://profiles.wordpress.org/rahmohn/\" target=\"_blank\" rel=\"noreferrer noopener\">Ramon Ahnert</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://br.wordpress.org/2024/01/24/pessoas-do-wordpress-daniel-kossmann/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://br.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 03 Apr 2024 18:13:08 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 02 Apr 2024 19:59:49 GMT\";s:4:\"link\";s:61:\"<https://br.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20211220193300\";}", "no");
INSERT INTO `wpcx_options` VALUES("1079", "_transient_timeout_feed_mod_b85365aa61afaf3d4189819a6f57c4c4", "1712211189", "no");
INSERT INTO `wpcx_options` VALUES("1080", "_transient_feed_mod_b85365aa61afaf3d4189819a6f57c4c4", "1712167989", "no");
INSERT INTO `wpcx_options` VALUES("1081", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1712211189", "no");
INSERT INTO `wpcx_options` VALUES("1082", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: #114 – Tammie Lister on the Journey Through Design and Theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=155234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/podcast/114-tammie-lister-on-the-journey-through-design-and-theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48061:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, design and the future of theming in WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WP Tavern.com forward slash feed forward slash podcast. And you can copy that URL in to most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to WP Tavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Tammie Lister. Tammie is a product creator focusing on WordPress. She has a hybrid background across product, design, psychology and development. She contributes to WordPress and is passionate about open source and the community. If you&#8217;ve been in the WordPress space for awhile, Tammie&#8217;s name is likely a familiar one. She&#8217;s an 18 year veteran of the project. A talented designer, developer and a key contributor to the project. Her journey has made her wear a variety of hats in both agency, life and product development.</p>\n\n\n\n<p>Today, Tammie shares insights that span from the practical, to the philosophical within the open source landscape. We get to hear Tammie&#8217;s perspective on this crucial experimentation phase in WordPress theme development. The balance she seeks between minimalist design and functional complexity, and active roles, including the default theme task force.</p>\n\n\n\n<p>Our discussion takes us into the evolving WordPress editor experience, user roles and interface design. We discussed the future of WordPress UI and UX, touching on visual configurations and how the Gutenberg site editor continues to shape our digital toolkit.</p>\n\n\n\n<p>For those inspired by themes, Tammie reveals her passion for them from preserving the essence of classic themes, to ways that the project might break new ground.</p>\n\n\n\n<p>She also introduces us to some of our own projects, such as Composition Themes and discusses her Classic to Block Themes project as well.</p>\n\n\n\n<p>Tammie shares some of the resources that she recommends for both beginners and seasoned developers alike, bringing to light the many pathways that you can now choose to learn about WordPress.</p>\n\n\n\n<p>Looking over the horizon of collaborative editing and design systems, Tammie&#8217;s excitement for what&#8217;s next is palpable.</p>\n\n\n\n<p>So, whether you&#8217;re a developer, a designer or a WordPress aficionado this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WP Tavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>A quick note, before we begin, this episode was recorded live at WordCamp Asia. There was quite a lot of background noise to contend with, and I&#8217;ve done my best to make the audio as easy to listen to as possible.</p>\n\n\n\n<p>And so without further delay, I bring you Tammie Lister.</p>\n\n\n\n<p>I am joined on the podcast by Tammie Lister. Hello Tammie.</p>\n\n\n\n<p>[00:03:44] <strong>Tammie Lister:</strong> Hello. How are you?</p>\n\n\n\n<p>[00:03:45] <strong>Nathan Wrigley:</strong> Yeah, good. Thank you for joining me today. We are at WordCamp Asia. I actually don&#8217;t know the name of the venue, but we are at WordCamp Asia. And Tammie&#8217;s giving us a presentation during the event. But before she tells us about that, just give us a little bit of a background. Give us your potted biography. Tell us who you are, where you&#8217;ve been, whatever you like.</p>\n\n\n\n<p>[00:04:04] <strong>Tammie Lister:</strong> Ah, yeah. So my name is Tammie Lister. I have been involved in project, oh, I think 18 years or so now, a little while. I have been pretty much, designer, developer, worn most hats around the project. I&#8217;ve been a full-time contributor, I&#8217;ve worked on phase one of Gutenberg, and I&#8217;ve also worked in agencies. And currently, I am working a kind of hybrid function, working with products, and also doing some sponsored contribution.</p>\n\n\n\n<p>[00:04:32] <strong>Nathan Wrigley:</strong> You&#8217;ve been around the houses, haven&#8217;t you, basically? You&#8217;ve been there, done that. What&#8217;s your talk about? It&#8217;s called The Elements of WordPress, but I&#8217;ve got it written down in front of me, so I know what it&#8217;s about. But you want to, just for the sake of the audience, maybe somebody listening to this will be able to watch it on WordPress TV. Tell us what you&#8217;re intending to say.</p>\n\n\n\n<p>[00:04:48] <strong>Tammie Lister:</strong> Yeah. So my talk is specifically looking at the elements of WordPress, going up from blocks, to patterns, to template parts, to templates, and then styling. And looking at how they all come together. So everything on the front end of the site, but also the hidden design system as well.</p>\n\n\n\n<p>[00:05:03] <strong>Nathan Wrigley:</strong> So that&#8217;s the talk. You haven&#8217;t done it yet, have you?</p>\n\n\n\n<p>[00:05:06] <strong>Tammie Lister:</strong> Yes.</p>\n\n\n\n<p>[00:05:06] <strong>Nathan Wrigley:</strong> You have. And how did it go?</p>\n\n\n\n<p>[00:05:08] <strong>Tammie Lister:</strong> It went really well. I was really pleased to be able to deliver it and, as of all these talks, I think it&#8217;s a good idea to kind of deliver it. I always like writing blog posts, so I&#8217;m hoping to write a blog post about it, and then iterate on it. And some of the conversations are really interesting afterwards as well.</p>\n\n\n\n<p>[00:05:22] <strong>Nathan Wrigley:</strong> Yeah. A little bit off piste, but how do you manage the nerves for things like that?</p>\n\n\n\n<p>[00:05:26] <strong>Tammie Lister:</strong> I am atrocious with nerves. I am not one of those people that ever doesn&#8217;t have nerves. I would probably worry if I didn&#8217;t have nerves.</p>\n\n\n\n<p>[00:05:33] <strong>Nathan Wrigley:</strong> Well, it&#8217;s something that I couldn&#8217;t do, so bravo. Thank you for doing that. So I&#8217;ve got a list of questions here, and I&#8217;ll go through them, and we&#8217;ll tackle them one at a time. So my first question to you, and because I know of the history that you&#8217;ve had, this question seems like on message, but we&#8217;ll see.</p>\n\n\n\n<p>I&#8217;ve written down, over the last 10 years let&#8217;s say, WordPress, well, let&#8217;s maybe go for 5 years. WordPress has changed a lot. Tell us what you make of everything that&#8217;s happened since your involvement, you know, phase one, and all of that. What sticks out as the most important moments?</p>\n\n\n\n<p>[00:06:02] <strong>Tammie Lister:</strong> The word at the moment that I&#8217;m focusing on is patterns. I love patterns because they, and I kind of said this in my talk, because when people think of a site, they don&#8217;t think of blocks, they think of patterns. If you shut your eyes and you think of a site. So that, to me, is really significant because it&#8217;s starting to deal with the science and deal with the interface as people see it.</p>\n\n\n\n<p>A lot of the work that we&#8217;ve done, is dealing with it as people see it, because a lot of phase one, and a lot of all that work was foundational. I kind of use the term iceberg. And it was all that kind of groundwork, or that big foundational pieces. And you don&#8217;t see that, and you don&#8217;t recognise that.</p>\n\n\n\n<p>The work now is refinements on top of that, and it can seem bigger, but it&#8217;s making all of that hidden work visible. So I really like that. I like it when something that I made is changed, I get great delight in that. I like it when the language is firmed, both visually and also that we start having solid names for things, and the name stick, rather than the names changing.</p>\n\n\n\n<p>[00:07:03] <strong>Nathan Wrigley:</strong> We&#8217;ve had a a lot of changing of names, haven&#8217;t we?</p>\n\n\n\n<p>[00:07:05] <strong>Tammie Lister:</strong> Yeah. I really like that we are using proper things, so we&#8217;ll get examples, reusable blocks, and then patterns, and syncing, and all those kind of things. That we&#8217;re also making things in response to how they&#8217;re being used, is really important as well.</p>\n\n\n\n<p>Initially, you&#8217;re going to make the best bet that you can be. So phase one was very much a, well, we know we need the editor, we know we need this, the block kind of needs it, this is how an editor kind of should work, rough bet, you know, throw something.</p>\n\n\n\n<p>But then you only know when people are using it how to refine it. And then, even more so when site editor, the site editor and block editor are very different. So all of that kind of information refines and changes it as well.</p>\n\n\n\n<p>[00:07:44] <strong>Nathan Wrigley:</strong> You mentioned an iceberg, and whilst I don&#8217;t want to sort of open up Pandora&#8217;s box a little bit, how well do you feel the whole of the Gutenberg project, from phase one, was communicated? Because it feels, right now, 2024, it feels like a lot of things are beginning to land, and are beginning to be understood. I&#8217;ve got the intuition that, for the last five years or so there was, just maybe the communication wasn&#8217;t what it could have been, or something like that. So it was difficult for people to understand, and that leads to all sorts of interesting conversations.</p>\n\n\n\n<p>[00:08:13] <strong>Tammie Lister:</strong> I think communication is a conversation, and conversations need to happen between two, both ways. That&#8217;s where I come back to. I think everyone has learned in this, you know, we didn&#8217;t even really have a concept of developer relations. You know, we were asking the people who were building it to do developer relations, who weren&#8217;t doing developer relations, who didn&#8217;t know how to do developer relations, right? Or we were asking people to build it, whilst also advocating for it.</p>\n\n\n\n<p>You know, all these kind of different things. And we&#8217;ve learned over time, and how to do an awful lot in this project. And we&#8217;ve had to learn a lot of, we have things like hallway hangouts, now and we have all these amazing, like the developer blog, and we have all these amazing resources that we didn&#8217;t have in phase one.</p>\n\n\n\n<p>We had, just had some like user feedback sessions, and we didn&#8217;t have the FSE program, the outreach. That kind of didn&#8217;t happen, that started happening later. We didn&#8217;t have specific people who were specifically focused on things. That was the people who were building it as well.</p>\n\n\n\n<p>So I think we&#8217;ve learned from having those conversations and refining it. But also, it&#8217;s really hard to communicate what you don&#8217;t know yet, whilst you are learning how to do it. So if you&#8217;re like, I need to experiment and I need to explore this thing, but you need to give me time to experiment and explore this thing, that&#8217;s a completely different conversation.</p>\n\n\n\n<p>[00:09:31] <strong>Nathan Wrigley:</strong> Yeah, I was having, a chat with somebody yesterday, and sort of explaining that if WordPress was a, I don&#8217;t know, a blue chip company, and it was a for-profit entity, and you had a hierarchy with the CEO at the top, you could communicate everything down with just a memo. But the nature of the WordPress project, given that there&#8217;s loads of volunteer hours, and contributor hours, and people are in different time zones, I think that&#8217;s a really difficult thing to manage.</p>\n\n\n\n<p>[00:09:51] <strong>Tammie Lister:</strong> Well you couldn&#8217;t say like, hey, can everyone just go into experimentation mode for like four years, and just everyone not judge anything that&#8217;s going to be produced. That&#8217;s a whole different conversation. And then who&#8217;s going to get the memo that we&#8217;re actually all in experimentation. And then if Bob in the corner, and then Mary in the other corner doesn&#8217;t get that memo, they&#8217;re going to be judging something. Bob and Mary are super awesome people, but they&#8217;re not going to have that knowledge to make those judgements on different things.</p>\n\n\n\n<p>[00:10:15] <strong>Nathan Wrigley:</strong> Yeah. I have no intuition as to whether anything&#8217;s changed in the background, but it sounds, from everything that you&#8217;ve said and the messaging that I&#8217;m receiving, that that message has been understood, in the places where it needs to be understood. That getting the message out, getting buy-in from people who are using it, communicating it, setting up things like the FSE program as you mentioned, and the Learn WordPress, and the mentor sponsorship.</p>\n\n\n\n<p>[00:10:37] <strong>Tammie Lister:</strong> It&#8217;s maturing of the project as well, and maturing of concepts and learning, like we all learn. I think that&#8217;s one of the things in the open source projects, you learn by doing. And it&#8217;s as safe a place as you can have as any to learn from, and as gentle a place.</p>\n\n\n\n<p>But we all need to be very gentle with allowing that learning, and just give that consideration of, we&#8217;re all learning together, we&#8217;re all reflecting on what we do. That ability to experiment, if we can kind of replicate that and keep that, I think that&#8217;s going to serve us well in the future as well.</p>\n\n\n\n<p>[00:11:10] <strong>Nathan Wrigley:</strong> I haven&#8217;t been in the WordPress ecosystem since day one, probably more like 12 years or something like that. So long enough to know a bit, but not long enough to know everything. But it does feel like when phase one began, that was probably the moment where WordPress changed beyond all recognition, in a way that it had never done before. So there may was no need to communicate on such a deep level.</p>\n\n\n\n<p>[00:11:33] <strong>Tammie Lister:</strong> I think there&#8217;s always been pivotal changes. They&#8217;ve just sometimes not, if it&#8217;s not impacting your area, impacted so many areas, I think if it impacts your area, it may have impacted a smaller area, so it would&#8217;ve felt huge in that smaller area, to that group of people.</p>\n\n\n\n<p>Because it impacted so many people, it&#8217;s the editor, right? The editor is where you go to write things. You want to impact a big area of WordPress, impact the editor. It&#8217;s pretty much impacting the heart, right? In a beautiful way.</p>\n\n\n\n<p>It really is important to think about, there&#8217;s been, you know, from plugins, to themes, to different things. There&#8217;s been so many areas that have had pivotal changes from day one that, I&#8217;m sure different people would have this on this day, and this time. This was this change that shook me, right? And I can think of many little kerfuffles, that kind of people would&#8217;ve felt, or little blips that people felt.</p>\n\n\n\n<p>But we kind of have learned along the way to have those, and learn from those. And each one you learn from, and each one as a community. I think one of the big things to do is think, okay, how do we then progress? How do we then take those learnings? How do we then get better? And I do think we have some strong learnings from this project.</p>\n\n\n\n<p>[00:12:49] <strong>Nathan Wrigley:</strong> Yeah. I also feel the footprint is important, because back 12 years ago, let&#8217;s just use that number. I don&#8217;t know what the percentage was, but it wasn&#8217;t 43 that this number, this percentage of the internet&#8217;s being used. So obviously the impact.</p>\n\n\n\n<p>[00:13:00] <strong>Tammie Lister:</strong> The footprint and the businesses that are established on it, and the livelihoods, and the families, and the people that depend on it, you know? And the children, and the partners, and there&#8217;s passion, and there&#8217;s the depth and the roots, and the people that have been on it for decades, or whatever. That leaves a lot of change. You know, trying to change things when someone has been very used to something for 15, whatever years, is quite a change.</p>\n\n\n\n<p>[00:13:26] <strong>Nathan Wrigley:</strong> How confusing do you think the editing experience is at the moment? So I&#8217;m in WordPress all the time, I have this subset of things that I need to achieve. And so for me to do that is really straightforward, because I&#8217;ve spent the time to understand the things that I need to do.</p>\n\n\n\n<p>But if I was somebody brand new coming to WordPress, what&#8217;s your intuition about how finished it is as an editing experience? Do you think we&#8217;ve got a way to go? Are you happy? Of anybody that I&#8217;ve met, you&#8217;ve probably put as much thought into this as anybody. And so I&#8217;m just curious what you think.</p>\n\n\n\n<p>[00:13:57] <strong>Tammie Lister:</strong> So I don&#8217;t think it&#8217;s baked yet, seeing it as a cake, because I think it&#8217;s getting there. One of the things with core is it&#8217;s always going to be the middle ground. And I think we often forget that when we&#8217;re looking at the interface, or we&#8217;re looking at the product, that it&#8217;s the middle that it&#8217;s going for.</p>\n\n\n\n<p>And I would always encourage people to think about how, yes, you can use it out of the box, you can use the middle, but maybe, what do you want to turn on or off? There are options that you can turn, settings as well. I would like to have more configurations to be able to be done, so that you can have less or more, depending on that.</p>\n\n\n\n<p>One of the big things from an agency perspective, is more control from user locking, and user roles, and user capacities. I&#8217;m also probably a big critic as well. I think those people that have been involved in the project, are probably way more critical than those who are outside.</p>\n\n\n\n<p>I always find that interesting. Like, you&#8217;re always going to be more critical of the things that you&#8217;ve ever touched, than anyone else&#8217;s going to be critical. If you know how the cake&#8217;s made, you&#8217;re going to be more critical about the cake.</p>\n\n\n\n<p>I think, for me, I have a personal taste, and then I have a work taste. And so I can share both of those. My personal taste is super minimal, so I would actually like to see, how less distilled can it be. But I also know, for most jobs to be done, that&#8217;s also not going to be the case at all. So I don&#8217;t want to see that to be the default of the interface.</p>\n\n\n\n<p>What I maybe want from a design perspective is absolutely not what should be the default case. And that is always the challenge as a creator of interfaces. But I would definitely like to see different types. I would like to see more visual configuration of that. And I would like to see the ability to, just be able to change the experience a lot more, and style it.</p>\n\n\n\n<p>[00:15:37] <strong>Nathan Wrigley:</strong> Do you feel that the project is heading in the right direction with the UI, the UX that we&#8217;ve got at the moment? Where patterns seem to be taking a bit more of a leading role, and also we&#8217;ve got FSE. I mean, goodness me, we could spend, honestly we could do two hours on FSE. But, is this the direction you want to see it go in? Some like really visual way of just, okay, I want to put that little pattern in that row.</p>\n\n\n\n<p>[00:15:57] <strong>Tammie Lister:</strong> So I love using the site editor&#8217;s Dreamweaver. And I go back, like super dates me. But it is right. Like, for me, that&#8217;s how I make themes now. I love Figma, but Figma, I really use, I don&#8217;t know if you know the concept of style tiles, which is basically just like, you pick your colors, you pick your fonts, and then you just make a little tile basically.</p>\n\n\n\n<p>That&#8217;s kind of what I do. And then I put that into a theme json, and then I load it up, using create block theme, the plugin. I always get those words muddled round. And then I go straight into the editor, and then I start mixing stuff around, and I make my patterns, and I do export. So I&#8217;m basically using it like Dreamweaver, that&#8217;s what I&#8217;m doing, because I find it incredibly effective.</p>\n\n\n\n<p>I strongly recommend people do that, because you are then in it and, would you release it like that? No, probably not, because then you don&#8217;t get translatable, all of those things. But I find it a really effective tool, and it&#8217;s become not just a way to do it, it&#8217;s a way to create. It&#8217;s almost like a coding tool that way.</p>\n\n\n\n<p>Patterns being central, I think is way more important. We do put too much emphasis on blocks, because patterns to me are way more important. One of the things I want with patterns is, I want pattern variations. I really would love to see that.</p>\n\n\n\n<p>[00:17:08] <strong>Nathan Wrigley:</strong> Just tell us more about that, because I think that could easily get missed.</p>\n\n\n\n<p>[00:17:11] <strong>Tammie Lister:</strong> Yeah, so as we have, you know, we have block styles or pattern styles, maybe we call it. Being able to attach different styling to different patterns that you can change. I don&#8217;t know how that happens, but I think that that would be really nice, to be able to switch that in the interface somehow. No idea how that happens.</p>\n\n\n\n<p>The other thing I would love is easier sharing styling. In fact, I&#8217;ve had a couple of conversations at this WordCamp of people just being like, I just want to port. People are going back to CSS Zen Garden. It&#8217;s got a place in everyone&#8217;s heart, right? And what if, bear with me, I&#8217;ve had more than one person say this to me in the past couple of days. What if you could go on the site, and you could grab a load of code, and no matter what theme you had, you could put it in, and then your site would look like that.</p>\n\n\n\n<p>[00:17:56] <strong>Nathan Wrigley:</strong> Neat. Neat. Really neat.</p>\n\n\n\n<p>[00:17:59] <strong>Tammie Lister:</strong> That is kind of what we want. And if it&#8217;s just styling, I mean, it&#8217;s going to be more or less, right? Because of the patterns and everything. But if you are grabbing that and getting the styles, that&#8217;s kind of where we probably should be heading, I think, personally. Very opinions on my own.</p>\n\n\n\n<p>But for me, that&#8217;s true independence of styling. And that&#8217;s what I really want, because I love ephemeral styling. That creative freedom. I think it opens up, not just to developers. It allows front end developers to really polish their fine art. They can boost their skills. They can do even more CSS on top of it, if they want to.</p>\n\n\n\n<p>And they can do even more amazing animation. It opens all these things up to more designers to be able to do it without having to know to code. So at both ends, more capable as well. So it doesn&#8217;t limit anyone.</p>\n\n\n\n<p>[00:18:48] <strong>Nathan Wrigley:</strong> Some of the steps that you mentioned, I don&#8217;t exactly know the level of every listener to this podcast, but some of them will be very technical, and would&#8217;ve understood everything that you&#8217;ve said. But then you may have said something like theme json, and then some people are glazing over and thinking, what? What&#8217;s your intuition as to where being able to create themes and patterns, what level of expertise would you ideally like to see that? Would it be ideal to allow anybody?</p>\n\n\n\n<p>[00:19:12] <strong>Tammie Lister:</strong> I would literally love you to be able to, you know, the Pattern Directory, or the Museum of Block Art. Maybe we can literal just go, pattern directory. I would love a style directory. Where you could literally go and grab a style, grab it, and then you can put it.</p>\n\n\n\n<p>[00:19:23] <strong>Nathan Wrigley:</strong> So no knowledge required, you just need to be able to just go through the directory, copy and paste.</p>\n\n\n\n<p>[00:19:27] <strong>Tammie Lister:</strong> I would love that. WordPress Zen Garden.</p>\n\n\n\n<p>[00:19:30] <strong>Nathan Wrigley:</strong> Yeah, Zen Garden takes me right back.</p>\n\n\n\n<p>[00:19:32] <strong>Tammie Lister:</strong> WordPress Zengarden. How amazing would that be, right?</p>\n\n\n\n<p>[00:19:34] <strong>Nathan Wrigley:</strong> But I guess even that step for some people, I know it seems almost ridiculous on a WordPress podcast, to say even that step might be a of a leap.</p>\n\n\n\n<p>[00:19:41] <strong>Tammie Lister:</strong> But if you had it in the interface.</p>\n\n\n\n<p>[00:19:43] <strong>Nathan Wrigley:</strong> In the interface. Okay, so it&#8217;s not like a separate Zen Garden site.</p>\n\n\n\n<p>[00:19:46] <strong>Tammie Lister:</strong> The pattern directory is in the interface. So if you had the style interface in there somehow, and you could browse it, and you could be like, I want a whatever. I have this rather peculiar analogy I&#8217;m going to share for theming, which is, at the moment, themeing should be super easy to change. But at the moment, changing a theme is like removing your head, rather than changing your clothes. Changing your jumpers should be easy, right?</p>\n\n\n\n<p>And it should just be super simple to change styling. And themes are great and amazing, but they&#8217;re a package, that&#8217;s what they are. And we need to just go back to having that beautiful freedom. And then we can have these creative freedoms.</p>\n\n\n\n<p>Themes to me are, we talk about design. Design and art are very, very different. But art is where meets WordPress in theming, to me. And art is part of my background. And there is potential for us to have some beautiful art in themes again. If we just have that freedom, and we stop themes having to have all this weight in them as well, and be tied down.</p>\n\n\n\n<p>[00:20:47] <strong>Nathan Wrigley:</strong> I get the feeling that an ideal place for you to land with this would be that, most people can do most of what they need to do when they want to style their own website. But there&#8217;s always still going to be an area for a professional.</p>\n\n\n\n<p>[00:20:59] <strong>Tammie Lister:</strong> If you think of it like fashion, is good example. So you can go and have custom fashion, you can go and have high-end, haute couture. You can always go and have custom tailoring. You can go and have all of that. Or you can go to high street, and go get something off the rack. And I think that&#8217;s a really good model for us to kind of think of it as well, right?</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Nobody&#8217;s used that on me before. That actually sums it up perfectly. That&#8217;s nice, yeah.</p>\n\n\n\n<p>[00:21:20] <strong>Tammie Lister:</strong> Yeah. And that isn&#8217;t belittling anything. That&#8217;s totally fine, you know. And that still allows us to have theme shops, fashion shops, right? That still allows us to have very functional, you know, we have very functional clothing, we have functional themes as well.</p>\n\n\n\n<p>And I think it&#8217;s really important to think about the site works, the site has to do something. Some fashion is very frivolous. Some themes are going to be incredibly frivolous as well. And I actually adore frivolous themes. I don&#8217;t think we have enough of them.</p>\n\n\n\n<p>But some are going to have to just be functional, and jobs to be done as well, because absolutely. And some are going to be frameworks, and some are going to be whatevers, you know. But it&#8217;s having those options. You know, you&#8217;re looking at high street, you have the options to be able to wear different clothing as well.</p>\n\n\n\n<p>And some people are going to be super dependent on a brand, and super passionate about only wearing that brand as well, you know, all those kind of things.</p>\n\n\n\n<p>[00:22:13] <strong>Nathan Wrigley:</strong> So you can peel back the curtain a little bit on this, because of your experience inside the project, trying to drive this change. How does it happen? Are there certain people that we should be, you know, if we&#8217;re strongly into themes, and we&#8217;re opinionated about that, and we want to make the change, where do we go? Do we start talking directly to people like you? Are there other people that we need to be banging on the door and saying, this is what we want?</p>\n\n\n\n<p>[00:22:36] <strong>Tammie Lister:</strong> So I&#8217;m not a full-time contributor, so I&#8217;m just like anybody else in that sense. I mean, I have the knowledge, I&#8217;ve been in the project, but there&#8217;s many people who&#8217;ve been in the project and have that knowledge.</p>\n\n\n\n<p>My biggest thing is use the things, start experimenting, start creating if you can. And I&#8217;m well aware, I&#8217;m suggesting that most people have a time machine to do that, because you are trying to do your job as well as you&#8217;re doing that. But if you can, in your projects, start using them. As you start using new things, you&#8217;re going to find bugs, because the universe.</p>\n\n\n\n<p>And then you can start reporting those issues, and then you can start saying, these things need to change, when you&#8217;re changing classic themes to block themes, that&#8217;s one of the big things at the moment. So you can help with those things.</p>\n\n\n\n<p>And just find the area that you want to help with. Reporting one issue, which is a few minutes, is an incredibly big help. Having one conversation is incredibly helpful. Watching one hallway hangout, which is an hour, is a big help. Watching a video, going to a talk. But then scaling it up, going to a triage session.</p>\n\n\n\n<p>It&#8217;s really finding where you are. Experiment, have a pattern in the Museum of Block Art. Have a pattern in the Pattern Directory. Find where you want to join in. But by using these things, you start to contribute, is the biggest thing, because you start then knowing how they fit.</p>\n\n\n\n<p>To dive in straight away and say, these things should be this way, without having used them in their current state, is a little bit, you might not be knowing how they are utilised. I would also always encourage people to search to see that something&#8217;s not coming up. So if you&#8217;re going to log something as an issue, just have a little quick search, and see whether it&#8217;s coming up to be fixed, before you log it in the GitHub repo. That&#8217;s always a really good kind of tip as well.</p>\n\n\n\n<p>There&#8217;s the channels in Slack, but Slack can also be quite a lot for a lot of people. So just, yeah, just using it, and just figure out where your happy is. But just start experimenting and using is the biggest one.</p>\n\n\n\n<p>[00:24:33] <strong>Nathan Wrigley:</strong> Yeah, joining in, we could probably sum it up, couldn&#8217;t we? That&#8217;s nice. Where would you go? There was a nice little segue there, because you were talking about ways to learn, and you mentioned a couple of things.</p>\n\n\n\n<p>But, where do you find to be the best places to send somebody who&#8217;s, well, let&#8217;s just say a novice? Let&#8217;s go with that. Where are the online resources, the places to hang out?</p>\n\n\n\n<p>[00:24:51] <strong>Tammie Lister:</strong> So there&#8217;s a couple of different ones. We are very lucky, we have a developer blog now, which is incredible good resources. But all the Hallway Hangouts, amazing to watch back. Learn WordPress is also a really good resource. And between all of those, you&#8217;ve just got your good start then.</p>\n\n\n\n<p>And then there&#8217;s quite a few people in between those that start doing. So Ryan has been doing some through develop blog, has also been doing some live streams. So just doing things like that.</p>\n\n\n\n<p>The problem with a lot of these things are, maybe a live stream is like an hour watching. That might be quite a lot of time for you. So that&#8217;s why maybe following like a quick little tutorial, that maybe has a GitHub repo that you can do quickly. Again it&#8217;s, how much time have you got?</p>\n\n\n\n<p>I find pointing people to the Museum of Block Art&#8217;s quite good, because they can just go there, they can see the code, they can drop it in. And then they can learn, oh, this is what a pattern is. And some of those are quite fun. Or go to the Pattern Directory, and then they can be like, oh okay, well, this is what a pattern is, and this is how it forms. Yeah, so those kind of things as well.</p>\n\n\n\n<p>WordPress.tv is also really, really good, because, if you&#8217;ve got some time, type in whatever you want to follow, and just start learning that way. You can learn some really diverse things that way. Following along some State of the Words, the kind of pivotal points, you are going to find out the points of the project that way as well, is a good milestone as well.</p>\n\n\n\n<p>[00:26:11] <strong>Nathan Wrigley:</strong> I will make sure that there is a link to everything that Tammie just said. So if you go to wptavern.com/podcast, and you search for Tammie&#8217;s episode and you find it, there will be all of the links in there.</p>\n\n\n\n<p>Lets pivot a little bit. It&#8217;s not apropos of themes at all but, what do you think about this current phase that we&#8217;re in of Gutenberg? Which is called phase three. But the highlight item for me, I mean there&#8217;s absolutely loads to be honest, but I&#8217;m just going to talk about collaborative editing. What do you make about that? And especially related to themes and sites more generally, not just the content, but editing collaboratively, just the way the whole site looks, so the theme.</p>\n\n\n\n<p>[00:26:47] <strong>Tammie Lister:</strong> I think it hasn&#8217;t been worked out yet, how it&#8217;s going to work on the theme. I don&#8217;t know if it means you are creating the theme collaboratively.</p>\n\n\n\n<p>[00:26:54] <strong>Nathan Wrigley:</strong> It&#8217;s to imagine actually.</p>\n\n\n\n<p>[00:26:56] <strong>Tammie Lister:</strong> Well, it definitely means you&#8217;re creating, so if you think of the site editor as the builder of the theme, which it kind of is, then technically, if you are creating content, which is the theme, you are creating that collaboratively, so yes. Collaborative editing at enterprise scale is something that happens quite often anyway.</p>\n\n\n\n<p>[00:27:17] <strong>Nathan Wrigley:</strong> So tools like Figma, you can do all of that collaborative editing is my understanding.</p>\n\n\n\n<p>[00:27:20] <strong>Tammie Lister:</strong> Yeah. So I&#8217;m very, if I put my design hat on, very used to, in Figma, like comments and, or even like in Google Docs, people are very used to like leaving messages and whatever. So I just think being very aware of those kind of workflows, is kind of interesting.</p>\n\n\n\n<p>One of the things we might find is, someone would just set up a template, and it&#8217;d be like, add something here, and something here later. So adding comments to your templates, might be curious and interesting.</p>\n\n\n\n<p>A different aspect might be people using different themes in the backend. That kind of comes to mind, from accessibility reasons. That is also something that I&#8217;ve always thought about is, could people want to have different editor experiences depending on their accessibility. Which you might do as well. So collaborative editor experiences, or different editor experiences. Which is slightly a sidetrack of this, but it&#8217;s something to consider.</p>\n\n\n\n<p>But phase three is collaborative editing, and plus, plus, plus. Which also the design system, finally, kind of flow. And that kind of, to me, is more Lego pieces to play with. And that&#8217;s the bit that I am incredibly excited about. Because a lot of the stuff that&#8217;s been hidden, we&#8217;ve had a design system all along. It&#8217;s really good.</p>\n\n\n\n<p>People, when they talk about the work that&#8217;s recently done, they&#8217;re pointing just to like the editor. Yes, but it&#8217;s not going to just be the editor. It&#8217;s going to be coming into the settings, into the admin, and to everything, because it needs to. There&#8217;s areas of WordPress that haven&#8217;t been touched for a very long time. And by bringing these components, and being this unification through, it&#8217;s better user experience. But it&#8217;s one user experience.</p>\n\n\n\n<p>Again, that point of, it&#8217;s a middle road. If it&#8217;s, the way that it&#8217;s being done, means you then will be able to have the same level of customisation, the same level of extensibility, the same level of styling on top of it. So you&#8217;ll be able to then, for your end users, customise it how you want to. So you have that flexibility still, yeah.</p>\n\n\n\n<p>[00:29:17] <strong>Nathan Wrigley:</strong> I think it&#8217;s fabulous that somebody who&#8217;s been around in the projects as long as you have, and I&#8217;m sure you&#8217;ve had your ups and downs, I&#8217;m sure that, you know, some days it&#8217;s like, oh, WordPress. It sounds like you are very, very, genuinely excited about what&#8217;s coming. That&#8217;s amazing.</p>\n\n\n\n<p>[00:29:30] <strong>Tammie Lister:</strong> And I&#8217;m excited about who&#8217;s doing it.</p>\n\n\n\n<p>[00:29:32] <strong>Nathan Wrigley:</strong> Oh, okay. Yeah.</p>\n\n\n\n<p>[00:29:33] <strong>Tammie Lister:</strong> It&#8217;s exciting the new, I love when you have fresher people have fresher eyes on it. I love when older people have fresh eyes on it as well, and different energy. I love when, as I&#8217;ve mentioned previously, when someone re-does work that I&#8217;ve done, I&#8217;m so excited. I&#8217;m like, yes, that&#8217;s gone.</p>\n\n\n\n<p>But it&#8217;s exciting to see areas that haven&#8217;t been touched for such a long time. We shouldn&#8217;t have areas that haven&#8217;t been for 10 years, because that&#8217;s how many years. That&#8217;s like dog years.</p>\n\n\n\n<p>[00:30:02] <strong>Nathan Wrigley:</strong> Tell us a little bit about your stuff. We&#8217;ve heard about your relationship with WordPress. Let&#8217;s just get into what you are doing at the minute. I think you said you had four hats or something. Is it four hats?</p>\n\n\n\n<p>[00:30:11] <strong>Tammie Lister:</strong> Yeah, I go with lots of hats.</p>\n\n\n\n<p>[00:30:12] <strong>Nathan Wrigley:</strong> What are the four hats? What&#8217;s keeping Tammie busy at the minute?</p>\n\n\n\n<p>[00:30:14] <strong>Tammie Lister:</strong> So I&#8217;m working on a project called Gildenberg. I&#8217;m working with Luke and Jonathan. What we&#8217;re doing is, we&#8217;re working on a guild of product creators, and we&#8217;re working to support them through that as well. That&#8217;s really exciting. So I&#8217;m doing that a little bit.</p>\n\n\n\n<p>I&#8217;m also creating my own, looking to create my own products. I&#8217;m working out what that means. Spoilers, going to start with theming. I&#8217;m also collaborating with some, doing some agency work as well. And I&#8217;ve been collab&#8217;ing some awesome plugins, doing some classic block based work. Which I actually really enjoy.</p>\n\n\n\n<p>There&#8217;s something about converting classic themes to block. One, because I&#8217;m learning where the friction points are. I&#8217;m also really lucky to be sponsored by Automattic, to be doing two days a week on the default theme task force.</p>\n\n\n\n<p>[00:30:59] <strong>Nathan Wrigley:</strong> Go on, tell us more about that. That sounds fun.</p>\n\n\n\n<p>[00:31:00] <strong>Tammie Lister:</strong> Yeah, I am really excited about that. It&#8217;s 400 odd tickets on the default themes. So the idea is, eventually, it came from the community summit. There&#8217;s actually a post up by Jonathan Desrosiers. Rather than scorch earthing, and removing all the default themes, it&#8217;s what if we actually fixed them? Which is a beautiful and wonderful concept.</p>\n\n\n\n<p>So what we&#8217;re doing is, we&#8217;re going through each ticket, and we are going to analyse, does it need fixing? Some of those tickets have been sat there for four, five years. They haven&#8217;t had attention.</p>\n\n\n\n<p>So we&#8217;re going to look at it, we&#8217;re going to see if it even stands in this time. If it does, great, let&#8217;s ship it, let&#8217;s get that patch in. If it doesn&#8217;t, it&#8217;s got a new patch. If it needs closing, let&#8217;s close it. And then we&#8217;ll able to see the lay of the land, once we don&#8217;t have this amount of tickets. Then we can decide where we go from this, on block based theme.</p>\n\n\n\n<p>[00:31:48] <strong>Nathan Wrigley:</strong> Kind of a nice project, that you can see that 400 dropping.</p>\n\n\n\n<p>[00:31:51] <strong>Tammie Lister:</strong> Oh goodness, yeah. We&#8217;ve already done some at contribution day.</p>\n\n\n\n<p>[00:31:53] <strong>Nathan Wrigley:</strong> Oh nice. Lovely.</p>\n\n\n\n<p>[00:31:55] <strong>Tammie Lister:</strong> And it is. I got to be part of some of the default themes. You know, one of my first roles within WordPress, you know, I kind of came in through theming. Theming has been a theme throughout my whole history of WordPress, throughout everything. And my heart is strongly there.</p>\n\n\n\n<p>And default themes, yes, some of them are classic, and we could be like, oh, just forget it. I don&#8217;t believe that. I think it&#8217;s history. It&#8217;s like denying that we have a history, right? And I love block themes. I think they&#8217;re amazing and they&#8217;re fantastic, but that doesn&#8217;t mean that we should forget that we have these themes.</p>\n\n\n\n<p>I think we should look at how we can bring the essence of those, if we want to bring them. Or we should look at how can we support the people that are still using them and how can we have that respect. So, if someone&#8217;s using 2011, how can we still respect that they&#8217;re using 2011?</p>\n\n\n\n<p>[00:32:50] <strong>Nathan Wrigley:</strong> Yeah. Yeah.</p>\n\n\n\n<p>[00:32:51] <strong>Tammie Lister:</strong> As well.</p>\n\n\n\n<p>[00:32:52] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s a lovely project. You very quickly glossed over, there was one there where you are going to be looking at doing your own projects, but you didn&#8217;t dive into that. Maybe it&#8217;s because you haven&#8217;t distilled it quite yet.</p>\n\n\n\n<p>[00:33:03] <strong>Tammie Lister:</strong> I haven&#8217;t yet fully.</p>\n\n\n\n<p>[00:33:04] <strong>Nathan Wrigley:</strong> What&#8217;s, the kind of intuition that that you&#8217;re going to tackle.</p>\n\n\n\n<p>[00:33:08] <strong>Tammie Lister:</strong> I really want to start creating my own themes again, that&#8217;s one of the things. And I also want to start exploring maybe some plugins as well. I don&#8217;t have an idea yet, but the idea that I can start. I&#8217;m going to use the word playing, but playing to an end. I have so many ideas, and that&#8217;s awesome, but I need to work out which idea I&#8217;m going to work on.</p>\n\n\n\n<p>[00:33:30] <strong>Nathan Wrigley:</strong> Okay, so maybe we should do this conversation again in 2025, and see where you are?</p>\n\n\n\n<p>[00:33:34] <strong>Tammie Lister:</strong> I have a theme site, Composition Themes, and I want to, I want to start making themes that have one purpose and, both that are beautiful, but also that have one purpose for types as well. That&#8217;s where I want to be themeing. But I also really like the idea of doing similar for plugins.</p>\n\n\n\n<p>Maybe it&#8217;s blocks, but maybe it&#8217;s also companion experience plugins. Going back to that idea of experience. I love the idea of maybe making the experience lesser for the editor or maybe exploring different things around that.</p>\n\n\n\n<p>[00:34:04] <strong>Nathan Wrigley:</strong> Yeah. Okay. 2025 is the date. We&#8217;ll have you back and we&#8217;ll see. What was it again?</p>\n\n\n\n<p>[00:34:08] <strong>Tammie Lister:</strong> Composition Themes.</p>\n\n\n\n<p>[00:34:10] <strong>Nathan Wrigley:</strong> Composition Themes.</p>\n\n\n\n<p>[00:34:10] <strong>Tammie Lister:</strong> Yeah. I also have Classic to Block Themes as well.</p>\n\n\n\n<p>[00:34:13] <strong>Nathan Wrigley:</strong> Oh, nice. Okay, we&#8217;ll put both of those in the show notes. Great. Well, Tammie Lister, thank you so much for joining me on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:34:21] <strong>Tammie Lister:</strong> Thank you.</p>\n\n\n\n<p>[00:34:21] <strong>Nathan Wrigley:</strong> You are very welcome.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://tammielister.com/\">Tammie Lister</a>.</p>\n\n\n\n<p>Tammie is a product creator focusing on WordPress. She has a hybrid background across product, design, psychology and development. She contributes to WordPress and is passionate about open source, and the community.</p>\n\n\n\n<p>If you’ve been in the WordPress space for a while, Tammie&#8217;s name is likely a familiar one. She&#8217;s an 18-year veteran of the project, a talented designer, developer, and a key contributor to the project. Her journey has made her wear a variety of hats in both agency life and product development.</p>\n\n\n\n<p>Today, Tammie shares insights that span from the practical to the philosophical within the open-source landscape. We get to hear Tammie&#8217;s perspective on this crucial experimentation phase in WordPress theme development, the balance she seeks between minimalist design and functional complexity, and her active roles, including the default theme task force.</p>\n\n\n\n<p>Our discussion takes us into the evolving WordPress editor experience, user roles, and interface design. We discuss the future of WordPress UI / UX, touching on visual configurations and how the Gutenberg site editor continues to shape our digital toolkit.</p>\n\n\n\n<p>For those inspired by themes, Tammie reveals her passion for them. From preserving the essence of classic themes to ways that the project might break new ground.</p>\n\n\n\n<p>She also introduces us to some of her own projects, such as Composition Themes, and discusses her Classic to Block Themes project as well.</p>\n\n\n\n<p>Tammie shares some of the resources that she recommends for both beginners and seasoned developers alike, bringing to light the many pathways that you can now choose to learn about WordPress.</p>\n\n\n\n<p>Looking over the horizon of collaborative editing and design systems, Tammie&#8217;s excitement for what&#8217;s next is palpable. So, whether you&#8217;re a developer, a designer, or a WordPress aficionado, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block Theme plugin</a></p>\n\n\n\n<p><a href=\"https://www.csszengarden.com/\">CSS Zen Garden</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/patterns/\">Pattern Directory</a></p>\n\n\n\n<p><a href=\"https://block-museum.com/\">Museum of Block Art</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/\">Developer blog</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/tag/hallwayhangout/\">Hallway Hangouts</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://wordpress.tv/\">WordPress.tv</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/state-of-the-word/\">State of the Word from 2024</a></p>\n\n\n\n<p><a href=\"https://guildenberg.com/\">Gildenberg</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/12/05/proposal-default-theme-task-force-for-2024/\">Jonathan Desrosiers&#8217; post &#8220;Proposal: Default Theme Task Force for 2024&#8221;</a></p>\n\n\n\n<p><a href=\"https://compositionthemes.com/\">Composition Themes</a></p>\n\n\n\n<p><a href=\"https://classictoblock.com/\">Classic to Block Themes</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Do The Woo Community: You Don’t Need to be a Developer to Join a Hackathon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/you-dont-need-to-a-developer-to-join-a-hackathon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Patricia, a non-developer and WordPress contributor, shares her experience and the value of having diverse skills at CloudFest Hackathon.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 09:02:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"HeroPress: The Time I Left My Island – Quella volta che sono uscito dalla mia isola\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=6656\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"https://heropress.com/essays/the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola/#utm_source=rss&utm_medium=rss&utm_campaign=the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21363:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2024/04/040224-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The sea has never been a limit, now that I know the way, I can cross it whenever I want. - Il mare non è mai stato un limite, ora che conosco la strada, posso attraversarlo tutte le volte che voglio.\" /><p><a href=\"https://heropress.com/feed/#italian\">Questo saggio è disponibile anche in italiano.</a></p>\n\n\n\n<p>Perfect, I have my blank sheet, notes on what I need to express, and I&#8217;m ready to write this essay. I have my hot coffee on the desk and my compilation of Bob Dylan playing in my ears, but we&#8217;re on the tenth song and I haven&#8217;t written a word yet, in fact, I&#8217;ve written and then deleted many. Do you know what happens? I&#8217;m not a writer, I spend my life in PHP, why should I completely detach from what is my daily routine? Okay, here we go! I&#8217;ll open my code editor, coffee, and Dylan at this hour are constants, let&#8217;s see if the words flow now.</p>\n\n\n\n<h2 class=\"kt-adv-heading6656_ed8ffe-24 wp-block-kadence-advancedheading\">My Island</h2>\n\n\n\n<p>I&#8217;m Sardinian, I come from an island in the Mediterranean envied for its sea, climate, food, and the warmth of its people. Let&#8217;s talk about an island, and sometimes the sea is a boundary, it&#8217;s a beautiful blue wall that separates you from the rest of the world, often it&#8217;s difficult to feel Italian, let alone European.</p>\n\n\n\n<p>My story begins here, with a strong introversion orchestrating my life, a passion for computer science, PHP which had been accompanying me for about 5 years, and some small attempts to overcome my shyness. Not to mention the years of studying English at school, which remained theoretical and never put into practice. To help me overcome shyness, I had started speaking at small events about Free Software, and there had been some small improvements. Meanwhile, I was beginning to get to know a CMS called WordPress, required by several companies; at that time, I didn&#8217;t know what it would give me.</p>\n\n\n\n<p>I had left my small town and moved to Cagliari, the city, on my island and facing the sea. Imagine, in 10 minutes with public transport, I was at the nearest beach, and in 30 minutes, I was at those beaches you see in screensavers. I felt in my place, at least geographically. But sometimes an island doesn&#8217;t offer you much from a work perspective, and remote work wasn&#8217;t yet so widespread. But my move to Cagliari was just a first step, like when you dip your foot in the water to see if it&#8217;s cold, before taking a run and diving in.</p>\n\n\n\n<h2 class=\"kt-adv-heading6656_06671b-01 wp-block-kadence-advancedheading\">Let&#8217;s change the song, but also the city and life.</h2>\n\n\n\n<p>I packed my bags, took a flight, and changed regions to pursue a job. I was leaving the place that De Andrè, a famous Italian singer-songwriter, described: &#8220;Life in Sardinia is perhaps the best a man can wish for: twenty-four thousand kilometers of forests, countryside, coasts immersed in a miraculous sea should coincide with what I would recommend to God to give us as Paradise.&#8221; And I arrived in what another famous Italian singer, Ligabue, describes as &#8220;This city is a hell disguised as paradise, where every dream is at risk of burning.&#8221;</p>\n\n\n\n<p>The city called me, and now I&#8217;m here. There are proposals, there are opportunities, there are hopes, and there are dreams, all within reach, my reach. The city is ready to give me everything but it needs me, my time, and my hard work. I just had to change, the island had to become a city, shyness must disappear here and change pace. Walking following that frenetic rhythm, which I didn&#8217;t understand, but which was ready to give me more and more.</p>\n\n\n\n<p>If you walk fast, in a place you don&#8217;t know, you risk coming across a street you don&#8217;t know and you could find yourself in a situation you never want to relive. You could walk on asphalt, on the sidewalk, or on a lawn, and if you&#8217;re not careful, it&#8217;s easy to stumble upon something, and from a panic attack, it&#8217;s not always easy to get back up, from two, worse.</p>\n\n\n\n<p>During the same period, I found myself on a fairly intense WordPress-based project, and between one check and another, my eye fell on a type of event I didn&#8217;t know, called WordCamp Torino, just over an hour by train from where I was.</p>\n\n\n\n<p>Early wake-up call, coffee, and off to the station, the train departs and slowly the city fades away. I participate in a contributor day and a day of talks. A nice event, I took thousands of notes but experienced only as much as my shyness allowed me to.</p>\n\n\n\n<p>I knew that this event was much more beautiful than what I had experienced, so I started paying more and more attention to that part of the site until I found two tickets, Zurich and Verona. I bought the ticket to Verona immediately, but Zurich was two weeks earlier and the choice wasn&#8217;t so easy.</p>\n\n\n\n<p>Zurich is part of German-speaking Switzerland, okay that the WordCamp was organized in two languages, but my English had been stagnant for almost 12 years, plus it was a trip to be done alone.</p>\n\n\n\n<p>Verona was a great WordCamp, I began to understand how these events work and to meet some members of the city&#8217;s MeetUp.</p>\n\n\n\n<p>Honestly, I remember Zurich less and less, it was a beautiful WordCamp, but I learned more things about myself there than about WordPress. I just wonder if there are Swiss people who believe that my surname is &#8220;sorry my English is terrible&#8221;, because when I&#8217;m a bit nervous, I speak faster and to introduce myself I would say &#8220;My name is Matteo sorry my English is terrible, nice to meet you&#8221;. The thing I remember best is that I filled out the application to be a speaker and volunteer during the return trip. Let&#8217;s talk about WordCamp Milano.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-but-it-s-just-a-tool-how-can-it-do-all-this\">But it&#8217;s just a tool, how can it do all this?</h2>\n\n\n\n<p>I was preparing my slides, comparing WordPress development with another CMS, starting from the latter. After finishing the first section where I had to talk about WordPress, I had to create a separation slide. Somewhat sarcastically, I wrote &#8220;But we&#8217;re at a WordCamp so let&#8217;s go home!&#8221; Ajo is a word widely used in Sardinia, taking it away from a Sardinian is like preventing a Roman from saying daje, it&#8217;s the equivalent of an English &#8220;let’s go&#8221;.</p>\n\n\n\n<p>It wasn&#8217;t my first time in front of an audience, but I was used to a maximum of 20/30 people. I found myself facing a university class with a lot of people, I was extremely excited and super tense. But at my &#8220;ajo&#8221; moment, amidst some laughter and some smiles, I felt at home again, in my island but at the same time in Milan, what a strange feeling.</p>\n\n\n\n<p>But it&#8217;s just a CMS, a work tool, how can it do all this? A stupid question if the person asking it has books like &#8220;Just for Fun&#8221; by Linus Torvalds, &#8220;The Cathedral and the Bazaar&#8221; by Eric Steven Raymond, and &#8220;Free Software, Free Society&#8221; by Richard Stallman in their library. So the term &#8220;community&#8221; in those texts was true and WordPress was the best example I could come across.</p>\n\n\n\n<p>In the span of a few months, I also attended events in Dublin and volunteered in Glasgow, English wasn&#8217;t a limitation for me, just something I had to work on.</p>\n\n\n\n<p>Glasgow was at the beginning of 2020, the last memory of a WordCamp before a year of closure, a year where there were online events, but the energy was different. A period in which I changed two jobs.</p>\n\n\n\n<p>It was a period halfway between the city and the island until the end of 2021, when I saw &#8220;WordCamp Geneva&#8221;, I proposed to tell my story at WordCamps, how they helped me, but they still do, both with language confidence and shyness. It was accepted and that became both my first talk in English, but also the non-technical one. A talk that involved a higher intimacy never experienced before, which will always remain a source of pride for me.</p>\n\n\n\n<p>From that moment on, WordCamp after WordCamp, each stop began to give me more and more emotions and more and more lessons, especially about myself, but not about who I am, but about what I could and wanted to be.</p>\n\n\n\n<p>From WordCamp Italy where I first became an organizer to Turin and Verona as a speaker.</p>\n\n\n\n<p>In all three, I decided to participate both days, also attending contribution days and gladly joining the polyglots team, a group I have never abandoned.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-to-infinity-and-beyond\">To infinity and beyond</h2>\n\n\n\n<p>Then they announced WordCamp Europe in Turin, the city where it all started, I applied as an organizer, which was accepted. Now I find myself talking to many new people in English almost twice a week. Every time is a challenge to my shyness, but by now I&#8217;ve learned to accept them.</p>\n\n\n\n<p>Sometimes I find myself comparing my first and last WordCamp. From a silent Contribution Day to one where I shared my experience, from being an attendee to a speaker with many listeners, from a day in silence to being someone trying to integrate the newcomers, from a person who leaves early to the last person leaving the after-party.</p>\n\n\n\n<p>But WordPress is just a tool, the end goal is always something else, in my story it&#8217;s not a website but understanding a part of myself and stopping suffocating my true identity and starting to behave in my own way. Making me understand that my island side shouldn&#8217;t be suppressed but valued, it was always me. Like in the code, with oneself too, there are best practices, they are needed to look back and live in harmony with oneself. In my case, WordCamp after WordCamp, I added one more brick to my self-esteem and I understood something more about my shyness.</p>\n\n\n\n<p>In the end, living the WordPress community, getting to know many different people guided me towards rediscovering myself until I realized that I had never left my island, maybe it was the city&#8217;s fog that made me perceive it as farther away, it had always been here. The sea has never been a limit, now that I know the way, I can cross it whenever I want. My island was me and now I&#8217;ve learned to accept it.</p>\n\n\n\n<p>Yes, I&#8217;d say I did well to use the dark editor! Let&#8217;s contribute!</p>\n\n\n\n<h1 class=\"wp-block-heading\" id=\"italian\">Quella volta che sono uscito dalla mia isola</h1>\n\n\n\n<p>Perfetto, ho il mio foglio bianco, gli appunti su quello che devo esprimere e sono pronto a scrivere questo saggio. Ho il mio caffè caldo sulla scrivania e la mia compilation di Bob Dylan alle orecchie, ma siamo alla decima canzone e non ho ancora scritto una parola, anzi, ne ho scritte e poi cancellate tante. Sai che succede? Non sono uno scrittore, passo la mia vita in PHP, perché dovrei estraniarmi completamente da ciò che è la mia quotidianità? Ok, ci sono! Apro il mio editor di codice, il caffè e Dylan a quest&#8217;ora sono una costante, vediamo se ora le parole escono.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-la-mia-isola\">La mia isola</h2>\n\n\n\n<p>Sono sardo, vengo da un’isola del mediterraneo invidiata per il mare, il clima, il cibo ed il cuore delle persone. Parliamo di un isola, e il mare a volte è un limite, è un bellissimo muro blu che ti separa dal resto del mondo, spesso si ha la difficoltà di sentirsi italiani, figurati europei.</p>\n\n\n\n<p>La mia storia inizia qua, con una forte introversione che orchestrava la mia vita, la passione per l&#8217;informatica, il PHP che da circa 5 anni mi accompagnava e qualche piccolo tentativo di superare la mia timidezza. Senza dimenticare gli anni di studio dell&#8217;inglese a scuola, che sono rimasti teorici e mai messi in pratica. Per aiutarmi a sconfiggere la timidezza avevo iniziato a fare lo speaker in piccoli eventi sul Software Libero e qualche piccolo miglioramento c&#8217;era stato. Intanto iniziavo a conoscere un CMS chiamato WordPress richiesto da diverse aziende, in quel periodo non sapevo quello che mi avrebbe dato.</p>\n\n\n\n<p>Avevo lasciato il mio paesino e trasferito a Cagliari, la città, nella mia isola e davanti al mare. Pensate, in 10 minuti con i mezzi cittadini ero nella spiaggia più vicina e in 30 minuti ero in quelle spiagge che si vedono nei screensaver. Mi sentivo nel mio posto, almeno geograficamente. Ma un&#8217;isola a volte, non ti offre tantissimo da un punto di vista lavorativo e il lavoro da remoto non era ancora così diffuso. Ma il mio trasferimento a Cagliari era solo un primo passo, come quando metti il piede in acqua per sapere se è fredda, prima di prendere la rincorsa e tuffarsi.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-cambiamo-canzone-ma-anche-citta-e-vita\">Cambiamo canzone, ma anche città e vita</h2>\n\n\n\n<p>Avevo riempito le valigie, preso un volo e cambiato regione per seguire un lavoro. Lasciavo il luogo che De Andrè, un famoso cantautore italiano, descriveva: “La vita in Sardegna è forse la migliore che un uomo possa augurarsi: ventiquattromila chilometri di foreste, di campagne, di coste immerse in un mare miracoloso dovrebbero coincidere con quello che io consiglierei al buon Dio di regalarci come Paradiso” e arrivavo in quella che un altro famoso cantante italiano, Ligabue, descrive come “Questa città è un inferno travestito da paradiso, dove ogni sogno è a rischio di bruciarsi&#8221;.</p>\n\n\n\n<p>La città mi ha chiamato, ed ora sono qua. Ci sono proposte, ci sono occasioni, ci sono speranze e ci sono sogni e tutte a portata di mano, la mia mano. La città è pronta a darmi tutto ma ha bisogno di me, del mio tempo e del mio duro lavoro. Dovevo solo cambiare, l’isola doveva diventare città, la timidezza deve sparire qua e cambiare passo. Camminare seguendo quel ritmo frenetico, che non capivo, ma che era pronto a darmi sempre di più.</p>\n\n\n\n<p>Se cammini veloce, in un posto che non conosci, rischi di imbatterti in una strada che non conosci e potresti trovarti in una situazione che mai vorresti rivivere. Potresti camminare sull’asfalto, sul marciapiede o su un prato, e se non si sta attenti è facile inciampare su qualcosa e da un attacco di panico non sempre è facile rialzarsi, da due peggio.</p>\n\n\n\n<p>Nello stesso periodo mi sono ritrovato su un progetto basato su WordPress abbastanza intenso e tra un controllo e l&#8217;altro mi è caduto l’occhio su una tipologia di evento, che non conoscevo, chiamato WordCamp Torino a poco più di un ora di treno da dove stavo.&nbsp;</p>\n\n\n\n<p>Sveglia presto, caffè e di corsa in stazione, il treno parte e pian piano la città si allontana. Partecipo ad un giorno di contributor day e ad una giornata di talk. Un bel evento, preso migliaia di appunti ma vissuto come solo la mia timidezza mi permetteva di essere.&nbsp;</p>\n\n\n\n<p>Sapevo che questo evento era molto più bello di quello che avevo vissuto, quindi inizio a prestare sempre più attenzione a quella parte del sito sino a che non trovai due biglietti, Zurigo e Verona. Il biglietto di Verona lo presi subito, ma Zurigo era due settimane prima e la scelta non era così facile.&nbsp;</p>\n\n\n\n<p>Zurigo fa parte della Svizzera tedesca, ok che il WordCamp era organizzato in due lingue, ma il mio inglese era rimasto fermo da quasi 12 anni, in più era un viaggio da fare da solo.</p>\n\n\n\n<p>Verona fu un ottimo WordCamp, iniziai a capire il funzionamento di questi eventi e conoscere alcuni componenti dei MeetUp della città.</p>\n\n\n\n<p>Zurigo sinceramente lo ricordo sempre meno, è stato un bellissimo WordCamp, ma ho imparato lì più cose su me stesso che su WordPress. Mi chiedo solamente se ci sono svizzeri che credono che il mio cognome sia “sorry my English is terrible”, perchè quando sono un po’ nervoso, parlo più veloce e per presentarmi dicevo “My name is Matteo sorry my English is terrible, nice to meet you”. La cosa che ricordo meglio è che ho compilato la domanda per fare da speaker e volontario durante il viaggio di ritorno.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-parliamo-di-wordcamp-milano\">Parliamo di WordCamp Milano.</h2>\n\n\n\n<p>Ma è solo uno strumento, come può fare tutto questo?</p>\n\n\n\n<p>Preparo le mie slide, confrontavo lo sviluppo su WordPress con un altro CMS, partendo da quest’ultimo. Finito il primo pezzo dovevo parlare di WordPress, dovevo creare una slide di separazione, un po’ sarcasticamente scrissi “Ma siamo in un WordCamp quindi ajo a casa!”. Ajo è una parola molto usata in Sardegna, toglierla a un sardo è come impedire ad un romano di dire daje, è l&#8217;equivalente di un “let’s go” inglese.&nbsp;</p>\n\n\n\n<p>Non era la prima volta davanti ad un pubblico, ma ero abituato a un massimo di 20/30 persone, mi trovai davanti una classe universitaria con tantissime persone, ero emozionatissimo e super teso. Ma al mio momento del “ajo”, tra qualche risata e qualche sorriso mi sentii nuovamente a casa, nella mia isola ma allo stesso tempo a Milano, che strana emozione.&nbsp;</p>\n\n\n\n<p>Ma si tratta di un CMS, uno strumento di lavoro, come può fare tutto questo? Una domanda stupida se chi la fa ha nella sua libreria libri come “Rivoluzionario per caso” di Linus Torvald, “La cattedrale e il bazaar” di Eric Steven Raymond e “software libero, pensiero libero” di Richard Stallman. Quindi il termine “comunità” in quei testi era vero e WordPress era il miglior esempio in cui potevo capitare.</p>\n\n\n\n<p>Nel giro di pochi mesi, partecipai anche a Dublino e feci da volontario a Glasgow, l’inglese non era un mio limite, ma solo qualcosa su cui dovevo lavorare.&nbsp;</p>\n\n\n\n<p>Glasgow fu ad inizio 2020, l’ultimo ricordo di un WordCamp prima di un anno di chiusura, un anno in cui c&#8217;erano gli eventi online, ma l’energia era diversa. Un periodo in cui cambia due lavori.<br />Fu un periodo a metà tra la città e l’isola fino alla fine del 2021, quando vidi “WordCamp Ginevra”, proposi di raccontare la mia storia nei WordCamp, come mi aiutarono, ma lo fanno tutt’ora, sia con la sicurezza nella lingua che con la timidezza. Fu accettato e quello per me diventò sia il mio primo talk in inglese, ma anche quello non tecnico. Un talk che prevedeva un&#8217;intimità più alta mai sperimentata, che rimarrà per sempre un mio orgoglio.</p>\n\n\n\n<p>Da quel momento in poi, WordCamp dopo WordCamp, ogni tappa iniziò a regalarmi sempre più emozioni e sempre più lezioni, soprattutto su me stesso, ma non su come sono, ma su quello che potevo e volevo essere.&nbsp;</p>\n\n\n\n<p>Da WordCamp Italia in cui feci per la prima volta l’organizer a Torino e Verona da speaker.</p>\n\n\n\n<p>In tutti e tre decisi di partecipare entrambi i giorni, partecipando anche alle giornate di contribuzione e portandomi con piacere nel team polyglots, gruppo che non ho mai più abbandonato.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-verso-l-infinito-ed-oltre\">Verso l’infinito ed oltre</h2>\n\n\n\n<p>Poi annunciarono WordCamp Europe a Torino, la città dove tutto è iniziato, feci domanda come organizer, che fu accettata. Ora mi ritrovo a parlare con tantissime persone nuove in inglese quasi due volte alla settimana. Ogni volta è una sfida alla mia timidezza, ma ormai ho imparato ad accettarle.</p>\n\n\n\n<p>A volte mi capita di confrontare il mio primo ed ultimo WordCamp. Da un Contribution Day silenzioso ad uno in cui raccontavo la mia esperienza, solo attendee a speaker con tantissimi ascoltatori, da una giornata in silenzio a persona che cercava di far integrare i nuovi, da persona che rientra presto all’ultima persona che esce dall&#8217;after party.</p>\n\n\n\n<p>Ma WordPress è solo uno strumento, il fine è sempre un altro, nella mia storia non è un sito internet ma riuscire a capire una parte di me e smettere di soffocare la mia vera identità ed iniziare a comportarsi a modo mio. Facendomi capire che la mia parte isola non andava soffocata ma valorizzata, ero sempre io. Come nel codice, anche con se stessi, ci sono delle best practice, servono per riguardarsi e vivere in armonia con se stessi. Nel mio caso, WordCamp dopo WordCamp ho messo un mattoncino in più alla mia autostima e ho capito qualcosa in più sulla mia timidezza.</p>\n\n\n\n<p>Alla fine vivere la community di WordPress, conoscere tante persone diverse mi ha guidato verso la riscoperta di me stesso sino ad accorgermi che non avevo mai lasciato la mia isola, forse era la nebbia della città che me la faceva percepire più lontana, era sempre stata qui. Il mare non è mai stato un limite, ora che conosco la strada, posso attraversarlo tutte le volte che voglio. La mia isola ero io e ora ho imparato ad accettarlo.</p>\n\n\n\n<p>Si, direi che ho fatto bene ad usare l’editor scuro! Ajo a contribuire!</p>\n<p>The post <a href=\"https://heropress.com/essays/the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola/\">The Time I Left My Island &#8211; Quella volta che sono uscito dalla mia isola</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 07:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matteo Enna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WordPress.org blog: WP Briefing: Episode 76: A WordPress 6.5 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=17158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2024/04/episode-76-a-wordpress-6-5-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40474:\"<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.5 release, accompanied by special guest Dave Smith, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br />Guest:&nbsp;<a href=\"https://profiles.wordpress.org/mikachan/\">Dave Smith</a><br />Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a> and <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a><br />Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/download/\">WordPress Download</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/6-5/#:~:text=To%20get%20involved%20in%20WordPress,leave%20feedback%20on%20the%20ticket.\">WordPress 6.5 Development Cycle</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/07/unblocking-wp6-5-font-library-and-synced-pattern-overrides/\">Unblocking WP6.5 – Font Library and Synced Pattern Overrides</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-dataviews/\">Data Views</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/07/12/admin-design/\">WP-Admin Redesign</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/02/29/an-introduction-to-block-based-mega-menus/\">An Introduction to Block-Based Mega Menus</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/daveonwp\">Dave on WP</a>\n<ul>\n<li><a href=\"https://www.youtube.com/watch?v=ySyJRYAbU_M\">These TINY Link Editing CHANGES Just Made WORDPRESS 6.5 So Much Better</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2024/01/13/early-opportunities-to-test-wordpress-6-5/\">Opportunities to Test WordPress 6.5</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2024/03/08/asia-meetup-revival-project-2024/\" target=\"_blank\" rel=\"noreferrer noopener\">Asia Meetup Revival Project 2024</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\" target=\"_blank\" rel=\"noreferrer noopener\">Upcoming WordPress Meetings</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2024/03/20/making-a-wordpress-media-corps/\" target=\"_blank\" rel=\"noreferrer noopener\">Making a WordPress Media Corps</a></li>\n</ul>\n</li>\n\n\n\n<li>Have a question you’d like answered? Submit them to <a href=\"mailto:wpbriefing@WordPress.org\">WPBriefing@WordPress.org</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-17158\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go!&nbsp;</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> Dave, I&#8217;m so excited to have you here with us today. Welcome.</p>\n\n\n\n<p>[00:00:42] <strong>Dave:</strong> Thank you. I&#8217;m really excited to be here. Thank you so much for inviting me on.</p>\n\n\n\n<p>[00:00:46] <strong>Josepha:</strong> Yeah. So before we get much further, how about you tell us a little bit about what you do on the WordPress project? And if I recall correctly, that you have a role on the release squad. So just let us know a bit about what that role is and what that looks like.</p>\n\n\n\n<p>[00:01:00] <strong>Dave:</strong> Sure. Absolutely. Well, obviously said I&#8217;m Dave Smith. I&#8217;m from England in the United Kingdom, and I am full-time contributor to WordPress. I&#8217;ve focused primarily on the Block Editor during that time. And I&#8217;ve been doing it for about three years now. And fortunately for me, I am sponsored by Automattic, so that allows me to contribute full-time to the project, which is fantastic.</p>\n\n\n\n<p>But my history of WordPress goes back a fair way longer than that, and I used to work in agency land, and so I used WordPress for making things for a living before I worked in WordPress if you see what I mean.&nbsp;</p>\n\n\n\n<p>[00:01:35] <strong>Josepha:</strong> I, no, I definitely understand. I also was agency before WordPress.&nbsp;</p>\n\n\n\n<p>[00:01:40] <strong>Dave:</strong> I think it&#8217;s a common origin story, if you see what I mean. And yes, you&#8217;re absolutely right. I&#8217;ve been fortunate enough in this release, WordPress 6.5, to be the Co-editor Tech Lead. Obviously alongside my colleague which is Riad Benguella. Some of you may know him. He is the lead architect of Gutenberg. So yeah, it&#8217;s been fantastic to work alongside him.</p>\n\n\n\n<p>[00:02:00] <strong>Josepha:</strong> Yeah, excellent. One of these days, I&#8217;m going to get Riad on here. I think I&#8217;ve never had him on.</p>\n\n\n\n<p>[00:02:05] <strong>Dave:</strong> Oh, you should definitely.&nbsp;</p>\n\n\n\n<p>[00:02:06] <strong>Josepha:</strong> He&#8217;s so kind and reasonable. And I was just gonna tell a personal anecdote about Riad, and I don&#8217;t know that it makes any sense, but I&#8217;m gonna do it anyway. I&#8217;m gonna do it anyway. I saw him at an event like right after he came back from his most recent sabbatical, and he was like, it was great being away, but also like, I had forgotten what kind of energy events like this really bring in.</p>\n\n\n\n<p>And he has always struck me as an introvert, but I think maybe he&#8217;s like an outgoing introvert or something. Cause normally, like, introvert introverts are not like, this gives me so much energy. They&#8217;re like, I know that this is important work, and I&#8217;m here. And so that&#8217;s my personal anecdote about Riad, I am, gonna get him on here someday, but be that as it may, we&#8217;re delighted to have you.</p>\n\n\n\n<p>So, 6.5 is coming out are you excited, number one?</p>\n\n\n\n<p>[00:02:54] <strong>Dave:</strong> I am very excited. Yeah, it&#8217;s been a long road into this release. As you may know, well, as you do know, it&#8217;s, it was delayed by one week. That was actually, I think was, was a good decision. We&#8217;ve had a lot of work needing to go into the Font Library feature. I&#8217;ve seen a few posts saying there were bugs.</p>\n\n\n\n<p>[00:03:09] <strong>Dave:</strong> I think mainly it was a decision about where to upload fonts to, which seems quite amazing when you think about it. I was talking to my wife about it the other day, and she said, really, you&#8217;re delaying a release because of where to upload things. But, yeah, this is software that runs a considerable part of the web.</p>\n\n\n\n<p>So when we make these decisions about where things uploaded, we&#8217;ve got to be really confident that they are the right decisions. And so, yeah, that decision to delay the release has been good. And we&#8217;ve had an opportunity to make sure the release is fully robust and ready to go out. So yeah, I&#8217;m super excited to see it land.</p>\n\n\n\n<p>[00:03:40] <strong>Josepha:</strong> Yeah. I have some follow up questions about just like, how doing all of that work in public feels. But probably, we should get through the bulk of the sorts of things that people tune into this episode for, so like, let&#8217;s talk about some of the big features that are going into 6.5 so that folks have a sense for that.</p>\n\n\n\n<p>And then we&#8217;ll take a look at just like things that you&#8217;re excited to get in, things that I&#8217;m excited to get in. And maybe like if there&#8217;s a hidden surprise for users, things that will be really beneficial to users, but they don&#8217;t quite see it yet. We can maybe cover that too, but like, what are the big things going into this release from your perspective?</p>\n\n\n\n<p>[00:04:17] <strong>Dave:</strong> Sure. There&#8217;s some highlights, I think that the key highlights, and we should probably cover them. So the first one we&#8217;ve already touched on it is the Fonts Library. And this has been brewing for a while now, and it&#8217;s finally come to fruition. And it basically allows you to manage, install, and upload custom fonts for use on your website. And it&#8217;s really, really powerful. It&#8217;s, I think it&#8217;s going to really change the way people create themes and create their websites. It is unlocking a lot of power for users.</p>\n\n\n\n<p>[00:04:46] <strong>Josepha:</strong> And for folks who&#8217;ve been listening to this podcast for a long time, you have heard me say for, I think, like a year, basically every release podcast where we&#8217;re looking at what&#8217;s coming up. I&#8217;m like, and this time it&#8217;s fonts. I&#8217;m so excited. And so I&#8217;m saying it again this time, &#8217;cause it&#8217;s really happening this time.</p>\n\n\n\n<p>[00:05:03] <strong>Dave:</strong> It&#8217;s finally here. Yeah, it&#8217;s a great feature. There&#8217;s a lot of work gone into it. It&#8217;s really, really good.</p>\n\n\n\n<p>[00:05:07] <strong>Josepha:</strong> So much work. We&#8217;ve been working on it for like two or three years. And it&#8217;s at the point where like getting it out in front of people is the only way to figure out where the remaining problems will be. And it is the most scary part of any software release, I assume, the things where you&#8217;re like, this is time for people to tell us how it&#8217;s broken. Please look at it and break it for a while.</p>\n\n\n\n<p>[00:05:29] <strong>Dave:</strong> Yeah, absolutely. We&#8217;ve been working on resolving any bugs that we could find, but there&#8217;s always going to be things we haven&#8217;t noticed. So yeah, we can&#8217;t wait for users to get their hands on it. Exactly. Other than fonts, we&#8217;ve also got revisions that are now in place in the Site Editor. And this is more than just undo, redo that people may be already familiar with in the editor.</p>\n\n\n\n<p>It actually gives you the ability to fully revert your site back to any state that you previously had it. So you could make some changes in the editor. You could completely close down your computer, go away for a week, come back. And you&#8217;ve still got the opportunity to say, &#8220;Ah, do you know what? I don&#8217;t like the way that looks. I&#8217;m just gonna; I&#8217;m gonna roll that back.&#8221; And there&#8217;s a nice UI that shows you what it will affect. And you can even roll back styles, you know, like style changes. So it&#8217;s, it&#8217;s super, super powerful. And it&#8217;s just something we&#8217;ve been waiting for for such a long time. Just, it&#8217;s fantastic to see it land.</p>\n\n\n\n<p>[00:06:17] <strong>Josepha:</strong> I&#8217;m really excited about this one personally because I have been to so many meetup events with like new users being taught how to do things with WordPress. And invariably, in the last two or three years, the people who are presenting to new users are saying consistently like, &#8220;You can do any experimental thing that you feel like you need to do with your sites because there&#8217;s an undo button. WordPress wouldn&#8217;t let you do things that fully break your site.&#8221;</p>\n\n\n\n<p>Like there is a lot of trust in our kind of like time machine, roll-it-back kind of implementations. And so I&#8217;m really excited about this one. I think that for all of our new and mid-level users. Who like, have a little bit of fear, but mostly joy around it. Like, this will only increase that and so I&#8217;m super excited for this one to go in there.</p>\n\n\n\n<p>[00:07:09] <strong>Dave:</strong> Yeah, it&#8217;s really nice. Other than that, the two things I wanted to touch on as well, which is we&#8217;ve got these new views now for key objects in WordPress. So things like pages, patterns, templates, and template parts in the Site Editor. You can now view these in a sort of a table layout or in a grid layout. So it gives you a much easier way to sort them, find them, filter them. And I think it points us forward to the possibilities we&#8217;ve got in the future for the editor sort of taking some parts of WP Admin and making them more accessible without having to leave the Site Editor. And it&#8217;s extremely powerful; you can search in real-time, find things very, very quickly, do all the things you&#8217;re used to from the post listing screen, but all within the Site Editor. And it&#8217;s for these key objects that you use quite a lot of the time. So I think it&#8217;s going to be really, a really great thing for users to get hold of.</p>\n\n\n\n<p>[00:07:55] <strong>Josepha:</strong> Is this related to the Data Views work that we&#8217;ve been doing in the first part of the year here?</p>\n\n\n\n<p>[00:08:00] <strong>Dave:</strong> Exactly that exactly. The Data Views work has been a major feed into this, and this is where we see the fruits of all that work coming to the fore for the first time. And I expect to see more of that in future releases as well.</p>\n\n\n\n<p>[00:08:12] <strong>Josepha:</strong> Yeah. For folks who are really, really watching, like, our administrative side of things, you probably are aware that we, I don&#8217;t know, I wouldn&#8217;t say that we paused the phase three roadmap for this, but I do think that we made a clear choice to get this Data Views work done first so that we could, in parallel with phase three, do a bit of work on the WP Admin redesign, the dashboard redesign, which we all know, like, we love this dashboard, but also this dashboard, it needs a sprucing up, it needs a little bit of, of polish and a little bit of 2024 style I was going to say design. I don&#8217;t know if the design folks would love if I just was like, it needs to be modernized that way, but also like it, it does, right?</p>\n\n\n\n<p>[00:09:00] <strong>Dave:</strong> Yeah, and I mean, you know, we all know that the Site Editor is being used more and more. If you&#8217;ve got a Block theme, you&#8217;re using the Site Editor increasingly, and you&#8217;re spending less and less time sort of going between screens in WP Admin. So it makes sense that, you know, these things are accessible within that one interface of the Site Editor. So, yeah, it&#8217;s only going to be a good thing for users going forward.</p>\n\n\n\n<p>[00:09:20] <strong>Josepha:</strong> Yeah, absolutely. I probably should have like a whole episode about Data Views and what it&#8217;s intending to do, what it&#8217;s actually doing, what it&#8217;s going to look like as it goes because that&#8217;s such a big project. And so many things rely on it. And so, note to self and all listeners, that&#8217;s the thing that you should keep an eye out for. We&#8217;re going to get it done. But you said you had a final thing also.</p>\n\n\n\n<p>[00:09:40] <strong>Dave:</strong> Yeah, I&#8217;ve got one more which is this is for our users of classic themes. We haven&#8217;t forgotten about you. Basically, we now have support for appearance tools. So in prior releases, the Block themes have got these really cool design tools like ability to set border colors, border radius, link colors, you name it. We&#8217;ve got all these tools, but they haven&#8217;t been always available to classic themes. And classic themes can use the Block Editor; they may not be using the Site Editor in the same way, but they can use the Block Editor. And we&#8217;ve not made those things available in the same way, but there&#8217;s been work going into this release to allow that to happen.</p>\n\n\n\n<p>[00:10:11] <strong>Dave:</strong> So now you can opt into those if you so wish. And it is an opt-in basis. So none your themes will break out of the box if you&#8217;ve got classic theme or classic site. But it is a powerful tool to those people who are using classic themes, and that&#8217;s completely legitimate.</p>\n\n\n\n<p>[00:10:26] <strong>Josepha:</strong> And so is the opt in like something that you can do for yourself or something that your developer needs to do?</p>\n\n\n\n<p>[00:10:32] <strong>Dave:</strong> You would need to do it in your theme code. So you&#8217;d need to do that with PHP. So, your theme developer, if they choose to update their theme and provide support for these things. Then, they would obviously need to test their theme works with those new tools, make sure it&#8217;s ready, and then they would ship that update.</p>\n\n\n\n<p>And so maybe after 6.5 is released, you may see some themes incrementally adding support. My understanding at the moment is that the core themes, the Block themes, will not automatically add those straight away. I think they need more time to allow them to bed in and more time to get them ready for prime time if you see what I mean, but you know the fact that they&#8217;re there and ready means that the wider theme audience and theme developers can start taking advantage of them.</p>\n\n\n\n<p>[00:11:15] <strong>Josepha:</strong> Nice, nice. I have been wondering lately, this is only marginally related, but I&#8217;m gonna wonder it out loud anyway. I&#8217;ve been wondering lately if like, our classic themes, our most favorite, our most loved classic themes do need a little bit of help moving into a Block theme future. And I think that this will help. I think, on the one hand this will help, and on the other hand, like, what would it take for us to just say, and you&#8217;re not the theme person I know, but like, what would it take for us to just say, &#8220;These are our top five most favorite, most used, classic themes that we&#8217;ve got in WordPress. Let&#8217;s rebuild it in blocks and just ship the block version of it and help the classic themes users that love the design, love the look, love the features get introduced to this new block territory so that they can see that not only do they have the look, the feel, the features, but also the flexibility that comes with that and a little bit more feeling of safety as they wander around modifying themes.&#8221;</p>\n\n\n\n<p>[00:12:18] <strong>Josepha:</strong> I have no fear of any code changes and didn&#8217;t when I started working with WordPress, as opposed to working in WordPress, but I think that that&#8217;s not the way that that works right now. Like there&#8217;s a whole lot of like, I need to get it right-ish with folks who are using our software. And so I just wonder if that will help everybody feel a little more confident in what they&#8217;re doing, knowing they&#8217;re not going to break things because we&#8217;ve built it so you can&#8217;t.</p>\n\n\n\n<p>[00:12:45] <strong>Dave:</strong> It could do, it could do. And I was just thinking as you were talking, like, do we have any themes that already do that? And, of course, we do have 2021. If you can think back that far into the mists of time, we had 2021 classic, which is that it&#8217;s called 2021, but we also 2021 blocks, which is doing very much what you&#8217;ve just described.</p>\n\n\n\n<p>[00:13:03] <strong>Dave:</strong> So we haven&#8217;t pursued that for the new default themes or block themes, but, you know, it might be something to look at for onboarding if there are any of classic themes from the more distant past, you know, maybe some of those could do with a block theme equivalent just to let people on board to that experience and just feel comfortable. Yeah, interesting, interesting. You should definitely talk to the theme people about that.</p>\n\n\n\n<p>[00:13:23] <strong>Josepha:</strong> I&#8217;m going to. They&#8217;re going to love it. They&#8217;re going to be like, Yay! Of course! Of course! I don&#8217;t know, actually. I don&#8217;t know if anyone ever loves the things that I suggest, but that doesn&#8217;t mean that they&#8217;re not going to get suggested. I have all these ideas, and they got to come out somewhere. Okay. So do you have something that you worked on that&#8217;s not in this big list of features or that you helped people to really shepherd into the release that you think is really cool? Like, maybe it&#8217;s not going to be super visible or something, but like that you&#8217;ve personally felt was like a cool feature, excited for it to get into the release.</p>\n\n\n\n<p>[00:13:53] <strong>Dave:</strong> Yeah, there are a couple of things, a couple of things at the top of mind. One of them is user-facing and one of them is more developer-facing features. So, I&#8217;ll start with the developer feature first. And this one is a change to an API. Now, that API is always a slightly intimidating word, I think, but it just means a set of tools, a standardized set of tools that developers can use to do something. And in this case, it&#8217;s the allowed blocks API. </p>\n\n\n\n<p>[00:14:20] <strong>Josepha:</strong> Sounds so fun.&nbsp;</p>\n\n\n\n<p>[00:14:21] <strong>Dave:</strong> Yeah, I know it&#8217;s riveting, isn&#8217;t it? But trust me, it does come with some benefits. So the Navigation block is a good example. It&#8217;s a block that acts as a container and it&#8217;s got child blocks. Okay. But you can only insert certain blocks. You can insert links, you can insert social icons, you can insert search. But if you want to insert, I don&#8217;t know, an Icon block, for example. You can&#8217;t do that, but you can with WordPress 6.5 because of the change to the allow box API. And what it allows you to do is say, &#8220;I want to additionally allow the following blocks to be inserted as well.&#8221;</p>\n\n\n\n<p>So as a developer, you can hook into this filter and change those blocks. Now, okay, so far, so good. &#8220;What&#8217;s the big deal?&#8221; you might say, well, it&#8217;s open the door, is open the door to some very, very interesting explorations. Some of which I&#8217;ve no doubt that you and your listeners would have already encountered. And one is by a colleague of mine called Nick Diego. And I think it&#8217;s on the WordPress Developer blog right now. I think he&#8217;s done a fantastic inspiration into mega menus in the navigation block. I&#8217;m someone who&#8217;s worked on the Navigation block extensively in the past, and I&#8217;m very aware of how much users want mega menus to be a part of the Navigation block.</p>\n\n\n\n<p>[00:15:30] <strong>Dave:</strong> I was never convinced it was going to be something we were going to do in core, because it requires so many different things. But Nick has actually managed with this allow blocks API and some other tweaks as well to build a mega menu as a plugin for WordPress using the standard Navigation block.</p>\n\n\n\n<p>And I think that&#8217;s just one example of the utility of this API. But for example, I mentioned that you could add icons to your Navigation block and you can&#8217;t really do that at the moment. It&#8217;s pretty powerful. It&#8217;s kind of hidden away. It&#8217;s in the release notes, but it&#8217;s not massively clear, but it does open some pretty big doors. And I think if you&#8217;re a developer or a theme author, indeed, you should you should definitely be looking into that and see what it enables for you.</p>\n\n\n\n<p>[00:16:06] <strong>Josepha:</strong> Yeah, we&#8217;ll put a link to Nick&#8217;s post in the show notes, and we&#8217;ll share it around the social spaces. So like, I hear you saying it&#8217;s buried, it&#8217;s hard to see, it won&#8217;t necessarily be exciting now, but will be exciting later, but like mega menus and sliders, those are the most contested things that people want to put on sites all the time. Like from my agency days, like when I was thinking in the mindset of a strategist, a data person, that&#8217;s what I was doing. Like, I never wanted sliders. I never wanted mega menus because it just implied that we didn&#8217;t have a decision about the sites we were making, like we had not decided the primary purpose, and also it was just hard to track, but it was always literally every single time people are like well if Amazon has it why can&#8217;t we have it? You&#8217;re like, yeah, I know, but they&#8217;re Amazon. They&#8217;re not the same like mega menus sliders. I know that from a project perspective that we&#8217;re like, that should be a theme thing. That should be in theme territory. But I think it makes sense to have in core because so many people want to be able to do it.</p>\n\n\n\n<p>[00:17:14] <strong>Josepha:</strong> And just because like someone like me feels like it&#8217;s not the right call for your business doesn&#8217;t mean that you shouldn&#8217;t be able to make that decision for yourself, you know, I think that&#8217;s a, I think that&#8217;s a great, a great feature to call out.</p>\n\n\n\n<p>[00:17:28] <strong>Dave:</strong> Yeah, absolutely. I completely agree. I can look for my agency days. I can exactly imagine that sort of thing. We have a lot of people, a problem that a lot of people are facing. So it&#8217;s really important that we provide the tools to allow people to do that now. And we can always look at if it&#8217;s valid to include it in core later, then we can look at that as well.</p>\n\n\n\n<p>Yeah. So that&#8217;s, that&#8217;s the first one I had. The second one is a little bit more user-facing. I would say it&#8217;s hidden away. But I&#8217;m not 100 percent sure it is. I mean, Josepha, how often do you create links when you&#8217;re working with WordPress?</p>\n\n\n\n<p>[00:17:58] <strong>Josepha:</strong> Like every time that I&#8217;m in WordPress.</p>\n\n\n\n<p>[00:18:00] <strong>Dave:</strong> Yeah, exactly. Same here. I do it all the time, right? And a lot of people do. And for a long while, contributors to the editor have been sort of collecting and collating the feedback that&#8217;s come in from people about their frustrations with the built in link interface in the Block Editor. So if you&#8217;re creating a hyperlink to, you know, hyperlink to another page or, you know, you&#8217;re going to link to Nick&#8217;s mega menu article, you&#8217;re going to be doing that a lot, right?</p>\n\n\n\n<p>That&#8217;s something that people do when they&#8217;re creating content in WordPress. And so we worked a lot to refine that with a contributor who, who you may know, Rich Tabor. Who&#8217;s also, I think, on the release squad as well. An influencer in the WordPress space as well. He spent a lot of time looking at the UX and myself and a number of other contributors have spent a lot of time in this release refining that. And I think it&#8217;s surprisingly difficult to get right, but I think we&#8217;ve, I think we&#8217;ve made some nice improvements to that will be nice quality of life for people who, to do this sort of content creation quite a lot.</p>\n\n\n\n<p>So there&#8217;s things like now when you create the link for the first time, it remains open on the initial creation of the link. So that means you can quickly then easily adjust the link. I mean, it seems obvious, doesn&#8217;t it? Yeah, but it&#8217;s not happening. It just used to just automatically close, and the people are like, &#8220;Hey, I wanted to make more adjustments. &#8220;</p>\n\n\n\n<p>[00:19:08] <strong>Josepha:</strong> I wasn&#8217;t done yet.&nbsp;</p>\n\n\n\n<p>[00:19:10] <strong>Dave:</strong> Exactly. Yeah, exactly. We&#8217;ve, we&#8217;ve streamlined the UI. We&#8217;ve removed a lot of clutter, but we&#8217;ve also added some useful tools, like ability to copy a link and remove the link directly from the control itself. And lastly along with lots of other accessibility changes in this release. We have worked a lot on refining the implementation.</p>\n\n\n\n<p>So that is discoverable for, for users of assistive tech because we spent a lot of time talking to core accessibility team and other people, and they were finding it very hard to perceive that the UI was there because of the way that keyboard interactions work and you&#8217;ve got the block toolbar in the way and things like that.</p>\n\n\n\n<p>We think we&#8217;ve nailed on a really good solution now that works for, not only uses assistive tech, but actually provides benefits for sighted users as well. It&#8217;s kind of difficult to talk about. I mean, I have got a video covering this on my YouTube channel, which kind of shows it in a bit more detail, but we&#8217;re happy it&#8217;s in a much better place.</p>\n\n\n\n<p>[00:20:02] <strong>Dave:</strong> And yeah if people have got feedback about it, and when, when 6.5 comes out, we&#8217;re always happy to hear that. And you can go to the WordPress GitHub repository and raise an issue. And one of us will jump on it and see what we can do.</p>\n\n\n\n<p>[00:20:13] <strong>Josepha:</strong> And we can include a link to that video also. So like, for folks where this sounded intriguing, but they don&#8217;t quite get the concept, like video content all day, let&#8217;s pop it into our show notes. And everybody can take a look at it there. I think that&#8217;s a great idea.</p>\n\n\n\n<p>[00:20:28] <strong>Dave:</strong> Great. Yeah, I appreciate that.</p>\n\n\n\n<p>[00:20:30] <strong>Josepha:</strong> So final question, maybe, maybe final question, final planned question. Is there anything from a user-facing perspective again that you feel has not really gotten the airtime that it needs so far?&nbsp;</p>\n\n\n\n<p>[00:20:44] <strong>Dave:</strong> I think there&#8217;s a lot of technical changes that have happened in this release. So it&#8217;s easy to look at those. I mean, we&#8217;ve covered quite a lot of the key ones that will be user-facing in terms of Font Library and Revisions. We&#8217;ve got things that are going to this release that enable things a lot for people to experience in the future, I think, so underlying changes like the Interactivity API becoming public. Now that&#8217;s public, plugin developers can start to make sites much more interactive on the front of the site rather than just in the editor. So I think that once 6.5 has gone in, and people have started to explore the Interactivity API in more detail, we might see more plugins offering sort of interactivity on the fronts of their sites. An example is obviously the lightbox you&#8217;ve got with images in core, but I can; there&#8217;s way more stuff that you can do with that. So we&#8217;re going to see more of that. </p>\n\n\n\n<p>[00:21:28] <strong>Dave:</strong> We&#8217;ve got Block Hooks that have landed in 6.5, and this is going to open for things like ecommerce plugins and to be able to add, you know, cart blocks or log in, log out blocks to things like navigation, for example, or you might want a ability to like all your comments, and you can do that with Block Hooks and then a plugin developer can just, you know, when the plugin is enabled, they can just make it so that those things just appear on your site, but you still got control over the design.</p>\n\n\n\n<p>So there&#8217;s a lot of like hidden things I think are going to uncover new features for users over time as a result of the community getting involved and changing their plugins and themes to do these take advantage of these new tools.&nbsp;</p>\n\n\n\n<p>[00:22:07] <strong>Josepha:</strong> Yeah, so the Interactivity API, obviously it has &#8220;API&#8221; on it. And so no one&#8217;s thinking, well, this is a user-facing thing. And while the API is not a user facing thing, like, I think that you&#8217;re right. That what it enables absolutely is going to be really useful and hopefully really engaging for like end-to-end users, like the users that are not listening to this podcast and they don&#8217;t know we exist, like they don&#8217;t know that WordPress has a community building it, they&#8217;re just like, it exists, there&#8217;s a software that came out of nowhere, like, I&#8217;m really excited to see how our developers in the community start to use that in their plugins and themes and get that out to end users. I&#8217;m really, really excited to see how creative they get with it.</p>\n\n\n\n<p>Did you have a final thing?</p>\n\n\n\n<p>[00:22:51] <strong>Dave:</strong> There&#8217;s a lot of design changes, I think. I mean, we can&#8217;t cover them all, obviously, in verbal form in this podcast, but some things that are just standing out to me if we look at the source of truth for, for WordPress 6.5, it is, it is big. There&#8217;s a lot in this release. But there&#8217;s some very cool things for, I don&#8217;t know, quality. I like to see them as like quality of life design design changes. Things like, if you drop an image, as a background image of a cover block, it automatically sets the overlay color for that cover block to match the most prominent color of the background image. Like things like that, they seem small, but over time, they just, you just drop that thing, and it just does it. And it&#8217;s like, this is nice. And it feels like a nice tool to use that just is intuitive. And I think there&#8217;s, we&#8217;ll see a lot of those things landing in this release that can just make the experience of working with WordPress and working in the Site Editor much, much nicer.</p>\n\n\n\n<p>[00:23:41] <strong>Josepha:</strong> Yeah. I remember when I first ran into that particular thing, it was on the Showcase, our most recent redesign of it. We&#8217;re using that functionality in there before it was available in core. Obviously, I know, but it was really fascinating. I&#8217;m not great with color combinations. Like, I don&#8217;t have a sense for, like, oh, that&#8217;s the primary thing. That&#8217;s not. And so having that being done kind of automatically so that my stuff looks good anyway, despite what my color sense said to do or not. I thought it was great. Makes you look good as somebody who&#8217;s running a business. You don&#8217;t have to know how things work in order to have excellently functional, really beautiful things.</p>\n\n\n\n<p>[00:24:21] <strong>Josepha:</strong> And I think that&#8217;s a great thing about all of our releases. Obviously, everything is supposed to work that way, but like this one has a lot of really cool things like that available. I think those are really the questions that I had. Is there anything you want to make sure to share before we kind of give last thoughts and head out?</p>\n\n\n\n<p>[00:24:39] <strong>Dave:</strong> Yeah, I was, I was thinking a lot about, you know, the community we&#8217;ve got with WordPress, and I think that people outside of WordPress may not really understand that how amazing this community is that we&#8217;ve got here, but I wanted to say to people like don&#8217;t shy away from contributing to WordPress. I get that, you know, people like myself are fortunate enough to be sponsored to do it. But there&#8217;s always something that people can do, even if that&#8217;s just spending like 30 minutes testing a release or donating some of your time to run one of the meetings. It can really make a difference overall. Even just filing a bug report for something you see in WordPress 6.5 or testing 6.5 before it goes out, those little things do make a big difference. And if you&#8217;re not sure where to go, then we can signpost you with links, no doubt in this, in the podcast description with where where&#8217;s to go. But yeah, I just want to encourage people to get involved, basically.</p>\n\n\n\n<p>[00:25:27] <strong>Josepha:</strong> Yeah. And it&#8217;s all working out in public, like we&#8217;ve got developers, designers, marketing folks, community folks like all doing this work out where everybody can see it. And so that, I know, can look really kind of overwhelming. But I want to just highlight, like, you don&#8217;t have to know everything about what&#8217;s happening in the project in order to get involved in the project. Like every small bit of contribution toward like finding a new bug or confirming that a bug happens across other devices, other setups, things like that, like those all help make things better and keep things moving as quickly as we are able to make them move. And so, yeah, I&#8217;ll second that every little thing that you think like that won&#8217;t make a difference. It does. We can&#8217;t tell that things are broken or things are working or things are in need of some care unless you highlight those for us. And this is the best way to do it is to show up and give 30 minutes to send out a group testing invite to your meetup group or whatever it is that you all have been thinking you should do, like, this is your sign. You can do it.</p>\n\n\n\n<p>[00:26:34] <strong>Dave:</strong> Everyone should get involved if they can.</p>\n\n\n\n<p>[00:26:37] <strong>Josepha:</strong> I agree. I agree. Dave, this has been such an excellent conversation. Thank you so much for joining me today.</p>\n\n\n\n<p>[00:26:42] <strong>Dave:</strong> Oh, thank you very much. It&#8217;s a pleasure.</p>\n\n\n\n<p>[00:26:43] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:26:49] <strong>Josepha:</strong> What an interesting release we&#8217;ve got coming out this week. I&#8217;m so glad you all made it this far in the pod, and now it&#8217;s time for our small list of big things.</p>\n\n\n\n<p>[00:27:00] <strong>Josepha:</strong> First up, following up on the WordPress meetup reactivation project that we had in 2022, we aim to revive some meetup groups in big cities that are inactive or help the local WordPress community that are not yet part of our meetup chapter program to join our program. There is a post out on the community P2 on the community site. That is titled Asia Meetup Revival Project 2024. I&#8217;ll leave a link to that in the show notes if you want to read more about that and figure out how to get involved.</p>\n\n\n\n<p>And speaking of getting involved, we have roughly a million meetings. Because it&#8217;s a new month, we&#8217;re in April now. New month, new opportunities. There are a lot of things happening in April. We will be coming out of a major release, obviously, and so there will be some minor release follow up to do. There will be a lot of discussion about what&#8217;s coming next, what&#8217;s in trunk, what&#8217;s not in trunk. But also a lot of work being done around our next big major events, our next big major training initiatives. There&#8217;s just so much happening. Spring is a time when we are looking at stuff that&#8217;s new, what we want to invest in, what we want to grow. And so if you have not attended one in a while or even at all if you&#8217;ve never attended a meeting in the community, then this is a great time to start and join your fellow community members trying to make WordPress better every day.</p>\n\n\n\n<p>[00:28:23] <strong>Josepha:</strong> And then the final thing on our small list of big things is I am looking at helping to shift the focus of our WordPress marketing community. We&#8217;ve had a bit of a struggle over the years to figure out what our primary focus and our primary impact can be. So there&#8217;s a post up called &#8216;Making a WordPress Media Corps&#8217;. It&#8217;s gotten quite a bit of attention, and I do really think that it has a lot of potential for solving some of the issues that we have and kind of getting some quick wins into our recent history of that team so that we can move forward confidently together. So pop on over, give it a read, share your thoughts. And if you are one of these qualified media partners, also let us know.&nbsp;</p>\n\n\n\n<p>[00:29:08] <strong>Josepha:</strong> That, my friends, is your small list of big things.</p>\n\n\n\n<p>Don&#8217;t forget to follow us on your favorite podcast app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever there&#8217;s a new episode. And if you liked what you heard today, share it with a fellow WordPresser, or if you had questions about what you heard, you can share those with me at WPBriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thank you for tuning in today for the WordPress Briefing, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:18:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress.org blog: WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2024/04/regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:65839:\"<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=1024%2C683&ssl=1\" alt=\"WordPress 6.5 \" />\n\n\n\n<p>Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&nbsp;</p>\n\n\n\n<p>Let the stunning twists and subtle turns of <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">Regina’s genre-bending sound</a> surprise you as you explore everything 6.5 offers.</p>\n\n\n\n<p>This latest version of WordPress puts more power into the details. It offers new and improved ways to fine-tune and enhance your site-building experience, letting you take control in ways that make it your own. You’ll find new ways to manage your site’s typography, more comprehensive revisions available in more places, and a collection of Site Editor updates paired with impressive performance gains to help you get things done smoother and faster.</p>\n\n\n\n<p>&#8220;Regina&#8221; also marks the introduction of some breakthrough developer tools that will start transforming how you use and extend blocks to craft engaging experiences. The Interactivity API opens up a world of creative front-end possibilities, while the Block Bindings API makes dynamic connections between blocks and data seamless. These, among other developer-focused improvements and updates, are ready to help you evolve how you build with WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s inside 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add and manage fonts across your site</h3>\n\n\n\n<p>The new Font Library puts you in control of an essential piece of your site’s design—typography—without coding or extra steps. Effortlessly install, remove, and activate local and Google Fonts across your site for any Block theme. The ability to include custom typography collections gives site creators and publishers more options when it comes to styling content.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17167\" />\n\n\n\n<h3 class=\"wp-block-heading\">Get more from your revisions—including revisions for templates and template parts</h3>\n\n\n\n<p>Work through creative projects with a more comprehensive picture of what’s been done—and what you can fall back on. Get details like time stamps, quick summaries, and a paginated list of all revisions. View revisions from the Style Book to see how changes impact every block. Revisions are also now available for templates and template parts.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17168\" />\n\n\n\n<h3 class=\"wp-block-heading\">Play with enhanced background and shadow tools</h3>\n\n\n\n<ul>\n<li>Control the size, repeat, and focal point options for background images in Group blocks so you can explore subtle or splashy ways to add visual interest to layouts.&nbsp;</li>\n\n\n\n<li>Set aspect ratios for Cover block images and easily add color overlays that automatically source color from your chosen image.&nbsp;</li>\n\n\n\n<li>Add box shadow support to more block types and create layouts with visual depth, or throw a little personality into your design.</li>\n</ul>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17169\" />\n\n\n\n<h3 class=\"wp-block-heading\">Discover new Data Views</h3>\n\n\n\n<p>Every piece of your site comes with a library of information and data—now, you can find what you need quickly and organize it however you like. Data views for pages, templates, patterns, and template parts let you see data in a table or grid view, with the option to toggle fields and make bulk changes.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17165\" />\n\n\n\n<h3 class=\"wp-block-heading\">Smoother drag-and-drop</h3>\n\n\n\n<p>Feel the difference when you move things around, with helpful visual cues like displaced items in List View or frictionless dragging to anywhere in your workspace—from beginning to end.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17170\" />\n\n\n\n<h3 class=\"wp-block-heading\">Improved link controls</h3>\n\n\n\n<p>Create and manage links easily with a more intuitive link-building experience, like a streamlined UI and a shortcut for copying links.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17171\" />\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s fresh for developers in 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Bring interactions to blocks with the Interactivity API</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API</a> offers developers a standardized method for building interactive front-end experiences with blocks. It simplifies the process, with fewer dependencies on external tooling, while maintaining optimal performance. Use it to create memorable user experiences, like fetching search results instantly or letting visitors interact with content in real time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks to custom fields or other dynamic content</h3>\n\n\n\n<p>Link core block attributes to custom fields and use the value of custom fields without creating custom blocks. Powered by the <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">Block Bindings API</a>, developers can extend this capability further to connect blocks to any dynamic content—even beyond custom fields. If there’s data stored elsewhere, easily point blocks to that new source with only a few lines of code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Add appearance tools to Classic themes</h3>\n\n\n\n<p>Give designers and creators using Classic themes access to an upgraded design experience. Opt in to support for spacing, border, typography, and color options, even without using theme.json. Once support is enabled, more tools will be automatically added as they become available.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore improvements to the plugin experience</h3>\n\n\n\n<p>There&#8217;s now an <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">easier way to manage plugin dependencies</a>. Plugin authors can supply a new <code>Requires Plugins</code> header with a comma-separated list of required plugin slugs, presenting users with links to install and activate those plugins first.</p>\n\n\n\n<h2 class=\"wp-block-heading\">From fast to faster: Performance updates</h2>\n\n\n\n<p>This release includes 110+ performance updates, resulting in an impressive increase in speed and efficiency across the Post Editor and Site Editor. Loading is over two times faster than in 6.4, with input processing speed up to five times faster than the previous release.</p>\n\n\n\n<p>&nbsp;Translated sites see up to 25% improvement in load time for this release courtesy of <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Additional performance highlights include <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">AVIF image support</a> and improvements for <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registering block variations with callbacks</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A tradition of inclusion</h2>\n\n\n\n<p>This release includes more than 65 accessibility improvements across the platform, making it more accessible than ever. It contains an important fix that unblocks access to the admin submenus for screen reader users and others who navigate by keyboard. This release also adds fixes to color contrast in admin focus states, positioning of elements, and cursor focus, among many others, that help improve the WordPress experience for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.5</h2>\n\n\n\n<p>Check out the new&nbsp;<a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 page</a>&nbsp;to learn more about the numerous enhancements and features of this release—including short demos of some of the highlighted features. </p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> for detailed technical information and <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">developer notes</a> to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> for developer updates, feature tutorials, and other helpful WordPress content from a developer perspective.</p>\n\n\n\n<p>For more information about installation, file changes, fixes, and other updates, read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">6.5 release notes</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.5 release squad</h2>\n\n\n\n<p>Every release has many moving parts with its own triumphs and challenges. It takes a dedicated team of enthusiastic contributors to help keep things on track and moving smoothly. 6.5 is made possible by a cross-functional group of contributors, always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Marketing and Communication Leads: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Performance Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Default Themes Leads: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratizing publishing and the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. Supporting this idea is a global and diverse community of people collaborating to strengthen the software.&nbsp;</p>\n\n\n\n<p>WordPress 6.5 reflects the countless efforts and passion of around 700 contributors in at least 57 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 2,500 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">70 locales have translated 90 percent</a> or more of WordPress 6.5 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved and contribute</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">One more haiku</h2>\n\n\n\n<p>6.5 is here!<br />Play, interact, build better,<br />Stronger and faster.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 18:42:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: Day Two Updates from the CloudFest Hackathon 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80779\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://dothewoo.io/day-two-updates-from-the-cloudfest-hackathon-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"A diverse group at the CloudFest Hackathon worked on innovative projects, from database integration to accessibility plugins, showcasing dedication and collaboration.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 09:25:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Gutenberg Times: Gutenberg Changelog #98 – WordPress 6.5, Gutenberg 18.0 Community Theme Project and the Contributor Mentorship Program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=28067\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44696:\"<p>In this episode, Maggie Cabrera and Birgit Pauli-Haack discuss WordPress 6.5, Gutenberg 18.0, Community Theme Project and the Contributor Mentorship Program.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Maggie Cabrera</h2>\n\n\n\n<ul>\n<li><a href=\"https://profiles.wordpress.org/onemaggie/\">WordPress profile</a></li>\n\n\n\n<li><a href=\"https://twitter.com/one_maggie\">Twitter @one_maggie</a></li>\n\n\n\n<li>GitHub <a href=\"https://github.com/MaggieCabrera\">MaggieCabrera</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">WordPress 6.5 release delayed 1 week</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\">WordPress 6.5 Release Candidate 4&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2024/02/16/contributor-mentorship-program-second-cohort-2024-q1/\">Announcing the Second Cohort (2024 Q1) of the WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/26/hallway-hangout-data-liberation-discussion-and-brainstorm/\">Hallway Hangout: Data Liberation Discussion and Brainstorm</a></li>\n\n\n\n<li>Recording: <a href=\"https://www.youtube.com/watch?v=ezPHiyhhaoQ\">Developer Hours: Exploring Block Hooks in WordPress 6.5</a></li>\n\n\n\n<li><strong>April 9, 2024, at 14:00 UTC</strong>: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300032710/\"><strong>Developer Hours: Building custom blocks with the Interactivity API</strong>.</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/community-themes\">Community Theme Project</a></li>\n</ul>\n\n\n\n<p><strong>Developer Blog updates</strong></p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2024/03/14/how-to-register-block-variations-with-php/\">How to register block variations with PHP</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/19/pattern-design-tips-and-tricks-for-developers/\">Pattern design tips and tricks for developers</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/21/drop-shadow-updates-in-wordpress-6-5/\">Drop Shadow updates in WordPress 6.5</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/25/exploring-the-block-hooks-api-in-wordpress-6-5/\">Exploring the Block Hooks API in WordPress 6.5</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/26/how-to-use-wordpress-react-components-for-plugin-pages/\">How to use WordPress React components for plugin pages</a></li>\n</ul>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">What’s new in Gutenberg 18.0? (27 March)</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.github.io/gutenberg/?path=/story/dataviews-dataviews--default\">Story Dataviews Component</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/design/2024/03/25/design-share-mar-11-mar-22/\">Design Share: Mar 11-Mar 22</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hello, and welcome to our 98th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about WordPress 6.5 briefly, Gutenberg 18.0, the community mentorship program, and some other things that are in the works. And I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and full-time Core contributor for the WordPress open-source project sponsored by Automattic&#8217;s Five for the Future Program. That is a mouthful, and we&#8217;re going to repeat it again. I am thrilled to have with me Maggie Cabrera, also Core contributor, also sponsored by Automattic. She was also the co-lead for the Twenty Twenty Four theme development, and she does so much more in the community as well, and we will talk about those things. Thank you for joining me on the show, Maggie. Welcome. How are you today?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Hi. Thanks for having me. I&#8217;m doing really good. How are you?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;m good, I&#8217;m good. I&#8217;m excited. Yeah, it&#8217;s kind of Easter weekend, and we get a few additional days.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Yeah, short week. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Short week, yes.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: I&#8217;m really excited to be here with you.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So we have a couple of announcements that we want to kind of let our listeners know, and so one is, although contributors work really hard, the release team decided to delay the release of WordPress 6.5 for a week to get some more bugs fixed that are gravely impacting the user experience, and make the change to the default fonts directory. There was a discussion back and forth, and there was in Core, on the Core blog, you can certainly read up about it. I think the most important information is that it releases on April 2nd, just after the Easter holidays in Europe, so&#8230;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Yeah, I think it wouldn&#8217;t have, the holidays here, it would&#8217;ve been just a two-day release delay, or something like that, but I think it makes sense to take it out a little longer, and make sure that everything&#8217;s ironed out, and the change with the forms directory, it&#8217;s been a constant discussion, but it feels like there&#8217;s a solid decision now, so that it feels like it&#8217;s,&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s a solid decision to get a release out, yes.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it wasn&#8217;t easy, apparently. Yeah, yeah, it wasn&#8217;t a clear solution there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. No, and it&#8217;s kind of architectural versus practical, and all those kinds of different aspects of it, yeah. Would host work with it? How plugin devices work with it, and how users will find it. So I think it&#8217;s a decision, and we will see how it works out when WordPress 6.5 kind of hits your WordPress instance next week.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There are a few community contributions that I wanted to point out. The developer blog, we had a great publishing two weeks on the developer blog. Sometimes, we barely get one post out a week, but this time, we had two posts per week, so that is really cool, and in a very broad spectrum. So the first one was how to register block variations of PHP, and I think it was one of the most-read posts on that, and what we saw on Twitter was also the comments was, &#8220;Oh, finally, something for PHP developers who are not that comfortable with JavaScript,&#8221; and I&#8217;m glad we kind of, yeah, picked them up as well. Yeah, and another one that was well-received was the pattern design tips and tricks for developers and designers.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Oh, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, by Beatriz Fialho.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Yes, I love that one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. She did an awesome job with the dos and don&#8217;ts, and kind of make it also visually very attractive.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes. I need to link that one to the Community Themes project, because it&#8217;s really relevant, so that&#8217;s really good that I have the link there for me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the Meta team asked me if we could add some of the dos and don&#8217;ts to the pattern directory guidelines as well, because that would probably also change a little bit how people kind of approach it. Well, you mentioned the Community Theme project. Do you want to tell me about it, or our listeners about it?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Theme Project</h3>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, sure. Absolutely. Yeah, the Community Themes project is this really small thing that it&#8217;s&#8230; I hope it will attract more new contributors to the WordPress project. So, basically, it started after contributing to some of the previous default themes, I think it was Twenty Twenty One or Twenty Twenty Two. It was such a good experience for me to work with the community, and all the contributors, all together on a default thing, that it felt really sad that it only lasted a few months, and after that development was done, everyone went their own ways, and that was it. So I felt shouldn&#8217;t we just keep making blog themes together, and keep this momentum going? And so yeah, we just opened a repo, and started building some community themes that, they are block themes. It&#8217;s like this space where you can get with other contributors with different degrees of experience that can help you build block themes following the best code practices, and learn how to do that together. Now, we are using that project to also onboard new contributors via the mentorship program, which I think you&#8217;re going to talk about in a bit. So the new contributors will join that repo and help build the themes with some other more-seasoned contributors helping them out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, so was it Twenty Twenty Two that had the call for style variations?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I think it was Twenty Twenty Three.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Twenty Twenty Three? Oh, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And that was the community project that you are kind of working on, where you had about 38 people submitting style variations, and made it into the default theme. So that was really cool, and it was also interesting to see how different designers approach it, yeah, and was it one or two themes that the Community Theme project released?&nbsp;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> So, right now, there&#8217;s two that are already finished, but we&#8217;re working on four more. They&#8217;re still in different degrees of done, but we&#8217;re not in a rush, which is the nice thing, because a default theme has a deadline, but community themes don&#8217;t really, so we just go at the pace of the contributors, and hopefully there will be, like those four, will make it sometime in the future in the directory. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So where can people read up about it? Is a GitHub repo, or a GitHub space, or is a channel?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it is a GitHub repo under the WordPress namespace. I think there&#8217;s an old post on the Make blog on the themes team, and it&#8217;s also part of the mentorship program. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah, we definitely need to bring this out more, and amplify some of that work that you&#8217;re doing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, whenever I go to WordCamps, and during contributor day, we usually work on that, on the themes table. So if you&#8217;re around in WordCamp EU, I will probably do more of that. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Excellent. Excellent. So yeah, there are some more developer blog posts that I wanted to point out. The next one was drop shadow updates for WordPress 6.5. That kind of covers that drop shadows were only available for buttons, and only through the theme JSON file, so now, they&#8217;re available with a user interface under the Border and Shadows section in the styles, and come with five presets from Core. And you can add through the theme JSON additional ones, and they&#8217;re now available for images and column both, and the button block. Yeah, so those four blocks can now have drop shadows, have support for drop shadows. Yeah, it&#8217;s quite interesting to see how drop shadows make a revival design-wise, because they add a little bit of a dimension to a site, especially. Oh, and well, we talk about it when we cover Gutenberg 18.0 is, it now also came to featured image, but it will not be in 6.5. Yeah, and then Nick Diego published an Exploring the Block Hooks API in WordPress 6.5. You need, really, a big cup of coffee for it when you want to read it. It&#8217;s about 5,000 words, but it has 4 examples, how you can use this API to add blocks to various actions, and various other blocks, and also change content.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> More PHP for the PHP lovers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Say it again?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> More PHP for the PHP-lovers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s both, actually.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, true.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah, you need to tell the block what to do. So that&#8217;s probably in JavaScript some more. Yeah. But yeah, that definitely, yeah, and then the last one was just published yesterday is how to use the WordPress React components for plugin pages, and so you can use the components that are pre-configured, pre-designed. You don&#8217;t have to make those decisions, but you can use them to also create your settings pages, your additional pages on the plugins, and it kind of goes into the next phase of things, when admin changes over to a few additional pages and all that, so&#8230;&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Mentorship Program</h3>\n\n\n\n<p>Well, you mentioned it before, the second cohort of the mentorship program is almost finished. It has really taken off. Almost 50 contributors were paired with mentors, and the program ran for six weeks. Mentees came from a lot of different countries, from Spain, from Egypt, from India, from Brazil, Italy. That&#8217;s just what I can kind of, at a first glance, see. So you have been part of it as a mentor, Maggie. So thank you for raising your hand and stepping up to that plate, and so what was your experience in working with a mentee in the whole program?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it&#8217;s been really good. Our particular project has nine people working on building the community themes that I mentioned before. Of those mentees, they all have varying degrees of experience in blog theme development, and I was really happy to see that some of them were designers, which is something that slowly, we&#8217;re moving towards, which I&#8217;m really excited about.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s cool. That designers are going to now do themes. Yeah, absolutely.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Before, it was just developers, and then we&#8217;re getting more and more designers, because they don&#8217;t really need to actually know any kind of coding skills to do this. So I encourage any designers to join us, if they want to. I had the privilege to meet a few of them during WordCamp Contributor Day on the themes table. We were working on some community themes, along with other contributors that just joined our org, and I think this is the second instance of the mentorship program, which was successful, they did the first time around, and there&#8217;s been way more people this time, all over other teams of the project. I&#8217;m only talking about teams because it&#8217;s the one that I&#8217;m working on, but there&#8217;s a community, there&#8217;s Core, there&#8217;s tests, there&#8217;s documentation. All of the teams, I think, are represented. So everyone&#8217;s welcome. So yeah, I encourage, from here, anyone who&#8217;s interested in being a contributor to join it for the next one, and keep an eye on that. I think it&#8217;s the community Make blog where they are announcing when this mentorship is taking place, and it&#8217;s really nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. That will be <a href=\"http://make.wordpress.org/community\">make.wordpress.org/community</a>. So the program managers are Hari Shanker and Naoko Takano?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And they&#8217;re both very experienced community members.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes, they are.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and yes, the first cohort was in July last year. It started in July last year. It&#8217;s an experiment, yeah, and, obviously, the feedback was really great in how it all went, both from mentees and mentors. So they were able to expand this. I think they had 75 applicants. So there is an application embedding process for both mentees and mentors.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. There&#8217;s also been, this time around, there&#8217;s been a grant for LGBTQ+ people, so some of them are actually sponsored to join the mentorship program, which I hope will happen again. So yeah, I&#8217;m really excited about that, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, that&#8217;s one of the many, actually, efforts to bring underrepresented minorities also to the contributor team, and I really love that there is a sponsorship there, because many women, I say, were non-binaries, have so much requests on their times, that apart from having a profession, or a job to do, they&#8217;re also caretakers of their families, their kids, their elderly, and so they are not as free, most of the time, in our society, not as free to take on extra time, and we can&#8217;t change that, but we can help offset some of the financial burdens that are there. All right, so yeah, I&#8217;m glad we talked about the mentorship program there. Thank you so much.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Data Liberation</h3>\n\n\n\n<p>So there&#8217;s another initiative out there since the State of the Word in 2023. That was in Madrid. Matt Mullenweg talked about the data liberation, that anybody should be able to take their data and move either into WordPress, from WordPress to another WordPress, or from a third-party system, and the Data Liberation Project Initiative has invited developers and product owners to a hallway hangout, which is an informal discussion, to discuss and brainstorm around that project, and it&#8217;s on April 3rd at 7:00 PM, 1900 UTC, which is 1500 Europe or Germany, and 1900 is 1700. Well, time zones. Yeah, it&#8217;s 1900 UTC. Let&#8217;s do it that way.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> We&#8217;re close to daylight savings, so you just let those people figure it out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. It&#8217;s going to change on Sunday. So today is the 10th, and it will be on April 3rd. So yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> For some people.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> For some people.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> For some people.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s okay. Only for some people.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Well, if you miss it, because either time zones or daylight savings time, there, likely, will be a recording, and the topics that will become discussions is kind of the challenging of migrating from third-party platforms to WordPress, the good, the bad, and the ugly of exporting WordPress content. So the potential interoperability between block libraries, and page builders, and what work will make data liberation, and who should work on it. So that&#8217;s quite an interesting discussion to have with those people that are interested in the project on April 3rd. Okay, yeah, every time when I was working in an agency, it was always a little bit hard to move people away from hosting that is bad, or from page-builder that was bad, and all of that. So I&#8217;m glad that there is a project now where all the community can put together their scripts, and their ideas, and their work that they have already done, and share it with the rest of the community.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. I know more and more people who want to move out of those walled gardens, and own their own content, so I think that&#8217;s going to be a great initiative, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, the flexibility.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> To keep an eye on it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The interoperability is just unmatched there that WordPress has with other systems, and the more a website grows up, the more needs there are, for sure.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Developer Hours</h3>\n\n\n\n<p>Speaking of events, this week was a developer hour covering the block hooks API, and Nick Diego, and Ryan, or, no, Justin, went through four examples, Justin Tadlock, four examples of adding a like block to a page, and moving it from the comments to the top, or something like that, and then the Getting Started Guide in the Block Editor Handbook has a example of a copyright block. This developer API event kind of took that, and see what you could do with the block hooks, and get it into a footer, or get it into a template. And then the third example is to add a Back to Top link to a paragraph, or to the next heading, before the next heading, or something like that. Yeah, and then, last, but not least, how to add a login/logout block automatically to the navigation of a site in the template. So, right now, you can&#8217;t use the block hooks API, all the blocks. We should get rid of the name blocks, and just call it hooks.</p>\n\n\n\n<p>Right now, it&#8217;s only for templates; you cannot do it for pages or posts, but that certainly is the next iteration of it. The recording will be linked in the show notes, so you can catch up on it, and they use the developer blog post on the block hooks API as a guide, and how they talked about it. Yeah. The next Developer Block Hour&#8230; God. There&#8217;s an erroneous block added to it, the Developer Block hours. No, it&#8217;s the Developer Hours, and it will take place on April 9th with Damon Cook and Nick Diego, and they will showcase examples on how to use the interactivity API and enhance your block-building experience for you and your users. So save the date, April 9th at 1400 UTC. You&#8217;ll figure out when that is for you, but I will link to register in the show notes, and it&#8217;s a link to meet up, and they do a good job in translating the times to the local times of your browser. All right, that&#8217;s about that, and I think it&#8217;s time that we start with the Gutenberg 18.0 release. Maggie, do you want to be honest and get us into the groove of things?</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 18.0</h3>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. The 18.0 Gutenberg plugin release has 206 closed PRs by 59 contributors. It has a record setting of 17 first-time contributors, which is amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, amazing. Yeah. The last time, I think, was Gutenberg 13 point-something. Yeah, it was 13, but, normally, we have 4 or 5 first-time contributors.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I&#8217;m thinking that the successful Contributor Day in WordCamp Asia had something to do with it, but it&#8217;s just a theory.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, or the mentorship. Maybe the mentorship, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, mentorship, too, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Everything counts, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Everything counts. Yes, of course. Yeah, every contribution is worth it.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. If you look, you&#8217;ll find, in the release, the result of additional data view works, improvements on feature image in all the blocks, and a ton of bug fixes, and about 35 PRs just for the contribution updates.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s amazing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> So let&#8217;s have a look at some of them.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So DataViews is the prototype for the new admin design. Not a lot of people realize that, but if you&#8217;re in the blog edit and the site editor, the list views that you see there, the list of templates, and the list of pages, and the list of template parts, they&#8217;re all powered by the new data views, and this release brings with the multiple selection of filters. So if you were in a template view, you can say, &#8220;Okay, I want to combine the filter from the author with a theme,&#8221; or something like that. Yeah, or, &#8220;In a page, I want the ones that are published and pending for review, but not the draft ones,&#8221; or, &#8220;I want the ones published by a certain author.&#8221; So these, in the list here, I don&#8217;t think that&#8217;s actually available in the admin section now. I&#8217;m not quite sure. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Not as complex as this filter looks like in this PR. It feels like it&#8217;s going a step ahead, and what I think is very powerful is how this can be used, not just where it&#8217;s being used right now, but in any other place that a plugin author may want to implement it, or in the future, we&#8217;re going to see it in other places in the admin panel. So yeah, I think it&#8217;s really powerful, and they&#8217;re working really hard on making this something that can be used in many ways. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and in the pages state of view, they added some quick actions. The quick bulk actions. I think bulk actions is the one from the admin where you can say, &#8220;Okay, I want this page, and this page, and this page,&#8221; and then delete them all, or change something, or something like that. Yeah, and now, that&#8217;s also in the new ones. And the last one from the data view, there are tons of changes in the data views. Some were incremental changes, but one is that the updates…</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, the story.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, so I wanted to talk about the index page for the templates, because it now shows three different views of it. So you could have a table. So the templates are your archive pages, your single post template, and all that, and you can see them all in a list, or you use the toggle for the layout, and you can see a grid view, and the grid view gives you a little small preview of the template, so you know exactly what it will show with a featured image with where the content is, and all that, or you can have a list, but then, there&#8217;s another pane that gives you a preview of the full page, full template, where you can also edit it, so that, from table, to grid view, to list view, those are the different prototypes for the admin designs, and it&#8217;s really smooth how they move, and with all the animations, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. I&#8217;ve been looking at the PRs, and the contributors take a lot of care into the performance aspect of the changes. They are keeping close tabs into what the performance looks like. So these improvements, they&#8217;re going to be very important when this goes all over the admin. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next item on my list was in the site editor, the featured image is now, or in the site editor that we can look at, the post editor, the featured image section is now moved up to the top of the inspector control, which is….</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, I&#8217;m very excited about that. It feels like it&#8217;s such a small change, but it&#8217;s something that you want to be up top there, so I&#8217;m really excited that that finally made it. That&#8217;s the kind of thing that it&#8217;s like, &#8220;Why is it that hidden?&#8221; And it&#8217;s also something that it&#8217;s toggled, so you need to click it before you see it. So now, it&#8217;s up there, right where you need all the info for your photos.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. Yeah, the web pages become more and more just also visually, need to be visually attractive. You need to have a featured image for the social posts. Yeah, so it&#8217;s such a strong piece of your design that it should be more in the forefront, as it is now. Yeah. Yeah, speaking of featured image, you can now use the featured image in a media and text block, which I find exciting, because you don&#8217;t need to use complicated columns. Yeah, you can just use a media and text block for your featured image, and the title of your post, and then it kind of shows up in a great way, and you don&#8217;t have it as a background, or as a cover, or something like that; it&#8217;s just the picture has its own right, actually, in your header of your post, or in your archive pages. Yeah, so I really like it. Have you seen any designs for that yet?</p>\n\n\n\n<p><em>Maggie Cabrera: </em>No. You&#8217;ve seen that particular block, but I can think of a few things that I&#8217;ve worked on that try to replicate the same thing with columns, and I&#8217;m glad that now, we can do it with the media and text block, which is probably simpler than those solutions that we built. So yeah, I&#8217;m excited to have another tool for the theme developers to get those featured images in your posts. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, media and text block is actually quite versatile in how you can use it, and also, the expanding of the picture when the text goes bigger, and yeah, it&#8217;s all some automation in there. That was very intriguing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> And the responsive controls, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It was very intriguing to me, yeah, when I first kind of encountered it, and we mentioned it before, for the featured image, now, you can attach a box shadow or a drop shadow around it. It has support for that now. So you could have borders that are rounded plus a drop shadow on your featured image in the single post. It&#8217;s really cool. Yeah, I like it.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yep.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So the layout changes are part of the grid layout experiments? Have you experimented with those grid layouts that are coming to WordPress, or to the Gutenberg Times?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I have tested some of the PRs. This is not yet on Core, right?&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, it&#8217;s on 18.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Okay. Yeah, so that&#8217;s the reason why I haven&#8217;t used it in a production-ready theme, but I&#8217;m really excited. I&#8217;m following it, because I think it&#8217;s great. It&#8217;s the future of layout in WordPress. So I&#8217;m super stoked about how fast it&#8217;s moving, because grid is so complicated, and thinking about a UI for grid, that it&#8217;s both complex enough to give you all the tools that you need for those complicated layouts, while are still being friendly for users who don&#8217;t know how grid works in CSS, it&#8217;s an incredible difficult accomplishment. So I&#8217;m really excited to see it advance, and it&#8217;s looking really, really promising. I really think it&#8217;s the future for theme layout. So I&#8217;m really looking really closely into those features.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So right now, you can only experience it when you enable the grid layouts in the experiments section of the Gutenberg plugin, but it&#8217;s really eye-opening how it all works, and there are two new features in there, that one is to have start row, and column start and row start controls in the grid so inside the grid, so you can drag and drop around blocks, and use the drag and drop, which is, visually, much easier to accomplish than trying to figure out which column to put where, something wherever, and another one is that you can group blocks in a grid, so you have six paragraphs, and then you highlight them all, and you click the grid button, and then it arranges them in whatever grid you say, three by three, three by two, four by two, kind of&#8230; Yeah, it&#8217;s actually really magic. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> It&#8217;s magic. It&#8217;s magic, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, and it&#8217;s just so amazing that this is possible in WordPress, where you never had any layout tools before. Yeah, so yeah, we are really happy about that. The next thing is that, also, in the site editor, when you look at styles, up until now, you have just the style variations, but now, you also have access to the color and the typography presets in the same page or same column. So you can say, &#8220;Okay, I want this style variation, but I want it in a different color, and I want a different font for that.&#8221; So that informs your whole site as well. You don&#8217;t have to do it for every block, and every template, or something like that. Yeah, so this is really powerful to kind of bring the global styles, not only to the style variations, but also to color and typography presets. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, sometimes you really like everything about a style variation, but the colors or the typography, and now, you can mix and match however you like, which is nice having the extra option, and I think it&#8217;s also a stepping stone for more changes, in that vein, that will come. So yeah, I&#8217;m excited about that, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and it&#8217;s also visually pleasing. So if you try that out, then when you use the Gutenberg plugin, you have some great visual representation of what the presets would be like, and also, when you click on it, you have a preview on the right-hand side, so you know what you get yourself into. So it&#8217;s really good.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">APIs</h3>\n\n\n\n<p>There&#8217;s a new API for developers, and that is the plugin document settings panel. So in the document settings, you can have, now, a slot fill, where you, as a plugin developer, you can have put additional fields in there, additional information, and additional controls, and it&#8217;s now available, also, for the site editor. You could do this on the post editor, but now, it&#8217;s also available for the site editor. So there&#8217;s this matching-up with post editor and site editor kind of becoming the same.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Yes. Yeah, that&#8217;s important.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fixes</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh yeah. There&#8217;s one bug fix that I really love, and that&#8217;s the code bug. Finally. So yeah, especially for the developer blog, yeah, we had a few code examples.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I see why you highlighted it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> &#8230; where we had to kind of spend hours, no, not hours, but at least a half an hour, very tedious work, to remove the breaks, and kind of have new lines in there in code view. So, now, that&#8217;s finally solved, and yeah, we can now start writing again.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Focus your time on what&#8217;s important, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s actually very soothing. It&#8217;s almost meditative doing that, but you need to be in the mindset for that.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Put on some music.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, put on some music. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, I get it.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I think I wanted to highlight one of the documentation things. So, if you, as plugin developer, or agency developer, are interested in the data views, there is a&#8230; Well, all the components are in a storybook kind of site that gives you a representation outside of context of a component, and you can see all the attributes for it, and you can try it out, and they just updated the story for the data views component, and so it&#8217;s easier for if you want to kind of experiment with it, or, in your research, you can definitely use it now, and get a better handle on how the data views would maybe work for you in your plugin, and give us your more complicated custom post types that you might have. I will link the story to this DataViews component into the show notes so you don&#8217;t have to hunt it down.</p>\n\n\n\n<p>I think that was it. That&#8217;s all from the Gutenberg plugin 18.0. Of course, if you&#8217;re interested in any of the other 209 PRs, the release post will be on makeblog/core later, after we&#8217;ve finished recording, but way before this podcast is published, so we&#8217;ll have it there for you in the show notes.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>Now, we&#8217;re at the section of what&#8217;s in active development or discussed, and I wanted to point out for you, dear listeners, what&#8217;s coming with the admin design. We know we see a few things already in the site editor, and as kind of a prototype of Saxon Fletcher from the design team showed in the video how the next version of DataViews, the admin pages, could work, and it&#8217;s an insightful 18-minute video shared in the design channel, and he summarizes the most recent thinking, particularly about layout and transitions in and out of the editor, and walks us through some of the Figma views and prototypes. It also goes into details about some of the Core paradigms, and if you&#8217;re not part of the WP Slack, you can also watch it via the latest design share on the Make design blog. So, Maggie, did you watch it? What was the most intriguing for you, or what was it from it?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, we talked about the DataViews earlier, and I think it&#8217;s really exciting to see how it&#8217;s shaping up. I think one of the comments that he makes is probably what some of the people have mentioned, about how the drilldown on the sidebar looks like, and how you&#8217;ve got to kind of click too many times to get where you want, and if you want to go back, you got to get taken back again, and it&#8217;s nice that they&#8217;re looking into that, and see if they&#8217;re going to iterate on that design. I think it&#8217;s really important for extenders, and even just regular users, to look into those design explorations, and give them feedback, because there&#8217;s only so many things that the design team can take into account, even though they make a great job at trying to figure out all use cases, and all probable ways of using the WordPress admin, but if you have feedback, I think this is the key moment to give it. So go ahead and look at the video. It&#8217;s really exciting. I think it looks really good, and I&#8217;m super stoked to see it actually live, and maybe even work on it. I really enjoyed, particularly, the color stuff, so I&#8217;ll delve into that, if I can chime in on that, but yeah, absolutely 100% look into it and give feedback, because now is the moment. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, what struck me as really interesting to see was how the new layout, we talked about the layout being on the left-hand side, being the menu, and then you get a list view, and then a preview, that has also been explored to use with more complicated custom postings, like a product, for instance, that has a few additional settings that you need to enter it, and he showed, very nicely, how that can be done in that content area in the middle of it, and then you could either switch to settings of the product, and have additional tabs, and additional fields and forms, or you could go and edit the product in an editor view. So I think there&#8217;s some great explorations there, in terms of more complicated custom post types, and to see those in a more modern interface is, really, it&#8217;s quite exciting for me. Yeah, and I can see how, because the admin designs are all extensible right now, and that accessibility needs to come back. So yes, so&#8230;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. WordPress needs plugins to live. Plugins are the soul of WordPress, so having them be more consistent with the general admin field is going to make WordPress, in general, a better experience for any users, whatever the plugins are. So that&#8217;s really good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, in the Figma space section, it also showed some of the standard colors, and how the variables for primary, secondary, and tertiary could work out, but he also had a section in there where he changed a whole palette from light to dark, and then every screen would also follow suit, and how that is already thought through about it because admin themes are, I think on Core, we have six or seven admin themes, and plugins add additional ones there, so that needs to be taken care of as well. And with the Figma place, where all the standards are, it&#8217;s probably easier for the plugin developers to make decisions, and to come forward to going to production much faster than before, because they don&#8217;t have to invent the wheel over and over again. Yeah, so that&#8217;s an active discussion on the design team, and I have a link for you in the show notes, and, with that, we are at the end of the show.&nbsp;</p>\n\n\n\n<p>Maggie, it has been a great pleasure to chat with you, and I hope you&#8217;ll come back in a few months for another Gutenberg Changelog episode.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Absolutely. Yeah, I would be really happy to. It&#8217;s been a pleasure for me. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Thank you, Maggie.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Thank you so much for inviting me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely, and the pleasure was all mine. So, before we end the show, I want to remind everyone, April 9th, next Developer Hours on the Interactivity API at 1400 UTC. I think it&#8217;s 8:00 AM Eastern, but don&#8217;t hold me to that.&nbsp;</p>\n\n\n\n<p>As always, the show notes will be published on gutenbergtimes.com/podcast. This is episode 98, and if you have questions, or suggestions, or news you want us to include, send them to <a href=\"mailto:Changelog@GutenbergTimes.com\">Changelog@GutenbergTimes.com</a>. That&#8217;s <a href=\"mailto:Changelog@GutenbergTimes.com\">Changelog@GutenbergTimes.com</a>, and if you want to write a review about our podcast, I think our last reviews were from 2021. I also have asked that much for it, and I have the experience that when you ask for it, people will step up to the plate and write a review. So if you want to do that, that would be really helpful, because it helps with discovery for new people. All right, that&#8217;s it. Thanks for listening. Goodbye.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Goodbye.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Until the next time. See you.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> See you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Mar 2024 19:57:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Gutenberg Times: Gutenberg 18.0, Playground, Pattern, and Form plugins and so much more — Weekend Edition 289\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=28030\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24294:\"<p>Happy Easter if you celebrate it! 🐰 🐣&nbsp; The Easter weekend has a total different vibe in Munich as it had in Naples. In Naples, it was just a normal weekend, and you could get groceries over the weekend, and other shopping done.  Here it is a four-day weekend with Good Friday and Easter Monday as bank holidays and except for Saturday, almost all shops are closed. </p>\n\n\n\n<p>On Thursday, everyone was out grocery shopping for the long weekend. We went to our weekly neighborhood market and were surprised by the long queue in front of every stand. People weren&#8217;t deterred by the pouring rain. It took us twice as long to make our purchases then in a normal week. I bet the lines would have been even longer without the rain. </p>\n\n\n\n<p>We bought the first white asparagus already, some fish salad and graved lachsforelle from the local trout farmer, vegetable from the local farmers and butter and eggs from the local dairy farmers. At each stand, during the cash payment process you have a little chat with the merchant. I cherish these moments in the non-online, the analog world, that hasn&#8217;t changed for centuries. Interpersonal connections are so much richer than anything that can happen online,  writes she who has been building websites for 28 years. Anyway. What are your favorite offline every day interactions, you cherish?</p>\n\n\n\n<p>Now back to the world of blocks, themes, and plugins. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#upcoming-events\">Upcoming events</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>This week we expected WordPress 6.5 to land. After further deliberation evaluating late bug fixes, the release team <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">decided to move the release date</a> until after Easter and so committers have enough time to review the code and add some testing. The <a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\"><strong>WordPress 6.5 Release Candidate </strong></a>4 is now available for testing. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Gutenberg 18.0 plugin version was released. You can read everything about it in the release post <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\"><strong>What’s new in Gutenberg 18.0? (27 March)</strong></a>. As highlight, I pointed out: the newly added sitewide color and typography presets you find in <strong>Site Editor &gt; Styles</strong> section, you can now use the feature image in a Media + Text block and features images now have support for drop shadows. Furthermore, the Grid layout experiments showed some great progress </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Core Contributor, <strong>Maggie Cabrera</strong> and I chatted about the updates in Gutenberg 18.0, the Community Theme project and the Contributor mentorship program in our recording of the 98th Gutenberg changelog episode. As always, it will arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<a href=\"https://gutenbergtimes.com/podcast/\"><img width=\"652\" height=\"187\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/03/Screenshot-2024-03-29-at-15.25.06.png?resize=652%2C187&ssl=1\" alt=\"Maggie Cabrera and Birgit Pauli-Haack recording Gutenberg changelog episode 98. \" class=\"wp-image-28062\" /></a>\n\n\n\n<p class=\"has-accent-color has-light-background-background-color has-text-color has-background has-link-color wp-elements-b6fe42ed62408b6fe464d62777dc0282\">🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/\">Gutenberg Changelog #98 – WordPress 6.5, Gutenberg 18.0 Community Theme Project and the Contributor Mentorship Program</a> with special guest Maggie Cabrera</p>\n\n\n\n<p>If you haven’t yet, you can subscribe to any of these services and apps:<br /><a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\" target=\"_blank\" rel=\"noreferrer noopener\">Apple Podcasts</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\" target=\"_blank\" rel=\"noreferrer noopener\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\" target=\"_blank\" rel=\"noreferrer noopener\">Google&nbsp;</a>|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\" target=\"_blank\" rel=\"noreferrer noopener\">Podcasts</a>&nbsp;|&nbsp;<a href=\"https://pca.st/7O43\" target=\"_blank\" rel=\"noreferrer noopener\">PocketCasts</a>&nbsp;|&nbsp;&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Podbean</a>&nbsp;&nbsp;<br /><a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\" target=\"_blank\" rel=\"noreferrer noopener\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast/\" target=\"_blank\" rel=\"noreferrer noopener\">RSS</a>&nbsp;|&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg\">Spotify</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest, <a href=\"https://make.wordpress.org/design/2024/03/25/design-share-mar-11-mar-22/\"><strong>Design Share: Mar 11-Mar 22</strong></a>, <strong>Joen Asmussen</strong> lists the work of the WordPress Design Team. In this post, you  also find the links of design resources for WordPress Figma and GitHub spaces in one place. Asmussen shared about the progress of the Grid layout work, Template vs. page content refinements, Template part and proximity selection, color generation and an 18-minute video with Admin updates with Saxon Fletcher. </p>\n\n\n\n<p>In addition, </p>\n\n\n\n<ul>\n<li>progress on synced pattern overrides, a feature that didn&#8217;t make into WordPress 6.5, </li>\n\n\n\n<li>contentOnly improvements</li>\n\n\n\n<li>Top bar organization exploration</li>\n\n\n\n<li>Save &amp; publish</li>\n\n\n\n<li>Openverse dark mode</li>\n\n\n\n<li>Blocks page v2 (<a href=\"https://wordpress.org/blocks/\">https://wordpress.org/blocks</a>)</li>\n</ul>\n\n\n\n<img width=\"652\" height=\"348\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/03/Screenshot-2024-03-29-at-11.39.03.png?resize=652%2C348&ssl=1\" alt=\"Design explorations for Block page version 2\" class=\"wp-image-28041\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Data-liberation</strong> initiative invites developers and product owners to a <a href=\"https://make.wordpress.org/core/2024/03/26/hallway-hangout-data-liberation-discussion-and-brainstorm/\">Hallway Hangout: Data Liberation Discussion and Brainstorm</a> on April 3 at 7 PM UTC don’t worry if you miss it, there will likely be a recording. The topics that might come up are around&nbsp;</p>\n\n\n\n<ul>\n<li>Challenges of migrating from third-party platforms to WordPress</li>\n\n\n\n<li>The good, bad, and ugly of exporting WordPress content</li>\n\n\n\n<li>The potential of interoperability between Block libraries and page builders</li>\n\n\n\n<li>What work will make data liberation, and who should work on it</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upcoming-events\">Upcoming events</h3>\n\n\n\n<p>April 2, 2024 14:00 UTC <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300076015/\"><strong>WordPress developer live stream: Testing WP Playground</strong></a> Jonathan Bossenger will  dive deeply into WordPress Playground and all its different permutations, to see what they are capable of, and whether he could replace his custom local development environment with a version of WordPress Playground.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Learn.WordPress and&nbsp;<strong>Bud Kraus</strong>&nbsp;will present “<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/299175971/\"><strong>What’s New In WordPress 6.5?</strong></a>” via Zoom on&nbsp;<strong>Tuesday, April 9 at 19:00 UTC</strong>*. He will demonstrate the new features coming to WordPress 6.5, such as Font Management Revisions for Styles and templates, and the new data view screens coming to the Site Editor.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Also, <strong>April 9, 2024, at 14:00 UTC</strong>*<sup class=\"fn\"><a href=\"https://gutenbergtimes.com/feed/#77c4b891-cd4b-4ec6-a2cb-9c14f0b34849\" id=\"77c4b891-cd4b-4ec6-a2cb-9c14f0b34849-link\">1</a></sup>, <strong>Nick Diego</strong> and <strong>Damon Cook</strong> invite you to the next <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300032710/\"><strong>Developer Hours: Building custom blocks with the Interactivity API</strong>. </a><strong>Damon Cook</strong> from WP Engine will demonstrate how he built a form submission block that leverages the API. This example will teach you how to kick-start a custom interactive block using the Create Block package, use directives to assign critical attributes to your HTML markup, create the store, and hook up the client-side JavaScript.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>If you are looking for a block-based way to create form, <a href=\"https://twitter.com/MatzeKitt\"><strong>Matthias Kittsteiner</strong></a> has the solution as the <a href=\"https://wordpress.org/plugins/form-block/\"><strong>Form Block</strong></a> plugin. It comes with a Form creation Wizard, you can use unlimited fields and various field types, comes with honeypot implementation, client and server-side validation and built on consent check.  A pro-version is also available at <a href=\"https://formblock.pro/en/.\">Form Block Pro</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><b>Yay Commerce</b>, a long-time WooCommerce extender company,  just published a set of blocks as <strong><a href=\"https://wordpress.org/plugins/brandy-blocks/\">Brandy Blocks</a></strong> in the WordPress Repository, primarily a testimonial block and a 3-column pricing table block. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/RafalTomal\">Rafal Tomal</a></strong> reflected in his post <a href=\"https://rafaltomal.com/why-wordpress/\"><strong>Why I’m Excited About WordPress Again</strong></a> on his journey to Webflow as a site building tool and back and his experience with the Site editor and building the new premium block theme <a href=\"https://rockbase.co/get-rockbase/\">Rockbase.</a> &#8220;The full site editor aligns with the contemporary approach to web design, moving away from viewing websites as static, brochure-like pages. Instead, websites are envisioned as dynamic design systems, and the modern WordPress theme embodies this system.&#8221; Tomal wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David Artiss</strong>, customer success lead for WordPress VIP,  is using the new Footnotes block and migrated earlier content. And he shared how he did it:  <a href=\"https://artiss.blog/2024/03/adding-footnotes-in-the-wordpress-block-editor/\"><strong>Adding Footnotes in the WordPress block editor</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>Theme shop <strong>Blockify </strong>released a <a href=\"https://wordpress.org/plugins/pattern-editor/\"><strong>Pattern Manager</strong></a> in the WordPress plugin repository. It helps &#8220;you create and edit patterns for WordPress block themes. It automatically exports patterns on save as PHP files to the active themes&nbsp;<code>patterns</code>&nbsp;directory.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">#outreach channel</a>, Anne McCarthy posted a question for theme developer and users: </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong><img src=\"https://i0.wp.com/a.slack-edge.com/production-standard-emoji-assets/14.0/apple-medium/1f914.png?w=652&ssl=1\" alt=\":thinking_face:\" />&nbsp;Share your thoughts on what the block theme tag should be in the theme repo&nbsp;<img src=\"https://i0.wp.com/a.slack-edge.com/production-standard-emoji-assets/14.0/apple-medium/1f914.png?w=652&ssl=1\" alt=\":thinking_face:\" /></strong></p>\n\n\n\n<p>In this trac issue&nbsp;<a href=\"https://meta.trac.wordpress.org/ticket/7524\" target=\"_blank\" rel=\"noreferrer noopener\">https://meta.trac.wordpress.org/ticket/7524</a>&nbsp;, it’s proposed to update the&nbsp;&nbsp;<code>full site editing</code>&nbsp;tag for block themes. What makes the most sense to you all to include? If folks can take some time to chime in, I’d appreciate it. I flagged twice now for&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RP4VMP\" target=\"_blank\" rel=\"noreferrer noopener\">#core-themes</a>, and I am hoping to get more voices in the mix.</p>\n<cite>Anne McCarty #outreach </cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Via the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">WP Slack #outreach channel</a>, theme builders were invited to discuss their workflows and their challenges in a Hallway Hangout. Here the <a href=\"https://make.wordpress.org/core/2024/03/29/recap-hallway-hangout-using-site-editor-in-production-for-client-sites/\"><strong>Recap Hallway Hangout: Using Site editor in production for client sites</strong></a>. Hot topics, Navigation Block, Theme.json editor and the implementation of patterns, templates and Global styles between database and file system. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his blog post, <a href=\"https://rich.blog/composing-with-patterns/\"><strong>Composing with Patterns, </strong></a> Rich Tabor how <strong>patterns</strong> are pre-made designs that you can add to your website&#8217;s posts and pages. He explains that patterns make it quicker to build nice-looking pages. They also help keep the look of the website the same all over, which is good for people visiting your site. Rich thinks that as people use patterns more and tell WordPress what they like, patterns will get even better and make WordPress easier to use.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Bernie Reiter</strong> and <strong>Nick Diego</strong> took participants of the Developer Hours on the journey  <a href=\"https://www.youtube.com/watch?v=ezPHiyhhaoQ\"><strong>exploring Block Hooks in WordPress 6.5</strong></a>. In addition to covering the basics, they looked at practical examples that you can implement in your projects.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brian Coords</strong> shows you in his latest video on YouTube how he uses <a href=\"https://www.youtube.com/watch?v=qD5U7TNUKTQ\"><strong>Block Variations with the Block Bindings API</strong></a> and how you can offer a &#8220;no-code&#8221; experience for your users with Block Variations. Coords share <a href=\"https://github.com/bacoords/example-block-variation\">his code via GitHub</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest live stream, <strong>Ryan Welcher</strong> explored <a href=\"https://www.youtube.com/watch?v=EZnZQa_wjME\"><strong>Using Playground to preview plugins</strong></a>, and building a blueprint to show off some features of his  <a href=\"https://wordpress.org/plugins/advanced-query-loop/\">Advanced Query Loop plugin.</a> He walks through the process of how to set up a blueprint for the WordPress plugin repository, and then how to create demo content and integrate them into a blueprint as well.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> explains the difference between <strong><a href=\"https://wordpress.tv/2024/03/28/static-vs-dynamic-blocks/\">Static and Dynamic Blocks</a>,</strong> for the series of Introduction to Block development. In this video, Bossenger looks at what the difference is between static and dynamic blocks, how to determine which is right for your needs, and the different approaches for development. </p>\n\n\n\n<p>If you rather learn by reading than by watching, <strong>Joni Halabi</strong>, published an article covering a similar topic: <a href=\"https://developer.wordpress.org/news/2023/02/27/static-vs-dynamic-blocks-whats-the-difference/\"><strong>Static vs. dynamic blocks: What’s the difference?</strong></a> on the WordPress Developer Blog. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>🗞️ Speaking of Developer Blog: This week saw three new articles published; </p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/25/exploring-the-block-hooks-api-in-wordpress-6-5/\"><strong>Exploring the Block Hooks API in WordPress 6.5</strong></a> by <strong>Nick Diego.</strong> The Block Hooks API is an extensibility mechanism that allows you to dynamically insert blocks into block themes. Learn how to use the API in your projects in this comprehensive overview.</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/26/how-to-use-wordpress-react-components-for-plugin-pages/\"><strong>How to use WordPress React components for plugin pages</strong></a> by <strong>Robert Mészáros</strong>. Learn how to create a settings page with multiple controls using WordPress React components for a plugin that displays an announcement bar on the front end.</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/28/how-to-work-effectively-with-the-useselect-hook/\"><strong>How to work effectively with the useSelect hook</strong></a> by <strong>Jarda Snajdr</strong>. This article is about the useSelect React hook from the @wordpress/data library. It offers several tips and tricks on how to use it in the most efficient way possible, and answers many subtle questions about how it really works.</p>\n\n\n\n<p><em>If you don&#8217;t want to miss any new posts on the Developer blog, head on over there and <a href=\"https://developer.wordpress.org/news/subscribe/\">subscribe via email</a>. </em></p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" alt=\"GitHub all releases\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image: Scooters at the Festival of Lights, Taipei, Taiwan by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n<ol class=\"wp-block-footnotes\"><li id=\"77c4b891-cd4b-4ec6-a2cb-9c14f0b34849\"> <a href=\"https://gutenbergtimes.com/feed/#77c4b891-cd4b-4ec6-a2cb-9c14f0b34849-link\">↩︎</a></li></ol>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Mar 2024 07:59:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"HeroPress: Jouralism, 5000 Theme Reviews, WordCamp Europe and more!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=6624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:173:\"https://heropress.com/jouralism-5000-theme-reviews-wordcamp-europe-and-more/#utm_source=rss&utm_medium=rss&utm_campaign=jouralism-5000-theme-reviews-wordcamp-europe-and-more\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14741:\"<img width=\"1024\" height=\"683\" src=\"https://heropress.com/wp-content/uploads/2024/03/5665f5e9afc734c8.12871696-1024x683.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Front view of a Boeing 737-8AS airplane taking off from an airport runway, viewed from the perspective of the airport with a fence in the foreground and a hilly landscape with buildings in the background.\" /><div class=\"kb-row-layout-wrap kb-row-layout-id6624_9229b7-a3 alignnone wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_1c0628-36\"><div class=\"kt-inside-inner-col\">\n<p>Once again some extra stuff outside the normal HeroPress fare!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_231904-31\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_b0f88b-90 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_08fcd7-bc inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_b11492-92 wp-block-kadence-advancedheading\"><a href=\"https://heropress.com/\">HeroPress.com</a> &#8211; <a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\">Words to WordPress: The Uncharted Path of Syed Laden</a></h2>\n\n\n\n\n<div class=\"wp-block-image is-style-default\">\n<a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\"><img width=\"300\" height=\"300\" src=\"https://heropress.com/wp-content/uploads/2024/03/1052441B-31C7-4153-94F9-227FF564B1E1-Photoroom.png-Photoroom-300x300.webp\" alt=\"\" class=\"wp-image-6608\" /></a></div>\n\n\n<p>Syed Laden didn&#8217;t set out to be &#8220;into&#8221; technology, being a journalist. But when the right tool came along, he fell in love. </p>\n\n\n\n<p><em>My mission is simple: to bridge the gap between tech savviness and digital expression. WordPress is for everyone, and I’m here to prove it.</em></p>\n\n\n\n<p>Syed&#8217;s essay is <a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\">available</a> on <a href=\"https://heropress.com\">HeroPress.com</a>.</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_ae33f6-6d\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_2a0ab9-e1 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_e1f421-53 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<img width=\"1024\" height=\"390\" src=\"https://heropress.com/wp-content/uploads/2024/03/Badge-Facebook-cover-We-are-Media-Partners-1024x390.png\" alt=\"We\'re Media Partners!\" class=\"kb-img wp-image-6631\" />\n\n\n\n<div class=\"wp-block-kadence-image kb-image6624_931128-a3\"><a href=\"https://heropress.com/wp-content/uploads/2024/03/Vespa-Piaggio-Wapuu.png\" class=\"kb-advanced-image-link\"><img width=\"300\" height=\"220\" src=\"https://heropress.com/wp-content/uploads/2024/03/Vespa-Piaggio-Wapuu-300x220.png\" alt=\"\" class=\"kb-img wp-image-6632\" /></a></div>\n\n\n\n<p>That&#8217;s right, HeroPress is once again a WordCamp Europe Media Partner AND I&#8217;m going to attend!</p>\n\n\n\n<p>I plan to interview people while I&#8217;m there, so please come say hi to me.  If you don&#8217;t want to be interviewed, please come say hi to me and I won&#8217;t ask you any questions.  :)</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_3c0336-b9\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_885731-7c alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_d22a24-27 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<a href=\"https://kafleg.com.np/5k-wordpress-themes-reviewed/\" class=\"kb-advanced-image-link\"><img width=\"834\" height=\"417\" src=\"https://heropress.com/wp-content/uploads/2024/03/theme_reviews_number.jpg\" alt=\"\" class=\"kb-img wp-image-6629\" /></a>\n\n\n\n<p>The other day HeroPresser Ganga Kafle wrote to me from Nepal to let me know he recently finished his 5000th theme review! He did a great <a href=\"https://kafleg.com.np/5k-wordpress-themes-reviewed/\">blog post</a> about how he got started and who mentored him.  Coincidentally, most of them were HeroPressers!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_21c670-e7\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_2fd581-cb alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_735a1d-7c inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_c246c6-42 wp-block-kadence-advancedheading\"><a href=\"https://hallwaychats.com\">WPPhotos.Info</a></h2>\n\n\n\n\n<div class=\"wp-block-image\">\n<a href=\"https://wpphotos.info/close-up-percussion-instruments/\"><img width=\"300\" height=\"200\" src=\"https://heropress.com/wp-content/uploads/2024/03/79965f5f3b9e5c6b3.44956242-scaled-1-300x200.jpg\" alt=\"A close-up of percussion instruments, prominently featuring a tambourine placed on top of a Deagan xylophone, with drumsticks resting on a music stand and a cymbal in the background.\" class=\"wp-image-6630\" /></a></div>\n\n\n<p>Nice close-up taken by <a href=\"https://wordpress.org/photos/author/roytanck/\">Roy Tanck</a>. Here a short story:</p>\n\n\n\n<p>“This picture was taken at the National Military Museum in Soesterberg, NL. I was actually there to photograph their collection of tanks and fighter jets. They have several jets, including an F16, suspended from the ceiling. But when I was there they were also hosting the “Night of the Military Music”, a two-day music event. These instruments were set up to be used later in the day.”</p>\n\n\n\n<p><a href=\"https://wpphotos.info/close-up-percussion-instruments/\">Read more of the story at WPPhotos.info!</a></p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_333b50-2b\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_4639ae-64 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_bd0131-52 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_aad73c-cc wp-block-kadence-advancedheading\"><a href=\"https://wppodcasts.com\">WP Podcasts</a></h2>\n\n\n\n\n\n<a href=\"https://wppodcasts.com\"><img src=\"https://heropressnetwork.com/wp-content/uploads/2024/01/pocket_casts_single_315.png\" alt=\"Pocket Casts image\" class=\"wp-image-4316\" /></a>\n\n\n\n<p>There were <em>twenty-two</em> WordPress podcast episodes released this week!</p>\n\n\n\n<ul>\n<li><a href=\"https://underrepresented-in-tech-1.castos.com/episodes/invisible-disabilities-feat-caylin-white#new_tab\">Invisible Disabilities (feat. Caylin White)</a> from <a href=\"https://wppodcasts.com/podcast/underrepresented-in-tech/\">Underrepresented in Tech</a></li>\n\n\n\n<li><a href=\"https://remkusdevries.com/podcast/elevating-wordpress-education-insights-from-jonathan-bossenger/#new_tab\">Elevating WordPress Education: Insights from Jonathan Bossenger</a> from <a href=\"https://wppodcasts.com/podcast/within-wordpress/\">Within WordPress</a></li>\n\n\n\n<li><a href=\"https://unbilleteachattanooga.com/episodio-255/#new_tab\">Episodio 255: Review de WordCamp Torrelodones 2024</a> from <a href=\"https://wppodcasts.com/podcast/un-billete-a-chattanooga/\">Un billete a Chattanooga</a></li>\n\n\n\n<li><a href=\"https://www.wppodcast.fr/podcast/wordpress-media-corps/#new_tab\">19. WordPress Media Corps</a> from <a href=\"https://wppodcasts.com/podcast/wordpress-podcast-francais/\">WordPress Podcast (français)</a></li>\n\n\n\n<li><a href=\"http://www.ivoox.com/arte-hacer-preguntas-para-vender-con-audios-mp3_rf_126432063_1.html#new_tab\">El Arte de hacer preguntas para vender. Con Jokin Fernández</a> from <a href=\"https://wppodcasts.com/podcast/club-wordpress-emprendedores-online/\">Club WordPress Emprendedores Online</a></li>\n</ul>\n\n\n\n<p>There are new episodes every single day, so be sure to stop by <a href=\"https://wppodcasts.com\">WPPodcasts.com</a> and search for things that interest you!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_98fe15-27\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_40f699-80 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_bdd9ba-8a inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"wpphotos\" class=\"kt-adv-heading6624_d578e6-b7 wp-block-kadence-advancedheading\"><a href=\"https://wordpress.org/photos\">WP Photos</a></h2>\n\n\n\n<p>Here are some of the great photos submitted to the <a href=\"https://wordpress.org/photos\">WPPhotos</a> project this week!</p>\n\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/53165ff07eaf28c20.83046093-scaled.jpg\"><img width=\"683\" height=\"1024\" src=\"https://heropress.com/wp-content/uploads/2024/03/53165ff07eaf28c20.83046093-683x1024.jpg\" alt=\"Looking back through a side mirror of a car reveals a row of cherry blossom trees in bloom on a neighborhood street lined with cars. The camera taking the photo is barely in view in the side mirror.\" class=\"wp-image-6637\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/53165ff07e/\">photo</a> by <a href=\"https://wordpress.org/photos/author/annezazu/\">annezazu</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/69565fa4461789ba5.31742062-scaled.jpg\"><img width=\"768\" height=\"1024\" src=\"https://heropress.com/wp-content/uploads/2024/03/69565fa4461789ba5.31742062-768x1024.jpg\" alt=\"a mayfly on a glass surface, reflected symmetrically.\" class=\"wp-image-6638\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/69565fa446/\">photo</a> by <a href=\"https://wordpress.org/photos/author/ajithrn/\">Ajith R N</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/85665fee10fb74437.27225028-scaled.jpeg\"><img width=\"1024\" height=\"768\" src=\"https://heropress.com/wp-content/uploads/2024/03/85665fee10fb74437.27225028-1024x768.jpeg\" alt=\"A street dog is sleeping under the evening sun. From Pantheerankav, Kozhikode, Kerala.\" class=\"wp-image-6639\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/85665fee10/\">photo</a> by <a href=\"https://wordpress.org/photos/author/mbigul/\">Bigul Malayi</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/90065fe1e37c05ab7.12425413-scaled.jpg\"><img width=\"1024\" height=\"683\" src=\"https://heropress.com/wp-content/uploads/2024/03/90065fe1e37c05ab7.12425413-1024x683.jpg\" alt=\"A brown rabbit sitting on gravel near a metal gate with plants visible in the background.\" class=\"wp-image-6640\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/90065fe1e3/\">photo</a> by <a href=\"https://wordpress.org/photos/author/nilovelez/\">Nilo Velez</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/2516602bb29c08da0.74950620-scaled.jpg\"><img width=\"1024\" height=\"768\" src=\"https://heropress.com/wp-content/uploads/2024/03/2516602bb29c08da0.74950620-1024x768.jpg\" alt=\"A Bengal tiger lying on the grass. It has a rich orange fur coat with black stripes, and its front paws are extended forward.\" class=\"wp-image-6641\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/2516602bb2/\">photo</a> by <a href=\"https://wordpress.org/photos/author/neusitas/\">neusitas</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/3746602d32f248af1.64336328-scaled.jpg\"><img width=\"1024\" height=\"684\" src=\"https://heropress.com/wp-content/uploads/2024/03/3746602d32f248af1.64336328-1024x684.jpg\" alt=\"Close-up of a forsythia leaf shoot. Light green leaves on a dark background.\" class=\"wp-image-6642\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/3746602d32/\">photo</a> by <a href=\"https://wordpress.org/photos/author/werkform/\">werkform</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n\n<p>Be sure to check out the <a href=\"https://wordpress.org/photos/\">hundreds of other great photos</a>!</p>\n</div></div>\n\n</div></div><p>The post <a href=\"https://heropress.com/jouralism-5000-theme-reviews-wordcamp-europe-and-more/\">Jouralism, 5000 Theme Reviews, WordCamp Europe and more!</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Mar 2024 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: WordPress 6.5 Release Candidate 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6552:\"<p>The latest release candidate (RC4) for WordPress 6.5 is ready!&nbsp;</p>\n\n\n\n<p>This release candidate is an addition to the existing WordPress 6.5 release cycle. It allows more time for testing to ensure every feature and improvement is in the best shape possible.&nbsp;</p>\n\n\n\n<p>The updated target for the WordPress 6.5 release is <strong>April 2, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> for further details.&nbsp;If you’re looking for more detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What to expect in WordPress 6.5 RC4</h2>\n\n\n\n<p>There’s been a lot of helpful feedback regarding one of this release’s highlighted features: the Font Library. This has resulted in some <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">additional improvements needed</a> to make sure the greatest number of sites possible can benefit from this anticipated new feature.&nbsp;</p>\n\n\n\n<p>This release also includes six<strong> </strong>bug fixes for the Editor and 10+ <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F13%2F2024..03%2F19%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">tickets for WordPress Core</a>. For more technical information related to issues addressed since RC3, you can browse the following links: </p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-20&until=2024-03-28\">GitHub commits for 6.5</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F20%2F2024..03%2F28%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">Closed </a><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F13%2F2024..03%2F19%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">Trac</a><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F20%2F2024..03%2F28%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\"> tickets</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How to test</h2>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC4 on a test server and site.</p>\n\n\n\n<p>While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC4 in four ways:</p>\n\n\n\n<table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC4.zip\">RC4 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.5-RC</code>4</td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC4 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table>\n\n\n\n<h2 class=\"wp-block-heading\">Here comes the haiku</h2>\n\n\n\n<p>With some extra time<br />Test, rinse, repeat, and refresh<br />WordPress will really shine</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/dansoschin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dansoschin</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 16:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Welcome our Newest Sponsor Cloudways to the Woo ProductChat Show\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/welcome-our-newest-sponsor-cloudways-to-the-woo-productchat-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/welcome-our-newest-sponsor-cloudways-to-the-woo-productchat-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"<p>We welcome Cloudways, managed cloud hosting for WordPress and WooCommerce, as a sponsor of our Woo ProductChat show.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Do The Woo Community: Database Optimization, Monitoring Tools, and Client Communication with Nenad Conić\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://dothewoo.io/database-optimization-monitoring-tools-and-client-communication-with-nenad-conic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://dothewoo.io/database-optimization-monitoring-tools-and-client-communication-with-nenad-conic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"<p>Nenad Conić from Maksimer gives tips on scaling WooCommerce, tools for optimizing the database for scalability in high traffic events.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: The Path for Creating a Premium Plugin Extension with Maarten Belmans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/the-path-for-creating-a-premium-plugin-extension-with-maarten-belmans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/the-path-for-creating-a-premium-plugin-extension-with-maarten-belmans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"<p>Great tips and insights for WordPress and WooCommerce builders who are creating a plugin that is an extension of an existing plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Do the Woo is an Official Media Partner at CloudFest 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/do-the-woo-is-an-official-media-partner-at-cloudfest-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/do-the-woo-is-an-official-media-partner-at-cloudfest-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"<p>Do the Woo will be covering both the hackathon and the conference during CloudFest 2024 at Europa-Park in Germany.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Do The Woo Community: Woo Feature Request Board and WooCommerce Plugins for Sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/woo-feature-request-board-and-woocommerce-plugins-for-sale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/woo-feature-request-board-and-woocommerce-plugins-for-sale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"<p>In WooBits I amplify a hidden feature request board on Woo.com and 5 WooCommerce premium plugins for sale by our host Katie Keith at Barn2.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Do The Woo Community: The Importance of Product Testing in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/the-importance-of-product-testing-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/the-importance-of-product-testing-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<p>WordPress contributors Pooja, Brian and Anand discuss how product testing is crucial and the learning process behind it. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Content Strategies for Woo and WordPress Businesses with Adam and Emma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/content-strategies-for-woo-and-wordpress-businesses-with-adam-and-emma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/content-strategies-for-woo-and-wordpress-businesses-with-adam-and-emma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"<p>Adam and Emma talking about all things content when it comes to building brand recognition and trust for your Woo and WordPress business.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Do The Woo Community: More Takeaways from State of the Word with Miriam, Nik, Patricia and Mariano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/more-takeaways-from-state-of-the-word-with-miriam-nik-patricia-and-mariano/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/more-takeaways-from-state-of-the-word-with-miriam-nik-patricia-and-mariano/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"<p>One more show with reflections and takeaways from State of the Word 2023.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: AI, Accessibility, Security and Privacy in 2024 with Robbie and Robert\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/ai-accessibility-security-and-privacy-in-2024-with-robbie-and-robert/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/ai-accessibility-security-and-privacy-in-2024-with-robbie-and-robert/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"<p>Hosts Robbie Adair and Robert Jacobi discuss their predictions for 2024, focusing on the acronym ASP: Accessibility, Security, and Privacy</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Gutenberg, the Beginning to the Present with Tammie and Jonathan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/gutenberg-the-beginning-to-the-present-with-tammie-and-jonathan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/gutenberg-the-beginning-to-the-present-with-tammie-and-jonathan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"<p>Hosts Jonathan and Tammie reflect on their experiences with the Gutenberg project in WordPress. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Do The Woo Community: The Future of SEO, Content and AI with Alex Moss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/the-future-of-seo-content-and-ai-with-alex-moss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/the-future-of-seo-content-and-ai-with-alex-moss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"<p>Discover how AI SEO and content creation impacts the future of WordPress and WooCommerce with Dave Lockie and Alex Moss. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Share Your Do the Woo Experience with a Guest Post on the BobWP Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/share-your-do-the-woo-experience-with-a-guest-post-on-the-bobwp-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/share-your-do-the-woo-experience-with-a-guest-post-on-the-bobwp-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<p>If you have been a past sponsor, guest or guest host on our shows, consider a follow-up guest blog post on BobWP.com blog.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Do the Woo is a Sponsor and Media Partner for WordCamp Asia 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/do-the-woo-is-a-sponsor-and-media-partner-for-wordcamp-asia-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/do-the-woo-is-a-sponsor-and-media-partner-for-wordcamp-asia-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"<p>We are returning to WordCamp Asia again, and proud to be a Media Partner again as well as a sponsor for the event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Do The Woo Community: Make. WordPress. Happy.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://dothewoo.io/make-wordpress-happy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://dothewoo.io/make-wordpress-happy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>Starting 2024 on an optimistic note as I noticed more of my fellow WordPressers feeling more optimistic and happy about WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Do The Woo Community: Goodbye 2023 and Hello 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://dothewoo.io/goodbye-2023-and-hello-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://dothewoo.io/goodbye-2023-and-hello-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"<p>As we look at the past year, and what 2024 holds, we are growing even more globally and elevating more voices. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Do The Woo Community: A Post State of the Word Chat with Rocio Valdivia, Pooja Derashri &amp; José Ramón\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/a-post-state-of-the-word-chat-with-rocio-valdivia-pooja-derashri-jose-ramon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/a-post-state-of-the-word-chat-with-rocio-valdivia-pooja-derashri-jose-ramon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"<p>Listen to insights and experiences in the Spanish WordPress community, features and updates announced at SOTW, plus getting involved in the WordPress community. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Do The Woo Community: Resources and Opportunities in WordPress for Speaking, Contributing and Connecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://dothewoo.io/resources-and-opportunities-in-wordpress-for-speaking-contributing-and-connecting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://dothewoo.io/resources-and-opportunities-in-wordpress-for-speaking-contributing-and-connecting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"<p>WordCamp opportunities, supporting underrepresented and connecting the WordPress community with resources and sites.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: A Post Mortem Marketing Analysis of Black Friday aka Stuff You Should Do\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/a-post-mortem-marketing-analysis-of-black-friday-aka-stuff-you-should-do/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/a-post-mortem-marketing-analysis-of-black-friday-aka-stuff-you-should-do/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"<p>Adam and Emma discuss the importance of conducting a post-mortem analysis after a major marketing campaign, such as Black Friday.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: End of the Year Emerging Tech with Kathy Zant and Dave Lockie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/end-of-the-year-emerging-tech-with-kathy-zant-and-dave-lockie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/end-of-the-year-emerging-tech-with-kathy-zant-and-dave-lockie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:295:\"<p>In this episode, Kathy and Dave discuss the influence of AI and blockchain on content creation, the rise of businesses using OpenAI API, and the potential of using blockchain for content authentication. They also explore the options for WordPress content and online identity verification.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: Page Builders, Documentation and an Scaling for Swifties\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/page-builders-documentation-and-an-scaling-for-swifties/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/page-builders-documentation-and-an-scaling-for-swifties/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"<p>A look at a couple of polls on page builders and documentation and the WordPressVIP team preparing for an onslaught of Swifties on Time.com.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: Share a Question or Comment for the Do the Woo End-of-Year Show\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/share-a-question-or-comment-for-the-do-the-woo-end-of-year-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/share-a-question-or-comment-for-the-do-the-woo-end-of-year-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"<p>Want to share your favorite episode, host or show? Perhaps you have a burning question or comment. Here&#8217;s your chance.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Looking at 2023 and Moving into 2024 with Carl and Zach in Woo DevChat\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/looking-at-2023-and-moving-into-2024-with-carl-and-zach-in-woo-devchat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/looking-at-2023-and-moving-into-2024-with-carl-and-zach-in-woo-devchat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"<p>Carl Alexander and Zach Stepek, hosts of Woo DevChat at Do the Woo Podcast, end the year 2023 the only way these two could end a year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"Do The Woo Community: Agency Client Relations, Team Work and Differentiating with Nuno Morgadinho and Jesper Wallmander\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://dothewoo.io/agency-client-relations-team-work-and-differentiating-with-nuno-morgadinho-and-jesper-wallmander/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://dothewoo.io/agency-client-relations-team-work-and-differentiating-with-nuno-morgadinho-and-jesper-wallmander/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:154:\"<p>Nuno Morgadinho from WidgiLabs and Jesper Wallmander from Wallmander Co chat about their experiences and insights into running a WooCommerce Agency</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Growing Meetups at the WordPress Community Day, Roma 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/growing-meetups-at-the-wordpress-community-day-roma-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/growing-meetups-at-the-wordpress-community-day-roma-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:169:\"<p>In this show the organizers for this event share how the idea transpired for the Next-Gen event and the goals to help grow the Italian WordPress meetup community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Rebranding Your WordPress Plugin Business with Robert Abela\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/rebranding-your-wordpress-plugin-business-with-robert-abela/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/rebranding-your-wordpress-plugin-business-with-robert-abela/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"<p>Robert Abela from Melapress shares his story of rebranding his business and also shares some insights into the under-rated user roles in WP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: Do the Woo is Headed to State of the Word 2023 in Madrid\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/do-the-woo-is-headed-to-state-of-the-word-2023-in-madrid/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/do-the-woo-is-headed-to-state-of-the-word-2023-in-madrid/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"<p>BobWP from Do the Woo will once again attend State of the Word. The SOTW 2023 will be in Madrid this year to celebrate Spain&#8217;s WordPress community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: ChatGPT Told Me How I Can Do the Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://dothewoo.io/chatgpt-told-me-how-i-can-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://dothewoo.io/chatgpt-told-me-how-i-can-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"<p>How much can ChatGPT tell me about WooCommerce, and doing the Woo. Well, I found out and am sharing it in this weeks WooBits.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"Do The Woo Community: Working on Different Open Source Platforms and More with Ian Gordon and Philip James Wylie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://dothewoo.io/working-on-different-open-source-platforms-and-more-with-ian-gordon-and-philip-james-wylie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://dothewoo.io/working-on-different-open-source-platforms-and-more-with-ian-gordon-and-philip-james-wylie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"<p>Ian and Philip from Kanuka Digital talk about WooCommerce, Magento, web specializations and the open source community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: The Backstory of the New Woo Branding with David Callaway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/the-backstory-of-the-new-woo-branding-with-david-callaway/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/the-backstory-of-the-new-woo-branding-with-david-callaway/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"<p>David Callaway from Woo.com joins BobWP as they take a deeper dive into the latest WooCommerce branding.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: All Things WordPress 6.4 with Anne McCarthy and Bud Kraus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/all-things-wordpress-6-4-with-anne-mccarthy-and-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/all-things-wordpress-6-4-with-anne-mccarthy-and-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"<p>Anne McCarthy and Bud Kraus join Abha for a chat about the earlier release of WordPress 6.4 filled with insights and experiences from all.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: Meetups and State of the Word Watch Parties with Devin Maeztri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/meetups-and-state-of-the-word-watch-parties-with-devin-maeztri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/meetups-and-state-of-the-word-watch-parties-with-devin-maeztri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"<p>Devin Maeztri joins us as a new host and shares more about meetups and how to put together a State of the Word 2023 watch party.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: WordPress Meetups Have Always Had a Place in My Heart\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/wordpress-meetups-have-always-had-a-place-in-my-heart/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/wordpress-meetups-have-always-had-a-place-in-my-heart/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"<p>A bit of reflection and good feelings seeing more meetups being organized. Plus a teaser for State of the Word and watch parties.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Do The Woo Community: Now is the Time for Passkeys in WordPress, All the Time with Timothy Jacobs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"<p>On Emerging Tech, Timothy Jacobs of SolidWP explores passkeys, a security tech for WordPress. Eliminating passwords, it uses biometric data, ensuring user safety and resisting phishing. Adopted by major firms, passkeys promise enhanced WordPress security.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: Three Years Later, Why Woo Builders?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/three-years-later-why-woo-builders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/three-years-later-why-woo-builders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"<p>It started with Woo builders. And with the expectation of connecting the global community, it continues with Woo and WordPress builders.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: De Nederlandse WordPress Community – The Dutch WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:157:\"<p>In ons programma Community Voices, WordPress Around the World zetten we de Nederlandse gemeenschap in de spotlight voor een gesprek in hun moedertaal.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Do The Woo Community: Keeping Your Site Secure for the Holidays and Beyond with Rob Cairns and Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://dothewoo.io/keeping-your-site-secure-for-the-holidays-and-beyond-with-rob-cairns-and-dan-knauss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://dothewoo.io/keeping-your-site-secure-for-the-holidays-and-beyond-with-rob-cairns-and-dan-knauss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"<p>Rob and Dan discuss the importance of website security, hosting, plugins, backups and two-factor authentication in website security during the holiday season.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Do The Woo Community: WP 6.4, Black Friday, Tumblr, Free Plugins and Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/wp-6-4-black-friday-tumblr-free-plugins-and-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/wp-6-4-black-friday-tumblr-free-plugins-and-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"<p>BobWP mentioning WordPress 6.4, Black Friday deals, Tumblr in the red, free vs. premium plugins and the Woo brand.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: The Challenges of Hosting Difficult Woo Sites Tom Fanelli and Ben Gabler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/the-challenges-of-hosting-difficult-woo-sites-tom-fanelli-and-ben-gabler/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/the-challenges-of-hosting-difficult-woo-sites-tom-fanelli-and-ben-gabler/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"<p>Guests Ben Gabler from Rocket.net and Tom Fanelli from Convesio talk scaling, plugins and coding standards when it comes to performance.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Do The Woo Community: New Woo BizChat Hosts Emma and Adam Dive into Black Friday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/new-woo-bizchat-hosts-emma-and-adam-dive-into-black-friday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/new-woo-bizchat-hosts-emma-and-adam-dive-into-black-friday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"<p>Join our new hosts Emma Young and Adam Weeks for a great conversation and insights into doing sales on Black Friday.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Do The Woo Community: How to Tell Friends and Family What You Do in WordPress with Topher DeRosia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/how-to-tell-friends-and-family-what-you-do-in-wordpress-with-topher-derosia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/how-to-tell-friends-and-family-what-you-do-in-wordpress-with-topher-derosia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"<p>In this show we talk with Topher about explaining what WordPress pros do for a living, the demographics of WordPress and teaching with video.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 15:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 03 Apr 2024 18:13:09 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Wed, 03 Apr 2024 18:00:30 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211220193300\";}", "no");
INSERT INTO `wpcx_options` VALUES("1083", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1712211189", "no");
INSERT INTO `wpcx_options` VALUES("1084", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1712167989", "no");
INSERT INTO `wpcx_options` VALUES("1085", "_transient_timeout_dash_v2_01e18dead815ce736e3b9cccfbd773a5", "1712211189", "no");
INSERT INTO `wpcx_options` VALUES("1086", "_transient_dash_v2_01e18dead815ce736e3b9cccfbd773a5", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://br.wordpress.org/2024/04/02/wordpress-6-5-regina/\'>WordPress 6.5 “Regina”</a></li><li><a class=\'rsswidget\' href=\'https://br.wordpress.org/2024/03/28/wordpress-6-5-release-candidate-4/\'>WordPress 6.5 Release Candidate 4</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/podcast/114-tammie-lister-on-the-journey-through-design-and-theming\'>WPTavern: #114 – Tammie Lister on the Journey Through Design and Theming</a></li><li><a class=\'rsswidget\' href=\'https://dothewoo.io/you-dont-need-to-a-developer-to-join-a-hackathon/\'>Do The Woo Community: You Don’t Need to be a Developer to Join a Hackathon</a></li><li><a class=\'rsswidget\' href=\'https://heropress.com/essays/the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola/#utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola\'>HeroPress: The Time I Left My Island – Quella volta che sono uscito dalla mia isola</a></li></ul></div>", "no");

/* INSERT TABLE DATA: wpcx_postmeta */
INSERT INTO `wpcx_postmeta` VALUES("34", "15", "_wp_attached_file", "2024/02/1-e1707954812198.png");
INSERT INTO `wpcx_postmeta` VALUES("35", "15", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:394;s:4:\"file\";s:28:\"2024/02/1-e1707954812198.png\";s:8:\"filesize\";i:244363;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-300x109.png\";s:5:\"width\";i:300;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39469;}s:5:\"large\";a:5:{s:4:\"file\";s:29:\"1-e1707954812198-1024x374.png\";s:5:\"width\";i:1024;s:6:\"height\";i:374;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:227602;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23890;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-768x280.png\";s:5:\"width\";i:768;s:6:\"height\";i:280;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:153472;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:82108;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:14:\"1-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:246144;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:82921;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:116353;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-400x394.png\";s:5:\"width\";i:400;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:92275;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-980x394.png\";s:5:\"width\";i:980;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:234215;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:28:\"1-e1707954812198-480x270.png\";s:5:\"width\";i:480;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:101490;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("36", "16", "_wp_attached_file", "2024/02/2.png");
INSERT INTO `wpcx_postmeta` VALUES("37", "16", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:4:\"file\";s:13:\"2024/02/2.png\";s:8:\"filesize\";i:816095;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:84623;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"2-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:695823;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25760;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:13:\"2-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:429143;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:13:\"2-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:88951;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:14:\"2-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:521954;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:13:\"2-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:102308;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:13:\"2-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:164749;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:13:\"2-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:214155;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:13:\"2-980x980.png\";s:5:\"width\";i:980;s:6:\"height\";i:980;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:645546;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:13:\"2-480x480.png\";s:5:\"width\";i:480;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:191675;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("43", "15", "_wp_attachment_backup_sizes", "a:12:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:4:\"file\";s:5:\"1.png\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:13:\"1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14157;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:13:\"1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:40927;}s:17:\"medium_large-orig\";a:5:{s:4:\"file\";s:13:\"1-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:158264;}s:10:\"large-orig\";a:5:{s:4:\"file\";s:15:\"1-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:233699;}s:26:\"et-pb-post-main-image-orig\";a:5:{s:4:\"file\";s:13:\"1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:61965;}s:36:\"et-pb-post-main-image-fullwidth-orig\";a:5:{s:4:\"file\";s:14:\"1-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:246144;}s:26:\"et-pb-portfolio-image-orig\";a:5:{s:4:\"file\";s:13:\"1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62106;}s:33:\"et-pb-portfolio-module-image-orig\";a:5:{s:4:\"file\";s:13:\"1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:89090;}s:40:\"et-pb-gallery-module-image-portrait-orig\";a:5:{s:4:\"file\";s:13:\"1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:75821;}s:36:\"et-pb-image--responsive--tablet-orig\";a:5:{s:4:\"file\";s:13:\"1-980x980.png\";s:5:\"width\";i:980;s:6:\"height\";i:980;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:219009;}s:35:\"et-pb-image--responsive--phone-orig\";a:5:{s:4:\"file\";s:13:\"1-480x480.png\";s:5:\"width\";i:480;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:81877;}}");
INSERT INTO `wpcx_postmeta` VALUES("48", "18", "_wp_attached_file", "2024/02/instagram.svg");
INSERT INTO `wpcx_postmeta` VALUES("49", "18", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2024/02/instagram.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"instagram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("50", "19", "_wp_attached_file", "2024/02/mail.svg");
INSERT INTO `wpcx_postmeta` VALUES("51", "19", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:16:\"2024/02/mail.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:8:\"mail.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("52", "20", "_wp_attached_file", "2024/02/viber.svg");
INSERT INTO `wpcx_postmeta` VALUES("53", "20", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:17:\"2024/02/viber.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:9:\"viber.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("54", "21", "_wp_attached_file", "2024/02/whatsapp.svg");
INSERT INTO `wpcx_postmeta` VALUES("55", "21", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2024/02/whatsapp.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"whatsapp.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("56", "22", "_wp_attached_file", "2024/02/telegram.svg");
INSERT INTO `wpcx_postmeta` VALUES("57", "22", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2024/02/telegram.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"telegram.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("58", "23", "_wp_attached_file", "2024/02/facebook.svg");
INSERT INTO `wpcx_postmeta` VALUES("59", "23", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:88;s:6:\"height\";i:88;s:4:\"file\";s:20:\"2024/02/facebook.svg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:12:\"facebook.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("60", "24", "_wp_attached_file", "2024/02/jivo_main.en_.webp");
INSERT INTO `wpcx_postmeta` VALUES("61", "24", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1090;s:6:\"height\";i:698;s:4:\"file\";s:26:\"2024/02/jivo_main.en_.webp\";s:8:\"filesize\";i:64514;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-300x192.webp\";s:5:\"width\";i:300;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7444;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"jivo_main.en_-1024x656.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:656;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:46590;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:3470;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-768x492.webp\";s:5:\"width\";i:768;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:30592;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-400x250.webp\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11118;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:27:\"jivo_main.en_-1080x675.webp\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:48032;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-400x284.webp\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12900;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-510x382.webp\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:18702;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:27:\"jivo_main.en_-1080x692.webp\";s:5:\"width\";i:1080;s:6:\"height\";i:692;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:50228;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-400x516.webp\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16776;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-980x628.webp\";s:5:\"width\";i:980;s:6:\"height\";i:628;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:43800;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:26:\"jivo_main.en_-480x307.webp\";s:5:\"width\";i:480;s:6:\"height\";i:307;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14968;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("116", "43", "_wp_attached_file", "2024/02/sdk.webp");
INSERT INTO `wpcx_postmeta` VALUES("117", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:465;s:6:\"height\";i:203;s:4:\"file\";s:16:\"2024/02/sdk.webp\";s:8:\"filesize\";i:12780;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"sdk-300x131.webp\";s:5:\"width\";i:300;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16564;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"sdk-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10872;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:13:\"sdk-18x8.webp\";s:5:\"width\";i:18;s:6:\"height\";i:8;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:526;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:16:\"sdk-400x203.webp\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12254;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:16:\"sdk-400x203.webp\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12254;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:16:\"sdk-400x203.webp\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12254;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("130", "48", "_wp_attached_file", "2024/02/en-logo-7.svg");
INSERT INTO `wpcx_postmeta` VALUES("131", "48", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:185;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-7.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-7.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("132", "49", "_wp_attached_file", "2024/02/en-logo-6.svg");
INSERT INTO `wpcx_postmeta` VALUES("133", "49", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:210;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-6.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-6.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("134", "50", "_wp_attached_file", "2024/02/en-logo-5.svg");
INSERT INTO `wpcx_postmeta` VALUES("135", "50", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:156;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-5.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-5.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("136", "51", "_wp_attached_file", "2024/02/en-logo-4.svg");
INSERT INTO `wpcx_postmeta` VALUES("137", "51", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:135;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-4.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-4.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("138", "52", "_wp_attached_file", "2024/02/en-logo-3.svg");
INSERT INTO `wpcx_postmeta` VALUES("139", "52", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:137;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-3.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-3.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("140", "53", "_wp_attached_file", "2024/02/en-logo-2.svg");
INSERT INTO `wpcx_postmeta` VALUES("141", "53", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:167;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-2.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-2.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("142", "54", "_wp_attached_file", "2024/02/en-logo-1.svg");
INSERT INTO `wpcx_postmeta` VALUES("143", "54", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:187;s:6:\"height\";i:58;s:4:\"file\";s:21:\"2024/02/en-logo-1.svg\";s:5:\"sizes\";a:17:{s:9:\"thumbnail\";a:5:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";s:1:\"1\";s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:6:\"medium\";a:5:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:12:\"medium_large\";a:5:{s:5:\"width\";s:3:\"768\";s:6:\"height\";s:1:\"0\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:5:\"large\";a:5:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"1536x1536\";a:5:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:9:\"2048x2048\";a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:24:\"trp-custom-language-flag\";a:5:{s:5:\"width\";i:18;s:6:\"height\";i:12;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-post-main-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:250;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:675;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:21:\"et-pb-portfolio-image\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:284;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-module-image\";a:5:{s:5:\"width\";i:510;s:6:\"height\";i:382;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:28:\"et-pb-portfolio-image-single\";a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:9999;s:4:\"crop\";i:0;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:5:\"width\";i:400;s:6:\"height\";i:516;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:5:\"width\";i:980;s:6:\"height\";i:551;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}s:30:\"et-pb-image--responsive--phone\";a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"crop\";i:1;s:4:\"file\";s:13:\"en-logo-1.svg\";s:9:\"mime-type\";s:13:\"image/svg+xml\";}}}");
INSERT INTO `wpcx_postmeta` VALUES("156", "57", "_menu_item_type", "custom");
INSERT INTO `wpcx_postmeta` VALUES("157", "57", "_menu_item_menu_item_parent", "0");
INSERT INTO `wpcx_postmeta` VALUES("158", "57", "_menu_item_object_id", "57");
INSERT INTO `wpcx_postmeta` VALUES("159", "57", "_menu_item_object", "custom");
INSERT INTO `wpcx_postmeta` VALUES("160", "57", "_menu_item_target", "");
INSERT INTO `wpcx_postmeta` VALUES("161", "57", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wpcx_postmeta` VALUES("162", "57", "_menu_item_xfn", "");
INSERT INTO `wpcx_postmeta` VALUES("163", "57", "_menu_item_url", "#api");
INSERT INTO `wpcx_postmeta` VALUES("165", "58", "_menu_item_type", "custom");
INSERT INTO `wpcx_postmeta` VALUES("166", "58", "_menu_item_menu_item_parent", "0");
INSERT INTO `wpcx_postmeta` VALUES("167", "58", "_menu_item_object_id", "58");
INSERT INTO `wpcx_postmeta` VALUES("168", "58", "_menu_item_object", "custom");
INSERT INTO `wpcx_postmeta` VALUES("169", "58", "_menu_item_target", "");
INSERT INTO `wpcx_postmeta` VALUES("170", "58", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wpcx_postmeta` VALUES("171", "58", "_menu_item_xfn", "");
INSERT INTO `wpcx_postmeta` VALUES("172", "58", "_menu_item_url", "#integration");
INSERT INTO `wpcx_postmeta` VALUES("174", "59", "_menu_item_type", "custom");
INSERT INTO `wpcx_postmeta` VALUES("175", "59", "_menu_item_menu_item_parent", "0");
INSERT INTO `wpcx_postmeta` VALUES("176", "59", "_menu_item_object_id", "59");
INSERT INTO `wpcx_postmeta` VALUES("177", "59", "_menu_item_object", "custom");
INSERT INTO `wpcx_postmeta` VALUES("178", "59", "_menu_item_target", "");
INSERT INTO `wpcx_postmeta` VALUES("179", "59", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wpcx_postmeta` VALUES("180", "59", "_menu_item_xfn", "");
INSERT INTO `wpcx_postmeta` VALUES("181", "59", "_menu_item_url", "#savetime");
INSERT INTO `wpcx_postmeta` VALUES("195", "64", "_edit_lock", "1708046648:1");
INSERT INTO `wpcx_postmeta` VALUES("197", "64", "_et_pb_use_builder", "on");
INSERT INTO `wpcx_postmeta` VALUES("198", "64", "_et_gb_content_width", "");
INSERT INTO `wpcx_postmeta` VALUES("199", "64", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("200", "65", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("201", "64", "_edit_last", "1");
INSERT INTO `wpcx_postmeta` VALUES("202", "64", "_et_pb_post_hide_nav", "default");
INSERT INTO `wpcx_postmeta` VALUES("203", "64", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `wpcx_postmeta` VALUES("204", "64", "_et_pb_side_nav", "off");
INSERT INTO `wpcx_postmeta` VALUES("206", "66", "_wp_attached_file", "2024/02/ai-49c.jpg");
INSERT INTO `wpcx_postmeta` VALUES("207", "66", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:700;s:4:\"file\";s:18:\"2024/02/ai-49c.jpg\";s:8:\"filesize\";i:14927;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"ai-49c-300x105.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:105;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1841;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"ai-49c-1024x358.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:358;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9511;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"ai-49c-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:893;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"ai-49c-768x269.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:269;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6171;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:19:\"ai-49c-1536x538.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:538;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17164;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:15:\"ai-49c-18x6.jpg\";s:5:\"width\";i:18;s:6:\"height\";i:6;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:335;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:18:\"ai-49c-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2476;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:19:\"ai-49c-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10231;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:18:\"ai-49c-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2554;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:18:\"ai-49c-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3586;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:19:\"ai-49c-1080x378.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:378;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10312;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:18:\"ai-49c-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2925;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:19:\"ai-49c-1280x448.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:448;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13098;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:18:\"ai-49c-980x343.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:343;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8921;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:18:\"ai-49c-480x168.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3241;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("208", "67", "_wp_attached_file", "2024/02/divi-logo-gradient.png");
INSERT INTO `wpcx_postmeta` VALUES("209", "67", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:160;s:6:\"height\";i:160;s:4:\"file\";s:30:\"2024/02/divi-logo-gradient.png\";s:8:\"filesize\";i:6211;s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"divi-logo-gradient-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12950;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:28:\"divi-logo-gradient-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:484;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("210", "68", "_wp_attached_file", "2024/02/head-1.png");
INSERT INTO `wpcx_postmeta` VALUES("211", "68", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:562;s:4:\"file\";s:18:\"2024/02/head-1.png\";s:8:\"filesize\";i:66168;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"head-1-300x281.png\";s:5:\"width\";i:300;s:6:\"height\";i:281;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:89922;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"head-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:31793;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:16:\"head-1-13x12.png\";s:5:\"width\";i:13;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:539;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:18:\"head-1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:118489;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:18:\"head-1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:131683;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:18:\"head-1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:221341;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:18:\"head-1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:249467;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:18:\"head-1-480x450.png\";s:5:\"width\";i:480;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:217866;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("212", "69", "_wp_attached_file", "2024/02/brain-1.png");
INSERT INTO `wpcx_postmeta` VALUES("213", "69", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1002;s:4:\"file\";s:19:\"2024/02/brain-1.png\";s:8:\"filesize\";i:195323;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"brain-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:128127;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"brain-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:37604;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"brain-1-768x770.png\";s:5:\"width\";i:768;s:6:\"height\";i:770;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:764781;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:17:\"brain-1-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:579;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:19:\"brain-1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:142422;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:20:\"brain-1-1000x675.png\";s:5:\"width\";i:1000;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:470749;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:19:\"brain-1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:160055;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:19:\"brain-1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:265700;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:19:\"brain-1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:301990;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:19:\"brain-1-980x982.png\";s:5:\"width\";i:980;s:6:\"height\";i:982;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1223661;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:19:\"brain-1-480x481.png\";s:5:\"width\";i:480;s:6:\"height\";i:481;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:291872;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("214", "70", "_wp_attached_file", "2024/02/grid-bg-2.png");
INSERT INTO `wpcx_postmeta` VALUES("215", "70", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1598;s:6:\"height\";i:1300;s:4:\"file\";s:21:\"2024/02/grid-bg-2.png\";s:8:\"filesize\";i:12627;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-300x244.png\";s:5:\"width\";i:300;s:6:\"height\";i:244;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2624;}s:5:\"large\";a:5:{s:4:\"file\";s:22:\"grid-bg-2-1024x833.png\";s:5:\"width\";i:1024;s:6:\"height\";i:833;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10041;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1398;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-768x625.png\";s:5:\"width\";i:768;s:6:\"height\";i:625;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7542;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"grid-bg-2-1536x1250.png\";s:5:\"width\";i:1536;s:6:\"height\";i:1250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16793;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:19:\"grid-bg-2-15x12.png\";s:5:\"width\";i:15;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:217;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2374;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:22:\"grid-bg-2-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8749;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2884;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4398;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:22:\"grid-bg-2-1080x879.png\";s:5:\"width\";i:1080;s:6:\"height\";i:879;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11430;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3965;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:23:\"grid-bg-2-1280x1041.png\";s:5:\"width\";i:1280;s:6:\"height\";i:1041;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13056;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-980x797.png\";s:5:\"width\";i:980;s:6:\"height\";i:797;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8542;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:21:\"grid-bg-2-480x390.png\";s:5:\"width\";i:480;s:6:\"height\";i:390;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3727;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("216", "71", "_wp_attached_file", "2024/02/ai-icon-03.png");
INSERT INTO `wpcx_postmeta` VALUES("217", "71", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:22:\"2024/02/ai-icon-03.png\";s:8:\"filesize\";i:2728;s:5:\"sizes\";a:1:{s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:20:\"ai-icon-03-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:463;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("218", "72", "_wp_attached_file", "2024/02/grid-bg-1.png");
INSERT INTO `wpcx_postmeta` VALUES("219", "72", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1300;s:6:\"height\";i:1000;s:4:\"file\";s:21:\"2024/02/grid-bg-1.png\";s:8:\"filesize\";i:8625;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-300x231.png\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2487;}s:5:\"large\";a:5:{s:4:\"file\";s:22:\"grid-bg-1-1024x788.png\";s:5:\"width\";i:1024;s:6:\"height\";i:788;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8715;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:924;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-768x591.png\";s:5:\"width\";i:768;s:6:\"height\";i:591;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6443;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:19:\"grid-bg-1-16x12.png\";s:5:\"width\";i:16;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:269;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2948;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:22:\"grid-bg-1-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9238;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3017;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4595;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:22:\"grid-bg-1-1080x831.png\";s:5:\"width\";i:1080;s:6:\"height\";i:831;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9964;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4434;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:22:\"grid-bg-1-1280x985.png\";s:5:\"width\";i:1280;s:6:\"height\";i:985;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11807;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-980x754.png\";s:5:\"width\";i:980;s:6:\"height\";i:754;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8113;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:21:\"grid-bg-1-480x369.png\";s:5:\"width\";i:480;s:6:\"height\";i:369;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4243;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("220", "73", "_wp_attached_file", "2024/02/eye-bg-1.png");
INSERT INTO `wpcx_postmeta` VALUES("221", "73", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2340;s:6:\"height\";i:954;s:4:\"file\";s:20:\"2024/02/eye-bg-1.png\";s:8:\"filesize\";i:127458;s:5:\"sizes\";a:16:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-300x122.png\";s:5:\"width\";i:300;s:6:\"height\";i:122;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12812;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-1024x417.png\";s:5:\"width\";i:1024;s:6:\"height\";i:417;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:92453;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1660;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-768x313.png\";s:5:\"width\";i:768;s:6:\"height\";i:313;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:57887;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-1536x626.png\";s:5:\"width\";i:1536;s:6:\"height\";i:626;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:185145;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-2048x835.png\";s:5:\"width\";i:2048;s:6:\"height\";i:835;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:310415;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:17:\"eye-bg-1-18x7.png\";s:5:\"width\";i:18;s:6:\"height\";i:7;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:259;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17906;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:92412;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13421;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17621;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-1080x440.png\";s:5:\"width\";i:1080;s:6:\"height\";i:440;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:101021;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2297;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:21:\"eye-bg-1-1280x522.png\";s:5:\"width\";i:1280;s:6:\"height\";i:522;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:136005;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-980x400.png\";s:5:\"width\";i:980;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:85688;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:20:\"eye-bg-1-480x196.png\";s:5:\"width\";i:480;s:6:\"height\";i:196;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26710;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("222", "74", "_wp_attached_file", "2024/02/ai-icon-06.png");
INSERT INTO `wpcx_postmeta` VALUES("223", "74", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:22:\"2024/02/ai-icon-06.png\";s:8:\"filesize\";i:2748;s:5:\"sizes\";a:1:{s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:20:\"ai-icon-06-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:486;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("224", "75", "_wp_attached_file", "2024/02/ai-icon-05.png");
INSERT INTO `wpcx_postmeta` VALUES("225", "75", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:22:\"2024/02/ai-icon-05.png\";s:8:\"filesize\";i:2431;s:5:\"sizes\";a:1:{s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:20:\"ai-icon-05-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:438;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("226", "76", "_wp_attached_file", "2024/02/ai-icon-04.png");
INSERT INTO `wpcx_postmeta` VALUES("227", "76", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:22:\"2024/02/ai-icon-04.png\";s:8:\"filesize\";i:2590;s:5:\"sizes\";a:1:{s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:20:\"ai-icon-04-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:495;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("228", "77", "_wp_attached_file", "2024/02/eye.png");
INSERT INTO `wpcx_postmeta` VALUES("229", "77", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:773;s:4:\"file\";s:15:\"2024/02/eye.png\";s:8:\"filesize\";i:101045;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"eye-300x290.png\";s:5:\"width\";i:300;s:6:\"height\";i:290;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:85151;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"eye-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29494;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"eye-768x742.png\";s:5:\"width\";i:768;s:6:\"height\";i:742;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:475975;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:13:\"eye-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:526;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:15:\"eye-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:105080;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:15:\"eye-800x675.png\";s:5:\"width\";i:800;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:272453;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:15:\"eye-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:116654;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:15:\"eye-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:193139;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:15:\"eye-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:209486;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:15:\"eye-480x464.png\";s:5:\"width\";i:480;s:6:\"height\";i:464;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:195217;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("231", "64", "_et_pb_built_for_post_type", "page");
INSERT INTO `wpcx_postmeta` VALUES("232", "79", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("233", "64", "_et_pb_ab_subjects", "");
INSERT INTO `wpcx_postmeta` VALUES("234", "64", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `wpcx_postmeta` VALUES("235", "64", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"64\" /]");
INSERT INTO `wpcx_postmeta` VALUES("236", "64", "_et_pb_custom_css", "");
INSERT INTO `wpcx_postmeta` VALUES("237", "64", "_et_pb_gutter_width", "3");
INSERT INTO `wpcx_postmeta` VALUES("238", "64", "_thumbnail_id", "121");
INSERT INTO `wpcx_postmeta` VALUES("239", "64", "_global_colors_info", "{}");
INSERT INTO `wpcx_postmeta` VALUES("240", "64", "_et_pb_first_image", "");
INSERT INTO `wpcx_postmeta` VALUES("241", "64", "_et_pb_truncate_post", "");
INSERT INTO `wpcx_postmeta` VALUES("242", "64", "_et_pb_truncate_post_date", "");
INSERT INTO `wpcx_postmeta` VALUES("243", "64", "_et_builder_version", "VB|Divi|4.24.2");
INSERT INTO `wpcx_postmeta` VALUES("244", "64", "_et_pb_show_page_creation", "off");
INSERT INTO `wpcx_postmeta` VALUES("252", "81", "_wp_attached_file", "2024/02/global-connection-x-robo-sem-fundo.png");
INSERT INTO `wpcx_postmeta` VALUES("253", "81", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2044;s:6:\"height\";i:2765;s:4:\"file\";s:46:\"2024/02/global-connection-x-robo-sem-fundo.png\";s:8:\"filesize\";i:4778449;s:5:\"sizes\";a:17:{s:6:\"medium\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-222x300.png\";s:5:\"width\";i:222;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:86535;}s:5:\"large\";a:5:{s:4:\"file\";s:47:\"global-connection-x-robo-sem-fundo-757x1024.png\";s:5:\"width\";i:757;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:699258;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33375;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:47:\"global-connection-x-robo-sem-fundo-768x1039.png\";s:5:\"width\";i:768;s:6:\"height\";i:1039;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:717487;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:48:\"global-connection-x-robo-sem-fundo-1135x1536.png\";s:5:\"width\";i:1135;s:6:\"height\";i:1536;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1394490;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:48:\"global-connection-x-robo-sem-fundo-1514x2048.png\";s:5:\"width\";i:1514;s:6:\"height\";i:2048;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2249321;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:43:\"global-connection-x-robo-sem-fundo-9x12.png\";s:5:\"width\";i:9;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:512;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:98117;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:47:\"global-connection-x-robo-sem-fundo-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:544437;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:119555;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:194438;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:48:\"global-connection-x-robo-sem-fundo-1080x1461.png\";s:5:\"width\";i:1080;s:6:\"height\";i:1461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1283480;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:226676;}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:4:\"file\";s:48:\"global-connection-x-robo-sem-fundo-2044x1800.png\";s:5:\"width\";i:2044;s:6:\"height\";i:1800;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2541133;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:48:\"global-connection-x-robo-sem-fundo-1280x1732.png\";s:5:\"width\";i:1280;s:6:\"height\";i:1732;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1704159;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:47:\"global-connection-x-robo-sem-fundo-980x1326.png\";s:5:\"width\";i:980;s:6:\"height\";i:1326;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1086157;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:46:\"global-connection-x-robo-sem-fundo-480x649.png\";s:5:\"width\";i:480;s:6:\"height\";i:649;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321778;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("254", "82", "_wp_attached_file", "2024/02/Ativo-2@4x.png");
INSERT INTO `wpcx_postmeta` VALUES("255", "82", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:7458;s:6:\"height\";i:2222;s:4:\"file\";s:22:\"2024/02/Ativo-2@4x.png\";s:8:\"filesize\";i:257961;s:5:\"sizes\";a:17:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"Ativo-2@4x-300x89.png\";s:5:\"width\";i:300;s:6:\"height\";i:89;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10969;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-1024x305.png\";s:5:\"width\";i:1024;s:6:\"height\";i:305;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41452;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5769;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-768x229.png\";s:5:\"width\";i:768;s:6:\"height\";i:229;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30279;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-1536x458.png\";s:5:\"width\";i:1536;s:6:\"height\";i:458;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:65139;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-2048x610.png\";s:5:\"width\";i:2048;s:6:\"height\";i:610;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:89893;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:19:\"Ativo-2@4x-18x5.png\";s:5:\"width\";i:18;s:6:\"height\";i:5;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:275;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13948;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42455;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13961;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18400;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-1080x322.png\";s:5:\"width\";i:1080;s:6:\"height\";i:322;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44306;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15554;}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:4:\"file\";s:24:\"Ativo-2@4x-2880x1800.png\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:127781;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:23:\"Ativo-2@4x-1280x381.png\";s:5:\"width\";i:1280;s:6:\"height\";i:381;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:52739;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-980x292.png\";s:5:\"width\";i:980;s:6:\"height\";i:292;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39463;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:22:\"Ativo-2@4x-480x143.png\";s:5:\"width\";i:480;s:6:\"height\";i:143;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18477;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("257", "64", "_et_builder_dynamic_assets_loading_attr_threshold", "3");
INSERT INTO `wpcx_postmeta` VALUES("268", "84", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("278", "88", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("280", "90", "_wp_attached_file", "2024/02/global.png");
INSERT INTO `wpcx_postmeta` VALUES("281", "90", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:453;s:6:\"height\";i:203;s:4:\"file\";s:18:\"2024/02/global.png\";s:8:\"filesize\";i:24434;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"global-300x134.png\";s:5:\"width\";i:300;s:6:\"height\";i:134;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25310;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"global-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14900;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:15:\"global-18x8.png\";s:5:\"width\";i:18;s:6:\"height\";i:8;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:527;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:18:\"global-400x203.png\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35433;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:18:\"global-400x203.png\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35433;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:18:\"global-400x203.png\";s:5:\"width\";i:400;s:6:\"height\";i:203;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35433;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("282", "91", "_wp_attached_file", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone.jpg");
INSERT INTO `wpcx_postmeta` VALUES("283", "91", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1500;s:6:\"height\";i:2000;s:4:\"file\";s:72:\"2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone.jpg\";s:8:\"filesize\";i:867731;s:5:\"sizes\";a:16:{s:6:\"medium\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16252;}s:5:\"large\";a:5:{s:4:\"file\";s:73:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91664;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7867;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:73:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91664;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1152x1536.jpg\";s:5:\"width\";i:1152;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:166835;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:69:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-9x12.jpg\";s:5:\"width\";i:9;s:6:\"height\";i:12;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1339;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17469;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:73:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68720;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20108;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29730;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:151479;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35512;}s:37:\"et-pb-post-main-image-fullwidth-large\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1500x1800.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:248683;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1280x1707.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:195409;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:73:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-980x1307.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:1307;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:133066;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:72:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-480x640.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46004;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("284", "92", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("290", "94", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("295", "95", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("304", "96", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("309", "97", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("314", "98", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("319", "99", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("328", "100", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("333", "101", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("339", "103", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("346", "64", "_wp_page_template", "page-template-blank.php");
INSERT INTO `wpcx_postmeta` VALUES("347", "104", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("352", "105", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("359", "106", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("364", "107", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("379", "57", "_wp_old_date", "2024-02-14");
INSERT INTO `wpcx_postmeta` VALUES("380", "58", "_wp_old_date", "2024-02-14");
INSERT INTO `wpcx_postmeta` VALUES("381", "59", "_wp_old_date", "2024-02-14");
INSERT INTO `wpcx_postmeta` VALUES("385", "111", "_menu_item_type", "post_type");
INSERT INTO `wpcx_postmeta` VALUES("386", "111", "_menu_item_menu_item_parent", "0");
INSERT INTO `wpcx_postmeta` VALUES("387", "111", "_menu_item_object_id", "64");
INSERT INTO `wpcx_postmeta` VALUES("388", "111", "_menu_item_object", "page");
INSERT INTO `wpcx_postmeta` VALUES("389", "111", "_menu_item_target", "");
INSERT INTO `wpcx_postmeta` VALUES("390", "111", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wpcx_postmeta` VALUES("391", "111", "_menu_item_xfn", "");
INSERT INTO `wpcx_postmeta` VALUES("392", "111", "_menu_item_url", "");
INSERT INTO `wpcx_postmeta` VALUES("394", "112", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("400", "114", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("413", "119", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("418", "120", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("423", "121", "_wp_attached_file", "2024/02/favicon.png");
INSERT INTO `wpcx_postmeta` VALUES("424", "121", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:19:\"2024/02/favicon.png\";s:8:\"filesize\";i:13540;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14491;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6562;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:17:\"favicon-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:356;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:19:\"favicon-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14987;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:19:\"favicon-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16671;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:19:\"favicon-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22558;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:19:\"favicon-400x512.png\";s:5:\"width\";i:400;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19957;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:19:\"favicon-480x480.png\";s:5:\"width\";i:480;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24985;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("425", "122", "_wp_attached_file", "2024/02/cropped-favicon.png");
INSERT INTO `wpcx_postmeta` VALUES("426", "122", "_wp_attachment_context", "site-icon");
INSERT INTO `wpcx_postmeta` VALUES("427", "122", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2024/02/cropped-favicon.png\";s:8:\"filesize\";i:25537;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14491;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6562;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:25:\"cropped-favicon-12x12.png\";s:5:\"width\";i:12;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:356;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14987;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16671;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22558;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-400x512.png\";s:5:\"width\";i:400;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19957;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-480x480.png\";s:5:\"width\";i:480;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24985;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12848;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8714;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8028;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:25:\"cropped-favicon-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1183;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("434", "124", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("450", "64", "_yoast_wpseo_focuskw", "chat");
INSERT INTO `wpcx_postmeta` VALUES("451", "64", "_yoast_wpseo_title", "%%page%% %%sitename%%");
INSERT INTO `wpcx_postmeta` VALUES("452", "64", "_yoast_wpseo_metadesc", "The Future with ChatBot - Collect all communication channels in one place: chat, social networks, instant messengers and phone calls.");
INSERT INTO `wpcx_postmeta` VALUES("453", "64", "_yoast_wpseo_linkdex", "56");
INSERT INTO `wpcx_postmeta` VALUES("454", "64", "_yoast_wpseo_content_score", "90");
INSERT INTO `wpcx_postmeta` VALUES("455", "64", "_yoast_wpseo_estimated-reading-time-minutes", "6");
INSERT INTO `wpcx_postmeta` VALUES("456", "64", "_yoast_wpseo_wordproof_timestamp", "");
INSERT INTO `wpcx_postmeta` VALUES("457", "64", "_yoast_wpseo_opengraph-title", "Global ConnectionX");
INSERT INTO `wpcx_postmeta` VALUES("458", "64", "_yoast_wpseo_opengraph-description", "Collect all communication channels in one place: chat, social networks, instant messengers and phone calls. Engage with customers using their preferred channel");
INSERT INTO `wpcx_postmeta` VALUES("459", "64", "_yoast_wpseo_opengraph-image", "https://connectionx.sousalimaconsultoria.com.br/wp-content/uploads/2024/02/favicon-300x300.png");
INSERT INTO `wpcx_postmeta` VALUES("460", "64", "_yoast_wpseo_opengraph-image-id", "121");
INSERT INTO `wpcx_postmeta` VALUES("465", "128", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("494", "129", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("495", "129", "gfw_label", "");
INSERT INTO `wpcx_postmeta` VALUES("496", "129", "gfw_location", "6");
INSERT INTO `wpcx_postmeta` VALUES("497", "129", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("498", "129", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("499", "129", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("500", "129", "gtmetrix_test_id", "Jq1LslEC");
INSERT INTO `wpcx_postmeta` VALUES("501", "129", "page_load_time", "17593");
INSERT INTO `wpcx_postmeta` VALUES("502", "129", "fully_loaded_time", "18070");
INSERT INTO `wpcx_postmeta` VALUES("503", "129", "html_bytes", "23175");
INSERT INTO `wpcx_postmeta` VALUES("504", "129", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("505", "129", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/dicz172P/");
INSERT INTO `wpcx_postmeta` VALUES("506", "129", "html_load_time", "3034");
INSERT INTO `wpcx_postmeta` VALUES("507", "129", "page_bytes", "6633998");
INSERT INTO `wpcx_postmeta` VALUES("508", "129", "pagespeed_score", "16");
INSERT INTO `wpcx_postmeta` VALUES("509", "129", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("510", "130", "_wp_attached_file", "2024/02/global-connection-x-robo.png");
INSERT INTO `wpcx_postmeta` VALUES("511", "130", "litespeed-optimize-set", "150x150\n300x300\n768x0\n1024x1024\n1536x1536\n2048x2048\n18x12\n400x250\n1080x675\n400x284\n510x382\n1080x9999\n400x516\n2880x1800\n1280x720\n980x551\n480x270");
INSERT INTO `wpcx_postmeta` VALUES("512", "130", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:798;s:6:\"height\";i:1080;s:4:\"file\";s:36:\"2024/02/global-connection-x-robo.png\";s:8:\"filesize\";i:321850;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-222x300.png\";s:5:\"width\";i:222;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:86324;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"global-connection-x-robo-757x1024.png\";s:5:\"width\";i:757;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:648191;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33441;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:37:\"global-connection-x-robo-768x1039.png\";s:5:\"width\";i:768;s:6:\"height\";i:1039;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:660956;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:33:\"global-connection-x-robo-9x12.png\";s:5:\"width\";i:9;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:512;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:94875;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-798x675.png\";s:5:\"width\";i:798;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:370554;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:115903;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:187581;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:221987;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-480x650.png\";s:5:\"width\";i:480;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:312936;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("514", "132", "_wp_attached_file", "2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1.jpg");
INSERT INTO `wpcx_postmeta` VALUES("515", "132", "litespeed-optimize-set", "150x150\n300x300\n768x0\n1024x1024\n1536x1536\n2048x2048\n18x12\n400x250\n1080x675\n400x284\n510x382\n1080x9999\n400x516\n2880x1800\n1280x720\n980x551\n480x270");
INSERT INTO `wpcx_postmeta` VALUES("516", "132", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:74:\"2024/02/uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1.jpg\";s:8:\"filesize\";i:25411;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11870;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5797;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:71:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-9x12.jpg\";s:5:\"width\";i:9;s:6:\"height\";i:12;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:856;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12750;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14745;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-450x382.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22712;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:74:\"uso-de-aplicativos-para-fazer-amigos-conceito-com-smartphone-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26057;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wpcx_postmeta` VALUES("517", "133", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("522", "134", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("523", "134", "gfw_label", "");
INSERT INTO `wpcx_postmeta` VALUES("524", "134", "gfw_location", "6");
INSERT INTO `wpcx_postmeta` VALUES("525", "134", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("526", "134", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("527", "134", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("528", "134", "gtmetrix_test_id", "cvk2geq9");
INSERT INTO `wpcx_postmeta` VALUES("529", "134", "page_load_time", "4182");
INSERT INTO `wpcx_postmeta` VALUES("530", "134", "fully_loaded_time", "4224");
INSERT INTO `wpcx_postmeta` VALUES("531", "134", "html_bytes", "23172");
INSERT INTO `wpcx_postmeta` VALUES("532", "134", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("533", "134", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/IH93CZL3/");
INSERT INTO `wpcx_postmeta` VALUES("534", "134", "html_load_time", "3051");
INSERT INTO `wpcx_postmeta` VALUES("535", "134", "page_bytes", "1335149");
INSERT INTO `wpcx_postmeta` VALUES("536", "134", "pagespeed_score", "69");
INSERT INTO `wpcx_postmeta` VALUES("537", "134", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("538", "135", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("539", "135", "gfw_label", "");
INSERT INTO `wpcx_postmeta` VALUES("540", "135", "gfw_location", "6");
INSERT INTO `wpcx_postmeta` VALUES("541", "135", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("542", "135", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("543", "135", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("544", "135", "gtmetrix_test_id", "Z3KjnNWi");
INSERT INTO `wpcx_postmeta` VALUES("545", "135", "page_load_time", "3718");
INSERT INTO `wpcx_postmeta` VALUES("546", "135", "fully_loaded_time", "3765");
INSERT INTO `wpcx_postmeta` VALUES("547", "135", "html_bytes", "23200");
INSERT INTO `wpcx_postmeta` VALUES("548", "135", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("549", "135", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/sYyfFTVw/");
INSERT INTO `wpcx_postmeta` VALUES("550", "135", "html_load_time", "3028");
INSERT INTO `wpcx_postmeta` VALUES("551", "135", "page_bytes", "1335210");
INSERT INTO `wpcx_postmeta` VALUES("552", "135", "pagespeed_score", "68");
INSERT INTO `wpcx_postmeta` VALUES("553", "135", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("554", "136", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("555", "136", "gfw_label", "");
INSERT INTO `wpcx_postmeta` VALUES("556", "136", "gfw_location", "4");
INSERT INTO `wpcx_postmeta` VALUES("557", "136", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("558", "136", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("559", "136", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("560", "136", "gtmetrix_test_id", "4ymDtead");
INSERT INTO `wpcx_postmeta` VALUES("561", "136", "page_load_time", "3275");
INSERT INTO `wpcx_postmeta` VALUES("562", "136", "fully_loaded_time", "3419");
INSERT INTO `wpcx_postmeta` VALUES("563", "136", "html_bytes", "23229");
INSERT INTO `wpcx_postmeta` VALUES("564", "136", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("565", "136", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/I5ivFbUc/");
INSERT INTO `wpcx_postmeta` VALUES("566", "136", "html_load_time", "2623");
INSERT INTO `wpcx_postmeta` VALUES("567", "136", "page_bytes", "1335105");
INSERT INTO `wpcx_postmeta` VALUES("568", "136", "pagespeed_score", "68");
INSERT INTO `wpcx_postmeta` VALUES("569", "136", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("570", "137", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("571", "137", "gfw_label", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("572", "137", "gfw_location", "4");
INSERT INTO `wpcx_postmeta` VALUES("573", "137", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("574", "137", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("575", "137", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("576", "137", "gtmetrix_test_id", "qvXqC1Mp");
INSERT INTO `wpcx_postmeta` VALUES("577", "137", "page_load_time", "3260");
INSERT INTO `wpcx_postmeta` VALUES("578", "137", "fully_loaded_time", "3386");
INSERT INTO `wpcx_postmeta` VALUES("579", "137", "html_bytes", "23217");
INSERT INTO `wpcx_postmeta` VALUES("580", "137", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("581", "137", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/WyZ0AtQN/");
INSERT INTO `wpcx_postmeta` VALUES("582", "137", "html_load_time", "2614");
INSERT INTO `wpcx_postmeta` VALUES("583", "137", "page_bytes", "1335116");
INSERT INTO `wpcx_postmeta` VALUES("584", "137", "pagespeed_score", "68");
INSERT INTO `wpcx_postmeta` VALUES("585", "137", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("586", "138", "gfw_url", "https://connectionx.sousalimaconsultoria.com.br/");
INSERT INTO `wpcx_postmeta` VALUES("587", "138", "gfw_label", "");
INSERT INTO `wpcx_postmeta` VALUES("588", "138", "gfw_location", "6");
INSERT INTO `wpcx_postmeta` VALUES("589", "138", "gfw_adblock", "0");
INSERT INTO `wpcx_postmeta` VALUES("590", "138", "gfw_video", "0");
INSERT INTO `wpcx_postmeta` VALUES("591", "138", "gfw_event_id", "0");
INSERT INTO `wpcx_postmeta` VALUES("592", "138", "gtmetrix_test_id", "47Q9Sgm4");
INSERT INTO `wpcx_postmeta` VALUES("593", "138", "page_load_time", "5524");
INSERT INTO `wpcx_postmeta` VALUES("594", "138", "fully_loaded_time", "5969");
INSERT INTO `wpcx_postmeta` VALUES("595", "138", "html_bytes", "23210");
INSERT INTO `wpcx_postmeta` VALUES("596", "138", "page_elements", "42");
INSERT INTO `wpcx_postmeta` VALUES("597", "138", "report_url", "https://gtmetrix.com/reports/connectionx.sousalimaconsultoria.com.br/gNec0H6c/");
INSERT INTO `wpcx_postmeta` VALUES("598", "138", "html_load_time", "4023");
INSERT INTO `wpcx_postmeta` VALUES("599", "138", "page_bytes", "1335130");
INSERT INTO `wpcx_postmeta` VALUES("600", "138", "pagespeed_score", "69");
INSERT INTO `wpcx_postmeta` VALUES("601", "138", "yslow_score", "85");
INSERT INTO `wpcx_postmeta` VALUES("605", "139", "_wp_attached_file", "2024/02/Video-do-WhatsApp-de-2024-02-20-as-11.32.29_69a154fb.mp4");
INSERT INTO `wpcx_postmeta` VALUES("606", "139", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:5978866;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:98;s:16:\"length_formatted\";s:4:\"1:38\";s:5:\"width\";i:480;s:6:\"height\";i:640;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wpcx_postmeta` VALUES("608", "141", "footnotes", "");
INSERT INTO `wpcx_postmeta` VALUES("609", "142", "_wp_attached_file", "2024/02/global-connection-x-robo-2.png");
INSERT INTO `wpcx_postmeta` VALUES("610", "142", "litespeed-optimize-set", "150x150\n300x300\n768x0\n1024x1024\n1536x1536\n2048x2048\n18x12\n400x250\n1080x675\n400x284\n510x382\n1080x9999\n400x516\n2880x1800\n1280x720\n980x551\n480x270");
INSERT INTO `wpcx_postmeta` VALUES("611", "142", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:1350;s:4:\"file\";s:38:\"2024/02/global-connection-x-robo-2.png\";s:8:\"filesize\";i:1214508;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-240x300.png\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:64353;}s:5:\"large\";a:5:{s:4:\"file\";s:39:\"global-connection-x-robo-2-819x1024.png\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:491873;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29313;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-768x960.png\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:442001;}s:24:\"trp-custom-language-flag\";a:5:{s:4:\"file\";s:36:\"global-connection-x-robo-2-10x12.png\";s:5:\"width\";i:10;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:506;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:104713;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:39:\"global-connection-x-robo-2-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:564438;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:116147;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:38:\"global-connection-x-robo-2-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:181975;}s:35:\"et-pb-gallery-module-image-portrait\"